/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Iterator;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;

public final class Predicate {
    private final ExprNode expr;

    public Predicate(ExprNode expr) {
        this.expr = expr;
    }

    public NodeSet filter(Context context, NodeSet nodeSet) {
        int contextPosition = 1;
        int contextSize = nodeSet.size();
        NodeSetImpl result = new NodeSetImpl(contextSize);
        Iterator i = nodeSet.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            Context subContext = context.newSubContext(node, contextPosition, contextSize);
            Object exprVal = this.expr.evalAsObject(subContext);
            if (exprVal instanceof Number) {
                if (((Number)exprVal).doubleValue() == (double)contextPosition) {
                    result.add(node);
                }
            } else if (BooleanFunction.evaluate(exprVal)) {
                result.add(node);
            }
            ++contextPosition;
        }
        return result;
    }

    public String toString() {
        return "[" + this.expr.toString() + "]";
    }
}

