/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.utils.AcceleoNonStandardLibrary;
import org.eclipse.acceleo.common.utils.AcceleoStandardLibrary;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoUMLReflection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEnvironment
extends EcoreEnvironment {
    private AcceleoNonStandardLibrary acceleoNonStdLib;
    private AcceleoStandardLibrary acceleoStdLib;
    private Collection<EPackage> metamodels = new ArrayList<EPackage>();
    private List<EClassifier> types = new ArrayList<EClassifier>();
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> umlReflection;

    protected AcceleoEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
    }

    protected AcceleoEnvironment(Resource oclEnvironmentResource) {
        super(EPackage.Registry.INSTANCE, oclEnvironmentResource);
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getInteger(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getInteger()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getReal(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getReal()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOclAny(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOclAny()));
    }

    public void addMetamodel(EPackage metamodel) {
        this.metamodels.add(metamodel);
        this.types.clear();
    }

    public void removeMetamodel(EPackage metamodel) {
        this.metamodels.remove(metamodel);
        this.types.clear();
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier classifier = null;
        if (names.size() > 0) {
            Iterator<EClassifier> eClassifierIt = this.getTypes().iterator();
            while (classifier == null && eClassifierIt.hasNext()) {
                EClassifier eClassifier = eClassifierIt.next();
                if (!names.get(names.size() - 1).equals(eClassifier.getName()) || names.size() >= 2 && !names.get(names.size() - 2).equals(eClassifier.getEPackage().getName())) continue;
                classifier = eClassifier;
            }
            if (classifier == null) {
                classifier = super.lookupClassifier(names);
            }
        }
        return classifier;
    }

    public EClassifier lookupClassifier(String name) {
        if (name != null) {
            for (EClassifier eClassifier : this.getTypes()) {
                if (!name.equals(eClassifier.getName())) continue;
                return eClassifier;
            }
        }
        return null;
    }

    public AcceleoNonStandardLibrary getAcceleoNonStandardLibrary() {
        if (this.acceleoNonStdLib == null) {
            this.acceleoNonStdLib = new AcceleoNonStandardLibrary();
        }
        return this.acceleoNonStdLib;
    }

    public AcceleoStandardLibrary getAcceleoStandardLibrary() {
        if (this.acceleoStdLib == null) {
            this.acceleoStdLib = new AcceleoStandardLibrary();
        }
        return this.acceleoStdLib;
    }

    public List<EClassifier> getTypes() {
        if (this.types.size() == 0) {
            for (EPackage ePackage : this.metamodels) {
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    this.computeOCLType(this.types, eClassifier);
                }
            }
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getBag());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getBoolean());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getCollection());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getInteger());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getInvalid());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclAny());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclElement());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclExpression());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclMessage());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclType());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOclVoid());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getOrderedSet());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getReal());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getSequence());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getSet());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getState());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getString());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getT());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getT2());
            this.computeOCLType(this.types, (EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural());
        }
        return this.types;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.umlReflection == null) {
            this.umlReflection = new AcceleoUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection());
        }
        return this.umlReflection;
    }

    private void computeOCLType(List<EClassifier> result, EClassifier type) {
        EClassifier oclType = (EClassifier)this.getTypeResolver().resolve((Object)type);
        if (oclType != null) {
            if (!result.contains(oclType)) {
                result.add(oclType);
            }
        } else if (!result.contains(type)) {
            result.add(type);
        }
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }

    public void addHelperOperations(EClassifier owner, List<EOperation> operations) {
        for (EOperation operation : operations) {
            this.addHelperOperation(owner, operation);
        }
    }
}

