/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui.binding;

import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;
import org.eclipse.emf.editor.ui.ProposalCreator;
import org.eclipse.emf.editor.ui.binding.MultipleFeatureControl;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmfSwtBindingFactory {
    private Composite parent = null;
    private FormToolkit toolkit = null;
    private final EObject owner;
    private final EditingDomain domain;
    private final EMFDataBindingContext edbc;
    private final AdapterFactory adapterFactory;
    private final ProposalCreator proposalcreator;
    public static final String EOBJECT_KEY = EcorePackage.Literals.EOBJECT.getName();
    public static final String ESTRUCTURALFEATURE_KEY = EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName();

    public EmfSwtBindingFactory(AdapterFactory adapterFactory, EditingDomain domain, EObject owner, Composite parent, FormToolkit toolkit, ExtXptFacade facade) {
        this.adapterFactory = adapterFactory;
        this.edbc = new EMFDataBindingContext();
        this.domain = domain;
        this.proposalcreator = new ProposalCreator(domain, facade);
        this.owner = owner;
        this.parent = parent;
        this.toolkit = toolkit;
    }

    public Control create(EObject eObject) {
        Control retVal = null;
        if (eObject instanceof EStructuralFeature) {
            retVal = this.createForEStructuralFeature((EStructuralFeature)eObject);
        }
        return retVal;
    }

    private Control createForEStructuralFeature(EStructuralFeature feature) {
        Control retVal = null;
        retVal = feature.isMany() ? this.bindList(feature) : this.bindValue(feature);
        this.setupControl(feature, retVal);
        return retVal;
    }

    private Control bindList(EStructuralFeature feature) {
        IObservableList source = EMFEditObservables.observeList((EditingDomain)this.domain, (EObject)this.owner, (EStructuralFeature)feature);
        List<?> choice = this.proposalcreator.proposals(this.owner, feature);
        MultipleFeatureControl mfc = new MultipleFeatureControl(this.parent, this.toolkit, (ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory), this.owner, feature, choice);
        IObservableList target = ViewersObservables.observeMultiSelection((ISelectionProvider)mfc.getInternalSelectionProvider());
        Binding binding = this.edbc.bindList(target, source, null, null);
        binding.updateModelToTarget();
        return mfc;
    }

    private Control bindValue(EStructuralFeature feature) {
        Button retVal = null;
        IObservableValue source = EMFEditObservables.observeValue((EditingDomain)this.domain, (EObject)this.owner, (EStructuralFeature)feature);
        ISWTObservableValue target = null;
        if (feature.getEType().equals(EcorePackage.Literals.EBOOLEAN) || feature.getEType().equals(EcorePackage.Literals.EBOOLEAN_OBJECT) || feature.getEType() instanceof EDataType && (feature.getEType().getInstanceClass() == Boolean.class || feature.getEType().getInstanceClass() == Boolean.TYPE)) {
            Button b = this.toolkit.createButton(this.parent, "", 32);
            target = SWTObservables.observeSelection((Control)b);
            retVal = b;
        } else if (feature instanceof EReference || feature.getEType() instanceof EEnumImpl) {
            ComboViewer combo = new ComboViewer(this.parent, 8);
            this.toolkit.adapt((Composite)combo.getCombo());
            combo.setContentProvider((IContentProvider)new ArrayContentProvider());
            combo.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
            combo.setInput(this.proposalcreator.proposals(this.owner, feature));
            target = ViewersObservables.observeSingleSelection((Viewer)combo);
            retVal = combo.getCombo();
        } else {
            Text t = this.toolkit.createText(this.parent, new String());
            t.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            List<?> proposals = this.proposalcreator.proposals(this.owner, feature);
            if (proposals != null && !proposals.isEmpty()) {
                while (proposals.remove(null)) {
                }
                ControlDecoration field = new ControlDecoration((Control)t, 2048);
                FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
                field.setImage(requiredFieldIndicator.getImage());
                field.setDescriptionText(requiredFieldIndicator.getDescription());
                KeyStroke keyStroke = null;
                String string = new String();
                try {
                    string = "Ctrl+Space";
                    keyStroke = KeyStroke.getInstance((String)string);
                }
                catch (ParseException e) {
                    EEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.generic.editor", "Error while parse: " + string, (Throwable)e));
                }
                new ContentProposalAdapter((Control)t, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(proposals.toArray(new String[0])), keyStroke, null);
            }
            target = SWTObservables.observeText((Control)t, (int)24);
            retVal = t;
        }
        this.edbc.bindValue((IObservableValue)target, source, null, null);
        return retVal;
    }

    private void setupControl(EStructuralFeature f, Control c) {
        c.setEnabled(f.isChangeable() && (!(f.getEType() instanceof EDataType) || ((EDataType)f.getEType()).isSerializable()));
        c.setData(ESTRUCTURALFEATURE_KEY, (Object)f);
        c.setData(EOBJECT_KEY, (Object)this.owner);
        c.setLayoutData((Object)new GridData(768));
    }

    public void dispose() {
        this.edbc.dispose();
        this.parent.dispose();
    }
}

