/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.launch;

import java.io.IOException;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.launch.JETStreamMonitor;

public class JETStreamsProxy
implements IStreamsProxy {
    public static String JET_WARNING_STREAM = "org.eclipse.jet.warningStream";
    public static String JET_TRACE_STREAM = "org.eclipse.jet.traceStream";
    public static String JET_DEBUG_STREAM = "org.eclipse.jet.debugStream";
    private JETStreamMonitor outputStreamMonitor = null;
    private JETStreamMonitor errorStreamMonitor = null;
    private JETStreamMonitor warningStreamMonitor = null;
    private JETStreamMonitor traceStreamMonitor = null;
    private JETStreamMonitor debugStreamMonitor = null;

    public JETStreamsProxy(JET2Context context, int levelFilter) {
        this.outputStreamMonitor = this.createLogger(context, 3, levelFilter);
        this.errorStreamMonitor = this.createLogger(context, 5, levelFilter);
        this.warningStreamMonitor = this.createLogger(context, 4, levelFilter);
        this.traceStreamMonitor = this.createLogger(context, 2, levelFilter);
        this.debugStreamMonitor = this.createLogger(context, 1, levelFilter);
    }

    private JETStreamMonitor createLogger(JET2Context context, int level, int minLevel) {
        return level >= minLevel ? new JETStreamMonitor(context, level) : null;
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.errorStreamMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.outputStreamMonitor;
    }

    public void write(String input) throws IOException {
        this.outputStreamMonitor.log(input, null, null, 3);
    }

    public final JETStreamMonitor getDebugStreamMonitor() {
        return this.debugStreamMonitor;
    }

    public final JETStreamMonitor getTraceStreamMonitor() {
        return this.traceStreamMonitor;
    }

    public final JETStreamMonitor getWarningStreamMonitor() {
        return this.warningStreamMonitor;
    }
}

