/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.NodeTest;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.INodeInspectorExtension1;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public abstract class Axis {
    private static final Axis childAxis = new ChildAxis();
    private static final Axis attributeAxis = new AttributeAxis();
    private static final Axis parentAxis = new ParentAxis();
    private static final Axis selfAxis = new SelfAxis();
    private static final Axis descendantAxis = new DescendantAxis();
    private static final Axis descendantOrSelfAxis = new DescendantOrSelfAxis();
    private static final Axis ancestorAxis = new AncestorAxis();
    private static final Axis ancestorOrSelfAxis = new AncestorOrSelfAxis();
    private static final Axis followingSiblingAxis = new FollowingSiblingAxis();
    private static final Axis followingAxis = new FollowingAxis();
    private static final Axis precedingSiblingAxis = new PrecedingSiblingAxis();
    private static final Axis precedingAxis = new PrecedingAxis();
    private static final Map axisByNameMap = new HashMap(15);

    static {
        axisByNameMap.put(childAxis.getAxisName(), childAxis);
        axisByNameMap.put(attributeAxis.getAxisName(), attributeAxis);
        axisByNameMap.put(parentAxis.getAxisName(), parentAxis);
        axisByNameMap.put(selfAxis.getAxisName(), selfAxis);
        axisByNameMap.put(descendantOrSelfAxis.getAxisName(), descendantOrSelfAxis);
        axisByNameMap.put(descendantAxis.getAxisName(), descendantAxis);
        axisByNameMap.put(ancestorAxis.getAxisName(), ancestorAxis);
        axisByNameMap.put(ancestorOrSelfAxis.getAxisName(), ancestorOrSelfAxis);
        axisByNameMap.put(followingSiblingAxis.getAxisName(), followingSiblingAxis);
        axisByNameMap.put(followingAxis.getAxisName(), followingAxis);
        axisByNameMap.put(precedingSiblingAxis.getAxisName(), precedingSiblingAxis);
        axisByNameMap.put(precedingAxis.getAxisName(), precedingAxis);
    }

    protected final Object hasAnnotations(Context context, Object contextNode, AnnotationAction action) {
        IAnnotationManager annotationManager;
        if (context.hasAnnotationManager() && (annotationManager = context.getAnnotationManager()).hasAnnotations(contextNode)) {
            Object annotation = annotationManager.getAnnotationObject(contextNode);
            IElementInspector inspector = (IElementInspector)InspectorManager.getInstance().getInspector(annotation);
            return action.doAction(annotation, inspector);
        }
        return null;
    }

    protected static void addAllDescendants(Context context, Collection result) {
        NodeSet children = Axis.childAxis().evaluate(NodeTest.allNodes(), context);
        int position = 1;
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            result.add(object);
            Context subContext = context.newSubContext(object, position, children.size());
            Axis.addAllDescendants(subContext, result);
            ++position;
        }
    }

    protected static void addAllDescendantsReversed(Context context, Collection result) {
        ArrayList children = new ArrayList(Axis.childAxis().evaluate(NodeTest.allNodes(), context));
        Collections.reverse(children);
        int position = 1;
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            Context subContext = context.newSubContext(object, position, children.size());
            Axis.addAllDescendantsReversed(subContext, result);
            result.add(object);
            ++position;
        }
    }

    protected static void addParent(Context context, Collection result) {
        Object obj = context.getContextNode();
        INodeInspector inspector = context.getContextNodeInspector();
        Object parent = inspector.getParent(obj);
        if (parent != null) {
            result.add(parent);
        }
    }

    protected static void addAncestors(Context context, Collection result) {
        Object obj = context.getContextNode();
        INodeInspector inspector = context.getContextNodeInspector();
        Object parent = inspector.getParent(obj);
        if (parent != null) {
            result.add(parent);
            Axis.addAncestors(context.newSubContext(parent, 1, 1), result);
        }
    }

    protected static void addFollowingSiblings(Context context, Collection result) {
        Object contextNode;
        INodeInspector inspector = context.getContextNodeInspector();
        INodeInspector.NodeKind nodeKind = inspector.getNodeKind(contextNode = context.getContextNode());
        if (nodeKind != INodeInspector.NodeKind.ATTRIBUTE && nodeKind != INodeInspector.NodeKind.NAMESPACE) {
            Object parent = inspector.getParent(contextNode);
            List<Object> children = Arrays.asList(inspector.getChildren(parent));
            int index = children.indexOf(contextNode);
            result.addAll(children.subList(index + 1, children.size()));
        }
    }

    protected static void addPrecedingSiblings(Context context, Collection result) {
        Object contextNode;
        INodeInspector inspector = context.getContextNodeInspector();
        INodeInspector.NodeKind nodeKind = inspector.getNodeKind(contextNode = context.getContextNode());
        if (nodeKind != INodeInspector.NodeKind.ATTRIBUTE && nodeKind != INodeInspector.NodeKind.NAMESPACE) {
            Object parent = inspector.getParent(contextNode);
            List<Object> children = Arrays.asList(inspector.getChildren(parent));
            int index = children.indexOf(contextNode);
            List<Object> precedingChildren = children.subList(0, index);
            Collections.reverse(precedingChildren);
            result.addAll(precedingChildren);
        }
    }

    public abstract NodeSet evaluate(NodeTest var1, Context var2);

    public abstract INodeInspector.NodeKind principalNodeKind();

    public abstract String getAxisName();

    public static Axis childAxis() {
        return childAxis;
    }

    public static Axis attributeAxis() {
        return attributeAxis;
    }

    public static Axis parentAxis() {
        return parentAxis;
    }

    public static Axis descendant() {
        return descendantAxis;
    }

    public static Axis descendantOrSelf() {
        return descendantOrSelfAxis;
    }

    public static Axis axisByName(String axisName) {
        return (Axis)axisByNameMap.get(axisName);
    }

    public static Axis selfAxis() {
        return selfAxis;
    }

    public String toString() {
        return String.valueOf(this.getAxisName()) + "::";
    }

    protected NodeSet arrayToNodeSet(Object[] attributes) {
        NodeSetImpl result = new NodeSetImpl(attributes.length);
        int i = 0;
        while (i < attributes.length) {
            result.add(attributes[i]);
            ++i;
        }
        return result;
    }

    public static Axis ancestor() {
        return ancestorAxis;
    }

    public static Axis ancestorOrSelf() {
        return ancestorOrSelfAxis;
    }

    public static Axis followingSibling() {
        return followingSiblingAxis;
    }

    public static Axis following() {
        return followingAxis;
    }

    public static Axis precedingSibling() {
        return precedingSiblingAxis;
    }

    public static Axis preceding() {
        return precedingAxis;
    }

    private static final class AncestorAxis
    extends Axis {
        private AncestorAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            AncestorAxis.addAncestors(context, result);
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "ancestor";
        }
    }

    private static final class AncestorOrSelfAxis
    extends Axis {
        private AncestorOrSelfAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            result.add(context.getContextNode());
            AncestorOrSelfAxis.addAncestors(context, result);
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "ancestor-of-self";
        }
    }

    private static interface AnnotationAction {
        public Object doAction(Object var1, IElementInspector var2);
    }

    private static final class AttributeAxis
    extends Axis {
        private AttributeAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSet result = NodeSetImpl.EMPTY_SET;
            Object contextNode = context.getContextNode();
            INodeInspector inspector = context.getContextNodeInspector();
            if (inspector instanceof IElementInspector && inspector.getNodeKind(contextNode) == INodeInspector.NodeKind.ELEMENT) {
                IElementInspector elementInspector = (IElementInspector)inspector;
                if (nodeTest.isSimpleNameTest()) {
                    Object namedAttribute = elementInspector.getNamedAttribute(contextNode, nodeTest.getNameTestExpandedName());
                    if (namedAttribute == null) {
                        namedAttribute = this.hasAnnotations(context, contextNode, new AnnotationAction(this, nodeTest){
                            final /* synthetic */ AttributeAxis this$1;
                            private final /* synthetic */ NodeTest val$nodeTest;
                            {
                                this.this$1 = attributeAxis;
                                this.val$nodeTest = nodeTest;
                            }

                            public Object doAction(Object annotation, IElementInspector inspector) {
                                return inspector.getNamedAttribute(annotation, this.val$nodeTest.getNameTestExpandedName());
                            }
                        });
                    }
                    if (namedAttribute != null) {
                        result = new NodeSetImpl();
                        result.add(namedAttribute);
                    }
                } else {
                    Object[] attributes = elementInspector.getAttributes(contextNode);
                    result = this.arrayToNodeSet(attributes);
                    Object[] annAttributes = (Object[])this.hasAnnotations(context, contextNode, new AnnotationAction(this){
                        final /* synthetic */ AttributeAxis this$1;
                        {
                            this.this$1 = attributeAxis;
                        }

                        public Object doAction(Object annotation, IElementInspector inspector) {
                            return inspector.getAttributes(annotation);
                        }
                    });
                    if (annAttributes != null) {
                        result.addAll(Arrays.asList(annAttributes));
                    }
                    nodeTest.filter(result);
                }
            }
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ATTRIBUTE;
        }

        public String getAxisName() {
            return "attribute";
        }
    }

    private static final class ChildAxis
    extends Axis {
        private ChildAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSet result = NodeSetImpl.EMPTY_SET;
            Object contextNode = context.getContextNode();
            INodeInspector inspector = context.getContextNodeInspector();
            INodeInspector.NodeKind nodeKind = inspector.getNodeKind(contextNode);
            if (nodeKind == INodeInspector.NodeKind.ELEMENT || nodeKind == INodeInspector.NodeKind.ROOT) {
                if (nodeTest.isSimpleNameTest() && inspector instanceof INodeInspectorExtension1) {
                    Object[] children = ((INodeInspectorExtension1)((Object)inspector)).getNamedChildren(contextNode, nodeTest.getNameTestExpandedName());
                    if (children != null) {
                        result = this.arrayToNodeSet(children);
                    }
                } else {
                    Object[] children = inspector.getChildren(contextNode);
                    result = this.arrayToNodeSet(children);
                    nodeTest.filter(result);
                }
            }
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "child";
        }
    }

    private static final class DescendantAxis
    extends Axis {
        private DescendantAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            DescendantAxis.addAllDescendants(context, result);
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "descendant";
        }
    }

    private static final class DescendantOrSelfAxis
    extends Axis {
        private DescendantOrSelfAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            result.add(context.getContextNode());
            DescendantOrSelfAxis.addAllDescendants(context, result);
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "descendant-or-self";
        }
    }

    private static final class FollowingAxis
    extends Axis {
        private FollowingAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            ArrayList ancestors = new ArrayList();
            FollowingAxis.addAncestors(context, ancestors);
            NodeSetImpl result = new NodeSetImpl();
            Iterator i = ancestors.iterator();
            while (i.hasNext()) {
                ArrayList siblings = new ArrayList();
                FollowingAxis.addFollowingSiblings(context, siblings);
                Iterator j = siblings.iterator();
                while (j.hasNext()) {
                    Object sibling = j.next();
                    result.add(sibling);
                    FollowingAxis.addAllDescendants(context.newSubContext(sibling, 1, 1), result);
                }
                context = context.newSubContext(i.next(), 1, 1);
            }
            nodeTest.filter(result);
            return result;
        }

        public String getAxisName() {
            return "following";
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }
    }

    private static final class FollowingSiblingAxis
    extends Axis {
        private FollowingSiblingAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            FollowingSiblingAxis.addFollowingSiblings(context, result);
            nodeTest.filter(result);
            return result;
        }

        public String getAxisName() {
            return "following-sibling";
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }
    }

    private static final class ParentAxis
    extends Axis {
        private ParentAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl(1);
            ParentAxis.addParent(context, result);
            nodeTest.filter(result);
            return result;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "parent";
        }
    }

    private static final class PrecedingAxis
    extends Axis {
        private PrecedingAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            ArrayList ancestors = new ArrayList();
            PrecedingAxis.addAncestors(context, ancestors);
            NodeSetImpl result = new NodeSetImpl();
            Iterator i = ancestors.iterator();
            while (i.hasNext()) {
                ArrayList siblings = new ArrayList();
                PrecedingAxis.addPrecedingSiblings(context, siblings);
                Iterator j = siblings.iterator();
                while (j.hasNext()) {
                    Object sibling = j.next();
                    PrecedingAxis.addAllDescendantsReversed(context.newSubContext(sibling, 1, 1), result);
                    result.add(sibling);
                }
                context = context.newSubContext(i.next(), 1, 1);
            }
            nodeTest.filter(result);
            return result;
        }

        public String getAxisName() {
            return "preceding";
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }
    }

    private static final class PrecedingSiblingAxis
    extends Axis {
        private PrecedingSiblingAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl result = new NodeSetImpl();
            PrecedingSiblingAxis.addPrecedingSiblings(context, result);
            nodeTest.filter(result);
            return result;
        }

        public String getAxisName() {
            return "preceding-sibling";
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }
    }

    private static final class SelfAxis
    extends Axis {
        private SelfAxis() {
        }

        public NodeSet evaluate(NodeTest nodeTest, Context context) {
            NodeSetImpl nodeSet = new NodeSetImpl(1);
            nodeSet.add(context.getContextNode());
            nodeTest.filter(nodeSet);
            return nodeSet;
        }

        public INodeInspector.NodeKind principalNodeKind() {
            return INodeInspector.NodeKind.ELEMENT;
        }

        public String getAxisName() {
            return "self";
        }
    }
}

