/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.compiler.JET2AST;
import org.eclipse.jet.compiler.JET2ASTElement;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.TemplatePathUtil;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTParser;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.core.parser.jasper.JETException;
import org.eclipse.jet.internal.core.parser.jasper.JETReader;
import org.eclipse.jet.internal.parser.resources.WorkspaceTemplateResolverBuilder;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jet.taglib.TagLibraryReference;

public final class JET2CompilationUnit
extends JET2ASTElement {
    private JETCompilationUnit delegate;
    private List wrappedBodyElements = null;
    private List wrappedProblems = null;
    private Map predefinedLibraryMap = Collections.EMPTY_MAP;
    private final URI baseLocation;
    private final String templatePath;
    private final ITemplateResolver templateResolver;
    private final String encoding;

    public JET2CompilationUnit() {
        super(new JET2AST(), null);
        this.baseLocation = null;
        this.templatePath = "";
        this.templateResolver = null;
        this.encoding = null;
        this.delegate = this.getAst().getDelegateAST().newJETCompilationUnit(this.baseLocation, this.templatePath, this.encoding);
        this.setDelegate(this.delegate);
    }

    public JET2CompilationUnit(IFile file) {
        super(new JET2AST(), null);
        this.baseLocation = TemplatePathUtil.baseLocationURI(file);
        this.templatePath = TemplatePathUtil.templatePath(file);
        this.templateResolver = new WorkspaceTemplateResolverBuilder(file.getProject()).build();
        try {
            this.encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            throw new IllegalArgumentException();
        }
        this.delegate = this.getAst().getDelegateAST().newJETCompilationUnit(this.baseLocation, this.templatePath, this.encoding);
        super.setDelegate(this.delegate);
    }

    public JET2CompilationUnit(JET2AST jet2ast, JETCompilationUnit unit) {
        super(jet2ast, (JETASTElement)unit);
        this.delegate = unit;
        this.baseLocation = null;
        this.templatePath = "";
        this.templateResolver = null;
        this.encoding = null;
    }

    public void setPredefinedTagLibraries(Map predefinedLibraryMap) {
        this.predefinedLibraryMap = predefinedLibraryMap;
    }

    public void parse(String document) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(document.getBytes("UTF-8"));
            this.internalParse(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should not have happened", e);
        }
    }

    public void parse() throws CoreException {
        if (this.templateResolver == null) {
            throw new IllegalStateException();
        }
        IFile file = TemplatePathUtil.workspaceFile(this.baseLocation, this.templatePath);
        InputStream contents = file.getContents();
        String charset = file.getCharset();
        this.internalParse(contents, charset);
    }

    public void parse(InputStream contents, String charset) {
        this.internalParse(contents, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalParse(InputStream contents, String charset) {
        block12: {
            this.wrappedProblems = null;
            this.wrappedBodyElements = null;
            try {
                try {
                    InputStreamReader isr = new InputStreamReader(contents, charset);
                    JETReader reader = new JETReader(this.baseLocation == null ? null : this.baseLocation.toString(), this.templatePath, (Reader)isr);
                    JETASTParser.Builder builder = new JETASTParser.Builder(2).predefinedTagLibraries(this.predefinedLibraryMap != null ? this.predefinedLibraryMap : Collections.EMPTY_MAP).tagLibraryResolver(new ITagLibraryResolver(){

                        public TagLibrary getLibrary(String tagLibraryID) {
                            return TagLibraryManager.getInstance().getTagLibrary(tagLibraryID);
                        }
                    });
                    if (this.templateResolver != null) {
                        builder.templateResolver(this.templateResolver);
                    }
                    JETASTParser parser = builder.build();
                    this.delegate = (JETCompilationUnit)parser.parse(reader.getChars());
                    this.setDelegate(this.delegate);
                    Object var7_9 = null;
                }
                catch (JETException e) {
                    this.createProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
                    break block12;
                }
                catch (UnsupportedEncodingException e) {
                    this.createProblem(ProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            contents.close();
            return;
        }
        Object var7_11 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        contents.close();
    }

    public final List getBodyElements() {
        if (this.wrappedBodyElements == null) {
            List delegateBodyElements = this.delegate.getBodyElements();
            if (delegateBodyElements.size() == 0) {
                this.wrappedBodyElements = Collections.EMPTY_LIST;
            } else {
                this.wrappedBodyElements = new ArrayList(delegateBodyElements.size());
                Iterator i = delegateBodyElements.iterator();
                while (i.hasNext()) {
                    BodyElement bodyElement = (BodyElement)i.next();
                    this.wrappedBodyElements.add(this.getAst().wrap((JETASTElement)bodyElement));
                }
            }
        }
        return this.wrappedBodyElements;
    }

    public void accept(JET2ASTVisitor visitor) {
        visitor.visit(this);
        Iterator i = this.getBodyElements().iterator();
        while (i.hasNext()) {
            JET2ASTElement element = (JET2ASTElement)i.next();
            element.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public List getProblems() {
        if (this.wrappedProblems == null) {
            List delegateProblems = this.delegate.getProblems();
            if (delegateProblems.size() == 0) {
                this.wrappedProblems = Collections.EMPTY_LIST;
            } else {
                this.wrappedProblems = new ArrayList(delegateProblems.size());
                Iterator i = delegateProblems.iterator();
                while (i.hasNext()) {
                    Problem problem = (Problem)i.next();
                    this.wrappedProblems.add(this.getAst().wrap(problem));
                }
            }
        }
        return this.wrappedProblems;
    }

    public boolean hasErrors() {
        return this.delegate.hasErrors();
    }

    public boolean hasWarnings() {
        return this.delegate.hasWarnings();
    }

    public void createProblem(ProblemSeverity error, int problemId, String message, Object[] messageArgs, int start, int end, int line, int colOffset) {
        this.delegate.createProblem(error, problemId, message, messageArgs, start, end, line, colOffset);
    }

    public String getOutputJavaPackage() {
        return this.delegate.getOutputJavaPackage();
    }

    public String getOutputJavaClassName() {
        return this.delegate.getOutputJavaClassName();
    }

    public void setOutputJavaClassName(String outputJavaClassName) {
        this.delegate.setOutputJavaClassName(outputJavaClassName);
    }

    public void setOutputJavaPackage(String outputJavaPackage) {
        this.delegate.setOutputJavaPackage(outputJavaPackage);
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        return this.delegate.getTagLibraryReferences();
    }

    public void addImports(List list) {
        this.delegate.addImports(list);
    }

    public Set getImports() {
        return this.delegate.getImports();
    }

    public JETCompilationUnit getDelegateCU() {
        return this.delegate;
    }
}

