/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.inspectors.AnyAttributeSetting;
import org.eclipse.jet.internal.xpath.inspectors.EMFEAttrAsElementWrapper;
import org.eclipse.jet.internal.xpath.inspectors.EMFXMLNodeWrapper;
import org.eclipse.jet.internal.xpath.inspectors.XMLTypeUtil2;
import org.eclipse.jet.xpath.inspector.AddElementException;
import org.eclipse.jet.xpath.inspector.CopyElementException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.INodeInspectorExtension1;
import org.eclipse.jet.xpath.inspector.InspectorManager;
import org.eclipse.jet.xpath.inspector.InvalidChildException;
import org.eclipse.jet.xpath.inspector.SimpleElementRequiresValueException;

public class EObjectInspector
implements IElementInspector,
INodeInspectorExtension1 {
    private static final String SCHEMA_ELEMENT_PREFIX = "_schema-element_";
    private static final String EMPTY_STRING = "";
    private static final Map resourceSetMetaData = Collections.synchronizedMap(new WeakHashMap());
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    public Object[] getAttributes(Object contextNode) {
        EObject eObject = (EObject)contextNode;
        return this.getAttributesInternal(eObject, false);
    }

    private Object[] getAttributesInternal(EObject eObject, boolean includeUnsets) {
        ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
        ArrayList<EAttribute> allAttributes = new ArrayList<EAttribute>(exMD.getAllAttributes(eObject.eClass()));
        Iterator i = eObject.eClass().getEAllAttributes().iterator();
        while (i.hasNext()) {
            EAttribute attribute = (EAttribute)i.next();
            if (exMD.getFeatureKind((EStructuralFeature)attribute) != 0) continue;
            allAttributes.add(attribute);
        }
        ArrayList<EStructuralFeature.Setting> attributeSettings = new ArrayList<EStructuralFeature.Setting>(allAttributes.size());
        Iterator i2 = allAttributes.iterator();
        while (i2.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)i2.next();
            if (!eObject.eIsSet(feature) && !includeUnsets) continue;
            if (exMD.getFeatureKind(feature) == 3) {
                FeatureMap featureMap = (FeatureMap)eObject.eGet(feature);
                Iterator j = featureMap.iterator();
                while (j.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)j.next();
                    AnyAttributeSetting setting = new AnyAttributeSetting(entry, eObject);
                    attributeSettings.add(setting);
                }
                continue;
            }
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(feature);
            attributeSettings.add(setting);
        }
        return attributeSettings.toArray();
    }

    public Object getNamedAttribute(Object contextNode, ExpandedName nameTestExpandedName) {
        EObject eObject = (EObject)contextNode;
        EStructuralFeature.Setting setting = this.getNamedAttributeInternal(eObject, nameTestExpandedName);
        return setting == null || !setting.isSet() && setting.get(true) == null ? null : setting;
    }

    private EStructuralFeature.Setting getNamedAttributeInternal(EObject eObject, ExpandedName nameTestExpandedName) {
        EClass eClass = eObject.eClass();
        EStructuralFeature feature = null;
        if (this.isXMLNode(eClass)) {
            ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
            Object[] allAttributeSettings = this.getAttributesInternal(eObject, true);
            int i = 0;
            while (i < allAttributeSettings.length) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)allAttributeSettings[i];
                EStructuralFeature settingFeature = setting.getEStructuralFeature();
                if (this.matchesFeature(nameTestExpandedName, settingFeature, exMD)) {
                    return setting;
                }
                ++i;
            }
        } else {
            String featureURI = nameTestExpandedName.getNamespaceURI();
            String featureName = nameTestExpandedName.getLocalPart();
            feature = eClass.getEStructuralFeature(featureName);
            if (feature instanceof EReference) {
                feature = null;
            } else if (featureURI != null && !featureURI.equals(feature.getEContainingClass().getEPackage().getNsURI())) {
                feature = null;
            }
            if (feature != null) {
                EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(feature);
                return setting;
            }
        }
        return null;
    }

    private boolean matchesFeature(ExpandedName expandedName, EStructuralFeature feature, ExtendedMetaData exMD) {
        ExpandedName featureEN = this.internalExpandedNameOfFeature(feature, exMD);
        boolean equals = expandedName.equals(featureEN) || expandedName.equals(new ExpandedName(featureEN.getLocalPart()));
        return equals;
    }

    private ExpandedName internalExpandedNameOfFeature(EStructuralFeature feature, ExtendedMetaData exMD) {
        ExpandedName featureEN = new ExpandedName(exMD.getNamespace(feature), exMD.getName(feature));
        return featureEN;
    }

    private boolean isXMLNode(EClass eClass) {
        return eClass.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData") != null;
    }

    public boolean createAttribute(Object contextNode, String attributeName, String value) {
        EObject eObject = (EObject)contextNode;
        EClass eClass = eObject.eClass();
        EStructuralFeature.Setting existingSetting = this.getNamedAttributeInternal(eObject, new ExpandedName(attributeName));
        if (existingSetting != null) {
            existingSetting.set(existingSetting.getEStructuralFeature().getEType().getEPackage().getEFactoryInstance().createFromString((EDataType)existingSetting.getEStructuralFeature().getEType(), value));
            return true;
        }
        EStructuralFeature feature = EObjectInspector.getExtendedMetaData(eObject).demandFeature(null, attributeName, false);
        EStructuralFeature affiliation = EObjectInspector.getExtendedMetaData(eObject).getAffiliation(eClass, feature);
        if (affiliation != null) {
            eObject.eSet(feature, (Object)value);
            return true;
        }
        return false;
    }

    public INodeInspector.NodeKind getNodeKind(Object obj) {
        EObject eObject = (EObject)obj;
        INodeInspector.NodeKind result = INodeInspector.NodeKind.ELEMENT;
        EStructuralFeature containingFeature = eObject.eContainingFeature();
        ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
        EClass eClass = eObject.eClass();
        String eClassName = exMD.getName((EClassifier)eClass);
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(exMD.getNamespace((EClassifier)eClass))) {
            if ("processingInstruction_._type".equals(eClassName)) {
                return INodeInspector.NodeKind.PROCESSING_INSTRUCTION;
            }
            if (EMPTY_STRING.equals(eClassName)) {
                return INodeInspector.NodeKind.ROOT;
            }
        }
        if (containingFeature != null) {
            switch (exMD.getFeatureKind(containingFeature)) {
                case 2: 
                case 3: {
                    result = INodeInspector.NodeKind.ATTRIBUTE;
                }
            }
        } else if (EMPTY_STRING.equals(eClassName)) {
            result = INodeInspector.NodeKind.ROOT;
        }
        return result;
    }

    public Object getParent(Object obj) {
        EObject eObject = (EObject)obj;
        EObject parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        return parent;
    }

    public String stringValueOf(Object object) {
        EObject eObject = (EObject)object;
        EClass eClass = eObject.eClass();
        if (this.isXMLNode(eClass)) {
            switch (EObjectInspector.getExtendedMetaData(eObject).getContentKind(eClass)) {
                case 0: 
                case 1: {
                    return EMPTY_STRING;
                }
                case 2: {
                    EStructuralFeature simpleFeature = EObjectInspector.getExtendedMetaData(eObject).getSimpleFeature(eClass);
                    Object rawValue = eObject.eGet(simpleFeature);
                    return this.stringValueOfFeature(simpleFeature, rawValue);
                }
                case 3: 
                case 4: {
                    StringBuffer result = new StringBuffer();
                    this.appendStringValue(result, eObject);
                    return result.toString();
                }
            }
        } else if (object instanceof EEnumLiteral) {
            return ((EEnumLiteral)object).getLiteral();
        }
        return EMPTY_STRING;
    }

    private void appendStringValue(StringBuffer result, EObject eObject) {
        Object[] children = this.getChildren(eObject);
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof EObject) {
                this.appendStringValue(result, (EObject)children[i]);
            } else if (children[i] instanceof EMFXMLNodeWrapper && ((EMFXMLNodeWrapper)children[i]).getNodeKind() == INodeInspector.NodeKind.TEXT) {
                result.append(((EMFXMLNodeWrapper)children[i]).getText());
            } else if (children[i] instanceof EMFEAttrAsElementWrapper) {
                EMFEAttrAsElementWrapper wrapper = (EMFEAttrAsElementWrapper)children[i];
                Object rawValue = wrapper.getValue();
                result.append(this.stringValueOfFeature(wrapper.getFeature(), rawValue));
            }
            ++i;
        }
    }

    protected String stringValueOfFeature(EStructuralFeature feature, Object rawValue) {
        EFactory ef = feature.getEType().getEPackage().getEFactoryInstance();
        String result = ef.convertToString((EDataType)feature.getEType(), rawValue);
        return result;
    }

    public ExpandedName expandedNameOf(Object object) {
        EObject eObject = (EObject)object;
        EReference containmentFeature = eObject.eContainmentFeature();
        return this.expandedNameOfFeature(eObject, (EStructuralFeature)containmentFeature);
    }

    protected final ExpandedName expandedNameOfFeature(EObject eObject, EStructuralFeature feature) {
        EClass eClass = eObject.eClass();
        if (feature != null && this.isXMLNode(eClass)) {
            ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
            return this.internalExpandedNameOfFeature(feature, exMD);
        }
        if (feature != null) {
            return new ExpandedName(feature.getName());
        }
        if (eObject.eResource() != null) {
            return new ExpandedName("contents");
        }
        return null;
    }

    public Object[] getChildren(Object contextNode) {
        EObject eObject = (EObject)contextNode;
        EClass eClass = eObject.eClass();
        if (this.isXMLNode(eClass)) {
            ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
            switch (exMD.getContentKind(eClass)) {
                case 0: 
                case 1: 
                case 2: {
                    return EMPTY_ARRAY;
                }
                case 4: {
                    List allElementsFeatures = exMD.getAllElements(eClass);
                    ArrayList<Object> result = new ArrayList<Object>(allElementsFeatures.size());
                    Iterator i = allElementsFeatures.iterator();
                    block9: while (i.hasNext()) {
                        EStructuralFeature feature = (EStructuralFeature)i.next();
                        switch (exMD.getFeatureKind(feature)) {
                            case 4: {
                                if (exMD.getGroup(feature) != null) continue block9;
                                if (feature instanceof EAttribute) {
                                    if (!eObject.eIsSet(feature)) break;
                                    EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(feature);
                                    if (!feature.isMany()) {
                                        result.add(new EMFEAttrAsElementWrapper(setting));
                                        break;
                                    }
                                    EList list = (EList)setting.get(true);
                                    int j = 0;
                                    while (j < list.size()) {
                                        result.add(new EMFEAttrAsElementWrapper(setting, j));
                                        ++j;
                                    }
                                    continue block9;
                                }
                                if (!((EReference)feature).isContainment()) break;
                                if (feature.isMany()) {
                                    result.addAll((List)eObject.eGet(feature));
                                    break;
                                }
                                if (!eObject.eIsSet(feature)) break;
                                result.add(eObject.eGet(feature));
                                break;
                            }
                            case 5: 
                            case 6: {
                                Object rawValue = eObject.eGet(feature);
                                if (rawValue instanceof FeatureMap) {
                                    FeatureMap featureMap = (FeatureMap)rawValue;
                                    Iterator j = featureMap.iterator();
                                    while (j.hasNext()) {
                                        FeatureMap.Entry entry = (FeatureMap.Entry)j.next();
                                        if (entry.getEStructuralFeature() instanceof EAttribute) {
                                            result.add(new EMFEAttrAsElementWrapper(new AnyAttributeSetting(entry, eObject)));
                                            continue;
                                        }
                                        result.add(entry.getValue());
                                    }
                                    continue block9;
                                }
                                result.addAll((List)rawValue);
                            }
                        }
                    }
                    return result.toArray();
                }
                case 3: {
                    EAttribute mixedFeature = exMD.getMixedFeature(eClass);
                    FeatureMap featureMap = (FeatureMap)eObject.eGet((EStructuralFeature)mixedFeature);
                    Object[] result = new Object[featureMap.size()];
                    int resultIndex = 0;
                    Iterator i = featureMap.iterator();
                    while (i.hasNext()) {
                        FeatureMap.Entry entry = (FeatureMap.Entry)i.next();
                        Object resultObject = null;
                        EStructuralFeature entryFeature = entry.getEStructuralFeature();
                        INodeInspector.NodeKind nodeKind = XMLTypeUtil2.getNodeKind(entryFeature);
                        if (nodeKind == INodeInspector.NodeKind.TEXT || nodeKind == INodeInspector.NodeKind.COMMENT) {
                            resultObject = new EMFXMLNodeWrapper(eObject, (String)entry.getValue(), nodeKind);
                        } else if (entryFeature instanceof EReference && ((EReference)entryFeature).isContainment()) {
                            resultObject = entry.getValue();
                        } else if (entryFeature instanceof EAttribute) {
                            resultObject = new EMFEAttrAsElementWrapper(new AnyAttributeSetting(entry, eObject));
                        }
                        result[resultIndex++] = resultObject;
                    }
                    return result;
                }
            }
        } else {
            return eObject.eContents().toArray();
        }
        return null;
    }

    public Object getDocumentRoot(Object contextNode) {
        EObject eObject;
        EObject parent = eObject = (EObject)contextNode;
        while (parent != null) {
            if (EMPTY_STRING.equals(EObjectInspector.getExtendedMetaData(eObject).getName((EClassifier)parent.eClass()))) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return eObject.eResource();
    }

    public String nameOf(Object contextNode) {
        EObject eObject = (EObject)contextNode;
        EReference feature = eObject.eContainmentFeature();
        return this.nameOfFeature(eObject, (EStructuralFeature)feature);
    }

    protected String nameOfFeature(EObject eObject, EStructuralFeature feature) {
        if (feature != null) {
            EPackage ePkg = feature.getEContainingClass().getEPackage();
            String namespace = ePkg.getNsURI();
            String nsPrefix = ePkg.getNsPrefix();
            INodeInspector inspector = InspectorManager.getInstance().getInspector(eObject);
            Object root = inspector.getDocumentRoot(eObject);
            if (root instanceof EObject) {
                String namespace2 = EObjectInspector.getExtendedMetaData(eObject).getNamespace(feature);
                if (namespace2 == null) {
                    nsPrefix = null;
                } else {
                    EObject rootEObject = (EObject)root;
                    EReference prefixMapFeature = EObjectInspector.getExtendedMetaData(eObject).getXMLNSPrefixMapFeature(rootEObject.eClass());
                    if (prefixMapFeature != null) {
                        EcoreEMap xmlnsPrefixMap = (EcoreEMap)rootEObject.eGet((EStructuralFeature)prefixMapFeature);
                        Iterator i = xmlnsPrefixMap.iterator();
                        while (i.hasNext()) {
                            BasicEMap.Entry entry = (BasicEMap.Entry)i.next();
                            if (!namespace.equals(entry.getValue())) continue;
                            nsPrefix = (String)entry.getKey();
                            break;
                        }
                    }
                }
            }
            String localName = this.isXMLNode(eObject.eClass()) ? EObjectInspector.getExtendedMetaData(eObject).getName(feature) : feature.getName();
            return nsPrefix != null && nsPrefix.length() > 0 ? String.valueOf(nsPrefix) + ":" + localName : localName;
        }
        if (eObject.eResource() != null) {
            return "contents";
        }
        return EMPTY_STRING;
    }

    public Object[] getNamedChildren(Object contextNode, ExpandedName nameTestExpandedName) {
        String featureName;
        EObject eObject = (EObject)contextNode;
        EClass eClass = eObject.eClass();
        if (this.isXMLNode(eClass)) {
            return this.getXMLNamedElement2(eObject, eClass, nameTestExpandedName);
        }
        String featureURI = nameTestExpandedName.getNamespaceURI();
        EStructuralFeature feature = this.getEReference(eClass, featureURI, featureName = nameTestExpandedName.getLocalPart());
        if (feature != null && eObject.eIsSet(feature)) {
            Object rawValue = eObject.eGet(feature);
            if (feature.isMany()) {
                return ((List)rawValue).toArray();
            }
            return new Object[]{rawValue};
        }
        ArrayList children = new ArrayList(eObject.eContents());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            EObject child = (EObject)i.next();
            if (child.eClass().getName().equals(featureName)) continue;
            i.remove();
        }
        return children.toArray();
    }

    private Object[] getXMLNamedElement2(EObject eObject, EClass eClass, ExpandedName expandedName) {
        Object[] children = this.getChildren(eObject);
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        IXMLElementTester test = this.getElementTester(eObject, expandedName);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (test.matches(child)) {
                result.add(child);
            }
            ++i;
        }
        return result.toArray();
    }

    private IXMLElementTester getElementTester(EObject eObject, ExpandedName expandedName) {
        Object documentRoot;
        ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(eObject);
        String localPart = expandedName.getLocalPart();
        IXMLElementTester test = localPart.startsWith(SCHEMA_ELEMENT_PREFIX) ? new SchemaElementTester(exMD, new ExpandedName(expandedName.getNamespaceURI(), localPart.substring(SCHEMA_ELEMENT_PREFIX.length()))) : new ElementNameTester(exMD, expandedName, (documentRoot = this.getDocumentRoot(eObject)) instanceof EObject ? (EObject)documentRoot : null);
        return test;
    }

    private EStructuralFeature getEReference(EClass eClass, String featureURI, String featureName) {
        EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
        if (feature instanceof EAttribute) {
            feature = null;
        } else if (featureURI != null && !featureURI.equals(feature.getEContainingClass().getEPackage().getNsURI())) {
            feature = null;
        }
        return feature;
    }

    private boolean addFeatureMapElement(EObject parent, EStructuralFeature feature, EStructuralFeature fmFeature, Object newElement, Object addBeforeThisSibling) {
        if (!(addBeforeThisSibling instanceof EObject)) {
            return false;
        }
        EObject sibling = (EObject)addBeforeThisSibling;
        if (parent != sibling.eContainer()) {
            return false;
        }
        ExtendedMetaData exMD = EObjectInspector.getExtendedMetaData(parent);
        if (!this.matchesFeature(this.internalExpandedNameOfFeature(feature, exMD), (EStructuralFeature)sibling.eContainmentFeature(), exMD)) {
            return false;
        }
        feature = sibling.eContainmentFeature();
        FeatureMap fm = (FeatureMap)parent.eGet(fmFeature);
        EList featureList = fm.list(feature);
        int addIndex = featureList.indexOf((Object)sibling);
        featureList.add(addIndex, newElement);
        return true;
    }

    public Object addElement(Object contextNode, ExpandedName elementName, Object addBeforeThisSibling) throws SimpleElementRequiresValueException, InvalidChildException {
        EObject eObject = (EObject)contextNode;
        EStructuralFeature feature = this.getElementFeature(eObject, elementName);
        if (feature == null) {
            return null;
        }
        Object newElement = null;
        if (feature instanceof EReference) {
            boolean useAnyType = feature.getEType() == EcorePackage.eINSTANCE.getEObject();
            newElement = useAnyType ? XMLTypeFactory.eINSTANCE.createAnyType() : feature.getEType().getEPackage().getEFactoryInstance().create((EClass)feature.getEType());
        } else if (feature instanceof EAttribute) {
            throw new SimpleElementRequiresValueException(contextNode, elementName);
        }
        newElement = this.addElementToParent(eObject, feature, newElement, addBeforeThisSibling);
        if (newElement == null) {
            throw new InvalidChildException(contextNode, elementName, addBeforeThisSibling);
        }
        return newElement;
    }

    private Object addElementToParent(EObject eParent, EStructuralFeature feature, Object newElement, Object addBeforeThisSibling) {
        EStructuralFeature affiliation = EObjectInspector.getExtendedMetaData(eParent).getAffiliation(eParent.eClass(), feature);
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)affiliation)) {
            FeatureMap fm = (FeatureMap)eParent.eGet(affiliation);
            if (addBeforeThisSibling == null) {
                fm.add((Object)FeatureMapUtil.createEntry((EStructuralFeature)feature, (Object)newElement));
            } else {
                boolean added = this.addFeatureMapElement(eParent, feature, affiliation, newElement, addBeforeThisSibling);
                if (!added) {
                    newElement = null;
                }
            }
        } else if (feature.isMany()) {
            int index;
            List values = (List)eParent.eGet(feature);
            int n = index = addBeforeThisSibling != null ? values.indexOf(addBeforeThisSibling) : values.size();
            if (index != -1) {
                values.add(index, newElement);
            } else {
                newElement = null;
            }
        } else {
            eParent.eSet(feature, newElement);
        }
        return newElement;
    }

    private EStructuralFeature getElementFeature(EObject eObject, ExpandedName elementName) {
        EStructuralFeature feature;
        EClass eClass = eObject.eClass();
        String elementNS = elementName.getNamespaceURI();
        String localName = elementName.getLocalPart();
        if (this.isXMLNode(eClass)) {
            EStructuralFeature wildCardFeature;
            feature = EObjectInspector.getExtendedMetaData(eObject).getElement(eClass, elementNS, localName);
            if (feature == null && (wildCardFeature = EObjectInspector.getExtendedMetaData(eObject).getElementWildcardAffiliation(eClass, elementNS, localName)) != null) {
                feature = EObjectInspector.getExtendedMetaData(eObject).demandFeature(elementNS, localName, true);
            }
        } else {
            feature = this.getEReference(eClass, elementNS, localName);
        }
        return feature;
    }

    public void removeElement(Object contextNode) {
        EObject eObject = (EObject)contextNode;
        EObject parent = eObject.eContainer();
        if (parent != null) {
            EStructuralFeature containingFeature = eObject.eContainingFeature();
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)containingFeature)) {
                EReference feature = eObject.eContainmentFeature();
                FeatureMap fm = (FeatureMap)parent.eGet(containingFeature);
                fm.list((EStructuralFeature)feature).remove((Object)eObject);
            } else if (containingFeature.isMany()) {
                EList eList = (EList)parent.eGet(containingFeature);
                eList.remove((Object)eObject);
            } else {
                parent.eSet(containingFeature, null);
            }
        } else if (eObject.eResource() != null) {
            eObject.eResource().getContents().remove((Object)eObject);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object copyElement(Object tgtParent, Object srcElement, String name, boolean recursive) throws CopyElementException {
        void var7_13;
        EObject eObject = (EObject)tgtParent;
        EStructuralFeature feature = this.getElementFeature(eObject, new ExpandedName(name));
        Object var7_7 = null;
        INodeInspector.NodeKind nodeKind = this.getNodeKind(srcElement);
        if (srcElement instanceof EObject && nodeKind == INodeInspector.NodeKind.ELEMENT) {
            void var7_10;
            EObject srcEObject = (EObject)srcElement;
            if (recursive) {
                EObject eObject2 = EcoreUtil.copy((EObject)srcEObject);
            } else {
                EAttribute mixedFeature;
                ShallowCopier copier = new ShallowCopier();
                EObject newEObject = copier.copy(srcEObject);
                copier.copyReferences();
                EClass eClass = newEObject.eClass();
                if (this.isXMLNode(eClass) && (mixedFeature = EObjectInspector.getExtendedMetaData(eObject).getMixedFeature(eClass)) != null) {
                    FeatureMap fm = (FeatureMap)newEObject.eGet((EStructuralFeature)mixedFeature);
                    fm.clear();
                }
                EObject eObject3 = newEObject;
            }
            this.addElementToParent(eObject, feature, var7_10, null);
            return var7_13;
        } else if (srcElement instanceof EObject && nodeKind == INodeInspector.NodeKind.ROOT) {
            try {
                Object object = this.addElement(eObject, new ExpandedName(name), null);
                if (!recursive) return var7_13;
                Object[] children = this.getChildren(srcElement);
                Object root = null;
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof EObject && this.getNodeKind(children[i]) == INodeInspector.NodeKind.ELEMENT) {
                        root = children[i];
                        break;
                    }
                    ++i;
                }
                if (root == null) return var7_13;
                this.copyElement(object, root, this.expandedNameOf(root).getLocalPart(), true);
                return var7_13;
            }
            catch (SimpleElementRequiresValueException e) {
                throw new CopyElementException(e);
            }
            catch (InvalidChildException e) {
                throw new CopyElementException(e);
            }
        } else {
            if (!(srcElement instanceof EMFEAttrAsElementWrapper)) throw new CopyElementException(JET2Messages.EObjectInspector_SourceIncompatibleWithTarget);
            EMFEAttrAsElementWrapper wrapper = (EMFEAttrAsElementWrapper)srcElement;
            eObject.eSet(feature, wrapper.getValue());
            EMFEAttrAsElementWrapper eMFEAttrAsElementWrapper = new EMFEAttrAsElementWrapper(((InternalEObject)eObject).eSetting(feature));
        }
        return var7_13;
    }

    public Object addTextElement(Object parentElement, String name, String bodyContent, boolean asCData) throws AddElementException {
        EObject eObject = (EObject)parentElement;
        ExpandedName elementName = new ExpandedName(name);
        EStructuralFeature feature = this.getElementFeature(eObject, elementName);
        if (feature == null) {
            return null;
        }
        if (feature.getEType() == EcorePackage.eINSTANCE.getEObject()) {
            EStructuralFeature affiliation = EObjectInspector.getExtendedMetaData(eObject).getAffiliation(eObject.eClass(), feature);
            AnyType newElement = XMLTypeFactory.eINSTANCE.createAnyType();
            if (asCData) {
                newElement.getMixed().add((EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA(), (Object)bodyContent);
            } else {
                newElement.getMixed().add((EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text(), (Object)bodyContent);
            }
            if (affiliation.isMany()) {
                FeatureMap fm = (FeatureMap)eObject.eGet(affiliation);
                fm.add(feature, (Object)newElement);
            } else {
                eObject.eSet(feature, (Object)newElement);
            }
            return newElement;
        }
        if (feature instanceof EReference) {
            throw new AddElementException(JET2Messages.EObjectInspector_NotSimpleTextElement);
        }
        EFactory factory = feature.getEType().getEPackage().getEFactoryInstance();
        Object setValue = factory.createFromString((EDataType)feature.getEType(), bodyContent);
        if (feature.isMany()) {
            throw new UnsupportedOperationException("Not implemented yet - multi-valued simple feature");
        }
        eObject.eSet(feature, setValue);
        return new EMFEAttrAsElementWrapper(((InternalEObject)eObject).eSetting(feature));
    }

    public void removeAttribute(Object element, String name) {
        EObject eObject = (EObject)element;
        EStructuralFeature.Setting setting = this.getNamedAttributeInternal(eObject, new ExpandedName(name));
        if (setting != null) {
            setting.unset();
        }
    }

    public boolean testExpandedName(Object node, ExpandedName testName) {
        return testName.equals(this.expandedNameOf(node)) || testName.equals(this.eclassNameOf(node));
    }

    private ExpandedName eclassNameOf(Object node) {
        ExpandedName en = null;
        if (this.getNodeKind(node) == INodeInspector.NodeKind.ELEMENT) {
            en = new ExpandedName(((EObject)node).eClass().getName());
        }
        return en;
    }

    public static ExtendedMetaData getExtendedMetaData(EObject eObject) {
        Resource resource = eObject.eResource();
        ResourceSet resourceSet = resource == null ? null : resource.getResourceSet();
        ExtendedMetaData extendedMetaData = (ExtendedMetaData)resourceSetMetaData.get(resourceSet);
        if (extendedMetaData == null) {
            extendedMetaData = resourceSet == null ? new BasicExtendedMetaData() : new BasicExtendedMetaData(resourceSet.getPackageRegistry());
            resourceSetMetaData.put(resourceSet, extendedMetaData);
        }
        return extendedMetaData;
    }

    static final class ElementNameTester
    implements IXMLElementTester {
        private final ExpandedName expandedName;
        private final ExtendedMetaData exMD;
        private final EObject documentRoot;

        public ElementNameTester(ExtendedMetaData exMD, ExpandedName expandedName, EObject documentRoot) {
            this.expandedName = expandedName;
            this.exMD = exMD;
            this.documentRoot = documentRoot;
        }

        public boolean matches(Object child) {
            if (child instanceof EObject) {
                EStructuralFeature affiliation;
                EObject eChild = (EObject)child;
                EReference containmentFeature = eChild.eContainmentFeature();
                if (this.expandedName.getLocalPart().equals(this.exMD.getName((EStructuralFeature)containmentFeature)) && (this.expandedName.getNamespaceURI() == null || this.expandedName.getNamespaceURI().equals(this.exMD.getNamespace((EStructuralFeature)containmentFeature))) && this.substFeatureMatches(eChild.eClass(), containmentFeature)) {
                    return true;
                }
                String childNS = this.exMD.getNamespace((EClassifier)eChild.eClass());
                EStructuralFeature testFeature = this.exMD.getElement(childNS, this.expandedName.getLocalPart());
                EStructuralFeature eStructuralFeature = affiliation = testFeature != null ? this.exMD.getAffiliation(testFeature) : null;
                if (affiliation != null && affiliation.getName().equals(containmentFeature.getName()) && testFeature.getEType().equals(eChild.eClass())) {
                    return true;
                }
            } else if (child instanceof EMFEAttrAsElementWrapper) {
                EMFEAttrAsElementWrapper wrapper = (EMFEAttrAsElementWrapper)child;
                EStructuralFeature feature = wrapper.getFeature();
                if (this.expandedName.getLocalPart().equals(this.exMD.getName(feature)) && (this.expandedName.getNamespaceURI() == null || this.expandedName.getNamespaceURI().equals(this.exMD.getNamespace(feature)))) {
                    return true;
                }
            }
            return false;
        }

        private boolean substFeatureMatches(EClass eClass, EReference containmentFeature) {
            EStructuralFeature substitutionFeature = this.substitutionFeature(eClass);
            return substitutionFeature == null || substitutionFeature.equals(containmentFeature);
        }

        private EStructuralFeature substitutionFeature(EClass eClass) {
            if (this.documentRoot == null) {
                return null;
            }
            List globalElements = this.exMD.getElements(this.documentRoot.eClass());
            Iterator i = globalElements.iterator();
            while (i.hasNext()) {
                EStructuralFeature sf = (EStructuralFeature)i.next();
                if (this.exMD.getAffiliation(sf) == null || !sf.getEType().equals(eClass)) continue;
                return sf;
            }
            return null;
        }
    }

    static interface IXMLElementTester {
        public boolean matches(Object var1);
    }

    static class SchemaElementTester
    implements IXMLElementTester {
        private final ExpandedName expandedName;
        private final ExtendedMetaData exMD;

        public SchemaElementTester(ExtendedMetaData exMD, ExpandedName expandedName) {
            this.expandedName = expandedName;
            this.exMD = exMD;
        }

        public boolean matches(Object child) {
            if (child instanceof EObject) {
                EObject eChild = (EObject)child;
                EReference containmentFeature = eChild.eContainmentFeature();
                List<EReference> affiliations = this.getAffiliations((EStructuralFeature)containmentFeature);
                List<EReference> testFeatures = affiliations.size() > 0 ? affiliations : Collections.singletonList(containmentFeature);
                Iterator<EReference> i = testFeatures.iterator();
                while (i.hasNext()) {
                    EStructuralFeature testFeature = (EStructuralFeature)i.next();
                    if (!this.expandedName.getLocalPart().equals(this.exMD.getName(testFeature)) || this.expandedName.getNamespaceURI() != null && !this.expandedName.getNamespaceURI().equals(this.exMD.getNamespace(testFeature))) continue;
                    return true;
                }
            }
            return false;
        }

        private List getAffiliations(EStructuralFeature feature) {
            ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
            EStructuralFeature affiliation = this.exMD.getAffiliation(feature);
            while (affiliation != null) {
                result.add(affiliation);
                affiliation = this.exMD.getAffiliation(affiliation);
            }
            return result;
        }
    }

    private final class ShallowCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 5305612945568496060L;

        private ShallowCopier() {
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        }
    }
}

