/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.EcoreBuilder;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;
import org.eclipse.xtend.typesystem.xsd.builder.OawEcoreBuilder;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;
import org.eclipse.xtend.typesystem.xsd.util.XSDUtil;
import org.xml.sax.helpers.DefaultHandler;

public class OawXMLResource
extends XMLResourceImpl {
    public static final String OPTION_DEFAULT_NAMESPACE = "DEFAULT_NAMESPACE";
    public static final String OPTION_NAMESPACE_MAP = "NAMESPACE_MAP";
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());
    private XSDMetaModel metaModel;

    public OawXMLResource(URI uri, XSDMetaModel metaModel) {
        super(uri);
        this.metaModel = metaModel;
        this.setOptions();
    }

    protected XMLLoad createXMLLoad() {
        return new OawXMLLoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new OawXMLSaveImpl(this.createXMLHelper());
    }

    public XSDMetaModel getMetaModel() {
        return this.metaModel;
    }

    protected void setOptions() {
        this.setEncoding("UTF-8");
        Map load = this.getDefaultLoadOptions();
        Map save = this.getDefaultSaveOptions();
        save.put("EXTENDED_META_DATA", Boolean.TRUE);
        load.put("EXTENDED_META_DATA", Boolean.TRUE);
        load.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        save.put("LINE_WIDTH", new Integer(80));
        save.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        load.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        save.put("SCHEMA_LOCATION", Boolean.TRUE);
        load.put("URI_HANDLER", new OawUriHandler());
        XMLOptionsImpl xml = new XMLOptionsImpl();
        xml.setProcessAnyXML(true);
        xml.setProcessSchemaLocations(true);
        load.put("XML_OPTIONS", xml);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OawSAXXMLHandler
    extends SAXXMLHandler {
        private String defaultNamespace;
        private Map<String, String> namespaceMap;

        protected OawSAXXMLHandler(XMLResource xmlResource, XMLHelper helper, Map<?, ?> options) {
            super(xmlResource, helper, options);
            this.prepareOptions(options);
        }

        public void reset() {
            this.defaultNamespace = null;
            this.namespaceMap = null;
            super.reset();
        }

        public void prepare(XMLResource resource, XMLHelper helper, Map<?, ?> options) {
            super.prepare(resource, helper, options);
            this.prepareOptions(options);
        }

        protected void prepareOptions(Map<?, ?> options) {
            String dns = (String)options.get(OawXMLResource.OPTION_DEFAULT_NAMESPACE);
            this.defaultNamespace = dns != null && !dns.equals("") ? dns : null;
            Map nsm = (Map)options.get(OawXMLResource.OPTION_NAMESPACE_MAP);
            this.namespaceMap = nsm instanceof Map ? nsm : null;
        }

        public void startDocument() {
            super.startDocument();
            if (this.defaultNamespace != null) {
                super.handleXMLNSAttribute("xmlns", this.defaultNamespace);
            }
        }

        protected void handleXMLNSAttribute(String attrib, String value) {
            String resolved = value;
            if (this.namespaceMap != null) {
                String ns = this.namespaceMap.get(value);
                while (ns != null) {
                    resolved = ns;
                    ns = this.namespaceMap.get(ns);
                }
            }
            if (!resolved.equals(value)) {
                OawXMLResource.this.log.info((Object)Msg.create("Namespace Mapping: Using ").txt(attrib).txt("=").ns(resolved).txt(" instead of ").ns(value).txt(" for file ").uri(this.xmlResource.getURI()));
            }
            super.handleXMLNSAttribute(attrib, resolved);
        }

        protected EcoreBuilder createEcoreBuilder(Map<?, ?> options, ExtendedMetaData extendedMetaData) {
            return new OawEcoreBuilder(OawXMLResource.this.metaModel.getXsdManager());
        }
    }

    public class OawUriHandler
    extends URIHandlerImpl {
        public URI resolve(URI uri) {
            return XSDUtil.resolve(OawXMLResource.this.getURIConverter(), this.baseURI, uri.toString());
        }

        public void setBaseURI(URI uri) {
            super.setBaseURI(uri);
        }
    }

    protected class OawXMLLoadImpl
    extends XMLLoadImpl {
        protected OawXMLLoadImpl(XMLHelper helper) {
            super(helper);
        }

        protected DefaultHandler makeDefaultHandler() {
            return new OawSAXXMLHandler(this.resource, this.helper, this.options);
        }
    }

    protected class OawXMLSaveImpl
    extends XMLSaveImpl {
        public OawXMLSaveImpl(XMLHelper helper) {
            super(helper);
        }

        private void tryCreateDocumentRoot(EObject obj) {
            EReference ref2;
            EClass drClass = this.extendedMetaData.getDocumentRoot(obj.eClass().getEPackage());
            if (drClass == obj.eClass()) {
                return;
            }
            this.roots = Arrays.asList(obj);
            if (obj.eContainer() != null && obj.eContainer().eClass() == drClass) {
                return;
            }
            ArrayList<EReference> refs = new ArrayList<EReference>();
            for (EReference ref2 : drClass.getEReferences()) {
                if (ref2.getEType() != obj.eClass()) continue;
                refs.add(ref2);
            }
            if (refs.size() < 1) {
                OawXMLResource.this.log.warn((Object)("The DocumentRoot class '" + drClass.getName() + "' has no valid property (aka xsd " + "element) to contain a '" + obj.eClass().getName() + "' object. Therefore, no " + "DocumentRoot object is created. " + " You might want to add an element of type '" + obj.eClass().getName() + "' to your XML schema definition."));
                return;
            }
            ref2 = (EReference)refs.get(0);
            if (refs.size() > 1) {
                OawXMLResource.this.log.warn((Object)("The DocumentRoot class '" + drClass.getName() + "' has more than one property (aka xsd " + "element) to contain a '" + obj.eClass().getName() + "' object. Therefore, the first property " + "has been choosen ('" + ref2.getName() + "'). If this decision is not ok, you should " + "supply the XMLWriter with an object of type '" + drClass.getName() + "' rather than '" + obj.eClass().getName() + "'."));
            }
            OawXMLResource.this.log.info((Object)Msg.create("Created ").scls(drClass).txt(" for ").scls(obj));
            EObject docroot = EcoreUtil.create((EClass)drClass);
            docroot.eSet((EStructuralFeature)ref2, (Object)obj);
        }

        protected Object writeTopObject(EObject top) {
            this.tryCreateDocumentRoot(top);
            return super.writeTopObject(top);
        }
    }
}

