/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.xtend.CheckBackendFacade;
import org.eclipse.xtend.middleend.xtend.XtendBackendFacade;
import org.eclipse.xtend.middleend.xtend.plugin.OldCheckRegistryFactory;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private String _expression = null;
    private List<String> _checkFiles = new ArrayList<String>();
    private boolean _abortOnError = true;
    private boolean _warnIfNothingChecked = false;
    private String _emfAllChildrenSlot;
    private String _fileEncoding = null;

    public CheckComponent() {
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Xtend") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldXtendRegistryFactory.class);
        }
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Check") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldCheckRegistryFactory.class);
        }
    }

    public void setAbortOnError(boolean abortOnError) {
        this._abortOnError = abortOnError;
    }

    public void addCheckFile(String checkFile) {
        this._checkFiles.add(checkFile);
    }

    public void setExpression(String expression) {
        this._expression = expression;
    }

    public void setWarnIfNothingChecked(boolean b) {
        this._warnIfNothingChecked = b;
    }

    public void setEmfAllChildrenSlot(String childExpression) {
        this._emfAllChildrenSlot = childExpression;
    }

    public void setFileEncoding(String fileEncoding) {
        this._fileEncoding = fileEncoding;
    }

    public String getLogMessage() {
        StringBuilder result = new StringBuilder();
        if (this._emfAllChildrenSlot != null) {
            result.append("slot " + this._emfAllChildrenSlot + " ");
        } else {
            result.append("expression " + this._expression + " ");
        }
        result.append("check file(s): ");
        for (String f : this._checkFiles) {
            result.append(String.valueOf(f) + " ");
        }
        return result.toString();
    }

    protected void invokeInternal2(WorkflowContext wfCtx, ProgressMonitor monitor, Issues issues) {
        Collection<?> allObjects = this.getExpressionResult(wfCtx, this._expression);
        for (String checkFile : this._checkFiles) {
            CheckBackendFacade.checkAll(checkFile, this._fileEncoding, this.metaModels, issues, allObjects);
        }
        if (this._abortOnError && issues.hasErrors()) {
            throw new WorkflowInterruptedException("Errors during validation.");
        }
    }

    public void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this._expression == null && this._emfAllChildrenSlot != null) {
            this._expression = String.valueOf(this._emfAllChildrenSlot) + ".eAllContents.union ( {" + this._emfAllChildrenSlot + "} )";
        } else if (this._expression == null || this._emfAllChildrenSlot != null) {
            issues.addError((WorkflowComponent)this, "You have to set one of the properties 'expression' and 'emfAllChildrenSlot'!");
        }
        if (this._checkFiles.isEmpty()) {
            issues.addError((WorkflowComponent)this, "Property 'checkFile' not set!");
        }
    }

    private Collection<?> getExpressionResult(WorkflowContext wfCtx, String expression2) {
        HashMap<String, Object> localVars = new HashMap<String, Object>();
        String[] names = wfCtx.getSlotNames();
        int i = 0;
        while (i < names.length) {
            localVars.put(names[i], wfCtx.get(names[i]));
            ++i;
        }
        Object result = XtendBackendFacade.evaluateExpression(expression2, this.metaModels, localVars);
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(result);
    }
}

