/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.emf.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.backend.util.CollectionHelper;
import org.eclipse.xtend.backend.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EClassType
extends AbstractType {
    private final EClass _cls;

    public EClassType(EClass cls, EmfTypesystem ts) {
        super(EmfTypesystem.getFullyQualifiedName((ENamedElement)cls), EmfTypesystem.getUniqueIdentifier((EClassifier)cls), EClassType.superTypes(cls, ts));
        this._cls = cls;
    }

    public void init(EmfTypesystem ts) {
        this.initProperties(ts);
        this.initOperations(ts);
    }

    private void initProperties(EmfTypesystem ts) {
        for (final EStructuralFeature feature : this._cls.getEStructuralFeatures()) {
            final BackendType t = ts.getTypeForETypedElement((ETypedElement)feature);
            if (feature.isChangeable() && !feature.isUnsettable() && !feature.isDerived()) {
                this.register(new AbstractProperty(this, feature.getEType().getInstanceClass(), feature.getName(), true, true){

                    public Object getRaw(ExecutionContext ctx, Object o) {
                        return ((EObject)o).eGet(feature);
                    }

                    public void setRaw(ExecutionContext ctx, Object o, Object newValue) {
                        ((EObject)o).eSet(feature, newValue);
                    }

                    public BackendType getType(BackendTypesystem ts) {
                        return t;
                    }
                }, t);
                continue;
            }
            this.register(new AbstractProperty(this, feature.getEType().getInstanceClass(), feature.getName(), true, false){

                public Object getRaw(ExecutionContext ctx, Object o) {
                    return ((EObject)o).eGet(feature);
                }

                public BackendType getType(BackendTypesystem ts) {
                    return t;
                }
            }, t);
        }
    }

    private void initOperations(EmfTypesystem ts) {
        for (EOperation op : this._cls.getEOperations()) {
            Class[] paramClasses = new Class[op.getEParameters().size()];
            int i = 0;
            final ArrayList<BackendType> paramTypes = new ArrayList<BackendType>();
            paramTypes.add(this);
            for (EParameter param : op.getEParameters()) {
                paramTypes.add(ts.getTypeForETypedElement((ETypedElement)param));
                paramClasses[i++] = param.getEType().getInstanceClass();
            }
            final ListType returnType = op.isMany() ? ListType.INSTANCE : ts.getTypeForEClassifier(op.getEType());
            try {
                final Method mtd = this._cls.getInstanceClass().getMethod(op.getName(), paramClasses);
                this.register(new QualifiedName(op.getName()), new Function(){

                    @Override
                    public ExpressionBase getGuard() {
                        return null;
                    }

                    @Override
                    public List<? extends BackendType> getParameterTypes() {
                        return paramTypes;
                    }

                    @Override
                    public Object invoke(ExecutionContext ctx, Object[] params) {
                        try {
                            return mtd.invoke(params[0], CollectionHelper.withoutFirst(params));
                        }
                        catch (Exception e) {
                            ErrorHandler.handle(e);
                            return null;
                        }
                    }

                    @Override
                    public boolean isCached() {
                        return false;
                    }

                    @Override
                    public FunctionDefContext getFunctionDefContext() {
                        return null;
                    }

                    @Override
                    public void setFunctionDefContext(FunctionDefContext fdc) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public BackendType getReturnType() {
                        return returnType;
                    }
                });
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        }
    }

    @Override
    public Object create() {
        return this._cls.getEPackage().getEFactoryInstance().create(this._cls);
    }

    private static Collection<? extends BackendType> superTypes(EClass eClass, EmfTypesystem ts) {
        HashSet<BackendType> result = new HashSet<BackendType>();
        for (EClass ec : eClass.getESuperTypes()) {
            result.add(ts.getTypeForEClassifier((EClassifier)ec));
        }
        result.add(EObjectType.INSTANCE);
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._cls == null ? 0 : this._cls.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EClassType other = (EClassType)obj;
        return !(this._cls == null ? other._cls != null : !this._cls.equals(other._cls));
    }
}

