/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui;

import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.editor.EEditor;
import org.eclipse.emf.editor.ui.GenericDetailsPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class EEMasterDetailsBlock
extends MasterDetailsBlock {
    private SectionPart masterSectionPart;
    private IDetailsPageProvider pageProvider;

    public EEMasterDetailsBlock(IDetailsPageProvider pageProvider) {
        this.pageProvider = pageProvider;
    }

    public SectionPart getMasterSectionPart() {
        return this.masterSectionPart;
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        Composite container = managedForm.getToolkit().createComposite(parent);
        container.setLayout((Layout)new GridLayout());
        Section section = managedForm.getToolkit().createSection(container, 256);
        section.setLayout((Layout)new FillLayout());
        section.setLayoutData((Object)new GridData(1808));
        section.setText("Model");
        Composite mastersClientArea = managedForm.getToolkit().createComposite((Composite)section);
        section.setClient((Control)mastersClientArea);
        this.masterSectionPart = new SectionPart(section);
        managedForm.addPart((IFormPart)this.masterSectionPart);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        this.sashForm.setOrientation(EEditor.formularOrientation());
        ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                EEMasterDetailsBlock.this.sashForm.setOrientation(512);
                EEMasterDetailsBlock.this.persistOrientation(512);
            }
        };
        haction.setChecked(this.sashForm.getOrientation() == 512);
        haction.setToolTipText("Horizontal orientation");
        haction.setImageDescriptor(EEPlugin.getDefault().getImageDescriptor("/icons/det_pane_under.gif"));
        Action vaction = new Action("ver", 8){

            public void run() {
                EEMasterDetailsBlock.this.sashForm.setOrientation(256);
                EEMasterDetailsBlock.this.persistOrientation(256);
            }
        };
        vaction.setChecked(this.sashForm.getOrientation() == 256);
        vaction.setToolTipText("Vertical orientation");
        vaction.setImageDescriptor(EEPlugin.getDefault().getImageDescriptor("/icons/det_pane_right.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
        this.createMoreToolBarActions(form.getToolBarManager());
        form.getToolBarManager().update(true);
    }

    protected void persistOrientation(int orientation) {
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        store.setValue("eeditor.orientation", orientation);
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider(this.pageProvider);
        detailsPart.setPageLimit(1);
    }

    public Control findControl(String key, Object data) {
        if (this.detailsPart.getCurrentPage() instanceof GenericDetailsPage) {
            return ((GenericDetailsPage)this.detailsPart.getCurrentPage()).locateControl(key, data);
        }
        return null;
    }

    protected void createMoreToolBarActions(IToolBarManager toolBarManager) {
    }
}

