/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.QualifiedName;

public class Identifier
extends SyntaxElement {
    private QualifiedName qn;

    public Identifier(String ... segments) {
        String[] qnSegments = new String[segments.length];
        int i = 0;
        while (i < segments.length) {
            qnSegments[i] = segments[i].charAt(0) == '^' ? segments[i].substring(1) : segments[i];
            ++i;
        }
        this.qn = QualifiedName.create(qnSegments);
    }

    public Identifier(String segment) {
        this.qn = QualifiedName.create(segment.charAt(0) == '^' ? segment.substring(1) : segment);
    }

    public Identifier append(Identifier t) {
        this.qn = this.qn.append(t.qn);
        this.end = t.end;
        return this;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return this.qn.toString();
    }

    public int getSegmentCount() {
        return this.qn.getSegmentCount();
    }

    public String getSegment(int index) {
        return this.qn.getSegment(index);
    }

    public String getLastSegment() {
        return this.qn.getLastSegment();
    }

    public String getFirstSegment() {
        return this.qn.getFirstSegment();
    }

    public int hashCode() {
        return this.qn.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.qn == other.qn;
    }
}

