/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.DoubleType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.LongType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.StringType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.emf.internal.EClassType;
import org.eclipse.xtend.backend.types.emf.internal.EDataTypeType;
import org.eclipse.xtend.backend.types.emf.internal.EEnumType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmfTypesystem
implements BackendTypesystem {
    private BackendTypesystem _rootTypesystem;
    public static final String UNIQUE_REPRESENTATION_PREFIX = "{emf}";
    private final Map<EClassifier, BackendType> _cache = new HashMap<EClassifier, BackendType>();
    private static final Map<EClassifier, BackendType> _ecorePrimitives = new HashMap<EClassifier, BackendType>();

    static {
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEString(), StringType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), StringType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), StringType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), BooleanType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), BooleanType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getELong(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEShortObject(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), LongType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), DoubleType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), DoubleType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), DoubleType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), DoubleType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), DoubleType.INSTANCE);
        _ecorePrimitives.put((EClassifier)EcorePackage.eINSTANCE.getEJavaObject(), ObjectType.INSTANCE);
    }

    public static String getUniqueIdentifier(EClassifier cls) {
        return "{emf}{" + cls.getEPackage().getNsURI() + "}" + cls.getName();
    }

    @Override
    public BackendType findType(String uniqueRepresentation) {
        if (!uniqueRepresentation.startsWith(UNIQUE_REPRESENTATION_PREFIX)) {
            return null;
        }
        uniqueRepresentation = uniqueRepresentation.substring(UNIQUE_REPRESENTATION_PREFIX.length());
        String nsUri = uniqueRepresentation.substring(1, uniqueRepresentation.indexOf(125));
        String name = uniqueRepresentation.substring(uniqueRepresentation.indexOf(125) + 1);
        EPackage pkg = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        TreeIterator iter = pkg.eAllContents();
        while (iter.hasNext()) {
            EClassifier cls;
            EObject eo = (EObject)iter.next();
            if (!(eo instanceof EClassifier) || !name.equals((cls = (EClassifier)eo).getName())) continue;
            return this.getTypeForEClassifier(cls);
        }
        return null;
    }

    public BackendType getTypeForEClassifier(EClassifier cls) {
        BackendType cached = this._cache.get(cls);
        if (cached != null) {
            return cached;
        }
        if (cls instanceof EClass) {
            EClassType result = new EClassType((EClass)cls, this);
            this._cache.put(cls, result);
            result.init(this);
            return result;
        }
        BackendType result = this.getTypeForEClassifierRaw(cls);
        this._cache.put(cls, result);
        return result;
    }

    private BackendType getTypeForEClassifierRaw(EClassifier cls) {
        if (cls instanceof EEnum) {
            return new EEnumType((EEnum)cls);
        }
        BackendType primitiveCandidate = _ecorePrimitives.get(cls);
        if (primitiveCandidate != null) {
            return primitiveCandidate;
        }
        if (cls instanceof EDataType) {
            return new EDataTypeType((EDataType)cls);
        }
        return null;
    }

    @Override
    public BackendType findType(Object obj) {
        if (!(obj instanceof EObject)) {
            return null;
        }
        if (obj instanceof EEnumLiteral) {
            return this.getTypeForEClassifier((EClassifier)((EEnumLiteral)obj).getEEnum());
        }
        return this.getTypeForEClassifier((EClassifier)((EObject)obj).eClass());
    }

    public BackendType getTypeForETypedElement(ETypedElement typedElement) {
        if (typedElement.getUpperBound() != 1) {
            return ListType.INSTANCE;
        }
        return this.getTypeForEClassifier(typedElement.getEType());
    }

    public static String getFullyQualifiedName(ENamedElement ele) {
        return EmfTypesystem.getFqnRec(ele.eContainer(), ele.getName());
    }

    private static final String getFqnRec(EObject ele, String suffix) {
        if (ele == null || !(ele instanceof ENamedElement)) {
            return suffix;
        }
        return EmfTypesystem.getFqnRec(ele.eContainer(), String.valueOf(((ENamedElement)ele).getName()) + "::" + suffix);
    }

    @Override
    public BackendType findType(Class<?> cls) {
        if (EObject.class.isAssignableFrom(cls)) {
            return EObjectType.INSTANCE;
        }
        return null;
    }

    @Override
    public BackendTypesystem getRootTypesystem() {
        return this._rootTypesystem;
    }

    @Override
    public void setRootTypesystem(BackendTypesystem ts) {
        this._rootTypesystem = ts;
    }
}

