/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.ResourceContributor2;
import org.eclipse.xtend.shared.ui.core.AbstractResource;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandBuilder;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandProject
implements IXtendXpandProject {
    private static final Set<IJavaProject> initializing = new HashSet<IJavaProject>();
    private static final IXtendXpandResource NULL_RESOURCE = new AbstractResource(null){

        @Override
        public String getFileExtension() {
            return null;
        }

        @Override
        protected void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        }

        @Override
        protected boolean internalRefresh() {
            return false;
        }
    };
    final IJavaProject project;
    private IElementChangedListener changeListener;
    private IResourceChangeListener resourceChangeListener;
    private final Map<ResourceID, IXtendXpandResource> resources = new HashMap<ResourceID, IXtendXpandResource>();
    private final Set<ResourceID> fromJar = new HashSet<ResourceID>();

    public XtendXpandProject(IJavaProject resource) {
        this.project = resource;
        try {
            IProject[] ps;
            IProject[] iProjectArray = ps = this.project.getProject().getReferencedProjects();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IProject element = iProjectArray[n2];
                if (initializing.add(this.project)) {
                    try {
                        Activator.getExtXptModelManager().findProject((IResource)element);
                    }
                    finally {
                        initializing.remove(this.project);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        this.installListeners();
        Job j = new Job("Initializing " + this.project.getElementName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject p = XtendXpandProject.this.project.getProject();
                    if (p.isAccessible() && p.isNatureEnabled(XtendXpandNature.NATURE_ID)) {
                        p.build(15, XtendXpandBuilder.getBUILDER_ID(), new HashMap(), monitor);
                    }
                }
                catch (CoreException e) {
                    XtendLog.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule(this.project.getResource().getWorkspace().getRuleFactory().buildRule());
        j.schedule();
    }

    private void installListeners() {
        this.changeListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (XtendXpandProject.this.fromJar.isEmpty()) {
                    return;
                }
                if (XtendXpandProject.this.containsRemovedClassPathEntry(event.getDelta().getAffectedChildren())) {
                    XtendXpandProject.this.removeResourcesFromJar();
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.changeListener, (int)1);
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 4 && event.getResource().getFullPath().equals((Object)XtendXpandProject.this.project.getPath())) {
                    XtendXpandProject.this.dispose();
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.changeListener);
        this.changeListener = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.resourceChangeListener = null;
        this.resources.clear();
        this.fromJar.clear();
    }

    protected boolean containsRemovedClassPathEntry(IJavaElementDelta[] affectedChildren) {
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            if ((delta.getFlags() & 0x80) != 0) {
                return true;
            }
            if (this.containsRemovedClassPathEntry(delta.getAffectedChildren())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void removeResourcesFromJar() {
        for (ResourceID id : this.fromJar) {
            this.resources.remove(id);
        }
    }

    @Override
    public IXtendXpandResource[] getRegisteredResources() {
        return this.resources.values().toArray(new IXtendXpandResource[this.resources.size()]);
    }

    @Override
    public IXtendXpandResource[] getAllRegisteredResources() {
        HashSet<IXtendXpandResource> result = new HashSet<IXtendXpandResource>();
        result.addAll(Arrays.asList(this.getRegisteredResources()));
        IXtendXpandProject[] iXtendXpandProjectArray = this.getAllReferencedProjects();
        int n = iXtendXpandProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject p = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(p.getRegisteredResources()));
            ++n2;
        }
        return result.toArray(new IXtendXpandResource[result.size()]);
    }

    @Override
    public IXtendXpandProject[] getReferencedProjects() {
        HashSet<IXtendXpandProject> result = new HashSet<IXtendXpandProject>();
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.getProject().getProject().getReferencedProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)project);
                if (p != null) {
                    result.add(p);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    @Override
    public IXtendXpandProject[] getAllReferencedProjects() {
        HashSet<IXtendXpandProject> result = new HashSet<IXtendXpandProject>();
        IXtendXpandProject[] projects = this.getReferencedProjects();
        result.addAll(Arrays.asList(projects));
        IXtendXpandProject[] iXtendXpandProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject project = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(project.getAllReferencedProjects()));
            ++n2;
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    @Override
    public IJavaProject getProject() {
        return this.project;
    }

    @Override
    public void unregisterXtendXpandResource(IXtendXpandResource res) {
        if (res != null && res.getUnderlyingStorage() instanceof IFile) {
            IFile file = (IFile)res.getUnderlyingStorage();
            XtendXpandMarkerManager.deleteMarkers((IResource)file);
            ResourceID toRemove = null;
            for (Map.Entry<ResourceID, IXtendXpandResource> entry : this.resources.entrySet()) {
                if (entry.getValue() != toRemove) continue;
                toRemove = entry.getKey();
                break;
            }
            if (toRemove != null) {
                this.resources.remove(toRemove);
            }
        }
    }

    @Override
    public IXtendXpandResource findExtXptResource(String fqn, String extension) {
        assert (fqn != null);
        assert (extension != null);
        if (Activator.getRegisteredResourceContributorFor(extension) == null) {
            throw new IllegalArgumentException("No resource contributor available for extension " + extension);
        }
        ResourceID resId = new ResourceID(fqn, extension);
        IXtendXpandResource res = this.findCachedXtendXpandResource(fqn, extension);
        if (res == NULL_RESOURCE) {
            return null;
        }
        if (res != null) {
            IFile workspaceFile;
            if (res.getUnderlyingStorage() instanceof IFile && !(workspaceFile = (IFile)res.getUnderlyingStorage()).exists()) {
                return null;
            }
            return res;
        }
        res = this.loadXtendXpandResource(fqn, extension, false);
        if (res == null) {
            res = this.loadXtendXpandResource(fqn, extension, true);
        }
        this.resources.put(resId, res != null ? res : NULL_RESOURCE);
        return res;
    }

    private IXtendXpandResource findCachedXtendXpandResource(String fqn, String extension) {
        IXtendXpandResource resource = this.resources.get(new ResourceID(fqn, extension));
        if (resource != null && resource != NULL_RESOURCE) {
            return resource;
        }
        return null;
    }

    private IXtendXpandResource loadXtendXpandResource(String fqn, String extension, boolean searchJars) {
        return this.loadXtendXpandResource(fqn, extension, searchJars, new HashSet<XtendXpandProject>(5));
    }

    private IXtendXpandResource loadXtendXpandResource(String fqn, String extension, boolean searchJars, Set<XtendXpandProject> projects) {
        assert (fqn != null);
        assert (extension != null);
        ResourceID resourceID = new ResourceID(fqn, extension);
        if (!projects.add(this)) {
            return null;
        }
        IStorage storage = Activator.findStorage(this.project, new ResourceID(fqn, extension), searchJars);
        if (storage != null && (searchJars || storage instanceof IFile)) {
            ResourceID jdtResourceID = JDTUtil.findXtendXpandResourceID(this.getProject(), storage);
            IXtendXpandResource result = null;
            String fileExtension = storage.getFullPath().getFileExtension();
            ResourceContributor contr = Activator.getRegisteredResourceContributorFor(fileExtension);
            if (contr != null && (result = contr instanceof ResourceContributor2 ? ((ResourceContributor2)contr).create(this.project.getProject(), storage, fqn) : contr.create(storage, fqn)) != null) {
                this.resources.put(jdtResourceID, result);
                if (!(storage instanceof IFile)) {
                    this.fromJar.add(jdtResourceID);
                }
                return result;
            }
        }
        try {
            IProject[] p;
            IProject[] iProjectArray = p = this.project.getProject().getReferencedProjects();
            int n = p.length;
            int n2 = 0;
            while (n2 < n) {
                IXtendXpandResource result;
                IProject project = iProjectArray[n2];
                XtendXpandProject extxptp = (XtendXpandProject)Activator.getExtXptModelManager().findProject((IResource)project);
                if (extxptp != null && (result = extxptp.loadXtendXpandResource(fqn, extension, searchJars, projects)) != null) {
                    if (storage == null) {
                        storage = result.getUnderlyingStorage();
                    }
                    this.resources.put(resourceID, result);
                    return result;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    @Override
    public IXtendXpandResource findXtendXpandResource(IStorage file) {
        if (file == null) {
            return null;
        }
        ResourceID id = Activator.findXtendXpandResourceID(this.project, file);
        if (id == null) {
            return null;
        }
        return this.findExtXptResource(id.name, id.extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(IProgressMonitor monitor, ExecutionContext ctx) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.resources.size());
        for (IXtendXpandResource resource : this.resources.values()) {
            if (monitor.isCanceled()) {
                return;
            }
            IXtendXpandResource iXtendXpandResource = resource;
            synchronized (iXtendXpandResource) {
                if (!this.isInExternalPackageFragmentRoot(resource)) {
                    String resName = resource.getUnderlyingStorage() != null ? resource.getUnderlyingStorage().getFullPath().toString() : resource.getFullyQualifiedName();
                    subMon.subTask("Analyzing resource " + resName);
                    resource.analyze(ctx);
                }
            }
            subMon.worked(1);
        }
    }

    private boolean isInExternalPackageFragmentRoot(IXtendXpandResource resource) {
        IStorage underlyingStorage = resource.getUnderlyingStorage();
        IProject containerProject = null;
        if (underlyingStorage instanceof IJarEntryResource) {
            containerProject = ((IJarEntryResource)underlyingStorage).getPackageFragmentRoot().getJavaProject().getProject();
        }
        if (underlyingStorage instanceof IFile) {
            containerProject = ((IFile)underlyingStorage).getProject();
        }
        return containerProject != null && containerProject.isHidden();
    }

    public String toString() {
        return this.project.getPath().toString();
    }

    public IElementChangedListener getElementChangeListener() {
        return this.changeListener;
    }

    public final Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

