/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.common;

import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FutureResultNotReadyException;
import org.eclipse.xtend.backend.common.QualifiedName;

public class FutureResultHolder {
    private Object _value;
    private QualifiedName _name;
    private boolean _isReady = false;
    private Function _function;
    private ExpressionBase _expression;

    public FutureResultHolder() {
    }

    public FutureResultHolder(Function function) {
        this._function = function;
    }

    public FutureResultHolder(ExpressionBase expression) {
        this._expression = expression;
    }

    public FutureResultHolder(QualifiedName name, Function function) {
        this._name = name;
        this._function = function;
    }

    public Object evaluate(ExecutionContext ctx) throws FutureResultNotReadyException {
        if (this._function != null) {
            this.setValue(this._function.invoke(ctx, new Object[0]));
        } else if (this._expression != null) {
            this.setValue(this._expression.evaluate(ctx));
        } else {
            throw new FutureResultNotReadyException();
        }
        return this.getValue();
    }

    public Object getValue() throws FutureResultNotReadyException {
        if (!this._isReady) {
            throw new FutureResultNotReadyException();
        }
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
        this._isReady = true;
    }

    public QualifiedName getName() {
        return this._name;
    }

    public boolean isReady() {
        return this._isReady;
    }

    public Function getFunction() {
        return this._function;
    }

    public void setFunction(Function _function) {
        this._function = _function;
    }

    public ExpressionBase getExpression() {
        return this._expression;
    }

    public void setExpression(ExpressionBase _expression) {
        this._expression = _expression;
    }

    public String toString() {
        if (!this._isReady) {
            throw new FutureResultNotReadyException();
        }
        if (this._value == null) {
            return "";
        }
        return this._value.toString();
    }
}

