/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.aop;

import java.util.List;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.aop.ThisJoinPoint;
import org.eclipse.xtend.backend.aop.ThisJoinPointStaticPart;
import org.eclipse.xtend.backend.aop.internal.AdviceScopeCounter;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.util.ObjectWrapper;
import org.eclipse.xtend.backend.util.Triplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdvisedFunction {
    private final Function _function;
    private final List<AroundAdvice> _advice;
    private final int _firstCacheableIndex;
    private final AdviceScopeCounter _scopeCounter;
    private final ThisJoinPointStaticPart _thisJoinPointStaticPart;

    public AdvisedFunction(QualifiedName functionName, Function function, List<AroundAdvice> advice, AdviceScopeCounter scopeCounter) {
        this._function = function;
        this._advice = advice;
        this._scopeCounter = scopeCounter;
        this._thisJoinPointStaticPart = new ThisJoinPointStaticPart(functionName, this._function);
        if (function.isCached()) {
            int firstCacheableIndex = advice.size();
            while (firstCacheableIndex > 0 && advice.get(firstCacheableIndex - 1).isCacheable()) {
                --firstCacheableIndex;
            }
            this._firstCacheableIndex = firstCacheableIndex;
        } else {
            this._firstCacheableIndex = advice.size();
        }
    }

    public Object evaluate(ExecutionContext ctx, List<?> params) {
        return this.proceedInternal(ctx, 0, params);
    }

    private Object proceedInternal(final ExecutionContext ctx, final int indNextAdvice, List<?> params) {
        ObjectWrapper ow;
        if (indNextAdvice >= this._advice.size()) {
            return ctx.getFunctionInvoker().invoke(ctx, this._function, params);
        }
        if (indNextAdvice >= this._firstCacheableIndex && (ow = ctx.getAdviceContext().getResultCache().get(new Triplet(this._function, this._advice.get(indNextAdvice), params))) != null) {
            return ow._content;
        }
        ThisJoinPoint thisJoinPoint = new ThisJoinPoint(ctx.getStacktrace(), params){

            @Override
            public Object proceedWithParams(List<?> localParams) {
                return AdvisedFunction.this.proceedInternal(ctx, indNextAdvice + 1, localParams);
            }
        };
        AroundAdvice advice = this._advice.get(indNextAdvice);
        Object result = advice.evaluate(ctx, this._scopeCounter, thisJoinPoint, this._thisJoinPointStaticPart);
        if (indNextAdvice >= this._firstCacheableIndex) {
            Triplet key = new Triplet(this._function, this._advice.get(indNextAdvice), params);
            ctx.getAdviceContext().getResultCache().put(key, new ObjectWrapper(result));
        }
        return result;
    }
}

