/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.syslib;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.common.EfficientLazyString;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Helpers;
import org.eclipse.xtend.middleend.javaannotations.AbstractExecutionContextAware;
import org.eclipse.xtend.middleend.javaannotations.M2tNoFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringOperations
extends AbstractExecutionContextAware {
    public String toString(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    public boolean startsWith(String s1, String s2) {
        if (s1 == null || s2 == null) {
            this._ctx.logNullDeRef(null);
            return false;
        }
        return s1.startsWith(s2);
    }

    public boolean endsWith(String s1, String s2) {
        if (s1 == null || s2 == null) {
            this._ctx.logNullDeRef(null);
            return false;
        }
        return s1.endsWith(s2);
    }

    public boolean contains(String s1, String s2) {
        if (s1 == null || s2 == null) {
            this._ctx.logNullDeRef(null);
            return false;
        }
        return s1.contains(s2);
    }

    public String substring(String s, int indexFrom) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.substring(indexFrom);
    }

    public CharSequence substring(CharSequence s, int indexFrom, int indexTo) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.subSequence(indexFrom, indexTo);
    }

    public String toUpperCase(String s) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.toUpperCase();
    }

    public String toLowerCase(String s) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.toLowerCase();
    }

    public String toFirstUpper(String s) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        if (s.length() < 2) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public String toFirstLower(String s) {
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        if (s.length() < 2) {
            return s.toLowerCase();
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public List<String> toCharList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            this._ctx.logNullDeRef(null);
            return result;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            result.add("" + ch);
            ++n2;
        }
        return result;
    }

    public String replace(String s, CharSequence searchString, CharSequence replaceString) {
        if (s == null || searchString == null || replaceString == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.replace(searchString, replaceString);
    }

    public String replaceFirstUsingRegex(String s, String searchString, String replaceString) {
        if (s == null || searchString == null || replaceString == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.replaceFirst(searchString, replaceString);
    }

    public String replaceAllUsingRegex(String s, String searchString, String replaceString) {
        if (s == null || searchString == null || replaceString == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.replaceAll(searchString, replaceString);
    }

    public String[] split(String s, String regex) {
        if (s == null || regex == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.split(regex);
    }

    public Boolean matches(String s, String regex) {
        if (s == null || regex == null) {
            this._ctx.logNullDeRef(null);
            return null;
        }
        return s.matches(regex);
    }

    public String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public Long asInteger(String s) {
        if (s == null) {
            return null;
        }
        return Long.valueOf(s);
    }

    public CharSequence operatorPlus(Object o1, Object o2) {
        return this.concat(o1, o2);
    }

    public CharSequence concat(Object o1, Object o2) {
        if (o1 instanceof EfficientLazyString) {
            return EfficientLazyString.createAppendedString((EfficientLazyString)o1, StringOperations.overridableToString(this._ctx, o2));
        }
        EfficientLazyString result = new EfficientLazyString();
        result = EfficientLazyString.createAppendedString(result, StringOperations.overridableToString(this._ctx, o1));
        result = EfficientLazyString.createAppendedString(result, StringOperations.overridableToString(this._ctx, o2));
        return result;
    }

    @M2tNoFunction
    public static CharSequence overridableToString(ExecutionContext ctx, Object o) {
        return Helpers.overridableToString(ctx, o);
    }
}

