/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.type;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

public class EMapEntryType
extends AbstractTypeImpl {
    private Type keyType;
    private Type valueType;
    private EClassifier emfType;

    public static boolean isEMapEntry(ETypedElement element) {
        EClassifier t = element.getEType();
        return element.eContainer() instanceof EClass && t != null && t.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(t.getInstanceClass()) && !element.isMany();
    }

    public static boolean isEMapEntryObject(Object o) {
        return o instanceof Map.Entry;
    }

    public EMapEntryType(TypeSystem typeSystem, String name, EClassifier innerType) {
        super(typeSystem, name);
        this.determineTypes(innerType);
    }

    private void determineTypes(EClassifier emfType) {
        this.emfType = emfType;
        EClass str2str = EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY;
        if (emfType instanceof EClass && str2str.isSuperTypeOf((EClass)emfType)) {
            this.keyType = this.getTypeSystem().getStringType();
            this.valueType = this.getTypeSystem().getStringType();
        } else {
            this.keyType = this.getTypeSystem().getObjectType();
            this.valueType = this.getTypeSystem().getObjectType();
        }
    }

    public Feature[] getContributedFeatures() {
        return new Feature[]{new PropertyImpl((Type)this, "value", this.valueType){

            public Object get(Object target) {
                Map.Entry ent = (Map.Entry)target;
                return ent.getValue();
            }
        }, new PropertyImpl((Type)this, "key", this.keyType){

            public Object get(Object target) {
                Map.Entry ent = (Map.Entry)target;
                return ent.getKey();
            }
        }, new OperationImpl((Type)this, "setValue", this.valueType, new Type[]{this.valueType}){

            protected Object evaluateInternal(Object target, Object[] params) {
                Map.Entry ent = (Map.Entry)target;
                Object old = ent.getValue();
                ent.setValue(params[0]);
                return old;
            }
        }};
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public EClassifier getEmfType() {
        return this.emfType;
    }

    public boolean isInstance(Object o) {
        return o instanceof Map.Entry;
    }

    public Object newInstance() {
        throw new UnsupportedOperationException("Map entries can not be instantiated standlaone");
    }
}

