/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.xtend.shared.ui.editor.preferences.Messages;
import org.eclipse.xtend.shared.ui.editor.preferences.UiDetailsPreferencePage;

public class TokenListFieldEditor
extends FieldEditor {
    private static final String[][] PREFERENCES = new String[][]{{Messages.xtendxpanduipref_keywords, "xpd_keywords"}, {Messages.xtendxpanduipref_terminals, "xpd_terminals"}, {Messages.xtendxpanduipref_definitions, "xpd_define"}, {Messages.xtendxpanduipref_strings, "xpd_string"}, {Messages.xtendxpanduipref_comments, "xpd_comment"}, {Messages.xtendxpanduipref_text, "xpd_text"}, {Messages.xtendxpanduipref_other, "xpd_other"}};
    private UiDetailsPreferencePage detailsPage = new UiDetailsPreferencePage();
    private List tokenList;

    public TokenListFieldEditor(Composite fieldEditorParent, IPreferenceStore preferenceStore) {
        this.setPreferenceStore(preferenceStore);
        this.createControl(fieldEditorParent);
        this.init("tokenStyles", Messages.xtendxpanduipref_tokenStyles);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tokenList.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        control.setLayoutData((Object)new GridData(1, 0x1000000, false, false, numColumns, 1));
        this.tokenList = new List(parent, 2820);
        this.tokenList.setLayoutData((Object)new GridData(1, 4, false, false, numColumns - 1, 1));
        String[][] stringArray = PREFERENCES;
        int n = PREFERENCES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pref = stringArray[n2];
            this.tokenList.add(pref[0]);
            ++n2;
        }
        this.tokenList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TokenListFieldEditor.this.doLoad();
            }
        });
        this.tokenList.setSelection(0);
        this.detailsPage.createControl(parent);
        this.detailsPage.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    protected void doLoad() {
        String token = this.getSelectedTokenName();
        if (token != null) {
            this.detailsPage.load(token);
        }
    }

    protected void doLoadDefault() {
        this.detailsPage.loadDefaults(this.getSelectedTokenName());
    }

    protected void doStore() {
        this.detailsPage.performOk();
    }

    public void store() {
        this.doStore();
    }

    public int getNumberOfControls() {
        return 2;
    }

    private String getSelectedTokenName() {
        if (this.tokenList == null) {
            return null;
        }
        int ind = this.tokenList.getSelectionIndex();
        if (ind < 0) {
            return null;
        }
        return PREFERENCES[ind][1];
    }
}

