/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.uml2.profile.StereotypeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleStereotypeType
extends StereotypeType {
    List<StereotypeType> stereotypes;

    public MultipleStereotypeType(TypeSystem typeSystem, List<StereotypeType> stereotypes) {
        this(typeSystem, stereotypes, null);
    }

    public MultipleStereotypeType(TypeSystem typeSystem, List<StereotypeType> stereotypes, Type umlType) {
        super(typeSystem, MultipleStereotypeType.computeName(stereotypes), null, umlType);
        this.stereotypes = stereotypes;
    }

    private static String computeName(List<StereotypeType> stereotypes) {
        String result = stereotypes.get(0).getName();
        int i = 1;
        while (i < stereotypes.size()) {
            result = String.valueOf(result) + "," + stereotypes.get(i).getName();
            ++i;
        }
        return result;
    }

    @Override
    public Feature[] getContributedFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (StereotypeType st : this.stereotypes) {
            features.addAll(Arrays.asList(st.getContributedFeatures()));
        }
        return features.toArray(new Feature[this.stereotypes.size()]);
    }

    @Override
    public Set<Type> getSuperTypes() {
        HashSet<Type> superTypes = new HashSet<Type>();
        for (StereotypeType st : this.stereotypes) {
            superTypes.addAll(st.getSuperTypes());
        }
        return superTypes;
    }

    @Override
    public boolean isInstance(Object o) {
        for (StereotypeType st : this.stereotypes) {
            if (!st.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCompatible(Type t) {
        for (StereotypeType st : this.stereotypes) {
            if (!st.equals(t, false)) continue;
            return true;
        }
        return false;
    }

    public List<StereotypeType> getStereotypes() {
        return this.stereotypes;
    }
}

