/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.SetType;

public class BasicOCLTest
extends AbstractTestSuite {
    public void testAliasPackageName() throws ParserException {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        EPackageRegistryImpl r = new EPackageRegistryImpl();
        r.put((Object)"EMFEcore", (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        r.put((Object)"OCLEcore", (Object)EcorePackage.eINSTANCE);
        OCL ocl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)r));
        ((EcoreEnvironment)ocl.getEnvironment()).setOption(ParsingOptions.PACKAGE_LOOKUP_STRATEGY, (Object)ParsingOptions.PACKAGE_LOOKUP_STRATEGIES.LOOKUP_PACKAGE_BY_ALIAS);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.eINSTANCE.getOCLExpression());
        OCLExpression expr = helper.createQuery("self.oclIsKindOf(EMFEcore::EClassifier) and not self.oclIsKindOf(OCLEcore::OCLExpression)");
        BasicOCLTest.assertTrue((boolean)this.check((org.eclipse.ocl.expressions.OCLExpression)expr, eCls));
        OperationCallExp and = (OperationCallExp)expr;
        OperationCallExp selfOclIsKindOfEMFEcoreEClassifier = (OperationCallExp)and.getSource();
        TypeExp emfEcoreEClassifier = (TypeExp)selfOclIsKindOfEMFEcoreEClassifier.getArgument().get(0);
        BasicOCLTest.assertSame((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEClassifier(), (Object)emfEcoreEClassifier.getReferredType());
        OperationCallExp not = (OperationCallExp)and.getArgument().get(0);
        OperationCallExp selfOclIsKindOfOCLEcoreOCLExpression = (OperationCallExp)not.getSource();
        TypeExp oclEcoreOCLExpression = (TypeExp)selfOclIsKindOfOCLEcoreOCLExpression.getArgument().get(0);
        BasicOCLTest.assertSame((Object)EcorePackage.eINSTANCE.getOCLExpression(), (Object)oclEcoreOCLExpression.getReferredType());
    }

    public void testRegularPackageNameInContextWithAliasLookupEnabled() throws ParserException {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        EPackageRegistryImpl r = new EPackageRegistryImpl();
        r.put((Object)"EMFEcore", (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        r.put((Object)"OCLEcore", (Object)EcorePackage.eINSTANCE);
        OCL ocl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)r));
        ((EcoreEnvironment)ocl.getEnvironment()).setOption(ParsingOptions.PACKAGE_LOOKUP_STRATEGY, (Object)ParsingOptions.PACKAGE_LOOKUP_STRATEGIES.LOOKUP_PACKAGE_BY_ALIAS);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.eINSTANCE.getOCLExpression());
        OCLExpression expr = helper.createQuery("self.oclIsKindOf(ecore::OCLExpression)");
        OperationCallExp oclIsKindOf = (OperationCallExp)expr;
        TypeExp emfEcoreEClassifier = (TypeExp)oclIsKindOf.getArgument().get(0);
        BasicOCLTest.assertSame((Object)EcorePackage.eINSTANCE.getOCLExpression(), (Object)emfEcoreEClassifier.getReferredType());
    }

    public void testRegularPackageNameOutOfContextWithAliasLookupEnabled() throws ParserException {
        this.initFruitPackage();
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        EPackageRegistryImpl r = new EPackageRegistryImpl();
        r.putAll((Map)resourceSet.getPackageRegistry());
        r.put((Object)"EMFEcore", (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        r.put((Object)"OCLEcore", (Object)EcorePackage.eINSTANCE);
        OCL ocl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)r));
        ((EcoreEnvironment)ocl.getEnvironment()).setOption(ParsingOptions.PACKAGE_LOOKUP_STRATEGY, (Object)ParsingOptions.PACKAGE_LOOKUP_STRATEGIES.LOOKUP_PACKAGE_BY_ALIAS_THEN_NAME);
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)EcorePackage.eINSTANCE.getOCLExpression());
        OCLExpression expr = helper.createQuery("self.oclIsKindOf(OclTest::Fruit)");
        OperationCallExp oclIsKindOf = (OperationCallExp)expr;
        TypeExp emfEcoreEClassifier = (TypeExp)oclIsKindOf.getArgument().get(0);
        BasicOCLTest.assertSame((Object)((EPackage)this.fruitPackage).getEClassifier("Fruit"), (Object)emfEcoreEClassifier.getReferredType());
    }

    public void hide_test_createStandardLibrary() {
        Resource res = ((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getOclAny()).eResource();
        URI oldURI = res.getURI();
        res.setURI(URI.createFileURI((String)"c:/temp/oclstdlib.ecore"));
        try {
            try {
                res.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                BasicOCLTest.fail((String)e.getLocalizedMessage());
                res.setURI(oldURI);
            }
        }
        finally {
            res.setURI(oldURI);
        }
    }

    public void test_collectionsAndIteratorsAccess_222747() {
        SetType type = this.ocl.getEnvironment().getOCLFactory().createSetType((Object)EcorePackage.Literals.ERESOURCE);
        HashSet iterators = new HashSet(type.oclIterators());
        HashSet operations = new HashSet(type.oclOperations());
        HashSet difference = new HashSet(operations);
        difference.removeAll(iterators);
        BasicOCLTest.assertEquals((int)difference.size(), (int)operations.size());
        BasicOCLTest.assertTrue((operations.size() > 0 ? 1 : 0) != 0);
        BasicOCLTest.assertTrue((iterators.size() > 0 ? 1 : 0) != 0);
    }

    public void testTrivialExpressions() {
        org.eclipse.ocl.expressions.OCLExpression constraint = this.parseConstraint("package ecore context EClass inv: true endpackage");
        Object result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    public void testLogicalConnectives() {
        org.eclipse.ocl.expressions.OCLExpression constraint = this.parseConstraint("package ecore context EClass inv: true and true endpackage");
        Object result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: false or false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: true and false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: true or false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: not true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: true implies true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: true implies false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: false implies true endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        constraint = this.parseConstraint("package ecore context EClass inv: false implies false endpackage");
        result = this.evaluate(constraint);
        BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testSimpleAttributeExpressions() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        org.eclipse.ocl.expressions.OCLExpression constraint = this.parseConstraint("package ecore context EClass inv: self.name <> 'foo' endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertFalse((boolean)this.check(constraint, eCls));
    }

    public void testCollectionExpressions() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        EAttribute eAttr = EcoreFactory.eINSTANCE.createEAttribute();
        eAttr.setName("att1");
        eCls.getEStructuralFeatures().add((Object)eAttr);
        eAttr = EcoreFactory.eINSTANCE.createEAttribute();
        eAttr.setName("att2");
        eCls.getEStructuralFeatures().add((Object)eAttr);
        BasicOCLTest.assertEquals((int)eCls.getEAttributes().size(), (int)2);
        org.eclipse.ocl.expressions.OCLExpression constraint = this.parseConstraint("package ecore context EClass inv: self.eAttributes->size() = 2 endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
        org.eclipse.ocl.expressions.OCLExpression constraint2 = this.parseConstraint("package ecore context EClass inv: Tuple{status:Boolean=self.eAttributes->size() = 2}.status endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint2, eCls));
        constraint = this.parseConstraint("package ecore context EClass inv: self.eAttributes->forAll(a: EAttribute | not a.derived) endpackage");
        BasicOCLTest.assertTrue((boolean)this.check(constraint, eCls));
    }

    public void testNonBooleansExpressions() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        org.eclipse.ocl.expressions.OCLExpression expr = this.parse("package ecore context EClass inv: self.name endpackage ");
        Object result = this.evaluate(expr, eCls);
        BasicOCLTest.assertEquals((Object)"bar", (Object)result);
        expr = this.parse("package ecore context EClass inv: self endpackage");
        result = this.evaluate(expr, eCls);
        BasicOCLTest.assertSame((Object)eCls, (Object)result);
    }

    public void testIfExpressions() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        org.eclipse.ocl.expressions.OCLExpression expr = this.parse("package ecore context EClass inv: if self.abstract then name = 'bar' else name <> 'bar' endif endpackage ");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        eCls.setAbstract(true);
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
    }

    public void testIfExpressions_184048() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("bar");
        org.eclipse.ocl.expressions.OCLExpression expr = this.parse("package ecore context EClass inv: if self.abstract then name = 'bar' else name <> 'bar' endif ->asSequence()->at(1)endpackage ");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        eCls.setAbstract(true);
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        org.eclipse.ocl.expressions.OCLExpression expr2 = this.parse("package ecore context EClass inv: 7 = 1 + let a : String = invalid in 1 + if self.oclIsUndefined() then 1 else 5 endif endpackage ");
        BasicOCLTest.assertTrue((boolean)this.check(expr2, eCls));
    }

    public void testLetExpressions() {
        EClass eCls = EcoreFactory.eINSTANCE.createEClass();
        eCls.setName("foo");
        org.eclipse.ocl.expressions.OCLExpression expr = this.parse("package ecore context EClass inv: let feats : OrderedSet(EStructuralFeature) = self.eAllStructuralFeatures in   feats->isEmpty() implies name <> 'bar' endpackage ");
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("bar");
        BasicOCLTest.assertFalse((boolean)this.check(expr, eCls));
        eCls.getEStructuralFeatures().add((Object)EcoreFactory.eINSTANCE.createEAttribute());
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
        eCls.setName("foo");
        BasicOCLTest.assertTrue((boolean)this.check(expr, eCls));
    }

    public void test_dataTypeAsContext() throws Throwable {
        try {
            org.eclipse.ocl.expressions.OCLExpression expr = this.parse("package ecore context EString inv: self.toUpper() <> self.toLower() endpackage ");
            BasicOCLTest.assertTrue((boolean)this.check(expr, "anything"));
            BasicOCLTest.assertTrue((boolean)this.check(expr, "ANYTHING"));
            expr = this.parse("package ecore context EString inv: self.toUpper() endpackage ");
            BasicOCLTest.assertEquals((Object)"ANYTHING", (Object)this.evaluate(expr, "anything"));
        }
        catch (Throwable e) {
            System.out.println(e);
            throw e;
        }
    }

    public void test_equals_primitives() {
        BasicOCLTest.assertTrue((boolean)this.check("1 = 1"));
        BasicOCLTest.assertTrue((boolean)this.check("1 = 1.0"));
        BasicOCLTest.assertTrue((boolean)this.check("1.0 = 1"));
        BasicOCLTest.assertTrue((boolean)this.check("1.0 = 1.0"));
        BasicOCLTest.assertTrue((boolean)this.check("'foo' = 'foo'"));
        BasicOCLTest.assertTrue((boolean)this.check("ocltest::Color::red = ocltest::Color::red"));
        BasicOCLTest.assertFalse((boolean)this.check("ocltest::Color::red = ocltest::Color::black"));
    }

    public void test_backslashes_184948() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        Boolean oldBackslashProcessingEnabled = (Boolean)ParsingOptions.getValue((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING);
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)false);
        String self = "";
        try {
            try {
                BasicOCLTest.assertEquals((Object)"str\\ning", (Object)this.evaluate(this.helper, self, "'str\\ning'"));
                BasicOCLTest.assertEquals((Object)"str\\(ing", (Object)this.evaluate(this.helper, self, "'str\\(ing'"));
                BasicOCLTest.assertEquals((Object)"string", (Object)this.evaluate(this.helper, self, "let \"s\\\"g\" : String = 'string' in \"s\\\"g\""));
            }
            catch (ParserException e) {
                BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)oldBackslashProcessingEnabled);
            }
        }
        finally {
            ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, (Object)oldBackslashProcessingEnabled);
        }
    }

    public void test_escapeSequences_242880() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        String self = "";
        try {
            this.assertInvalidString("'\\\\\\ '");
            this.assertInvalidString("'str\\(ing'");
            this.assertInvalidString("'string\\'");
            this.assertInvalidString("'string\\9'");
            BasicOCLTest.assertEquals((Object)"\\", (Object)this.evaluate(this.helper, self, "'\\\\'"));
            BasicOCLTest.assertEquals((Object)"str\ning", (Object)this.evaluate(this.helper, self, "'str\\ning'"));
            BasicOCLTest.assertEquals((Object)"str\\(ing", (Object)this.evaluate(this.helper, self, "'str\\\\(ing'"));
            BasicOCLTest.assertEquals((Object)"string", (Object)this.evaluate(this.helper, self, "let \"s\\\"g\" : String = 'string' in \"s\\\"g\""));
            BasicOCLTest.assertEquals((Object)"str\b \t \n \f \r \" ' \\ing", (Object)this.evaluate(this.helper, self, "'str\\b \\t \\n \\f \\r \\\" \\' \\\\ing'"));
            BasicOCLTest.assertEquals((Object)"String", (Object)this.evaluate(this.helper, self, "'\\123tring'"));
            BasicOCLTest.assertEquals((Object)"\n3tring", (Object)this.evaluate(this.helper, self, "'\\0123tring'"));
            BasicOCLTest.assertEquals((Object)"8123tring", (Object)this.evaluate(this.helper, self, "'\\70123tring'"));
            BasicOCLTest.assertEquals((Object)"8String", (Object)this.evaluate(this.helper, self, "'\\70\\123tring'"));
            BasicOCLTest.assertEquals((Object)"8String", (Object)this.evaluate(this.helper, self, "'\\70\\123tring'"));
            BasicOCLTest.assertEquals((Object)"\u00e5string", (Object)this.evaluate(this.helper, self, "'\\345string'"));
            BasicOCLTest.assertEquals((Object)"%6string", (Object)this.evaluate(this.helper, self, "'\\456string'"));
            BasicOCLTest.assertEquals((Object)"\n", (Object)this.evaluate(this.helper, self, "'\\12'"));
            BasicOCLTest.assertEquals((Object)"string\n", (Object)this.evaluate(this.helper, self, "'string\\12'"));
            BasicOCLTest.assertEquals((Object)"string\u00ff", (Object)this.evaluate(this.helper, self, "'string\\377'"));
            BasicOCLTest.assertEquals((Object)"string\t\u001f8", (Object)this.evaluate(this.helper, self, "'string\\t\\378'"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_stringEscapes_184948() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        String self = "";
        try {
            BasicOCLTest.assertEquals((Object)"", (Object)this.evaluate(this.helper, self, "''"));
            BasicOCLTest.assertEquals((Object)"", (Object)this.evaluate(this.helper, self, "''''"));
            BasicOCLTest.assertEquals((Object)"", (Object)this.evaluate(this.helper, self, "'' ''"));
            BasicOCLTest.assertEquals((Object)"string", (Object)this.evaluate(this.helper, self, "'str' 'ing'"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_enumerationLiteralValue_198945() {
        this.helper.setContext((Object)ExpressionsPackage.Literals.COLLECTION_KIND);
        try {
            BasicOCLTest.assertSame((Object)CollectionKind.SEQUENCE_LITERAL, (Object)this.evaluate(this.helper, CollectionKind.BAG_LITERAL, "CollectionKind::Sequence"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_laxNullHandling_null() {
        this.helper.setContext((Object)EcorePackage.Literals.EANNOTATION);
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        try {
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "null.oclIsTypeOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "null.oclIsKindOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, annotation, "null.oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, annotation, "null.oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "null.oclAsType(OclVoid)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "null.oclAsType(EAnnotation)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "null.oclAsType(String)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "source.oclIsTypeOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "source.oclIsKindOf(OclVoid)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "source.oclAsType(OclVoid)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "source.oclAsType(EAnnotation)"));
            BasicOCLTest.assertNull((Object)this.evaluate(this.helper, annotation, "source.oclAsType(String)"));
            EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)false);
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclIsTypeOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclIsKindOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclAsType(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "null.oclAsType(String)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.oclIsTypeOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.oclIsKindOf(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.oclAsType(OclVoid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.oclAsType(String)"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_laxNullHandling_OclInvalid() {
        this.helper.setContext((Object)EcorePackage.Literals.EANNOTATION);
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        try {
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "invalid.oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "invalid.oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(String)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(String)"));
            EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)false);
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "invalid.oclAsType(String)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclIsTypeOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclIsKindOf(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(OclInvalid)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(EAnnotation)"));
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, annotation, "source.substring(1, 1).oclAsType(String)"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_lax_null_handling_on_EcoreModel_253252() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        Object eclassifier = null;
        try {
            BasicOCLTest.assertEquals(null, (Object)this.evaluate(this.helper, eclassifier, "self.oclAsType(EClass)"));
            EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)false);
            BasicOCLTest.assertEquals((Object)this.getInvalid(), (Object)this.evaluate(this.helper, eclassifier, "self.oclAsType(EClass)"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_null_typeConformance_191041() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null <> Set{'foo'}"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null = Set{'foo'}"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null <> Sequence{'foo'}"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null = Sequence{'foo'}"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null <> OrderedSet{'foo'}"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null = OrderedSet{'foo'}"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null <> Bag{'foo'}"));
            BasicOCLTest.assertFalse((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "null = Bag{'foo'}"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_oclAsTypeConformingAndNonConforming() {
        this.helper.setContext((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEClassifier());
        try {
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEOperation(), "self.oclAsType(EAnnotation).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEOperation(), "self.oclAsType(EClassifier) = self"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEOperation(), "self.oclAsType(EClass) = self"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEOperation(), "self.oclAsType(EDataType).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEOperation(), "self.oclAsType(ocl::ecore::TupleType).oclIsInvalid()"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_OclInvalid_typeConformance_191041() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid <> Set{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid = Set{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid <> Sequence{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid = Sequence{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid <> OrderedSet{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid = OrderedSet{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid <> Bag{'foo'}).oclIsInvalid()"));
            BasicOCLTest.assertTrue((boolean)this.check(this.helper, "http://www.eclipse.org/emf/2002/Ecore", "(invalid = Bag{'foo'}).oclIsInvalid()"));
        }
        catch (ParserException e) {
            BasicOCLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    private void assertInvalidString(String input) {
        boolean isParserError = false;
        try {
            this.evaluate(this.helper, "", input);
        }
        catch (ParserException e) {
            isParserError = true;
        }
        BasicOCLTest.assertTrue((boolean)isParserError);
    }
}

