/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsUtils;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtext.AbstractElement;

public class IdiomGrammarMatch
implements IdiomMatch {
    protected final @NonNull Idiom idiom;
    private int subIdiomIndex = 0;
    private final @NonNull AbstractElement @NonNull [] locatedElements;
    private @Nullable IdiomGrammarMatch nestedMatch = null;
    private @Nullable IdiomGrammarMatch additionalMatch = null;

    public IdiomGrammarMatch(@NonNull Idiom idiom, @NonNull AbstractElement grammarElement) {
        this.idiom = idiom;
        this.locatedElements = new AbstractElement[idiom.getOwnedSubIdioms().size()];
        this.locatedElements[this.subIdiomIndex++] = grammarElement;
    }

    public @NonNull Idiom getIdiom() {
        return this.idiom;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean installIn(@NonNull Map<@NonNull AbstractElement, @NonNull List<@NonNull SubIdiom>> grammarElement2subIdioms) {
        if (this.additionalMatch != null) {
            this.additionalMatch.installIn(grammarElement2subIdioms);
        }
        if (this.subIdiomIndex >= this.locatedElements.length) {
            AbstractElement[] abstractElementArray = this.locatedElements;
            int n = this.locatedElements.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull AbstractElement grammarElement = abstractElementArray[n2];
                @NonNull List subIdioms = (List)SerializationUtils.maybeNull(grammarElement2subIdioms.get(grammarElement));
                if (subIdioms != null && !this.isAllMixIn(subIdioms)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.nestedMatch != null && !this.nestedMatch.installIn(grammarElement2subIdioms)) {
            return false;
        }
        if (this.subIdiomIndex >= this.locatedElements.length) {
            int i = 0;
            while (i < this.locatedElements.length) {
                AbstractElement grammarElement = this.locatedElements[i];
                SubIdiom subIdiom = (SubIdiom)SerializationUtils.nonNullState((Object)((SubIdiom)IdiomsUtils.getOwnedSubIdioms((Idiom)this.idiom).get(i)));
                if (subIdiom.getOwnedSegments().size() > 0) {
                    ArrayList<@NonNull SubIdiom> subIdioms = (ArrayList<SubIdiom>)SerializationUtils.maybeNull(grammarElement2subIdioms.get(grammarElement));
                    if (subIdioms == null) {
                        subIdioms = new ArrayList<SubIdiom>();
                        grammarElement2subIdioms.put(grammarElement, subIdioms);
                    }
                    if (this.isAllMixIn((Iterable<SubIdiom>)subIdioms)) {
                        subIdioms.add(subIdiom);
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isAllMixIn(@NonNull Iterable<@NonNull SubIdiom> subIdioms) {
        for (SubIdiom subIdiom : subIdioms) {
            if (IdiomsUtils.getOwningIdiom((SubIdiom)subIdiom).isMixin()) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean nextMatch(@NonNull AbstractElement grammarElement, @NonNull ParserRuleAnalysis parserRuleAnalysis) {
        @NonNull List subIdioms = IdiomsUtils.getOwnedSubIdioms((Idiom)this.idiom);
        if (this.subIdiomIndex >= this.locatedElements.length) {
            if (this.additionalMatch != null) {
                this.additionalMatch.nextMatch(grammarElement, parserRuleAnalysis);
            } else if (parserRuleAnalysis.matches((SubIdiom)subIdioms.get(0), grammarElement)) {
                this.additionalMatch = new IdiomGrammarMatch(this.idiom, grammarElement);
            }
            return true;
        }
        if (this.nestedMatch != null && this.nestedMatch.nextMatch(grammarElement, parserRuleAnalysis)) {
            return true;
        }
        if (parserRuleAnalysis.matches((SubIdiom)subIdioms.get(this.subIdiomIndex), grammarElement)) {
            this.locatedElements[this.subIdiomIndex++] = grammarElement;
            return true;
        }
        if (parserRuleAnalysis.matches((SubIdiom)subIdioms.get(0), grammarElement)) {
            this.nestedMatch = new IdiomGrammarMatch(this.idiom, grammarElement);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull StringBuilder s, int depth) {
        if (depth == 0) {
            s.append(this.idiom);
        }
        int i = 0;
        while (i < this.subIdiomIndex) {
            SerializationUtils.appendIndentation((StringBuilder)s, (int)depth);
            s.append(this.locatedElements[i]);
            ++i;
        }
        if (this.nestedMatch != null) {
            this.nestedMatch.toString(s, depth + 1);
        }
        if (this.additionalMatch != null) {
            this.additionalMatch.toString(s, depth);
        }
    }
}

