/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.tests.GenericEvaluationTestSuite;
import org.eclipse.ocl.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericEvaluationCollectionOperationTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericEvaluationTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void testCollectionAppend() {
        this.assertExpressionResults("Sequence{'a', 'b', 'c'}", "Sequence{'a', 'b'}->append('c')");
        this.assertExpressionResults("OrderedSet{'a', 'b', 'c'}", "OrderedSet{'a', 'b'}->append('c')");
    }

    public void testCollectionAppendInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->append('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->append('a')");
    }

    public void testCollectionAppendInvalidValue() {
        this.assertResultInvalid("Sequence{'a', 'b'}->append(invalid)");
        this.assertResultInvalid("OrderedSet{'a', 'b'}->append(invalid)");
    }

    public void testCollectionAppendNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->append('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->append('a')");
    }

    public void testCollectionAppendNullValue() {
        this.assertExpressionResults("Sequence{'a', 'b', null}", "Sequence{'a', 'b'}->append(null)");
        this.assertExpressionResults("OrderedSet{'a', 'b', null}", "OrderedSet{'a', 'b'}->append(null)");
    }

    public void testCollectionAsBag() {
        this.assertResult(CollectionUtil.createNewBag(), "Sequence{}->asBag()");
        this.assertResult(CollectionUtil.createNewBag(), "Bag{}->asBag()");
        this.assertResult(CollectionUtil.createNewBag(), "Set{}->asBag()");
        this.assertResult(CollectionUtil.createNewBag(), "OrderedSet{}->asBag()");
        this.assertExpressionResults("Bag{1, 2.0, '3'}", "Sequence{1, 2.0, '3'}->asBag()");
        this.assertExpressionResults("Bag{1, 2.0, '3'}", "Bag{1, 2.0, '3'}->asBag()");
        this.assertExpressionResults("Bag{1, 2.0, '3'}", "Set{1, 2.0, '3'}->asBag()");
        this.assertExpressionResults("Bag{1, 2.0, '3'}", "OrderedSet{1, 2.0, '3'}->asBag()");
    }

    public void testCollectionAsBagInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->asBag()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->asBag()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->asBag()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->asBag()");
    }

    public void testCollectionAsBagNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->asBag()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->asBag()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->asBag()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->asBag()");
    }

    public void testCollectionAsOrderedSet() {
        this.assertResult(CollectionUtil.createNewOrderedSet(), "Sequence{}->asOrderedSet()");
        this.assertResult(CollectionUtil.createNewOrderedSet(), "Bag{}->asOrderedSet()");
        this.assertResult(CollectionUtil.createNewOrderedSet(), "Set{}->asOrderedSet()");
        this.assertResult(CollectionUtil.createNewOrderedSet(), "OrderedSet{}->asOrderedSet()");
        this.assertExpressionResults("OrderedSet{1, 2.0, '3'}", "Sequence{1, 2.0, '3'}->asOrderedSet()");
        this.assertExpressionResults("OrderedSet{1, 2.0, '3'}", "OrderedSet{1, 2.0, '3'}->asOrderedSet()");
        this.assertResultContainsAll("OrderedSet{1, 2.0, '3'}", "Set{1, 2.0, '3'}->asOrderedSet()");
        this.assertResultContainsAll("OrderedSet{1, 2.0, '3'}", "Bag{1, 2.0, '3'}->asOrderedSet()");
    }

    public void testCollectionAsOrderedSetInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->asOrderedSet()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->asOrderedSet()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->asOrderedSet()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->asOrderedSet()");
    }

    public void testCollectionAsOrderedSetNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->asOrderedSet()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->asOrderedSet()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->asOrderedSet()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->asOrderedSet()");
    }

    public void testCollectionAsSequence() {
        this.assertResult(CollectionUtil.createNewSequence(), "Sequence{}->asSequence()");
        this.assertResult(CollectionUtil.createNewSequence(), "Bag{}->asSequence()");
        this.assertResult(CollectionUtil.createNewSequence(), "Set{}->asSequence()");
        this.assertResult(CollectionUtil.createNewSequence(), "OrderedSet{}->asSequence()");
        this.assertExpressionResults("Sequence{1, 2.0, '3'}", "Sequence{1, 2.0, '3'}->asSequence()");
        this.assertExpressionResults("Sequence{1, 2.0, '3'}", "OrderedSet{1, 2.0, '3'}->asSequence()");
        this.assertResultContainsAll("Sequence{1, 2.0, '3'}", "Bag{1, 2.0, '3'}->asSequence()");
        this.assertResultContainsAll("Sequence{1, 2.0, '3'}", "Set{1, 2.0, '3'}->asSequence()");
    }

    public void testCollectionAsSequenceInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->asSequence()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->asSequence()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->asSequence()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->asSequence()");
    }

    public void testCollectionAsSequenceNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->asSequence()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->asSequence()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->asSequence()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->asSequence()");
    }

    public void testCollectionAsSet() {
        this.assertResult(CollectionUtil.createNewSet(), "Sequence{}->asSet()");
        this.assertResult(CollectionUtil.createNewSet(), "Bag{}->asSet()");
        this.assertResult(CollectionUtil.createNewSet(), "Set{}->asSet()");
        this.assertResult(CollectionUtil.createNewSet(), "OrderedSet{}->asSet()");
        this.assertExpressionResults("Set{1, 2.0, '3'}", "Sequence{1, 2.0, '3'}->asSet()");
        this.assertResultContainsAll("Set{1, 2.0, '3'}", "Bag{1, 2.0, '3'}->asSet()");
        this.assertResultContainsAll("Set{1, 2.0, '3'}", "Set{1, 2.0, '3'}->asSet()");
        this.assertExpressionResults("Set{1, 2.0, '3'}", "OrderedSet{1, 2.0, '3'}->asSet()");
    }

    public void testCollectionAsSetInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->asSet()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->asSet()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->asSet()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->asSet()");
    }

    public void testCollectionAsSetNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->asSet()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->asSet()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->asSet()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->asSet()");
    }

    public void testCollectionAt() {
        this.assertResult("a", "Sequence{'a', 'b'}->at(1)");
        this.assertResult("b", "OrderedSet{'a', 'b'}->at(2)");
    }

    public void testCollectionAtInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->at(1)");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->at(1)");
    }

    public void testCollectionAtInvalidValue() {
        this.assertResultInvalid("Sequence{'a', invalid}->at(1)");
        this.assertResultInvalid("OrderedSet{'a', invalid}->at(1)");
    }

    public void testCollectionAtNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->at(1)");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->at(1)");
    }

    public void testCollectionAtNullValue() {
        this.assertResult(null, "Sequence{null, 'a'}->at(1)");
        this.assertResult(null, "OrderedSet{null, 'a'}->at(1)");
    }

    public void testCollectionAtOutOfBounds() {
        this.assertResultInvalid("Sequence{'a'}->at(0)");
        this.assertResultInvalid("OrderedSet{'a'}->at(0)");
        this.assertResultInvalid("Sequence{'a'}->at(2)");
        this.assertResultInvalid("OrderedSet{'a'}->at(2)");
    }

    public void testCollectionCount() {
        this.assertResult(1, "Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count(3)");
        this.assertResult(3, "Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count(4.0)");
        this.assertResult(2, "Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count('test')");
        this.assertResult(1, "Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count(3)");
        this.assertResult(3, "Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count(4.0)");
        this.assertResult(2, "Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count('test')");
        this.assertResult(1, "Set{3, 'test', 4.0, 4, 4.0, 'test'}->count(3)");
        this.assertResult(1, "Set{3, 'test', 4.0, 4, 4.0, 'test'}->count('test')");
        this.assertResult(1, "OrderedSet{3, 'test', 4.0, 4, 4.0, 'test'}->count(3)");
        this.assertResult(1, "OrderedSet{3, 'test', 4.0, 4, 4.0, 'test'}->count('test')");
        this.assertResult(0, "Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count(0)");
        this.assertResult(0, "Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count(0)");
        this.assertResult(0, "Set{3, 'test', 4.0, 4, 4.0, 'test'}->count(0)");
        this.assertResult(0, "OrderedSet{3, 'test', 4.0, 4, 4.0, 'test'}->count(0)");
    }

    public void testCollectionCountInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->count(0)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->count(0)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->count(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in os->count(0)");
    }

    public void testCollectionCountInvalidValue() {
        this.assertResultInvalid("Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count(invalid)");
        this.assertResultInvalid("Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count(invalid)");
        this.assertResultInvalid("Set{3, 'test', 4.0, 4, 4.0, 'test'}->count(invalid)");
        this.assertResultInvalid("OrderedSet{3, 'test', 4.0, 4, 4.0, 'test'}->count(invalid)");
        this.assertResultInvalid("Sequence{3, invalid, 4.0, invalid, 'test'}->count(3)");
        this.assertResultInvalid("Bag{3, invalid, 4.0, invalid, 'test'}->count(3)");
        this.assertResultInvalid("Set{3, invalid, 4.0, invalid, 'test'}->count(3)");
        this.assertResultInvalid("OrderedSet{3, invalid, 4.0, invalid, 'test'}->count(3)");
    }

    public void testCollectionCountNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->count(0)");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->count(0)");
        this.assertResultInvalid("let s : Set(Integer) = null in s->count(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in os->count(0)");
    }

    public void testCollectionCountNullValue() {
        this.assertResult(0, "Sequence{3, 'test', 4.0, 4, 4.0, 'test'}->count(null)");
        this.assertResult(0, "Bag{3, 'test', 4.0, 4, 4.0, 'test'}->count(null)");
        this.assertResult(0, "Set{3, 'test', 4.0, 4, 4.0, 'test'}->count(null)");
        this.assertResult(0, "OrderedSet{3, 'test', 4.0, 4, 4.0, 'test'}->count(null)");
        this.assertResult(2, "Sequence{3, null, 4.0, null, 'test'}->count(null)");
        this.assertResult(2, "Bag{3, null, 4.0, null, 'test'}->count(null)");
        this.assertResult(1, "Set{3, null, 4.0, null, 'test'}->count(null)");
        this.assertResult(1, "OrderedSet{3, null, 4.0, null, 'test'}->count(null)");
    }

    public void testCollectionEqualInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s = Sequence{5}");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Bag{5} = b");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s = Set{5}");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in OrderedSet{5} = o");
        this.assertResultInvalid("let s1 : Sequence(Integer) = invalid, s2 : Sequence(Integer) = invalid in s1 = s2");
        this.assertResultInvalid("let b1 : Bag(Integer) = invalid, b2 : Bag(Integer) = invalid in b1 = b2");
        this.assertResultInvalid("let s1 : Set(Integer) = invalid, s2 : Set(Integer) = invalid in s1 = s2");
        this.assertResultInvalid("let o1 : OrderedSet(Integer) = invalid, o2 : OrderedSet(Integer) = invalid in o1 = o2");
    }

    public void testCollectionEqualNull() {
        this.assertResultFalse("let s : Sequence(Integer) = null in s = Sequence{5}");
        this.assertResultFalse("let b : Bag(Integer) = null in Bag{5} = b");
        this.assertResultFalse("let s : Set(Integer) = null in s = Set{5}");
        this.assertResultFalse("let o : OrderedSet(Integer) = null in OrderedSet{5} = o");
        this.assertResultTrue("let s1 : Sequence(Integer) = null, s2 : Sequence(Integer) = null in s1 = s2");
        this.assertResultTrue("let b1 : Bag(Integer) = null, b2 : Bag(Integer) = null in b1 = b2");
        this.assertResultTrue("let s1 : Set(Integer) = null, s2 : Set(Integer) = null in s1 = s2");
        this.assertResultTrue("let o1 : OrderedSet(Integer) = null, o2 : OrderedSet(Integer) = null in o1 = o2");
    }

    public void testCollectionEqualOrderedXOrdered() {
        this.assertResultTrue("Sequence{4, 5, 'test'} = Sequence{4, 5, 'test'}");
        this.assertResultTrue("Sequence{4, 5, 'test', 5} = Sequence{4, 5, 'test', 5}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 5} = OrderedSet{4, 5, 'test'}");
        this.assertResultFalse("OrderedSet{4, 5, 6} = OrderedSet{6, 4, 5}");
        this.assertResultFalse("Sequence{4, 5, 'test'} = Sequence{4, 'test', 5}");
        this.assertResultFalse("Sequence{4, 5, 'test', 5} = Sequence{5, 4, 'test', 5}");
        this.assertResultFalse("Sequence{4, 5, 'test', 5} = Sequence{4, 5, 'test'}");
    }

    public void testCollectionEqualUnorderedXUnordered() {
        this.assertResultTrue("Bag{4, 5, 'test', 4} = Bag{4, 'test', 5, 4}");
        this.assertResultTrue("Set{4, 5, 'test', 4} = Set{4, 'test', 5, 4}");
        this.assertResultFalse("Bag{4, 5, 'test'} = Bag{4, 'test', 5, 4}");
    }

    public void testCollectionExcludes() {
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludes(3)");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludes('test')");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludes(3)");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludes('test')");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludes(3)");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludes('test')");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludes(3)");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludes('test')");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludes(3.0)");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludes(4)");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludes(3.0)");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludes(4)");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludes(3.0)");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludes(4)");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludes(3.0)");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludes(4)");
    }

    public void testCollectionExcludesAll() {
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludesAll(Sequence{3, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludesAll(Bag{3, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludesAll(Set{3, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->excludesAll(OrderedSet{3, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludesAll(Sequence{3, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludesAll(Bag{3, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludesAll(Set{3, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->excludesAll(OrderedSet{3, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludesAll(Sequence{3, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludesAll(Bag{3, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludesAll(Set{3, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->excludesAll(OrderedSet{3, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludesAll(Sequence{3, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludesAll(Bag{3, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludesAll(Set{3, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->excludesAll(OrderedSet{3, 'test'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludesAll(Sequence{3.0, 4, 'TEST'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludesAll(Bag{3.0, 4, 'TEST'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludesAll(Set{3.0, 4, 'TEST'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludesAll(OrderedSet{3.0, 4, 'TEST'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludesAll(Sequence{3.0, 4, 'TEST'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludesAll(Bag{3.0, 4, 'TEST'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludesAll(Set{3.0, 4, 'TEST'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludesAll(OrderedSet{3.0, 4, 'TEST'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludesAll(Sequence{3.0, 4, 'TEST'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludesAll(Bag{3.0, 4, 'TEST'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludesAll(Set{3.0, 4, 'TEST'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludesAll(OrderedSet{3.0, 4, 'TEST'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludesAll(Sequence{3.0, 4, 'TEST'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludesAll(Bag{3.0, 4, 'TEST'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludesAll(Set{3.0, 4, 'TEST'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludesAll(OrderedSet{3.0, 4, 'TEST'})");
    }

    public void testCollectionExcludesAllInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->excludesAll(Sequence{0})");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->excludesAll(Bag{0})");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->excludesAll(Set{0})");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in os->excludesAll(OrderedSet{0})");
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in Sequence{0}->excludesAll(s)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Bag{0}->excludesAll(b)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in Set{0}->excludesAll(s)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in OrderedSet{0}->excludesAll(os)");
    }

    public void testCollectionExcludesAllInvalidValue() {
        this.assertResultInvalid("Sequence{3, 4, invalid, 'test'}->excludesAll(OrderedSet{'test'})");
        this.assertResultInvalid("Bag{3, 4, invalid, 'test'}->excludesAll(Set{'test'})");
        this.assertResultInvalid("Set{3, 4, invalid, 'test'}->excludesAll(Bag{'test'})");
        this.assertResultInvalid("OrderedSet{3, 4, invalid, 'test'}->excludesAll(Sequence{'test'})");
        this.assertResultInvalid("Sequence{3, 4, 'test'}->excludesAll(OrderedSet{'test', invalid})");
        this.assertResultInvalid("Bag{3, 4, 'test'}->excludesAll(Set{'test', invalid})");
        this.assertResultInvalid("Set{3, 4, 'test'}->excludesAll(Bag{'test', invalid})");
        this.assertResultInvalid("OrderedSet{3, 4, 'test'}->excludesAll(Sequence{'test', invalid})");
    }

    public void testCollectionExcludesAllNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->excludesAll(Sequence{0})");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->excludesAll(Bag{0})");
        this.assertResultInvalid("let s : Set(Integer) = null in s->excludesAll(Set{0})");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in os->excludesAll(OrderedSet{0})");
        this.assertResultInvalid("let s : Sequence(Integer) = null in Sequence{0}->excludesAll(s)");
        this.assertResultInvalid("let b : Bag(Integer) = null in Bag{0}->excludesAll(b)");
        this.assertResultInvalid("let s : Set(Integer) = null in Set{0}->excludesAll(s)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in OrderedSet{0}->excludesAll(os)");
    }

    public void testCollectionExcludesAllNullValue() {
        this.assertResultFalse("Sequence{3, 4, null, 'test'}->excludesAll(OrderedSet{'TEST', null})");
        this.assertResultFalse("Bag{3, 4, null, 'test'}->excludesAll(Set{'TEST', null})");
        this.assertResultFalse("Set{3, 4, null, 'test'}->excludesAll(Bag{'TEST', null})");
        this.assertResultFalse("OrderedSet{3, 4, null, 'test'}->excludesAll(Sequence{'TEST', null})");
        this.assertResultTrue("Sequence{3, 4, 'test'}->excludesAll(OrderedSet{'TEST', null})");
        this.assertResultTrue("Bag{3, 4, 'test'}->excludesAll(Set{'TEST', null})");
        this.assertResultTrue("Set{3, 4, 'test'}->excludesAll(Bag{'TEST', null})");
        this.assertResultTrue("OrderedSet{3, 4, 'test'}->excludesAll(Sequence{'TEST', null})");
    }

    public void testCollectionExcludesInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->excludes(0)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->excludes(0)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->excludes(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in os->excludes(0)");
    }

    public void testCollectionExcludesInvalidValue() {
        this.assertResultInvalid("Sequence{3, 4.0, 'test'}->excludes(invalid)");
        this.assertResultInvalid("Bag{3, 4.0, 'test'}->excludes(invalid)");
        this.assertResultInvalid("Set{3, 4.0, 'test'}->excludes(invalid)");
        this.assertResultInvalid("OrderedSet{3, 4.0, 'test'}->excludes(invalid)");
        this.assertResultInvalid("Sequence{0, invalid}->excludes(0)");
        this.assertResultInvalid("Bag{0, invalid}->excludes(0)");
        this.assertResultInvalid("Set{0, invalid}->excludes(0)");
        this.assertResultInvalid("OrderedSet{0, invalid}->excludes(0)");
    }

    public void testCollectionExcludesNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->excludes(0)");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->excludes(0)");
        this.assertResultInvalid("let s : Set(Integer) = null in s->excludes(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in os->excludes(0)");
    }

    public void testCollectionExcludesNullValue() {
        this.assertResultFalse("Sequence{3, 4.0, null, 'test'}->excludes(null)");
        this.assertResultFalse("Sequence{null}->excludes(null)");
        this.assertResultFalse("Bag{3, 4.0, null, 'test'}->excludes(null)");
        this.assertResultFalse("Bag{null}->excludes(null)");
        this.assertResultFalse("Set{3, 4.0, null, 'test'}->excludes(null)");
        this.assertResultFalse("Set{null}->excludes(null)");
        this.assertResultFalse("OrderedSet{3, 4.0, null, 'test'}->excludes(null)");
        this.assertResultFalse("OrderedSet{null}->excludes(null)");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->excludes(null)");
        this.assertResultTrue("Sequence{}->excludes(null)");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->excludes(null)");
        this.assertResultTrue("Bag{}->excludes(null)");
        this.assertResultTrue("Set{3, 4.0, 'test'}->excludes(null)");
        this.assertResultTrue("Set{}->excludes(null)");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->excludes(null)");
        this.assertResultTrue("OrderedSet{}->excludes(null)");
    }

    public void testCollectionExcluding() {
        this.assertExpressionResults("Sequence{'a', 'c'}", "Sequence{'b', 'a', 'b', 'c'}->excluding('b')");
        this.assertExpressionResults("Bag{'c', 'a'}", "Bag{'b', 'a', 'b', 'c'}->excluding('b')");
        this.assertExpressionResults("Set{'c', 'a'}", "Set{'a', 'b', 'c'}->excluding('b')");
        this.assertExpressionResults("OrderedSet{'a', 'c'}", "OrderedSet{'a', 'b', 'c'}->excluding('b')");
    }

    public void testCollectionExcludingInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->excluding('a')");
        this.assertResultInvalid("let b : Bag(String) = invalid in b->excluding('a')");
        this.assertResultInvalid("let s : Set(String) = invalid in s->excluding('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->excluding('a')");
    }

    public void testCollectionExcludingInvalidValue() {
        this.assertResultInvalid("Sequence{'a', 'b'}->excluding(invalid)");
        this.assertResultInvalid("Bag{'a', 'b'}->excluding(invalid)");
        this.assertResultInvalid("Set{'a', 'b'}->excluding(invalid)");
        this.assertResultInvalid("OrderedSet{'a', 'b'}->excluding(invalid)");
    }

    public void testCollectionExcludingNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->excluding('a')");
        this.assertResultInvalid("let b : Bag(String) = null in b->excluding('a')");
        this.assertResultInvalid("let s : Set(String) = null in s->excluding('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->excluding('a')");
    }

    public void testCollectionExcludingNullValue() {
        this.assertExpressionResults("Sequence{'a', 'b'}", "Sequence{null, 'a', null, 'b'}->excluding(null)");
        this.assertExpressionResults("Bag{'b', 'a'}", "Bag{null, 'a', null, 'b'}->excluding(null)");
        this.assertExpressionResults("Set{'b', 'a'}", "Set{'a', null, 'b'}->excluding(null)");
        this.assertExpressionResults("OrderedSet{'a', 'b'}", "OrderedSet{'a', null, 'b'}->excluding(null)");
    }

    public void testCollectionFirst() {
        this.assertResultInvalid("Sequence{}->first()");
        this.assertResultInvalid("OrderedSet{}->first()");
        this.assertResult(1, "Sequence{1, 2.0, '3'}->first()");
        this.assertResult(1, "OrderedSet{1, 2.0, '3'}->first()");
    }

    public void testCollectionFirstInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->first()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->first()");
    }

    public void testCollectionFirstInvalidValue() {
        this.assertResultInvalid("Sequence{1, invalid}->first()");
        this.assertResultInvalid("OrderedSet{1, invalid}->first()");
    }

    public void testCollectionFirstNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->first()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->first()");
    }

    public void testCollectionFirstNullValue() {
        this.assertResult(null, "Sequence{null}->first()");
        this.assertResult(null, "OrderedSet{null}->first()");
    }

    public void testCollectionFlatten() {
        this.assertResult(CollectionUtil.createNewSequence(), "Sequence{}->flatten()");
        this.assertResult(CollectionUtil.createNewBag(), "Bag{}->flatten()");
        this.assertResult(CollectionUtil.createNewSet(), "Set{}->flatten()");
        this.assertResult(CollectionUtil.createNewOrderedSet(), "OrderedSet{}->flatten()");
        String expression = "Sequence{Set{1,2,3}, Sequence{2.0, 3.0}, Bag{'test'}}->flatten()";
        String expectedResultExpression = "Sequence{1, 2, 3, 2.0, 3.0, 'test'}";
        this.assertResultContainsAll(expectedResultExpression, expression);
        expression = "Bag{Set{Bag{'test', 2, 3.0}}, Sequence{OrderedSet{2.0, 3, 1}}}->flatten()";
        expectedResultExpression = "Bag{1, 2, 3, 2.0, 3.0, 'test'}";
        this.assertExpressionResults(expectedResultExpression, expression);
        expression = "Set{OrderedSet{Set{3.0, 'test'}, Sequence{2.0, 2}, Bag{1, 3}}}->flatten()";
        expectedResultExpression = "Set{1, 2, 3, 2.0, 3.0, 'test'}";
        this.assertExpressionResults(expectedResultExpression, expression);
    }

    public void testCollectionFlattenInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->flatten()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->flatten()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->flatten()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->flatten()");
    }

    public void testCollectionFlattenNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->flatten()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->flatten()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->flatten()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->flatten()");
    }

    public void testCollectionIncludes() {
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includes(3)");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includes('test')");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includes(3)");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includes('test')");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includes(3)");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includes('test')");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includes(3)");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includes('test')");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includes(3.0)");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includes(4)");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includes(3.0)");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includes(4)");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includes(3.0)");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includes(4)");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includes(3.0)");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includes(4)");
    }

    public void testCollectionIncludesAll() {
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includesAll(Sequence{3, 'test'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includesAll(Bag{3, 'test'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includesAll(Set{3, 'test'})");
        this.assertResultTrue("Sequence{3, 4.0, 'test'}->includesAll(OrderedSet{3, 'test'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includesAll(Sequence{3, 'test'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includesAll(Bag{3, 'test'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includesAll(Set{3, 'test'})");
        this.assertResultTrue("Bag{3, 4.0, 'test'}->includesAll(OrderedSet{3, 'test'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includesAll(Sequence{3, 'test'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includesAll(Bag{3, 'test'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includesAll(Set{3, 'test'})");
        this.assertResultTrue("Set{3, 4.0, 'test'}->includesAll(OrderedSet{3, 'test'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includesAll(Sequence{3, 'test'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includesAll(Bag{3, 'test'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includesAll(Set{3, 'test'})");
        this.assertResultTrue("OrderedSet{3, 4.0, 'test'}->includesAll(OrderedSet{3, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includesAll(Sequence{3, 4, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includesAll(Bag{3, 4, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includesAll(Set{3, 4, 'test'})");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includesAll(OrderedSet{3, 4, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includesAll(Sequence{3, 4, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includesAll(Bag{3, 4, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includesAll(Set{3, 4, 'test'})");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includesAll(OrderedSet{3, 4, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includesAll(Sequence{3, 4, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includesAll(Bag{3, 4, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includesAll(Set{3, 4, 'test'})");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includesAll(OrderedSet{3, 4, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includesAll(Sequence{3, 4, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includesAll(Bag{3, 4, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includesAll(Set{3, 4, 'test'})");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includesAll(OrderedSet{3, 4, 'test'})");
    }

    public void testCollectionIncludesAllInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->includesAll(Sequence{0})");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->includesAll(Bag{0})");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->includesAll(Set{0})");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in os->includesAll(OrderedSet{0})");
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in Sequence{0}->includesAll(s)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Bag{0}->includesAll(b)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in Set{0}->includesAll(s)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in OrderedSet{0}->includesAll(os)");
    }

    public void testCollectionIncludesAllInvalidValue() {
        this.assertResultInvalid("Sequence{3, 4, invalid, 'test'}->includesAll(OrderedSet{'test'})");
        this.assertResultInvalid("Bag{3, 4, invalid, 'test'}->includesAll(Set{'test'})");
        this.assertResultInvalid("Set{3, 4, invalid, 'test'}->includesAll(Bag{'test'})");
        this.assertResultInvalid("OrderedSet{3, 4, invalid, 'test'}->includesAll(Sequence{'test'})");
        this.assertResultInvalid("Sequence{3, 4, 'test'}->includesAll(OrderedSet{'test', invalid})");
        this.assertResultInvalid("Bag{3, 4, 'test'}->includesAll(Set{'test', invalid})");
        this.assertResultInvalid("Set{3, 4, 'test'}->includesAll(Bag{'test', invalid})");
        this.assertResultInvalid("OrderedSet{3, 4, 'test'}->includesAll(Sequence{'test', invalid})");
    }

    public void testCollectionIncludesAllNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->includesAll(Sequence{0})");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->includesAll(Bag{0})");
        this.assertResultInvalid("let s : Set(Integer) = null in s->includesAll(Set{0})");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in os->includesAll(OrderedSet{0})");
        this.assertResultInvalid("let s : Sequence(Integer) = null in Sequence{0}->includesAll(s)");
        this.assertResultInvalid("let b : Bag(Integer) = null in Bag{0}->includesAll(b)");
        this.assertResultInvalid("let s : Set(Integer) = null in Set{0}->includesAll(s)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in OrderedSet{0}->includesAll(os)");
    }

    public void testCollectionIncludesAllNullValue() {
        this.assertResultTrue("Sequence{3, 4, null, 'test'}->includesAll(OrderedSet{'test', null})");
        this.assertResultTrue("Bag{3, 4, null, 'test'}->includesAll(Set{'test', null})");
        this.assertResultTrue("Set{3, 4, null, 'test'}->includesAll(Bag{'test', null})");
        this.assertResultTrue("OrderedSet{3, 4, null, 'test'}->includesAll(Sequence{'test', null})");
        this.assertResultFalse("Sequence{3, 4, 'test'}->includesAll(OrderedSet{'test', null})");
        this.assertResultFalse("Bag{3, 4, 'test'}->includesAll(Set{'test', null})");
        this.assertResultFalse("Set{3, 4, 'test'}->includesAll(Bag{'test', null})");
        this.assertResultFalse("OrderedSet{3, 4, 'test'}->includesAll(Sequence{'test', null})");
    }

    public void testCollectionIncludesInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->includes(0)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->includes(0)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->includes(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = invalid in os->includes(0)");
    }

    public void testCollectionIncludesInvalidValue() {
        this.assertResultInvalid("Sequence{3, 4.0, 'test'}->includes(invalid)");
        this.assertResultInvalid("Bag{3, 4.0, 'test'}->includes(invalid)");
        this.assertResultInvalid("Set{3, 4.0, 'test'}->includes(invalid)");
        this.assertResultInvalid("OrderedSet{3, 4.0, 'test'}->includes(invalid)");
        this.assertResultInvalid("Sequence{0, invalid}->includes(0)");
        this.assertResultInvalid("Bag{0, invalid}->includes(0)");
        this.assertResultInvalid("Set{0, invalid}->includes(0)");
        this.assertResultInvalid("OrderedSet{0, invalid}->includes(0)");
    }

    public void testCollectionIncludesNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->includes(0)");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->includes(0)");
        this.assertResultInvalid("let s : Set(Integer) = null in s->includes(0)");
        this.assertResultInvalid("let os : OrderedSet(Integer) = null in os->includes(0)");
    }

    public void testCollectionIncludesNullValue() {
        this.assertResultTrue("Sequence{3, 4.0, null, 'test'}->includes(null)");
        this.assertResultTrue("Sequence{null}->includes(null)");
        this.assertResultTrue("Bag{3, 4.0, null, 'test'}->includes(null)");
        this.assertResultTrue("Bag{null}->includes(null)");
        this.assertResultTrue("Set{3, 4.0, null, 'test'}->includes(null)");
        this.assertResultTrue("Set{null}->includes(null)");
        this.assertResultTrue("OrderedSet{3, 4.0, null, 'test'}->includes(null)");
        this.assertResultTrue("OrderedSet{null}->includes(null)");
        this.assertResultFalse("Sequence{3, 4.0, 'test'}->includes(null)");
        this.assertResultFalse("Sequence{}->includes(null)");
        this.assertResultFalse("Bag{3, 4.0, 'test'}->includes(null)");
        this.assertResultFalse("Bag{}->includes(null)");
        this.assertResultFalse("Set{3, 4.0, 'test'}->includes(null)");
        this.assertResultFalse("Set{}->includes(null)");
        this.assertResultFalse("OrderedSet{3, 4.0, 'test'}->includes(null)");
        this.assertResultFalse("OrderedSet{}->includes(null)");
    }

    public void testCollectionIncluding() {
        this.assertExpressionResults("Sequence{'a', 'b', 'c'}", "Sequence{'a', 'b'}->including('c')");
        this.assertExpressionResults("Bag{'c', 'b', 'a'}", "Bag{'a', 'b'}->including('c')");
        this.assertExpressionResults("Set{'a', 'c', 'b'}", "Set{'a', 'b'}->including('c')");
        this.assertExpressionResults("OrderedSet{'a', 'b', 'c'}", "OrderedSet{'a', 'b'}->including('c')");
    }

    public void testCollectionIncludingInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->including('a')");
        this.assertResultInvalid("let b : Bag(String) = invalid in b->including('a')");
        this.assertResultInvalid("let s : Set(String) = invalid in s->including('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->including('a')");
    }

    public void testCollectionIncludingInvalidValue() {
        this.assertResultInvalid("Sequence{'a', 'b'}->including(invalid)");
        this.assertResultInvalid("Bag{'a', 'b'}->including(invalid)");
        this.assertResultInvalid("Set{'a', 'b'}->including(invalid)");
        this.assertResultInvalid("OrderedSet{'a', 'b'}->including(invalid)");
    }

    public void testCollectionIncludingNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->including('a')");
        this.assertResultInvalid("let b : Bag(String) = null in b->including('a')");
        this.assertResultInvalid("let s : Set(String) = null in s->including('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->including('a')");
    }

    public void testCollectionIncludingNullValue() {
        this.assertExpressionResults("Sequence{'a', 'b', null}", "Sequence{'a', 'b'}->including(null)");
        this.assertExpressionResults("Bag{null, 'b', 'a'}", "Bag{'a', 'b'}->including(null)");
        this.assertExpressionResults("Set{'a', null, 'b'}", "Set{'a', 'b'}->including(null)");
        this.assertExpressionResults("OrderedSet{'a', 'b', null}", "OrderedSet{'a', 'b'}->including(null)");
    }

    public void testCollectionIndexOf() {
        this.assertResult(1, "Sequence{'a', 'b'}->indexOf('a')");
        this.assertResult(2, "OrderedSet{'a', 'b'}->indexOf('b')");
    }

    public void testCollectionIndexOfInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->indexOf('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->indexOf('a')");
    }

    public void testCollectionIndexOfInvalidValue() {
        this.assertResultInvalid("Sequence{'a', invalid}->indexOf(invalid)");
        this.assertResultInvalid("OrderedSet{'a', invalid}->indexOf(invalid)");
    }

    public void testCollectionIndexOfNotContained() {
        this.assertResultInvalid("Sequence{'a'}->indexOf('b')");
        this.assertResultInvalid("OrderedSet{'a'}->indexOf('b')");
    }

    public void testCollectionIndexOfNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->indexOf('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->indexOf('a')");
    }

    public void testCollectionIndexOfNullValue() {
        this.assertResult(1, "Sequence{null, 'a'}->indexOf(null)");
        this.assertResult(1, "OrderedSet{null, 'a'}->indexOf(null)");
    }

    public void testCollectionInsertAt() {
        this.assertExpressionResults("Sequence{'c', 'a', 'b'}", "Sequence{'a', 'b'}->insertAt(1, 'c')");
        this.assertExpressionResults("OrderedSet{'a', 'c', 'b'}", "OrderedSet{'a', 'b'}->insertAt(2, 'c')");
        this.assertExpressionResults("Sequence{'a', 'b', 'c'}", "Sequence{'a', 'b'}->insertAt(3, 'c')");
        this.assertExpressionResults("OrderedSet{'a', 'b', 'c'}", "OrderedSet{'a', 'b'}->insertAt(3, 'c')");
    }

    public void testCollectionInsertAtInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->insertAt(1, 'a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->insertAt(1, 'a')");
    }

    public void testCollectionInsertAtInvalidValue() {
        this.assertResultInvalid("Sequence{'a'}->insertAt(1, invalid)");
        this.assertResultInvalid("OrderedSet{'a'}->insertAt(1, invalid)");
    }

    public void testCollectionInsertAtNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->insertAt(1, 'a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->insertAt(1, 'a')");
    }

    public void testCollectionInsertAtNullValue() {
        this.assertExpressionResults("Sequence{'a', null}", "Sequence{'a'}->insertAt(2, null)");
        this.assertExpressionResults("OrderedSet{'a', null}", "OrderedSet{'a'}->insertAt(2, null)");
    }

    public void testCollectionInsertAtOutOfBounds() {
        this.assertResultInvalid("Sequence{'a'}->insertAt(0, 'b')");
        this.assertResultInvalid("OrderedSet{'a'}->insertAt(0, 'b')");
        this.assertResultInvalid("Sequence{'a'}->insertAt(3, 'b')");
        this.assertResultInvalid("OrderedSet{'a'}->insertAt(3, 'b')");
    }

    public void testCollectionIntersectionDuplicates() {
        this.assertExpressionResults("Set{'a', 'b'}", "Set{'a', 'b', 'a'}->intersection(Set{'a', 'b', 'c'})");
        this.assertExpressionResults("Set{'a', 'b'}", "Set{'a', 'b', 'a'}->intersection(Bag{'a', 'b', 'c'})");
        this.assertExpressionResults("Set{'a', 'b'}", "Bag{'a', 'b', 'a'}->intersection(Set{'a', 'b', 'c'})");
        this.assertExpressionResults("Bag{'a', 'b'}", "Bag{'a', 'b', 'a'}->intersection(Bag{'a', 'b'})");
        this.assertExpressionResults("Bag{'a', 'b', 'b'}", "Bag{'a', 'b', 'a', 'b'}->intersection(Bag{'a', 'b', 'b'})");
    }

    public void testCollectionIntersectionEmptyCollection() {
        this.assertResult(CollectionUtil.createNewSet(), "Set{3, 4}->intersection(Set{})");
        this.assertResult(CollectionUtil.createNewSet(), "Set{3, 4}->intersection(Bag{})");
        this.assertResult(CollectionUtil.createNewBag(), "Bag{3, 4}->intersection(Bag{})");
        this.assertResult(CollectionUtil.createNewSet(), "Bag{3, 4}->intersection(Set{})");
        this.assertResult(CollectionUtil.createNewSet(), "let s:Set(Integer)=Set{} in s->intersection(Set{3, 4})");
        this.assertResult(CollectionUtil.createNewSet(), "let s:Set(Integer)=Set{} in s->intersection(Bag{3, 4})");
        this.assertResult(CollectionUtil.createNewBag(), "let b:Bag(Integer)=Bag{} in b->intersection(Bag{3, 4})");
        this.assertResult(CollectionUtil.createNewSet(), "let b:Bag(Integer)=Bag{} in b->intersection(Set{3, 4})");
    }

    public void testCollectionIntersectionInvalid() {
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->intersection(Set{4})");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->intersection(Bag{4})");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->intersection(Set{4})");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->intersection(Bag{4})");
        this.assertResultInvalid("let s : Set(Integer) = invalid in Set{4}->intersection(s)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in Bag{4}->intersection(s)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Set{4}->intersection(b)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Bag{4}->intersection(b)");
    }

    public void testCollectionIntersectionInvalidValue() {
        this.assertResultInvalid("Set{3, 4}->intersection(Set{invalid})");
        this.assertResultInvalid("Set{3, invalid}->intersection(Bag{4})");
        this.assertResultInvalid("Bag{3, invalid}->intersection(Set{4})");
        this.assertResultInvalid("Bag{3, 4}->intersection(Bag{invalid})");
    }

    public void testCollectionIntersectionNoDuplicates() {
        this.assertResult(CollectionUtil.createNewSet(), "Set{'a', 'b'}->intersection(Set{'c', 'd'})");
        this.assertResult(CollectionUtil.createNewSet(), "Set{'a', 'b'}->intersection(Bag{'c', 'd'})");
        this.assertResult(CollectionUtil.createNewSet(), "Bag{'a', 'b'}->intersection(Set{'c', 'd'})");
        this.assertResult(CollectionUtil.createNewBag(), "Bag{'a', 'b'}->intersection(Bag{'c', 'd'})");
    }

    public void testCollectionIntersectionNull() {
        this.assertResultInvalid("let s : Set(Integer) = null in s->intersection(Set{4})");
        this.assertResultInvalid("let s : Set(Integer) = null in s->intersection(Bag{4})");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->intersection(Set{4})");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->intersection(Bag{4})");
        this.assertResultInvalid("let s : Set(Integer) = null in Set{4}->intersection(s)");
        this.assertResultInvalid("let s : Set(Integer) = null in Bag{4}->intersection(s)");
        this.assertResultInvalid("let b : Bag(Integer) = null in Set{4}->intersection(b)");
        this.assertResultInvalid("let b : Bag(Integer) = null in Bag{4}->intersection(b)");
    }

    public void testCollectionIntersectionNullValue() {
        this.assertExpressionResults("Set{2, null}", "Set{2, 3, null}->intersection(Set{2, 4, null})");
        this.assertExpressionResults("Set{2, null}", "Set{2, 3, null}->intersection(Bag{2, 4, null})");
        this.assertExpressionResults("Set{2, null}", "Bag{2, 3, null}->intersection(Set{2, 4, null})");
        this.assertExpressionResults("Bag{null, null}", "Bag{3, 4, null, null}->intersection(Bag{null, 2, null})");
    }

    public void testCollectionIsEmpty() {
        this.assertResultTrue("Sequence{}->isEmpty()");
        this.assertResultTrue("Bag{}->isEmpty()");
        this.assertResultTrue("Set{}->isEmpty()");
        this.assertResultTrue("OrderedSet{}->isEmpty()");
        this.assertResultFalse("Sequence{4, 4, 'test'}->isEmpty()");
        this.assertResultFalse("Bag{4, 4, 'test'}->isEmpty()");
        this.assertResultFalse("Set{4, 4, 'test'}->isEmpty()");
        this.assertResultFalse("OrderedSet{4, 4, 'test'}->isEmpty()");
        this.assertResultFalse("'test'->isEmpty()");
    }

    public void testCollectionIsEmptyInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->isEmpty()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->isEmpty()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->isEmpty()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->isEmpty()");
    }

    public void testCollectionIsEmptyInvalidValue() {
        this.assertResultInvalid("Sequence{invalid}->isEmpty()");
        this.assertResultInvalid("Bag{invalid}->isEmpty()");
        this.assertResultInvalid("Set{invalid}->isEmpty()");
        this.assertResultInvalid("OrderedSet{invalid}->isEmpty()");
        this.assertResultInvalid("invalid->isEmpty()");
    }

    public void testCollectionIsEmptyNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->isEmpty()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->isEmpty()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->isEmpty()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->isEmpty()");
    }

    public void testCollectionIsEmptyNullValue() {
        this.assertResultFalse("Sequence{null}->isEmpty()");
        this.assertResultFalse("Bag{null}->isEmpty()");
        this.assertResultFalse("Set{null}->isEmpty()");
        this.assertResultFalse("OrderedSet{null}->isEmpty()");
        this.assertResultTrue("null->isEmpty()");
    }

    public void testCollectionLast() {
        this.assertResultInvalid("Sequence{}->last()");
        this.assertResultInvalid("OrderedSet{}->last()");
        this.assertResult("3", "Sequence{1, 2.0, '3'}->last()");
        this.assertResult("3", "OrderedSet{1, 2.0, '3'}->last()");
    }

    public void testCollectionLastInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->last()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->last()");
    }

    public void testCollectionLastInvalidValue() {
        this.assertResultInvalid("Sequence{invalid, 1}->last()");
        this.assertResultInvalid("OrderedSet{invalid, 1}->last()");
    }

    public void testCollectionLastNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->last()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->last()");
    }

    public void testCollectionLastNullValue() {
        this.assertResult(null, "Sequence{null}->last()");
        this.assertResult(null, "OrderedSet{null}->last()");
    }

    public void testCollectionMax() {
        this.assertResult(2, "Sequence{1, 2}->max()");
        this.assertResult(5.0, "Set{5, 4.0, 3.0, 2, 1}->max()");
        this.assertResult(1, "Bag{1}->max()");
        this.assertResult(1, "Bag{1}->max()");
        this.assertBadQuery(SemanticException.class, 4, "OrderedSet{'hi', 'lo'}->max()", OCLMessages.MaxOperator_ERROR_, new String[0]);
        this.assertBadQuery(SemanticException.class, 4, "Set{}->max()", OCLMessages.MaxOperator_ERROR_, new String[0]);
        this.assertBadQuery(SemanticException.class, 4, "OrderedSet{true, 1, 'bad'}->max()", OCLMessages.MaxOperator_ERROR_, new String[0]);
    }

    public void testCollectionMin() {
        this.assertResult(1, "Sequence{1, 2}->min()");
        this.assertResult(1.0, "Set{5, 4.0, 3.0, 2, 1}->min()");
        this.assertResult(1, "Bag{1}->min()");
        this.assertBadQuery(SemanticException.class, 4, "OrderedSet{'hi', 'lo'}->min()", OCLMessages.MinOperator_ERROR_, new String[0]);
        this.assertBadQuery(SemanticException.class, 4, "Set{}->min()", OCLMessages.MinOperator_ERROR_, new String[0]);
        this.assertBadQuery(SemanticException.class, 4, "OrderedSet{true, 1, 'bad'}->min()", OCLMessages.MinOperator_ERROR_, new String[0]);
    }

    public void testCollectionMinus() {
        this.assertExpressionResults("Set{'b'}", "Set{'a', 'b', 'c'} - Set{'c', 'a'}");
        this.assertExpressionResults("Set{'b'}", "OrderedSet{'a', 'b', 'c'} - Set{'c', 'a'}");
    }

    public void testCollectionMinusInvalid() {
        this.assertResultInvalid("let s : Set(String) = invalid in s - Set{'c'}");
        this.assertResultInvalid("let s : Set(String) = invalid in Set{'a'} - s");
    }

    public void testCollectionMinusInvalidValue() {
        this.assertResultInvalid("Set{'a', invalid} - Set{'c', invalid}");
        this.assertResultInvalid("Set{'a', invalid} - Set{'c', 'a'}");
    }

    public void testCollectionMinusNull() {
        this.assertResultInvalid("let s : Set(String) = null in s - Set{'c', null}");
        this.assertResultInvalid("let s : Set(String) = null in Set{'a', null} - s");
    }

    public void testCollectionMinusNullValue() {
        this.assertExpressionResults("Set{'a'}", "Set{'a', null} - Set{'c', null}");
        this.assertExpressionResults("let s:Set(String)=Set{} in s->including(null)", "Set{'a', null} - Set{'c', 'a'}");
    }

    public void testCollectionNotEmpty() {
        this.assertResultFalse("Sequence{}->notEmpty()");
        this.assertResultFalse("Bag{}->notEmpty()");
        this.assertResultFalse("Set{}->notEmpty()");
        this.assertResultFalse("OrderedSet{}->notEmpty()");
        this.assertResultTrue("Sequence{4, 4, 'test'}->notEmpty()");
        this.assertResultTrue("Bag{4, 4, 'test'}->notEmpty()");
        this.assertResultTrue("Set{4, 4, 'test'}->notEmpty()");
        this.assertResultTrue("OrderedSet{4, 4, 'test'}->notEmpty()");
        this.assertResultTrue("'test'->notEmpty()");
    }

    public void testCollectionNotEmptyInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->notEmpty()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->notEmpty()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->notEmpty()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->notEmpty()");
    }

    public void testCollectionNotEmptyInvalidValue() {
        this.assertResultInvalid("Sequence{invalid}->notEmpty()");
        this.assertResultInvalid("Bag{invalid}->notEmpty()");
        this.assertResultInvalid("Set{invalid}->notEmpty()");
        this.assertResultInvalid("OrderedSet{invalid}->notEmpty()");
        this.assertResultInvalid("invalid->notEmpty()");
    }

    public void testCollectionNotEmptyNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->notEmpty()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->notEmpty()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->notEmpty()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->notEmpty()");
    }

    public void testCollectionNotEmptyNullValue() {
        this.assertResultTrue("Sequence{null}->notEmpty()");
        this.assertResultTrue("Bag{null}->notEmpty()");
        this.assertResultTrue("Set{null}->notEmpty()");
        this.assertResultTrue("OrderedSet{null}->notEmpty()");
        this.assertResultFalse("null->notEmpty()");
    }

    public void testCollectionNotEqualInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s <> Sequence{5}");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Bag{5} <> b");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s <> Set{5}");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in OrderedSet{5} <> o");
        this.assertResultInvalid("let s1 : Sequence(Integer) = invalid, s2 : Sequence(Integer) = invalid in s1 <> s2");
        this.assertResultInvalid("let b1 : Bag(Integer) = invalid, b2 : Bag(Integer) = invalid in b1 <> b2");
        this.assertResultInvalid("let s1 : Set(Integer) = invalid, s2 : Set(Integer) = invalid in s1 <> s2");
        this.assertResultInvalid("let o1 : OrderedSet(Integer) = invalid, o2 : OrderedSet(Integer) = invalid in o1 <> o2");
    }

    public void testCollectionNotEqualNull() {
        this.assertResultTrue("let s : Sequence(Integer) = null in s <> Sequence{5}");
        this.assertResultTrue("let b : Bag(Integer) = null in Bag{5} <> b");
        this.assertResultTrue("let s : Set(Integer) = null in s <> Set{5}");
        this.assertResultTrue("let o : OrderedSet(Integer) = null in OrderedSet{5} <> o");
        this.assertResultFalse("let s1 : Sequence(Integer) = null, s2 : Sequence(Integer) = null in s1 <> s2");
        this.assertResultFalse("let b1 : Bag(Integer) = null, b2 : Bag(Integer) = null in b1 <> b2");
        this.assertResultFalse("let s1 : Set(Integer) = null, s2 : Set(Integer) = null in s1 <> s2");
        this.assertResultFalse("let o1 : OrderedSet(Integer) = null, o2 : OrderedSet(Integer) = null in o1 <> o2");
    }

    public void testCollectionNotEqualOrderedXOrdered() {
        this.assertResultFalse("Sequence{4, 5, 'test'} <> Sequence{4, 5, 'test'}");
        this.assertResultFalse("Sequence{4, 5, 'test', 5} <> Sequence{4, 5, 'test', 5}");
        this.assertResultFalse("OrderedSet{4, 5, 'test', 5} <> OrderedSet{4, 5, 'test'}");
        this.assertResultTrue("Sequence{4, 5, 'test'} <> OrderedSet{4, 5, 'test', 5}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 5} <> Sequence{4, 5, 'test'}");
        this.assertResultTrue("Sequence{4, 5, 'test'} <> Sequence{4, 'test', 5}");
        this.assertResultTrue("Sequence{4, 5, 'test', 5} <> Sequence{5, 4, 'test', 5}");
        this.assertResultTrue("Sequence{4, 5, 'test'} <> OrderedSet{5, 4, 'test', 5}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 5} <> Sequence{5, 4, 'test'}");
        this.assertResultTrue("Sequence{4, 5, 'test', 5} <> Sequence{4, 5, 'test'}");
        this.assertResultTrue("Sequence{4, 5, 'test', 5} <> OrderedSet{4, 5, 'test', 5}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 5} <> Sequence{4, 5, 'test', 5}");
    }

    public void testCollectionNotEqualOrderedXUnordered() {
        this.assertResultTrue("Sequence{4, 5, 'test'} <> Set{4, 'test', 5, 4}");
        this.assertResultTrue("Sequence{4, 5, 'test', 4} <> Bag{4, 'test', 5, 4}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 4} <> Set{4, 'test', 5, 4}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 4} <> Bag{4, 'test', 5}");
        this.assertResultTrue("Sequence{4, 5, 'test', 4} <> Set{4, 'test', 5, 4}");
        this.assertResultTrue("Sequence{4, 5, 'test'} <> Bag{4, 'test', 5, 4}");
        this.assertResultTrue("OrderedSet{4, 5, 'test', 4} <> Bag{4, 'test', 5, 4}");
    }

    public void testCollectionNotEqualUnorderedXUnordered() {
        this.assertResultTrue("Bag{4, 5, 'test'} <> Set{4, 'test', 5, 4}");
        this.assertResultFalse("Bag{4, 5, 'test', 4} <> Bag{4, 'test', 5, 4}");
        this.assertResultFalse("Set{4, 5, 'test', 4} <> Set{4, 'test', 5, 4}");
        this.assertResultTrue("Set{4, 5, 'test', 4} <> Bag{4, 'test', 5}");
        this.assertResultTrue("Bag{4, 5, 'test', 4} <> Set{4, 'test', 5, 4}");
        this.assertResultTrue("Bag{4, 5, 'test'} <> Bag{4, 'test', 5, 4}");
        this.assertResultTrue("Set{4, 5, 'test', 4} <> Bag{4, 'test', 5, 4}");
    }

    public void testCollectionPrepend() {
        this.assertExpressionResults("Sequence{'c', 'a', 'b'}", "Sequence{'a', 'b'}->prepend('c')");
        this.assertExpressionResults("OrderedSet{'c', 'a', 'b'}", "OrderedSet{'a', 'b'}->prepend('c')");
    }

    public void testCollectionPrependInvalid() {
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->prepend('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->prepend('a')");
    }

    public void testCollectionPrependInvalidValue() {
        this.assertResultInvalid("Sequence{'a', 'b'}->prepend(invalid)");
        this.assertResultInvalid("OrderedSet{'a', 'b'}->prepend(invalid)");
    }

    public void testCollectionPrependNull() {
        this.assertResultInvalid("let s : Sequence(String) = null in s->prepend('a')");
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->prepend('a')");
    }

    public void testCollectionPrependNullValue() {
        this.assertExpressionResults("Sequence{null, 'a', 'b'}", "Sequence{'a', 'b'}->prepend(null)");
        this.assertExpressionResults("OrderedSet{null, 'a', 'b'}", "OrderedSet{'a', 'b'}->prepend(null)");
    }

    public void testCollectionProduct() {
        String expectedResultExpression = "Set{Tuple{first = 3, second = 3.0}, Tuple{first = 3, second = 4.0}, Tuple{first = 4, second = 3.0}, Tuple{first = 4, second = 4.0}}";
        this.assertExpressionResults(expectedResultExpression, "Sequence{3, 4}->product(Sequence{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Sequence{3, 4}->product(Bag{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Sequence{3, 4}->product(Set{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Sequence{3, 4}->product(OrderedSet{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Bag{3, 4}->product(Sequence{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Bag{3, 4}->product(Bag{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Bag{3, 4}->product(Set{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Bag{3, 4}->product(OrderedSet{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Set{3, 4}->product(Sequence{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Set{3, 4}->product(Bag{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Set{3, 4}->product(Set{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "Set{3, 4}->product(OrderedSet{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "OrderedSet{3, 4}->product(Sequence{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "OrderedSet{3, 4}->product(Bag{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "OrderedSet{3, 4}->product(Set{3.0, 4.0})");
        this.assertExpressionResults(expectedResultExpression, "OrderedSet{3, 4}->product(OrderedSet{3.0, 4.0})");
    }

    public void testCollectionProductEmptyCollection() {
        this.assertResult(CollectionUtil.createNewSet(), "Sequence{3, 4}->product(OrderedSet{})");
        this.assertResult(CollectionUtil.createNewSet(), "Bag{3, 4}->product(Set{})");
        this.assertResult(CollectionUtil.createNewSet(), "Set{3, 4}->product(Bag{})");
        this.assertResult(CollectionUtil.createNewSet(), "OrderedSet{3, 4}->product(Sequence{})");
        this.assertResult(CollectionUtil.createNewSet(), "Sequence{}->product(OrderedSet{3, 4})");
        this.assertResult(CollectionUtil.createNewSet(), "Bag{}->product(Set{3, 4})");
        this.assertResult(CollectionUtil.createNewSet(), "Set{}->product(Bag{3, 4})");
        this.assertResult(CollectionUtil.createNewSet(), "OrderedSet{}->product(Sequence{3, 4})");
    }

    public void testCollectionProductInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in OrderedSet{3, 4}->product(s)");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in Set{3, 4}->product(b)");
        this.assertResultInvalid("let s : Set(Integer) = invalid in Bag{3, 4}->product(s)");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in Sequence{3, 4}->product(o)");
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->product(OrderedSet{3, 4})");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->product(Set{3, 4})");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->product(Bag{3, 4})");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->product(Sequence{3, 4})");
    }

    public void testCollectionProductInvalidValue() {
        this.assertResultInvalid("Sequence{3, 4}->product(OrderedSet{invalid})");
        this.assertResultInvalid("Bag{3, 4}->product(Set{invalid})");
        this.assertResultInvalid("Set{3, 4}->product(Bag{invalid})");
        this.assertResultInvalid("OrderedSet{3, 4}->product(Sequence{invalid})");
        this.assertResultInvalid("Sequence{invalid, 4}->product(Sequence{3})");
        this.assertResultInvalid("Bag{invalid, 4}->product(Set{3})");
        this.assertResultInvalid("Set{invalid, 4}->product(Bag{3})");
        this.assertResultInvalid("OrderedSet{invalid, 4}->product(Sequence{3})");
    }

    public void testCollectionProductNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in OrderedSet{3, 4}->product(s)");
        this.assertResultInvalid("let b : Bag(Integer) = null in Set{3, 4}->product(b)");
        this.assertResultInvalid("let s : Set(Integer) = null in Bag{3, 4}->product(s)");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in Sequence{3, 4}->product(o)");
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->product(OrderedSet{3, 4})");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->product(Set{3, 4})");
        this.assertResultInvalid("let s : Set(Integer) = null in s->product(Bag{3, 4})");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->product(Sequence{3, 4})");
    }

    public void testCollectionProduct_bug284129() {
        this.assertExpressionResults("let r3 : Real = 3, r4 : Real = 4 in Set{Tuple{first = r3, second = 3.0}, Tuple{first = r3, second = r4}, Tuple{first = 4.0, second = 3.0}, Tuple{first = 4.0, second = r4}}", "Sequence{3, 4.0}->product(Sequence{3.0, 4})");
    }

    public void testCollectionProductNullValue() {
        this.assertExpressionResults("Set{Tuple{first = 3, second = null}, Tuple{first = 4, second = null}}", "Sequence{3, 4}->product(OrderedSet{null})");
        this.assertExpressionResults("Set{Tuple{first = 3, second = null}, Tuple{first = 4, second = null}}", "Bag{3, 4}->product(let s:Set(OclVoid)=Set{} in s->including(null))");
        this.assertExpressionResults("Set{Tuple{first = 3, second = null}, Tuple{first = 4, second = null}}", "Set{3, 4}->product(Bag{null})");
        this.assertExpressionResults("Set{Tuple{first = 3, second = null}, Tuple{first = 4, second = null}}", "OrderedSet{3, 4}->product(Sequence{null})");
        this.assertExpressionResults("let iNull : Integer = null in Set{Tuple{first = iNull, second = 3}, Tuple{first = 4, second = 3}}", "Sequence{null, 4}->product(Sequence{3})");
        this.assertExpressionResults("let iNull : Integer = null in Set{Tuple{first = iNull, second = 3}, Tuple{first = 4, second = 3}}", "Bag{null, 4}->product(Set{3})");
        this.assertExpressionResults("let iNull : Integer = null in Set{Tuple{first = iNull, second = 3}, Tuple{first = 4, second = 3}}", "Set{null, 4}->product(Bag{3})");
        this.assertExpressionResults("let iNull : Integer = null in Set{Tuple{first = iNull, second = 3}, Tuple{first = 4, second = 3}}", "OrderedSet{null, 4}->product(Sequence{3})");
    }

    public void testCollectionSize() {
        this.assertResult(4, "Sequence{4, 4, 5, 'test'}->size()");
        this.assertResult(4, "Bag{4, 4, 5, 'test'}->size()");
        this.assertResult(3, "Set{4, 4, 5, 'test'}->size()");
        this.assertResult(3, "OrderedSet{4, 4, 5, 'test'}->size()");
        this.assertResult(0, "Sequence{}->size()");
        this.assertResult(0, "Bag{}->size()");
        this.assertResult(0, "Set{}->size()");
        this.assertResult(0, "OrderedSet{}->size()");
    }

    public void testCollectionSizeInvalid() {
        this.assertResultInvalid("let s : String = invalid in s->size()");
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->size()");
    }

    public void testCollectionSizeInvalidValue() {
        this.assertResultInvalid("OrderedSet{'a', 'b', invalid}->size()");
        this.assertResultInvalid("Set{'a', 'b', invalid}->size()");
        this.assertResultInvalid("Bag{'a', 'b', invalid}->size()");
        this.assertResultInvalid("Sequence{'a', 'b', invalid}->size()");
    }

    public void testCollectionSizeNull() {
        this.assertResult(0, "let s : String = null in s->size()");
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->size()");
    }

    public void testCollectionSizeNullValue() {
        this.assertResult(4, "Sequence{'a', 'b', null, null}->size()");
        this.assertResult(4, "Bag{'a', 'b', null, null}->size()");
        this.assertResult(3, "Set{'a', 'b', null, null}->size()");
        this.assertResult(3, "OrderedSet{'a', 'b', null, null}->size()");
    }

    public void testCollectionSubOrderedSet() {
        this.assertExpressionResults("OrderedSet{'a'}", "OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(1, 1)");
        this.assertExpressionResults("OrderedSet{'b', 'c'}", "OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(2, 3)");
        this.assertExpressionResults("OrderedSet{'d'}", "OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(4, 4)");
    }

    public void testCollectionSubOrderedSetIllegalArguments() {
        this.assertResultInvalid("OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(2, 1)");
    }

    public void testCollectionSubOrderedSetInvalid() {
        this.assertResultInvalid("let o : OrderedSet(String) = invalid in o->subOrderedSet(1, 1)");
    }

    public void testCollectionSubOrderedSetNull() {
        this.assertResultInvalid("let o : OrderedSet(String) = null in o->subOrderedSet(1, 1)");
    }

    public void testCollectionSubOrderedSetOutOfBounds() {
        this.assertResultInvalid("OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(0, 1)");
        this.assertResultInvalid("OrderedSet{'a', 'b', 'c', 'd'}->subOrderedSet(4, 5)");
    }

    public void testCollectionSubSequence() {
        this.assertExpressionResults("Sequence{'a'}", "Sequence{'a', 'b', 'c', 'd'}->subSequence(1, 1)");
        this.assertExpressionResults("Sequence{'b', 'c'}", "Sequence{'a', 'b', 'c', 'd'}->subSequence(2, 3)");
        this.assertExpressionResults("Sequence{'d'}", "Sequence{'a', 'b', 'c', 'd'}->subSequence(4, 4)");
    }

    public void testCollectionSubSequenceIllegalArguments() {
        this.assertResultInvalid("Sequence{'a', 'b', 'c', 'd'}->subSequence(2, 1)");
    }

    public void testCollectionSubSequenceInvalid() {
        this.assertResultInvalid("let o : Sequence(String) = invalid in o->subSequence(1, 1)");
    }

    public void testCollectionSubSequenceNull() {
        this.assertResultInvalid("let o : Sequence(String) = null in o->subSequence(1, 1)");
    }

    public void testCollectionSubSequenceOutOfBounds() {
        this.assertResultInvalid("Sequence{'a', 'b', 'c', 'd'}->subSequence(0, 1)");
        this.assertResultInvalid("Sequence{'a', 'b', 'c', 'd'}->subSequence(4, 5)");
    }

    public void testCollectionSum() {
        this.assertResult(0, "let s : Sequence(Integer) = Sequence{} in s->sum()");
        this.assertResult(0.0, "let b : Bag(Real) = Bag{} in b->sum()");
        this.assertResult(0.0, "let s : Set(Real) = Set{} in s->sum()");
        this.assertResult(0, "let o : OrderedSet(Integer) = OrderedSet{} in o->sum()");
        this.assertResult(13.0, "Sequence{4.0, 4.0, 5.0}->sum()");
        this.assertResult(13, "Bag{4, 4, 5}->sum()");
        this.assertResult(9.0, "Set{4, 4, 5.0}->sum()");
        this.assertResult(9.0, "OrderedSet{4.0, 4.0, 5.0}->sum()");
        this.assertResult(4, "4->sum()");
    }

    public void testCollectionSumInvalid() {
        this.assertResultInvalid("let s : Sequence(Integer) = invalid in s->sum()");
        this.assertResultInvalid("let b : Bag(Integer) = invalid in b->sum()");
        this.assertResultInvalid("let s : Set(Integer) = invalid in s->sum()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = invalid in o->sum()");
    }

    public void testCollectionSumInvalidValue() {
        this.assertResultInvalid("Sequence{4.0, invalid, 5.0}->sum()");
        this.assertResultInvalid("Bag{4, invalid, 5}->sum()");
        this.assertResultInvalid("Set{4, invalid, 5}->sum()");
        this.assertResultInvalid("OrderedSet{4.0, invalid, 5.0}->sum()");
    }

    public void testCollectionSumNull() {
        this.assertResultInvalid("let s : Sequence(Integer) = null in s->sum()");
        this.assertResultInvalid("let b : Bag(Integer) = null in b->sum()");
        this.assertResultInvalid("let s : Set(Integer) = null in s->sum()");
        this.assertResultInvalid("let o : OrderedSet(Integer) = null in o->sum()");
    }

    public void testCollectionSumNullValue() {
        this.assertResultInvalid("Sequence{4.0, null, 5.0}->sum()");
        this.assertResultInvalid("Bag{4, null, 5}->sum()");
        this.assertResultInvalid("Set{4, null, 5}->sum()");
        this.assertResultInvalid("OrderedSet{4.0, null, 5.0}->sum()");
    }

    public void testCollectionSymmetricDifference() {
        this.assertExpressionResults("Set{'a', 'c'}", "Set{'a', 'b'}->symmetricDifference(Set{'b', 'c'})");
    }

    public void testCollectionSymmetricDifferenceInvalid() {
        this.assertResultInvalid("let s : Set(String) = invalid in s->symmetricDifference(Set{'a'})");
    }

    public void testCollectionSymmetricDifferenceInvalidValue() {
        this.assertResultInvalid("Set{'a', invalid, 'b'}->symmetricDifference(Set{'b', 'c'})");
    }

    public void testCollectionSymmetricDifferenceNull() {
        this.assertResultInvalid("let s : Set(String) = null in s->symmetricDifference(Set{'a'})");
    }

    public void testCollectionSymmetricDifferenceNullValue() {
        this.assertExpressionResults("Set{'a', null, 'c'}", "Set{'a', null, 'b'}->symmetricDifference(Set{'b', 'c'})");
    }

    public void testCollectionUnionDuplicates() {
        this.assertExpressionResults("Set{'a', 'b', 'c'}", "Set{'a', 'b', 'a'}->union(Set{'b', 'c'})");
        this.assertExpressionResults("Bag{'a', 'b', 'b', 'c'}", "Set{'a', 'b', 'a'}->union(Bag{'b', 'c'})");
        this.assertExpressionResults("Bag{'a', 'b', 'a', 'b', 'c'}", "Bag{'a', 'b', 'a'}->union(Bag{'b', 'c'})");
        this.assertExpressionResults("Bag{'a', 'b', 'a', 'b', 'c'}", "Bag{'a', 'b', 'a'}->union(Set{'b', 'c'})");
        this.assertExpressionResults("Sequence{'a', 'b', 'a', 'b', 'c'}", "Sequence{'a', 'b', 'a'}->union(Sequence{'b', 'c'})");
    }

    public void testCollectionUnionEmptyCollection() {
        this.assertExpressionResults("Set{3, 4}", "Set{3, 4}->union(Set{})");
        this.assertExpressionResults("Bag{3, 4}", "Set{3, 4}->union(Bag{})");
        this.assertExpressionResults("Bag{3, 4}", "Bag{3, 4}->union(Bag{})");
        this.assertExpressionResults("Bag{3, 4}", "Bag{3, 4}->union(Set{})");
        this.assertExpressionResults("Sequence{3, 4}", "Sequence{3, 4}->union(Sequence{})");
        this.assertExpressionResults("Set{3, 4}", "let s:Set(Integer)=Set{} in s->union(Set{3, 4})");
        this.assertExpressionResults("Bag{3, 4}", "let s:Set(Integer)=Set{} in s->union(Bag{3, 4})");
        this.assertExpressionResults("Bag{3, 4}", "let b:Bag(Integer)=Bag{} in b->union(Bag{3, 4})");
        this.assertExpressionResults("Bag{3, 4}", "let b:Bag(Integer)=Bag{} in b->union(Set{3, 4})");
        this.assertExpressionResults("Sequence{3, 4}", "let s:Sequence(Integer)=Sequence{} in s->union(Sequence{3, 4})");
    }

    public void testCollectionUnionInvalid() {
        this.assertResultInvalid("let s : Set(String) = invalid in s->union(Set{'a'})");
        this.assertResultInvalid("let s : Set(String) = invalid in s->union(Bag{'a'})");
        this.assertResultInvalid("let b : Bag(String) = invalid in b->union(Bag{'a'})");
        this.assertResultInvalid("let b : Bag(String) = invalid in b->union(Set{'a'})");
        this.assertResultInvalid("let s : Sequence(String) = invalid in s->union(Sequence{'a'})");
        this.assertResultInvalid("let s : Set(String) = invalid in Set{'a'}->union(s)");
        this.assertResultInvalid("let s : Set(String) = invalid in Bag{'a'}->union(s)");
        this.assertResultInvalid("let b : Bag(String) = invalid in Bag{'a'}->union(b)");
        this.assertResultInvalid("let b : Bag(String) = invalid in Set{'a'}->union(b)");
        this.assertResultInvalid("let s : Sequence(String) = invalid in Sequence{'a'}->union(s)");
    }

    public void testCollectionUnionInvalidValue() {
        this.assertResultInvalid("Set{'a', invalid}->union(Set{'b', invalid})");
        this.assertResultInvalid("Set{'a', invalid}->union(Bag{'b', invalid})");
        this.assertResultInvalid("Bag{'a', invalid}->union(Bag{'b', invalid})");
        this.assertResultInvalid("Bag{'a', invalid}->union(Set{'b', invalid})");
        this.assertResultInvalid("Sequence{'a', invalid}->union(Sequence{'b', invalid})");
    }

    public void testCollectionUnionNoDuplicates() {
        this.assertExpressionResults("Set{'a', 'b', 'c', 'd'}", "Set{'a', 'b'}->union(Set{'c', 'd'})");
        this.assertExpressionResults("Bag{'a', 'b', 'c', 'd'}", "Set{'a', 'b'}->union(Bag{'c', 'd'})");
        this.assertExpressionResults("Bag{'a', 'b', 'c', 'd'}", "Bag{'a', 'b'}->union(Bag{'c', 'd'})");
        this.assertExpressionResults("Bag{'a', 'b', 'c', 'd'}", "Bag{'a', 'b'}->union(Set{'c', 'd'})");
        this.assertExpressionResults("Sequence{'a', 'b', 'c', 'd'}", "Sequence{'a', 'b'}->union(Sequence{'c', 'd'})");
    }

    public void testCollectionUnionNull() {
        this.assertResultInvalid("let s : Set(String) = null in s->union(Set{'a'})");
        this.assertResultInvalid("let s : Set(String) = null in s->union(Bag{'a'})");
        this.assertResultInvalid("let b : Bag(String) = null in b->union(Bag{'a'})");
        this.assertResultInvalid("let b : Bag(String) = null in b->union(Set{'a'})");
        this.assertResultInvalid("let s : Sequence(String) = null in s->union(Sequence{'a'})");
        this.assertResultInvalid("let s : Set(String) = null in Set{'a'}->union(s)");
        this.assertResultInvalid("let s : Set(String) = null in Bag{'a'}->union(s)");
        this.assertResultInvalid("let b : Bag(String) = null in Bag{'a'}->union(b)");
        this.assertResultInvalid("let b : Bag(String) = null in Set{'a'}->union(b)");
        this.assertResultInvalid("let s : Sequence(String) = null in Sequence{'a'}->union(s)");
    }

    public void testCollectionUnionNullValue() {
        this.assertExpressionResults("Set{'a', null, 'b'}", "Set{'a', null}->union(Set{'b', null})");
        this.assertExpressionResults("Bag{'a', null, 'b', null}", "Set{'a', null}->union(Bag{'b', null})");
        this.assertExpressionResults("Bag{'a', null, 'b', null}", "Bag{'a', null}->union(Bag{'b', null})");
        this.assertExpressionResults("Bag{'a', null, 'b', null}", "Bag{'a', null}->union(Set{'b', null})");
        this.assertExpressionResults("Sequence{'a', null, 'b', null}", "Sequence{'a', null}->union(Sequence{'b', null})");
    }
}

