/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.oclforuml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Rounding implements Enumerator
{
    NEAREST(0, "nearest", "nearest"),
    CEILING(1, "ceiling", "ceiling"),
    FLOOR(2, "floor", "floor"),
    CONGRUENT(3, "congruent", "congruent");

    public static final int NEAREST_VALUE = 0;
    public static final int CEILING_VALUE = 1;
    public static final int FLOOR_VALUE = 2;
    public static final int CONGRUENT_VALUE = 3;
    private static final Rounding[] VALUES_ARRAY;
    public static final List<Rounding> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Rounding[]{NEAREST, CEILING, FLOOR, CONGRUENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Rounding get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rounding result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rounding getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rounding result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rounding get(int value) {
        switch (value) {
            case 0: {
                return NEAREST;
            }
            case 1: {
                return CEILING;
            }
            case 2: {
                return FLOOR;
            }
            case 3: {
                return CONGRUENT;
            }
        }
        return null;
    }

    private Rounding(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

