/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;

public class NamesTest
extends AbstractTestSuite {
    protected static final String NAMES_TEST_XMI = "/model/NamesTest.xmi";
    public EClass level0Class;
    public EClass level1Class;
    public EClass level2aClass;
    public EClass level2bClass;
    public EClass level3Class;
    public EClass level4Class;
    public EObject container;
    public EObject level0;
    public EObject level1;
    public EObject level2a;
    public EObject level2b;
    public EObject level3;
    public EObject level4;

    protected void setUp() {
        super.setUp();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new EcoreResourceFactoryImpl());
        }
        this.initModel();
    }

    protected void initModel() {
        URI uri = this.getTestModelURI(NAMES_TEST_XMI);
        Resource testResource = resourceSet.getResource(uri, true);
        this.container = (EObject)testResource.getContents().get(0);
        EClass containerClass = this.container.eClass();
        EPackage namesTestPackage = containerClass.getEPackage();
        this.level0Class = (EClass)namesTestPackage.getEClassifier("Level0");
        this.level1Class = (EClass)namesTestPackage.getEClassifier("Level1");
        this.level2aClass = (EClass)namesTestPackage.getEClassifier("Level2a");
        this.level2bClass = (EClass)namesTestPackage.getEClassifier("Level2b");
        this.level3Class = (EClass)namesTestPackage.getEClassifier("Level3");
        this.level4Class = (EClass)namesTestPackage.getEClassifier("Level4");
        EStructuralFeature level0Name = this.level0Class.getEStructuralFeature("name");
        this.level0 = this.getObject(this.container, level0Name, "level0");
        this.level1 = this.getObject(this.container, level0Name, "level1");
        this.level2a = this.getObject(this.container, level0Name, "level2a");
        this.level2b = this.getObject(this.container, level0Name, "level2b");
        this.level3 = this.getObject(this.container, level0Name, "level3");
        this.level4 = this.getObject(this.container, level0Name, "level4");
    }

    private EObject getObject(EObject eContainer, EStructuralFeature eFeature, Object values) {
        for (EObject eObject : eContainer.eContents()) {
            if (!values.equals(eObject.eGet(eFeature))) continue;
            return eObject;
        }
        return null;
    }

    public void test_overriden_withStaticDispatch() {
        this.helper.setContext((Object)this.level0Class);
        this.assertQueryEquals(this.level0, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level0::overridden", "self.overridden()");
        this.helper.setContext((Object)this.level2aClass);
        this.assertQueryEquals(this.level0, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level2a::overridden", "self.overridden()");
        this.helper.setContext((Object)this.level4Class);
        this.assertQueryEquals(this.level0, "Level4::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level4::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level4::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level4::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level4::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level4::overridden", "self.overridden()");
    }

    public void test_overriden_withDynamicDispatch() {
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.DYNAMIC_DISPATCH, (Object)true);
        this.helper.setContext((Object)this.level0Class);
        this.assertQueryEquals(this.level0, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level1::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level2b::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level3::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level4::overridden", "self.overridden()");
        this.helper.setContext((Object)this.level2aClass);
        this.assertQueryEquals(this.level0, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level1::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level2b::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level3::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level4::overridden", "self.overridden()");
        this.helper.setContext((Object)this.level4Class);
        this.assertQueryEquals(this.level0, "Level0::overridden", "self.overridden()");
        this.assertQueryEquals(this.level1, "Level1::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2a, "Level2a::overridden", "self.overridden()");
        this.assertQueryEquals(this.level2b, "Level2b::overridden", "self.overridden()");
        this.assertQueryEquals(this.level3, "Level3::overridden", "self.overridden()");
        this.assertQueryEquals(this.level4, "Level4::overridden", "self.overridden()");
    }

    public void test_ambiguous_withStaticDispatch() {
        this.helper.setContext((Object)this.level0Class);
        this.assertSemanticError("self.ambiguous()", OCLMessages.OperationNotFound_ERROR_, new String[]{"ambiguous()", "Level0"});
        this.helper.setContext((Object)this.level1Class);
        this.assertQueryEquals(this.level0, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level3, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level1::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level2aClass);
        this.assertQueryEquals(this.level0, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level3, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level2a::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level3Class);
        this.assertQueryEquals(this.level0, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level3, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level2a::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level4Class);
        this.assertQueryEquals(this.level0, "Level4::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level4::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level4::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level4::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level3, "Level4::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level4::ambiguous", "self.ambiguous()");
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.OVERLOAD_AMBIGUITY_IS_INVALID, (Object)true);
        this.helper.setContext((Object)this.level3Class);
        this.assertSemanticError("self.ambiguous()", OCLMessages.OperationNotFound_ERROR_, new String[]{"ambiguous()", "Level3"});
    }

    public void test_ambiguous_withDynamicDispatch() {
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.DYNAMIC_DISPATCH, (Object)true);
        this.helper.setContext((Object)this.level0Class);
        this.assertSemanticError("self.ambiguous()", OCLMessages.OperationNotFound_ERROR_, new String[]{"ambiguous()", "Level0"});
        this.helper.setContext((Object)this.level1Class);
        this.assertQueryInvalid(this.level0, "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2b::ambiguous", "self.ambiguous()");
        this.assertQueryInvalid(this.level3, "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level4::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level2aClass);
        this.assertQueryInvalid(this.level0, "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2b::ambiguous", "self.ambiguous()");
        this.assertQueryInvalid(this.level3, "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level4::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level3Class);
        this.assertQueryInvalid(this.level0, "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2b::ambiguous", "self.ambiguous()");
        this.assertQueryInvalid(this.level3, "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level4::ambiguous", "self.ambiguous()");
        this.helper.setContext((Object)this.level4Class);
        this.assertQueryInvalid(this.level0, "self.ambiguous()");
        this.assertQueryEquals(this.level1, "Level1::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2a, "Level2a::ambiguous", "self.ambiguous()");
        this.assertQueryEquals(this.level2b, "Level2b::ambiguous", "self.ambiguous()");
        this.assertQueryInvalid(this.level3, "self.ambiguous()");
        this.assertQueryEquals(this.level4, "Level4::ambiguous", "self.ambiguous()");
    }

    public void test_overloads() {
        this.helper.setContext((Object)this.level0Class);
        this.assertQueryEquals(this.level0, "Level0::overload(Level4)", "self.overload(self.asLevel4())");
        this.helper.setContext((Object)this.level0Class);
        this.assertQueryEquals(this.level0, "Level0::overload(String)", "self.overload(self.toString())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level0)", "self.overload(self.asLevel0())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level1)", "self.overload(self.asLevel1())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level2a)", "self.overload(self.asLevel2a())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level2b)", "self.overload(self.asLevel2b())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level3)", "self.overload(self.asLevel3())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level4)", "self.overload(self.asLevel4())");
        this.helper.setContext((Object)this.level4Class);
        this.assertQueryEquals(this.level0, "Level0::overload(String)", "self.overload(self.toString())");
        this.assertQueryEquals(this.level0, "Level0::overload(Level0)", "self.overload(self.asLevel0())");
        this.assertQueryEquals(this.level0, "Level1::overload(Level1)", "self.overload(self.asLevel1())");
        this.assertQueryEquals(this.level0, "Level2a::overload(Level2a)", "self.overload(self.asLevel2a())");
        this.assertQueryEquals(this.level0, "Level2b::overload(Level2b)", "self.overload(self.asLevel2b())");
        this.assertQueryEquals(this.level0, "Level3::overload(Level3)", "self.overload(self.asLevel3())");
        this.assertQueryEquals(this.level0, "Level4::overload(Level4)", "self.overload(self.asLevel4())");
    }
}

