/*
 * Decompiled with CFR 0.152.
 */
package dataaccess.expressions.collectionexpressions.util;

import dataaccess.expressions.collectionexpressions.CollectionExpression;
import dataaccess.expressions.collectionexpressions.CollectionExpressionWithArgument;
import dataaccess.expressions.collectionexpressions.CollectionexpressionsPackage;
import dataaccess.expressions.collectionexpressions.Excluding;
import dataaccess.expressions.collectionexpressions.ExcludingAt;
import dataaccess.expressions.collectionexpressions.Including;
import dataaccess.expressions.collectionexpressions.IncludingAt;
import dataaccess.expressions.collectionexpressions.Iterate;
import dataaccess.expressions.collectionexpressions.WithPosition;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionexpressionsValidator
extends EObjectValidator {
    public static final CollectionexpressionsValidator INSTANCE = new CollectionexpressionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "dataaccess.expressions.collectionexpressions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String ITERATE__ACCUMULATOR_TYPE_EQUALS_EXPRESSION_TYPE__EEXPRESSION = "self.accumulator->notEmpty() implies\r\n  (self.accumulator.ownedTypeDefinition->notEmpty() implies\r\n     self.accumulator.ownedTypeDefinition.conformsTo(self.iteratorExpression.getType()))";
    protected static final String WITH_POSITION__SOURCE_MUST_BE_ORDERED__EEXPRESSION = "self.argument.getType().ordered";
    protected static final String COLLECTION_EXPRESSION_WITH_ARGUMENT__ARGUMENT_TYPE_MUST_CONFORM_TO_COLLECTION_EXPRESSION_TYPE__EEXPRESSION = "let snl : Integer = source.getType().getNestingLevel() in let anl : Integer = argument.getType().getNestingLevel() in\r\n    if snl = anl then\r\n      source.getType().conformsToIgnoringMultiplicity(argument.getType())\r\n    else\r\n      if snl = (anl + 1) then\r\n        source.getType().oclAsType(data::classes::NestedTypeDefinition).type.conformsToIgnoringMultiplicity(argument.getType())\r\n      else\r\n        if (snl + 1) = anl then\r\n          source.getType().conformsToIgnoringMultiplicity(argument.getType().oclAsType(data::classes::NestedTypeDefinition).type)\r\n        else\r\n          false\r\n        endif\r\n      endif\r\n    endif";

    protected EPackage getEPackage() {
        return CollectionexpressionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateIncluding((Including)value, diagnostics, context);
            }
            case 1: {
                return this.validateExcluding((Excluding)value, diagnostics, context);
            }
            case 2: {
                return this.validateIncludingAt((IncludingAt)value, diagnostics, context);
            }
            case 3: {
                return this.validateIterate((Iterate)value, diagnostics, context);
            }
            case 4: {
                return this.validateCollectionExpression((CollectionExpression)value, diagnostics, context);
            }
            case 5: {
                return this.validateExcludingAt((ExcludingAt)value, diagnostics, context);
            }
            case 6: {
                return this.validateWithPosition((WithPosition)value, diagnostics, context);
            }
            case 7: {
                return this.validateCollectionExpressionWithArgument((CollectionExpressionWithArgument)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateIncluding(Including including, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(including, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(including, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(including, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(including, diagnostics, context);
        }
        return result;
    }

    public boolean validateExcluding(Excluding excluding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(excluding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(excluding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(excluding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(excluding, diagnostics, context);
        }
        return result;
    }

    public boolean validateIncludingAt(IncludingAt includingAt, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(includingAt, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(includingAt, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(includingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateWithPosition_SourceMustBeOrdered(includingAt, diagnostics, context);
        }
        return result;
    }

    public boolean validateIterate(Iterate iterate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(iterate, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(iterate, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iterate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIterate_AccumulatorTypeEqualsExpressionType(iterate, diagnostics, context);
        }
        return result;
    }

    public boolean validateIterate_AccumulatorTypeEqualsExpressionType(Iterate iterate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CollectionexpressionsPackage.Literals.ITERATE, iterate, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AccumulatorTypeEqualsExpressionType", ITERATE__ACCUMULATOR_TYPE_EQUALS_EXPRESSION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCollectionExpression(CollectionExpression collectionExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(collectionExpression, diagnostics, context);
    }

    public boolean validateExcludingAt(ExcludingAt excludingAt, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(excludingAt, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(excludingAt, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(excludingAt, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateWithPosition_SourceMustBeOrdered(excludingAt, diagnostics, context);
        }
        return result;
    }

    public boolean validateWithPosition(WithPosition withPosition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(withPosition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(withPosition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(withPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateWithPosition_SourceMustBeOrdered(withPosition, diagnostics, context);
        }
        return result;
    }

    public boolean validateWithPosition_SourceMustBeOrdered(WithPosition withPosition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CollectionexpressionsPackage.Literals.WITH_POSITION, withPosition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SourceMustBeOrdered", WITH_POSITION__SOURCE_MUST_BE_ORDERED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCollectionExpressionWithArgument(CollectionExpressionWithArgument collectionExpressionWithArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionExpressionWithArgument, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionExpressionWithArgument, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionExpressionWithArgument, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(collectionExpressionWithArgument, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionExpressionWithArgument_ArgumentTypeMustConformToCollectionExpressionType(CollectionExpressionWithArgument collectionExpressionWithArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CollectionexpressionsPackage.Literals.COLLECTION_EXPRESSION_WITH_ARGUMENT, collectionExpressionWithArgument, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ArgumentTypeMustConformToCollectionExpressionType", COLLECTION_EXPRESSION_WITH_ARGUMENT__ARGUMENT_TYPE_MUST_CONFORM_TO_COLLECTION_EXPRESSION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

