/*
 * Decompiled with CFR 0.152.
 */
package persistence.expressions.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import persistence.expressions.All;
import persistence.expressions.Commit;
import persistence.expressions.ExpressionsPackage;
import persistence.expressions.Snapshot;
import persistence.expressions.SnapshotSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionsValidator
extends EObjectValidator {
    public static final ExpressionsValidator INSTANCE = new ExpressionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "persistence.expressions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String ALL__MUST_BE_ENTITY_CLASS__EEXPRESSION = "not self.ofClass.valueType";
    protected static final String ALL__EXPRESSION_MUST_BE_SNAPSHOT_OR_TIME_POINT__EEXPRESSION = "if self.snapshot = SnapshotSelection::SPECIFIED then\r\n    self.snapshotIdentifier.getType().upperMultiplicity = 1 and\r\n    self.snapshotIdentifier.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n   Set{'Snapshot', 'TimePoint'}->includes(self.snapshotIdentifier.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name)\r\n  else\r\n    true\r\n  endif";
    protected static final String COMMIT__RETURNS_SNAPSHOT__EEXPRESSION = "self.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Snapshot'";
    protected static final String SNAPSHOT__SOURCE_OBJECT_IS_OF_CLASS_TYPE__EEXPRESSION = "self.object.getType().oclIsKindOf(data::classes::ClassTypeDefinition)";

    protected EPackage getEPackage() {
        return ExpressionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAll((All)value, diagnostics, context);
            }
            case 1: {
                return this.validateCommit((Commit)value, diagnostics, context);
            }
            case 2: {
                return this.validateSnapshot((Snapshot)value, diagnostics, context);
            }
            case 3: {
                return this.validateSnapshotSelection((SnapshotSelection)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAll(All all, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(all, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(all, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAll_MustBeEntityClass(all, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAll_ExpressionMustBeSnapshotOrTimePoint(all, diagnostics, context);
        }
        return result;
    }

    public boolean validateAll_MustBeEntityClass(All all, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.ALL, all, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustBeEntityClass", ALL__MUST_BE_ENTITY_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAll_ExpressionMustBeSnapshotOrTimePoint(All all, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.ALL, all, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ExpressionMustBeSnapshotOrTimePoint", ALL__EXPRESSION_MUST_BE_SNAPSHOT_OR_TIME_POINT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCommit(Commit commit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(commit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(commit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(commit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCommit_ReturnsSnapshot(commit, diagnostics, context);
        }
        return result;
    }

    public boolean validateCommit_ReturnsSnapshot(Commit commit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.COMMIT, commit, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ReturnsSnapshot", COMMIT__RETURNS_SNAPSHOT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSnapshot(Snapshot snapshot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(snapshot, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(snapshot, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(snapshot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSnapshot_SourceObjectIsOfClassType(snapshot, diagnostics, context);
        }
        return result;
    }

    public boolean validateSnapshot_SourceObjectIsOfClassType(Snapshot snapshot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.SNAPSHOT, snapshot, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SourceObjectIsOfClassType", SNAPSHOT__SOURCE_OBJECT_IS_OF_CLASS_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSnapshotSelection(SnapshotSelection snapshotSelection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

