/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import com.google.common.collect.Lists;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.ocl.examples.test.xtext.AbstractBuilderTests;

public class OCLBuilderTests
extends AbstractBuilderTests {
    public void testBuilder_IOException() throws Exception {
        String testDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"UnresolvedReference\" nsURI=\"http://UnresolvedReference\" nsPrefix=\"UnresolvedReference\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"MyClass\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"comparison\" eType=\"#//ComparisonKind\"\n        defaultValueLiteral=\"=\"/>\n  </eClassifiers>\n</ecore:EPackage>\n";
        IFile file = this.createEcoreIFile(this.getTestProject().getName(), "UnresolvedReference.ecore", testDocument);
        this.doValidation(file, UnresolvedReferenceException.class, null);
    }

    public void testBuilder_MalformedName() throws Exception {
        String testDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"MalformedName\" nsURI=\"http://MalformedName\" nsPrefix=\"MalformedName\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"My#Class\">\n  </eClassifiers>\n</ecore:EPackage>\n";
        IFile file = this.createEcoreIFile(this.getTestProject().getName(), "MalformedName.ecore", testDocument);
        this.doValidation(file, null, Lists.newArrayList((Object[])new String[]{"The name 'My#Class' is not well formed"}));
    }

    public void testBuilder_OK() throws Exception {
        String testDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"OK\" nsURI=\"http://OK\" nsPrefix=\"OK\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"MyClass\">\n  </eClassifiers>\n</ecore:EPackage>\n";
        IFile file = this.createEcoreIFile(this.getTestProject().getName(), "OK.ecore", testDocument);
        this.doValidation(file, null, null);
    }
}

