/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.OperationCallExp;
import org.eclipse.ocl.uml.TypeType;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationTest
extends AbstractTestSuite {
    Resource res;

    public void test_basicSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.nestingPackage");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_primitiveTypeSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.nestedPackage->size() > 2");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_primitiveCollectionTypeSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.nestedPackage->collect(ownedType->size())");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_modelCollectionTypeSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "let subs : Collection(Package) = self.nestedPackage in subs->size() > 2");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_typeExpSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.ownedType->forAll(c | c.oclIsKindOf(Class) implies Class.allInstances()->includes(c.oclAsType(Class)))");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_tupleSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.nestedPackage->collect(Tuple{pkg = name, size = ownedType->size()})");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_operationMessageSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.fruit, "let msgs : Sequence(OclMessage) = self^^ripen(?) in msgs->forAll(m | m.hasReturned() implies m.color <> Color::black)");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_signalMessageSerialization() {
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.fruit, "let msgs : Sequence(OclMessage) = self^^Drop(?, ?) in msgs->forAll(m | m.delay = 0 implies m.stem.oclIsUndefined())");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
    }

    public void test_additionalOperationSerialization() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        Operation oper = null;
        try {
            oper = (Operation)this.helper.defineOperation("getUniqueClassifierNames() : Set(String) = self.ownedType->collect(name)->asSet()");
            SerializationTest.assertSame((Object)oper, (Object)this.ocl.getEnvironment().getTypeResolver().resolveAdditionalOperation((Object)((Classifier)this.getMetaclass("Package")), (Object)oper));
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.getUniqueClassifierNames()->size()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        OCL newOCL = OCL.newInstance((EnvironmentFactory)this.ocl.getEnvironment().getFactory(), (Resource)this.ocl.getEnvironment().getTypeResolver().getResource());
        Operation newOper = (Operation)newOCL.getEnvironment().getTypeResolver().resolveAdditionalOperation((Object)((Classifier)this.getMetaclass("Package")), (Object)oper);
        SerializationTest.assertNotSame((Object)oper, (Object)newOper);
    }

    public void test_additionalPropertySerialization() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        Property prop = null;
        try {
            prop = (Property)this.helper.defineAttribute("uniqueClassifierNames : Set(String) = self.ownedType->collect(name)->asSet()");
            SerializationTest.assertSame((Object)prop, (Object)this.ocl.getEnvironment().getTypeResolver().resolveAdditionalAttribute((Object)((Classifier)this.getMetaclass("Package")), (Object)prop));
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        OCLExpression<Classifier> expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "self.uniqueClassifierNames->size()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        OCL newOCL = OCL.newInstance((EnvironmentFactory)this.ocl.getEnvironment().getFactory(), (Resource)this.ocl.getEnvironment().getTypeResolver().getResource());
        Property newProp = (Property)newOCL.getEnvironment().getTypeResolver().resolveAdditionalAttribute((Object)((Classifier)this.getMetaclass("Package")), (Object)prop);
        SerializationTest.assertNotSame((Object)prop, (Object)newProp);
    }

    public void test_typeTypeSerialization_183494() {
        OCLExpression expr = this.parseExpression((Classifier)this.getMetaclass("Package"), "Package.allInstances()");
        String toStringForm = expr.toString();
        String serialForm = this.serialize((EObject)expr);
        expr = this.loadExpression(serialForm);
        this.validate(expr);
        SerializationTest.assertEquals((String)toStringForm, (String)expr.toString());
        SerializationTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        expr = ((OperationCallExp)expr).getSource();
        SerializationTest.assertNotNull((Object)expr);
        SerializationTest.assertTrue((boolean)(expr.getType() instanceof TypeType));
        TypeType typeType = (TypeType)expr.getType();
        SerializationTest.assertSame((Object)this.getMetaclass("Package"), (Object)typeType.getReferredType());
    }

    public void test_OclType_serialization_226455() {
        TypeResolver resolver = this.ocl.getEnvironment().getTypeResolver();
        Classifier oclType = (Classifier)resolver.resolve((Object)((Classifier)this.getOCLStandardLibrary().getOclType()));
        SerializationTest.assertSame((Object)this.getOCLStandardLibrary().getOclType(), (Object)oclType);
        SerializationTest.assertTrue((boolean)resolver.getResource().getContents().isEmpty());
    }

    public void test_typespec_resolution_226455() {
        this.parseExpression((Classifier)this.getMetaclass("Package"), "self.ownedType->any(oclIsKindOf(Class))");
        Resource res = this.ocl.getEnvironment().getTypeResolver().getResource();
        Package typesPackage = null;
        for (EObject next : res.getContents()) {
            if (!(next instanceof Package) || !"types".equals(((Package)next).getName())) continue;
            typesPackage = (Package)next;
            break;
        }
        SerializationTest.assertNotNull(typesPackage);
        SerializationTest.assertEquals((int)1, (int)typesPackage.getOwnedTypes().size());
        Classifier first = (Classifier)typesPackage.getOwnedTypes().get(0);
        SerializationTest.assertTrue((boolean)(first instanceof TypeType));
        SerializationTest.assertSame((Object)this.getMetaclass("Class"), (Object)((TypeType)first).getReferredType());
    }

    public void test_referenceToOCLEcoreMetamodel_214878() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("Foo");
        epackage.getEClassifiers().add((Object)eclass);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("expr");
        ref.setEType((EClassifier)UMLPackage.Literals.OCL_EXPRESSION);
        eclass.getEStructuralFeatures().add((Object)ref);
        String serialForm = this.serialize((EObject)epackage);
        epackage = this.load(serialForm, EPackage.class);
        eclass = (EClass)epackage.getEClassifier("Foo");
        SerializationTest.assertNotNull((Object)eclass);
        SerializationTest.assertFalse((boolean)eclass.eIsProxy());
        ref = (EReference)eclass.getEStructuralFeature("expr");
        SerializationTest.assertNotNull((Object)ref);
        SerializationTest.assertFalse((boolean)ref.eIsProxy());
        SerializationTest.assertSame((Object)UMLPackage.Literals.OCL_EXPRESSION, (Object)ref.getEType());
        SerializationTest.assertFalse((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/OCL#//uml/OCLExpression"));
        SerializationTest.assertTrue((boolean)serialForm.contains("http://www.eclipse.org/ocl/1.1.0/UML#//OCLExpression"));
    }

    protected void setUp() {
        this.res = new XMIResourceImpl(){

            protected boolean useIDs() {
                return true;
            }

            protected boolean useUUIDs() {
                return true;
            }
        };
        this.res.setURI(URI.createFileURI((String)"/tmp/ocltest.xmi"));
        ((XMLResource)this.res).setEncoding("UTF-8");
        super.setUp();
        resourceSet.getResources().add((Object)this.res);
    }

    protected OCL createOCL() {
        UMLEnvironmentFactory factory = new UMLEnvironmentFactory(resourceSet);
        UMLEnvironment environment = (UMLEnvironment)factory.loadEnvironment(this.res);
        return OCL.newInstance((Environment)environment);
    }

    protected OCLExpression<Classifier> parseExpression(Classifier context, String expr) {
        this.helper.setContext((Object)context);
        OCLExpression result = null;
        try {
            result = this.helper.createQuery(expr);
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        SerializationTest.assertNotNull((Object)result);
        return result;
    }

    protected String serialize(EObject eobject) {
        String result = null;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.res.getContents().add((Object)eobject);
            this.res.save((OutputStream)output, Collections.singletonMap("SAVE_TYPE_INFORMATION", Boolean.TRUE));
            result = output.toString("UTF-8");
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Exception serializing AST: " + e.getLocalizedMessage()));
        }
        SerializationTest.assertNotNull(result);
        SerializationTest.assertFalse((boolean)result.contains("ocl://"));
        return result;
    }

    protected List<EObject> deserialize(String serial) {
        EList result;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(serial.getBytes());
            this.res.unload();
            this.res.load((InputStream)input, Collections.EMPTY_MAP);
            this.ocl = this.createOCL();
            this.helper = this.createHelper();
            SerializationTest.assertFalse((String)"No contents in serial data", (boolean)this.res.getContents().isEmpty());
            this.assertNoProxies(this.res);
            result = this.res.getContents();
        }
        catch (Exception e) {
            SerializationTest.fail((String)("Exception deserializing AST: " + e.getLocalizedMessage()));
            result = Collections.emptyList();
        }
        SerializationTest.assertNotNull(result);
        return result;
    }

    protected OCLExpression<Classifier> loadExpression(String serial) {
        return this.load(serial, OCLExpression.class);
    }

    protected Constraint loadConstraint(String serial) {
        return this.load(serial, Constraint.class);
    }

    protected <T extends EObject> T load(String serial, Class<T> expectedType) {
        EObject result = null;
        List<EObject> objects = this.deserialize(serial);
        for (EObject next : objects) {
            if (!expectedType.isInstance(next)) continue;
            result = next;
            break;
        }
        SerializationTest.assertNotNull((String)("Did not deserialize a " + expectedType.getSimpleName()), result);
        return (T)result;
    }

    protected void assertNoProxies(Resource res) {
        TreeIterator iter = res.getAllContents();
        while (iter.hasNext()) {
            for (EObject xref : ((EObject)iter.next()).eCrossReferences()) {
                SerializationTest.assertFalse((String)("Unresolved reference: " + xref), (boolean)xref.eIsProxy());
            }
        }
    }
}

