/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativesSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedCurrentSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.NullSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SequenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedGrammarRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedSerializationRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.ToDebugString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CompoundElement;

public abstract class AbstractSerializationElement
implements SerializationElement,
ToDebugString.ToDebugStringable {
    private final @NonNull ToDebugString toDebugSring = new ToDebugString(this){};

    public static @NonNull SerializationElement createFrozenSequence(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, @NonNull List<@NonNull SerializationNode> listOfNodes, boolean isRootAlternative) {
        FindContext<UnassignedGrammarRuleCallSerializationNode> unassignedRuleContext;
        FindContext<@NonNull AssignedCurrentSerializationNode> assignedCurrentContext = AbstractSerializationElement.findAssignedCurrent(listOfNodes);
        if (assignedCurrentContext != null && (unassignedRuleContext = AbstractSerializationElement.findUnassignedRule(listOfNodes)) != null) {
            UnassignedGrammarRuleCallSerializationNode unassignedRuleCallSerializationNode = unassignedRuleContext.getElement();
            AssignedCurrentSerializationNode assignedCurrentSerializationNode = assignedCurrentContext.getElement();
            Iterable<@NonNull AbstractRuleAnalysis> targetRuleAnalyses = assignedCurrentSerializationNode.getTargetRuleAnalyses();
            GrammarCardinality grammarCardinality2 = assignedCurrentSerializationNode.getGrammarCardinality();
            assert (grammarCardinality2.isOne());
            AbstractRuleAnalysis calledRuleAnalysis = unassignedRuleCallSerializationNode.getCalledRuleAnalysis();
            AssignedRuleCallSerializationNode assignedRuleCallSerializationNode = new AssignedRuleCallSerializationNode(assignedCurrentSerializationNode.getGrammarAnalysis(), assignedCurrentSerializationNode.getAssignedEClass(), assignedCurrentSerializationNode.getEStructuralFeature(), grammarCardinality2, calledRuleAnalysis.getIndex(), targetRuleAnalyses);
            unassignedRuleContext.replace(assignedRuleCallSerializationNode);
            assignedCurrentContext.remove();
        }
        if (!grammarCardinality.isOne() && !AbstractSerializationElement.noAssignedCurrent(listOfNodes)) {
            SerializationElement sequenceSerializationNode = AbstractSerializationElement.createFlattenedSequence(compoundElement, GrammarCardinality.ONE, listOfNodes, isRootAlternative);
            ListOfListOfSerializationNode disjunction = new ListOfListOfSerializationNode();
            disjunction = disjunction.addConjunction(NullSerializationNode.INSTANCE);
            disjunction = disjunction.addConjunction(sequenceSerializationNode);
            return disjunction;
        }
        return AbstractSerializationElement.createFlattenedSequence(compoundElement, grammarCardinality, listOfNodes, isRootAlternative);
    }

    private static @NonNull SerializationElement createFlattenedSequence(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, @NonNull List<@NonNull SerializationNode> listOfNodes, boolean isRootAlternative) {
        assert (listOfNodes.size() > 0);
        UnassignedGrammarRuleCallSerializationNode firstRuleCall = null;
        for (SerializationNode serializationNode : listOfNodes) {
            UnassignedGrammarRuleCallSerializationNode unassignedRuleCallSerializationNode;
            AbstractRuleAnalysis calledRuleAnalysis;
            if (!(serializationNode instanceof UnassignedGrammarRuleCallSerializationNode) || !((calledRuleAnalysis = (unassignedRuleCallSerializationNode = (UnassignedGrammarRuleCallSerializationNode)serializationNode).getCalledRuleAnalysis()) instanceof ParserRuleAnalysis)) continue;
            assert (firstRuleCall == null);
            firstRuleCall = unassignedRuleCallSerializationNode;
            assert (firstRuleCall.isOne());
        }
        if (firstRuleCall == null) {
            GrammarCardinality maxGrammarCardinality;
            GrammarCardinality nodeGrammarCardinality;
            SerializationNode serializationNode;
            if (listOfNodes.size() == 1 && (nodeGrammarCardinality = (serializationNode = listOfNodes.get(0)).getGrammarCardinality()) == (maxGrammarCardinality = GrammarCardinality.max((GrammarCardinality)grammarCardinality, (GrammarCardinality)nodeGrammarCardinality))) {
                return serializationNode;
            }
            return new SequenceSerializationNode(compoundElement, grammarCardinality, listOfNodes);
        }
        ListOfListOfSerializationNode flattenedDisjunction = new ListOfListOfSerializationNode();
        for (SerializationNode serializationNode : listOfNodes) {
            SerializationElement conjunction = new ListOfSerializationNode();
            SerializationElement calledDisjunction = null;
            if (serializationNode instanceof UnassignedGrammarRuleCallSerializationNode) {
                calledDisjunction = AbstractSerializationElement.flattenUnassignedGrammarRuleCall((UnassignedGrammarRuleCallSerializationNode)serializationNode, grammarCardinality, isRootAlternative);
            }
            conjunction = conjunction.addConcatenation(calledDisjunction != null ? calledDisjunction : serializationNode);
            flattenedDisjunction = flattenedDisjunction.addConcatenation(conjunction.freezeSequences(compoundElement, GrammarCardinality.toEnum((AbstractElement)compoundElement), isRootAlternative));
        }
        return flattenedDisjunction;
    }

    private static @Nullable FindContext<@NonNull UnassignedGrammarRuleCallSerializationNode> findUnassignedRule(@NonNull List<@NonNull SerializationNode> serializationNodes) {
        int index = 0;
        for (SerializationNode serializationNode : serializationNodes) {
            if (serializationNode instanceof UnassignedGrammarRuleCallSerializationNode) {
                return new FindContext<UnassignedGrammarRuleCallSerializationNode>(serializationNodes, (UnassignedGrammarRuleCallSerializationNode)serializationNode, index);
            }
            if (serializationNode instanceof SequenceSerializationNode) {
                return AbstractSerializationElement.findUnassignedRule(((SequenceSerializationNode)serializationNode).getSerializationNodes());
            }
            if (serializationNode.isList() || serializationNode.isListOfList() || serializationNode.isNull() || serializationNode instanceof AlternativesSerializationNode) {
                throw new UnsupportedOperationException();
            }
            ++index;
        }
        return null;
    }

    private static @Nullable FindContext<@NonNull AssignedCurrentSerializationNode> findAssignedCurrent(@NonNull List<@NonNull SerializationNode> serializationNodes) {
        int index = 0;
        for (SerializationNode serializationNode : serializationNodes) {
            if (serializationNode instanceof AssignedCurrentSerializationNode) {
                return new FindContext<AssignedCurrentSerializationNode>(serializationNodes, (AssignedCurrentSerializationNode)serializationNode, index);
            }
            if (serializationNode instanceof SequenceSerializationNode) {
                return AbstractSerializationElement.findAssignedCurrent(((SequenceSerializationNode)serializationNode).getSerializationNodes());
            }
            if (serializationNode.isList() || serializationNode.isListOfList() || serializationNode.isNull() || serializationNode instanceof AlternativesSerializationNode) {
                throw new UnsupportedOperationException();
            }
            ++index;
        }
        return null;
    }

    public static @Nullable ListOfListOfSerializationNode flattenUnassignedGrammarRuleCall(@NonNull UnassignedGrammarRuleCallSerializationNode serializationNode, @NonNull GrammarCardinality grammarCardinality, boolean isRootAlternative) {
        ListOfListOfSerializationNode calledDisjunction;
        block5: {
            calledDisjunction = null;
            AbstractRuleAnalysis calledRuleAnalysis = serializationNode.getCalledRuleAnalysis();
            if (!(calledRuleAnalysis instanceof ParserRuleAnalysis)) break block5;
            calledDisjunction = new ListOfListOfSerializationNode();
            ParserRuleAnalysis calledParserRuleAnalysis = (ParserRuleAnalysis)calledRuleAnalysis;
            Iterable<@NonNull SerializationRuleAnalysis> calledSerializationRuleAnalyses = calledParserRuleAnalysis.getSerializationRuleAnalyses();
            if (!isRootAlternative) {
                for (SerializationRuleAnalysis serializationRuleAnalysis : calledSerializationRuleAnalyses) {
                    SerializationNode deepClone = serializationRuleAnalysis.getRootSerializationNode().clone(null);
                    calledDisjunction = calledDisjunction.addConjunction(deepClone);
                }
            } else {
                Iterator<SerializationRuleAnalysis> iterator = calledSerializationRuleAnalyses.iterator();
                while (iterator.hasNext()) {
                    SerializationNode rootSerializationNode;
                    SerializationRuleAnalysis calledSerializationRuleAnalysis;
                    SerializationRuleAnalysis serializationRuleAnalysis = calledSerializationRuleAnalysis = iterator.next();
                    while ((rootSerializationNode = serializationRuleAnalysis.getRootSerializationNode()) instanceof UnassignedSerializationRuleCallSerializationNode) {
                        serializationRuleAnalysis = ((UnassignedSerializationRuleCallSerializationNode)rootSerializationNode).getCalledRuleAnalysis();
                    }
                    EClass producedEClass = serializationRuleAnalysis.getProducedEClass();
                    UnassignedSerializationRuleCallSerializationNode serializationRuleCall = new UnassignedSerializationRuleCallSerializationNode(producedEClass, grammarCardinality, serializationRuleAnalysis);
                    calledDisjunction = calledDisjunction.addConjunction(serializationRuleCall);
                }
            }
        }
        return calledDisjunction;
    }

    private static boolean noAssignedCurrent(@NonNull List<@NonNull SerializationNode> serializationNodes) {
        for (SerializationNode serializationNode : serializationNodes) {
            if (serializationNode instanceof AssignedCurrentSerializationNode) {
                return false;
            }
            if (serializationNode instanceof SequenceSerializationNode) {
                return AbstractSerializationElement.noAssignedCurrent(((SequenceSerializationNode)serializationNode).getSerializationNodes());
            }
            if (!serializationNode.isList() && !serializationNode.isListOfList() && !serializationNode.isNull() && !(serializationNode instanceof AlternativesSerializationNode)) continue;
            throw new UnsupportedOperationException();
        }
        return true;
    }

    @Override
    public @NonNull ListOfSerializationNode asList() {
        throw new IllegalStateException();
    }

    @Override
    public @NonNull ListOfListOfSerializationNode asListOfList() {
        throw new IllegalStateException();
    }

    @Override
    public @NonNull SerializationNode asNode() {
        throw new IllegalStateException();
    }

    protected void appendNodeToList(@NonNull List<@NonNull SerializationNode> listOfNodes, @NonNull SerializationNode serializationNode) {
        listOfNodes.add(serializationNode);
    }

    protected void appendNodeToListOfList(@NonNull List<@NonNull List<@NonNull SerializationNode>> listOfListOfNodes, @NonNull SerializationNode serializationNode) {
        ArrayList<@NonNull SerializationNode> additionalListOfNodes = new ArrayList<SerializationNode>();
        this.appendNodeToList(additionalListOfNodes, serializationNode);
        listOfListOfNodes.add(additionalListOfNodes);
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isListOfList() {
        return false;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean noUnassignedParserRuleCall() {
        return true;
    }

    @Override
    public boolean onlyRootUnassignedSerializationRuleCall(boolean isRootAlternative) {
        return true;
    }

    public void toDebugString(@NonNull StringBuilder s, int depth) {
        s.append(this.toString());
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    private static class FindContext<@NonNull E> {
        protected final @NonNull List<@NonNull SerializationNode> elements;
        protected final E element;
        protected final int index;

        public FindContext(@NonNull List<@NonNull SerializationNode> elements, E element, int index) {
            this.elements = elements;
            this.element = element;
            this.index = index;
            assert (elements.get(index) == element);
        }

        public @NonNull E getElement() {
            return this.element;
        }

        public @NonNull E remove() {
            SerializationNode removed = this.elements.remove(this.index);
            assert (removed == this.element);
            return this.element;
        }

        public void replace(@NonNull SerializationNode serializationNode) {
            this.elements.remove(this.index);
            this.elements.add(this.index, serializationNode);
        }

        public String toString() {
            return this.element.toString();
        }
    }
}

