/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.as2es;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class AS2EcoreTypeRefVisitor
extends AbstractExtendingVisitor<EObject, AS2Ecore> {
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    protected final boolean isRequired;

    @Deprecated
    public AS2EcoreTypeRefVisitor(@NonNull AS2Ecore context) {
        this(context, true);
    }

    public AS2EcoreTypeRefVisitor(@NonNull AS2Ecore context, boolean isRequired) {
        super(context);
        this.metamodelManager = context.getMetamodelManager();
        this.standardLibrary = context.getStandardLibrary();
        this.isRequired = isRequired;
    }

    private <T extends EObject> @Nullable T getESObject(@NonNull java.lang.Class<T> requiredClass, @NonNull Class pivotType) {
        Iterable<Class> partialClasses = this.metamodelManager.getPartialClasses(pivotType);
        for (Class type : partialClasses) {
            EObject esObject;
            if (!(type instanceof PivotObjectImpl) || (esObject = ((PivotObjectImpl)((Object)type)).getESObject()) == null || !requiredClass.isAssignableFrom(esObject.getClass())) continue;
            return (T)esObject;
        }
        return null;
    }

    public EGenericType resolveEGenericType(@NonNull Class type) {
        EObject eType = this.safeVisit(type);
        if (eType instanceof EGenericType) {
            return (EGenericType)eType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)eType);
        TemplateSignature templateSignature = type.getOwnedSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : PivotUtil.getOwnedParameters(templateSignature)) {
                EObject eTypeParameter = this.safeVisit(templateParameter);
                if (!(eTypeParameter instanceof EGenericType)) continue;
                eGenericType.getETypeArguments().add((Object)((EGenericType)eTypeParameter));
            }
        }
        return eGenericType;
    }

    @Override
    public EObject safeVisit(@Nullable Visitable v) {
        if (v instanceof Type) {
            v = this.metamodelManager.getPrimaryType((Type)v);
        }
        return v == null ? null : v.accept(this);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EClassifier visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for AS2Ecore TypeRef pass");
    }

    @Override
    public EObject visitAnyType(@NonNull AnyType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        return OCLstdlibPackage.Literals.OCL_ANY;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotType) {
        if (pivotType.getOwnedBindings().size() == 0) {
            EObject eTarget;
            EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
            if (eClassifier != null) {
                return eClassifier;
            }
            if (this.metamodelManager.isTypeServeable(pivotType)) {
                eClassifier = this.getESObject(EClassifier.class, pivotType);
                if (eClassifier != null) {
                    return eClassifier;
                }
            } else if (pivotType instanceof PivotObjectImpl && (eTarget = ((PivotObjectImpl)((Object)pivotType)).getESObject()) != null) {
                return eTarget;
            }
            return null;
        }
        List<TemplateBinding> templateBindings = pivotType.getOwnedBindings();
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject rawType = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)rawType);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)templateBindings.get(0).getOwnedSubstitutions());
        return eGenericType;
    }

    @Override
    public EObject visitCollectionType(@NonNull CollectionType pivotType) {
        if (pivotType.getOwnedBindings().size() == 0) {
            EClassifier eClassifier1 = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
            if (eClassifier1 != null) {
                return eClassifier1;
            }
            Iterable<Class> partialClasses = this.metamodelManager.getPartialClasses(pivotType);
            for (Class type : partialClasses) {
                EObject eTarget;
                if (!(type instanceof PivotObjectImpl) || (eTarget = ((PivotObjectImpl)((Object)type)).getESObject()) == null) continue;
                return eTarget;
            }
            return OCLstdlibPackage.eINSTANCE.getEClassifier(pivotType.getName());
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject eClassifier2 = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)eClassifier2);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)pivotType.getOwnedBindings().get(0)).getOwnedSubstitutions());
        Number lower = pivotType.getLower();
        Number upper = pivotType.getUpper();
        if (lower != null && upper != null && lower.longValue() == 0L) {
            boolean cfr_ignored_0 = upper instanceof Unlimited;
        }
        return eGenericType;
    }

    @Override
    public EObject visitInvalidType(@NonNull InvalidType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        return OCLstdlibPackage.Literals.OCL_INVALID;
    }

    @Override
    public EObject visitMapType(@NonNull MapType mapType) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EClass eClassifier = OCLstdlibPackage.Literals.MAP;
        eGenericType.setEClassifier((EClassifier)eClassifier);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), mapType.getOwnedBindings());
        return eGenericType;
    }

    @Override
    public EObject visitPrimitiveType(@NonNull PrimitiveType pivotType) {
        EDataType eClassifier = ((AS2Ecore)this.context).getCreated(EDataType.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        String uri = ((AS2Ecore)this.context).getPrimitiveTypesUriPrefix();
        if (uri != null) {
            URI proxyURI = URI.createURI((String)(String.valueOf(uri) + pivotType.getName()));
            eClassifier = EcoreFactory.eINSTANCE.createEDataType();
            ((InternalEObject)eClassifier).eSetProxyURI(proxyURI);
            ((AS2Ecore)this.context).putCreated(pivotType, (EModelElement)eClassifier);
            return eClassifier;
        }
        CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass(pivotType);
        List<Class> partialClasses = completeClass.getPartialClasses();
        for (Class aType : partialClasses) {
            if (aType instanceof PrimitiveType || (eClassifier = ((AS2Ecore)this.context).getCreated(EDataType.class, pivotType)) == null) continue;
            return eClassifier;
        }
        for (Class aType : partialClasses) {
            if (aType == this.standardLibrary.getStringType()) {
                return EcorePackage.Literals.ESTRING;
            }
            if (aType == this.standardLibrary.getBooleanType()) {
                return this.isRequired ? EcorePackage.Literals.EBOOLEAN : EcorePackage.Literals.EBOOLEAN_OBJECT;
            }
            if (aType == this.standardLibrary.getIntegerType()) {
                return EcorePackage.Literals.EBIG_INTEGER;
            }
            if (aType == this.standardLibrary.getRealType()) {
                return EcorePackage.Literals.EBIG_DECIMAL;
            }
            if (aType != this.standardLibrary.getUnlimitedNaturalType()) continue;
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        throw new IllegalArgumentException("Unsupported primitive type '" + pivotType + "' in AS2Ecore TypeRef pass");
    }

    @Override
    public EObject visitTemplateBinding(@NonNull TemplateBinding object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameter(@NonNull TemplateParameter pivotType) {
        ETypeParameter eTypeParameter = ((AS2Ecore)this.context).getCreated(ETypeParameter.class, pivotType);
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setETypeParameter(eTypeParameter);
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution pivotTemplateParameterSubstitution) {
        EObject actualType = this.safeVisit(pivotTemplateParameterSubstitution.getActual());
        if (actualType instanceof EGenericType) {
            return actualType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)actualType);
        return eGenericType;
    }

    @Override
    public EObject visitTupleType(@NonNull TupleType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        return OCLstdlibPackage.Literals.OCL_TUPLE;
    }

    @Override
    public EObject visitVoidType(@NonNull VoidType pivotType) {
        EClassifier eClassifier = ((AS2Ecore)this.context).getCreated(EClassifier.class, pivotType);
        if (eClassifier != null) {
            return eClassifier;
        }
        return OCLstdlibPackage.Literals.OCL_VOID;
    }
}

