/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Scanner;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.validity.test.AbstractExportOCLValidationResultTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TextExportOCLValidationResultTests
extends AbstractExportOCLValidationResultTests {
    private static final int CONSTRAINING_FILES = 3;
    private static final int TOTAL_NUMBER_XPATH_LOCATION = 14;
    private static final int SUCCESS_NUMBER_XPATH_LOCATION = 15;
    private static final int INFO_NUMBER_XPATH_LOCATION = 16;
    private static final int WARNING_NUMBER_XPATH_LOCATION = 17;
    private static final int ERROR_NUMBER_XPATH_LOCATION = 18;
    private static final int FAILURE_NUMBER_XPATH_LOCATION = 19;
    private static final int DIAG_INFO_LOCATION = 28;
    private String exportedFileName = null;

    protected void assertLineContains(@NonNull String contents, int lineNumber, String expression) throws CoreException, IOException {
        Scanner sc = new Scanner(new StringReader(contents));
        String line = null;
        int i = 1;
        while (i <= lineNumber) {
            line = sc.nextLine();
            ++i;
        }
        if (line != null) {
            TextExportOCLValidationResultTests.assertTrue((String)("Expected \"" + line + "\" to contain \"" + expression + "\""), (boolean)line.contains(expression));
        }
        sc.close();
    }

    protected @NonNull String doTest() throws IOException {
        String exported = this.exporter.export(this.rootNode, this.exportedFileName);
        FileWriter writer = new FileWriter(this.exportedFileName);
        writer.append(exported);
        writer.close();
        TEST_PROGRESS.println("exported " + this.ecoreResource.getURI());
        return exported;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.exportedFileName = this.getProjectFileName(String.valueOf(this.getTestName()) + ".txt");
        this.initExporter("text");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testTEXTExport_LoggingMetricsWithNoSeverity() throws IOException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        String exported = this.doTest();
        this.assertLineContains(exported, 15, "1");
        this.assertLineContains(exported, 16, "0");
        this.assertLineContains(exported, 17, "0");
        this.assertLineContains(exported, 18, "0");
        this.assertLineContains(exported, 19, "0");
    }

    @Test
    public void testTEXTExport_LoggingMetricsWithInformationSeverity() throws IOException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String exported = this.doTest();
        this.assertLineContains(exported, 15, "1");
        this.assertLineContains(exported, 16, "1");
        this.assertLineContains(exported, 17, "0");
        this.assertLineContains(exported, 18, "0");
        this.assertLineContains(exported, 19, "0");
    }

    @Test
    public void testTEXTExport_LoggingMetricsWithWarningSeverity() throws IOException, InterruptedException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        String exported = this.doTest();
        this.assertLineContains(exported, 15, "1");
        this.assertLineContains(exported, 16, "1");
        this.assertLineContains(exported, 17, "1");
        this.assertLineContains(exported, 18, "0");
        this.assertLineContains(exported, 19, "0");
    }

    @Test
    public void testTEXTExport_LoggingMetricsWithErrorSeverity() throws IOException, InterruptedException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute2").setSeverity(Severity.ERROR);
        String exported = this.doTest();
        this.assertLineContains(exported, 15, "1");
        this.assertLineContains(exported, 16, "1");
        this.assertLineContains(exported, 17, "1");
        this.assertLineContains(exported, 18, "1");
        this.assertLineContains(exported, 19, "0");
    }

    @Test
    public void testTEXTExport_LoggingMetricsWithFailureSeverity() throws IOException, InterruptedException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.OK);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute2").setSeverity(Severity.ERROR);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute4").setSeverity(Severity.FATAL);
        String exported = this.doTest();
        this.assertLineContains(exported, 15, "1");
        this.assertLineContains(exported, 16, "1");
        this.assertLineContains(exported, 17, "1");
        this.assertLineContains(exported, 18, "1");
        this.assertLineContains(exported, 19, "1");
    }

    public void testTEXTExport_LogNullDiagnosticMessage() throws XPathExpressionException, CoreException, IOException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String exported = this.doTest();
        this.assertLineContains(exported, 28, "null diagnostic message");
    }

    @Test
    public void testTEXTExport_LogInfoDiagnosticMessage() throws IOException, InterruptedException, XPathExpressionException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.INFO);
        String diagnostic = "Diag INFO";
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setDiagnostic((Object)diagnostic);
        String exported = this.doTest();
        this.assertLineContains(exported, 28, diagnostic);
    }

    @Test
    public void testTEXTExport_ProducesAllLogHeadings() throws IOException, CoreException {
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", "Eclass1 in validityModelTest.ecoretest").setSeverity(Severity.ERROR);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.FATAL);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.WARNING);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint", "Eclass1::EClass2").setSeverity(Severity.INFO);
        String exported = this.doTest();
        int TEST_TABLE_1_LOCATION = 24;
        this.assertLineContains(exported, TEST_TABLE_1_LOCATION, "ecoreTest.ocl");
        this.assertLineContains(exported, TEST_TABLE_1_LOCATION + 1, "eclass2_constraint");
        this.assertLineContains(exported, TEST_TABLE_1_LOCATION + 2, "eclass2_constraint");
        this.assertLineContains(exported, TEST_TABLE_1_LOCATION + 3, "INFO");
        int TEST_TABLE_2_LOCATION = TEST_TABLE_1_LOCATION + 7;
        this.assertLineContains(exported, TEST_TABLE_2_LOCATION, "ecore.ocl");
        this.assertLineContains(exported, TEST_TABLE_2_LOCATION + 1, "eattribute_constraint");
        this.assertLineContains(exported, TEST_TABLE_2_LOCATION + 2, "eattribute_constraint");
        this.assertLineContains(exported, TEST_TABLE_2_LOCATION + 3, "WARNING");
        int TEST_TABLE_3_LOCATION = TEST_TABLE_1_LOCATION + 14;
        this.assertLineContains(exported, TEST_TABLE_3_LOCATION, "ecoreTest.ocl");
        this.assertLineContains(exported, TEST_TABLE_3_LOCATION + 1, "eclass1_constraint");
        this.assertLineContains(exported, TEST_TABLE_3_LOCATION + 2, "eclass1_constraint");
        this.assertLineContains(exported, TEST_TABLE_3_LOCATION + 3, "ERROR");
        int TEST_TABLE_4_LOCATION = TEST_TABLE_1_LOCATION + 21;
        this.assertLineContains(exported, TEST_TABLE_4_LOCATION, "ecore.ocl");
        this.assertLineContains(exported, TEST_TABLE_4_LOCATION + 1, "epackage_constraint");
        this.assertLineContains(exported, TEST_TABLE_4_LOCATION + 2, "epackage_constraint");
        this.assertLineContains(exported, TEST_TABLE_4_LOCATION + 3, "FATAL");
    }

    @Test
    public void testTEXTExport_Statistics() throws IOException, CoreException {
        for (Result result : this.results) {
            result.setSeverity(Severity.OK);
        }
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", "Eclass1 in validityModelTest.ecoretest").setSeverity(Severity.ERROR);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint_2", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.ERROR);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EPackage::epackage_constraint", "ecoreTest in ecoreTest.ecore").setSeverity(Severity.FATAL);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EClass::eclass_constraint", "ecoreTest::EClass3").setSeverity(Severity.FATAL);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::EClass2::eAttribute3").setSeverity(Severity.WARNING);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecoreTest.ocl::ecoreTest::EClass2::eclass2_constraint", "Eclass1::EClass2").setSeverity(Severity.INFO);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest2::Eclass5::eAttribute5").setSeverity(Severity.INFO);
        TextExportOCLValidationResultTests.getResultOfValidatableNodeFromLabel((Iterable<Result>)this.results, "ecore.ocl::ecore::EAttribute::eattribute_constraint", "ecoreTest::Eclass1::eAttribute1").setSeverity(Severity.WARNING);
        String exported = this.doTest();
        this.assertLineContains(exported, 14, EXPECTED_RESULTS.toString());
        this.assertLineContains(exported, 15, EXPECTED_SUCCESSES.toString());
        this.assertLineContains(exported, 16, EXPECTED_INFOS.toString());
        this.assertLineContains(exported, 17, EXPECTED_WARNINGS.toString());
        this.assertLineContains(exported, 18, EXPECTED_ERRORS.toString());
        this.assertLineContains(exported, 19, EXPECTED_FAILURES.toString());
    }

    @Test
    public void testTEXTExport_ModelsValidatedSuccessfully() throws IOException, CoreException {
        String exported = this.doTest();
        this.assertLineContains(exported, 2, this.exportedFileName);
        this.assertLineContains(exported, 8, "model/ecoreTest.ecore");
        this.assertLineContains(exported, 9, "model/ecoreTest2.ecore");
        this.assertLineContains(exported, 10, "model/validityModelTest.ecoretest");
        this.assertLineContains(exported, 14, "0");
        this.assertLineContains(exported, 15, "0");
        this.assertLineContains(exported, 16, "0");
        this.assertLineContains(exported, 17, "0");
        this.assertLineContains(exported, 18, "0");
        this.assertLineContains(exported, 19, "0");
        this.assertLineContains(exported, 23, "No log to display: models has been successfully validated.");
    }
}

