/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bpmn.BPMNProfile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.papyrus.bpmn.BPMNProfile.BPMNProcess;
import org.eclipse.papyrus.bpmn.BPMNProfile.BPMNProfilePackage;
import org.eclipse.papyrus.bpmn.BPMNProfile.BoundaryEvent;
import org.eclipse.papyrus.bpmn.BPMNProfile.FlowElement;
import org.eclipse.papyrus.bpmn.BPMNProfile.LaneSet;
import org.eclipse.papyrus.bpmn.BPMNProfile.Task;
import org.eclipse.papyrus.bpmn.BPMNProfile.impl.BPMNProcessImpl;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BPMNProcessCustom {
    private static final Logger log = Logger.getLogger(BPMNProcessCustom.class);

    private BPMNProcessCustom() {
    }

    private static List<FlowElement> getProcessFlowElements(Activity activity) {
        List flowElements = null;
        EList elements = activity.getOwnedElements();
        if (elements != null) {
            flowElements = elements.stream().map(e -> (FlowElement)UMLUtil.getStereotypeApplication((Element)e, FlowElement.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return flowElements;
    }

    private static List<FlowElement> getFlowElementsInLoop(LoopNode loopNode) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        List loopNodes = loopNode.getNodes().stream().filter(LoopNode.class::isInstance).map(LoopNode.class::cast).collect(Collectors.toList());
        for (LoopNode node : loopNodes) {
            flowElements.addAll(BPMNProcessCustom.getFlowElementsInLoop(node));
        }
        flowElements.addAll(loopNode.getNodes().stream().map(e -> (FlowElement)UMLUtil.getStereotypeApplication((Element)e, FlowElement.class)).filter(Objects::nonNull).collect(Collectors.toList()));
        return flowElements;
    }

    public static EList<FlowElement> getFlowElements(BPMNProcess bpmnProcess) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        Activity activity = bpmnProcess.getBase_Activity();
        if (activity != null) {
            flowElements.addAll(BPMNProcessCustom.getProcessFlowElements(activity));
            EList nodes = activity.getNodes();
            for (ActivityNode n : nodes) {
                EList<BoundaryEvent> boundaryEvents;
                Task task;
                log.debug((Object)("bpmnProcess " + bpmnProcess.getId() + " contains " + n.getName()));
                if (n instanceof LoopNode) {
                    LoopNode loopNode = (LoopNode)n;
                    flowElements.addAll(BPMNProcessCustom.getFlowElementsInLoop(loopNode));
                }
                if (!(n instanceof OpaqueAction) || (task = (Task)UMLUtil.getStereotypeApplication((Element)n, Task.class)) == null || (boundaryEvents = task.getBoundaryEventRefs()) == null || boundaryEvents.isEmpty()) continue;
                flowElements.addAll(boundaryEvents.stream().map(b -> (FlowElement)UMLUtil.getStereotypeApplication((Element)b.getBase_Element(), FlowElement.class)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)((BPMNProcessImpl)bpmnProcess), (EStructuralFeature)BPMNProfilePackage.eINSTANCE.getFlowElementsContainer_FlowElements(), flowElements.size(), flowElements.toArray());
    }

    public static EList<LaneSet> getLaneSets(BPMNProcess bpmnProcess) {
        EList partitions;
        ArrayList laneSet = new ArrayList();
        Activity activity = bpmnProcess.getBase_Activity();
        if (activity != null && (partitions = activity.getPartitions()) != null && !partitions.isEmpty()) {
            partitions.stream().map(b -> (LaneSet)UMLUtil.getStereotypeApplication((Element)b, LaneSet.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)((BPMNProcessImpl)bpmnProcess), (EStructuralFeature)BPMNProfilePackage.eINSTANCE.getFlowElementsContainer_FlowElements(), laneSet.size(), laneSet.toArray());
    }
}

