/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.PortKind;
import org.eclipse.papyrus.designer.components.FCM.TemplatePort;
import org.eclipse.papyrus.designer.components.transformation.Activator;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.transformation.core.utils.ComparisonUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortUtils {
    public static Interface getProvided(org.eclipse.uml2.uml.Port port) {
        if (port.getProvideds().size() > 0) {
            return (Interface)port.getProvideds().get(0);
        }
        return null;
    }

    public static List<Interface> getProvideds(org.eclipse.uml2.uml.Port port) {
        if (port.getProvideds().size() > 0) {
            return port.getProvideds();
        }
        return null;
    }

    public static Interface getRequired(org.eclipse.uml2.uml.Port port) {
        if (port.getRequireds().size() > 0) {
            return (Interface)port.getRequireds().get(0);
        }
        return null;
    }

    public static List<Interface> getRequireds(org.eclipse.uml2.uml.Port port) {
        if (port.getRequireds().size() > 0) {
            return port.getRequireds();
        }
        return null;
    }

    public static Port getFCMport(org.eclipse.uml2.uml.Port port) {
        return (Port)UMLUtil.getStereotypeApplication((Element)port, Port.class);
    }

    public static Type getFCMType(org.eclipse.uml2.uml.Port port) {
        Port fcmPort = PortUtils.getFCMport(port);
        if (fcmPort != null) {
            return fcmPort.getType();
        }
        return null;
    }

    public static EList<org.eclipse.uml2.uml.Port> getAllPorts(EncapsulatedClassifier ec) {
        BasicEList ports = new BasicEList();
        for (Property attribute : ec.getAllAttributes()) {
            if (!(attribute instanceof org.eclipse.uml2.uml.Port)) continue;
            ports.add((Object)((org.eclipse.uml2.uml.Port)attribute));
        }
        return ports;
    }

    public static EList<org.eclipse.uml2.uml.Port> getAllPorts2(EncapsulatedClassifier ec) {
        BasicEList ports = new BasicEList();
        ports.addAll((Collection)ec.getOwnedPorts());
        for (Classifier general : ec.getGenerals()) {
            if (!(general instanceof EncapsulatedClassifier) || !general.isAbstract()) continue;
            ports.addAll(PortUtils.getAllPorts2((EncapsulatedClassifier)general));
        }
        return ports;
    }

    public static EList<PortInfo> flattenExtendedPorts(EList<org.eclipse.uml2.uml.Port> ports) {
        BasicEList portInfos = new BasicEList();
        for (org.eclipse.uml2.uml.Port port : ports) {
            portInfos.addAll(PortUtils.flattenExtendedPort(port));
        }
        return portInfos;
    }

    public static EList<PortInfo> flattenExtendedPort(org.eclipse.uml2.uml.Port port) {
        BasicEList portInfos = new BasicEList();
        if (PortUtils.isExtendedPort(port)) {
            Class cl;
            Port fcmPort = PortUtils.getFCMport(port);
            if (PortUtils.isTemplatePort(port)) {
                TemplatePort tp = (TemplatePort)UMLUtil.getStereotypeApplication((Element)port, TemplatePort.class);
                if (tp.getBoundType() == null) {
                    Activator.log.debug("Bound type of template port is null, choosing base class of kind instead");
                    cl = fcmPort.getKind().getBase_Class();
                } else {
                    cl = tp.getBoundType().getBase_Class();
                }
            } else {
                cl = fcmPort.getKind().getBase_Class();
            }
            if (cl != null && PortUtils.getAllPorts((EncapsulatedClassifier)cl).size() > 0) {
                EList<org.eclipse.uml2.uml.Port> extendedPorts = PortUtils.getAllPorts((EncapsulatedClassifier)cl);
                for (org.eclipse.uml2.uml.Port extendedPort : extendedPorts) {
                    portInfos.add((Object)new PortInfo(extendedPort, port));
                }
            }
        } else {
            portInfos.add((Object)new PortInfo(port, null));
        }
        return portInfos;
    }

    public static boolean isExtendedPort(org.eclipse.uml2.uml.Port port) {
        Port fcmPort = PortUtils.getFCMport(port);
        if (fcmPort != null && fcmPort.getKind() != null) {
            Class cl = fcmPort.getKind().getBase_Class();
            return cl != null && PortUtils.getAllPorts((EncapsulatedClassifier)cl).size() > 0;
        }
        return false;
    }

    public static boolean isTemplatePort(org.eclipse.uml2.uml.Port port) {
        return StereotypeUtil.isApplied((Element)port, TemplatePort.class);
    }

    public static PortKind getKind(org.eclipse.uml2.uml.Port port) {
        Port fcmPort = PortUtils.getFCMport(port);
        if (fcmPort != null) {
            return fcmPort.getKind();
        }
        return null;
    }

    public static boolean sameKinds(org.eclipse.uml2.uml.Port portA, org.eclipse.uml2.uml.Port portB) {
        PortKind kindA = PortUtils.getKind(portA);
        PortKind kindB = PortUtils.getKind(portB);
        return ComparisonUtils.sameObject((EObject)kindA, (EObject)kindB);
    }

    public static boolean matches(org.eclipse.uml2.uml.Port portA, org.eclipse.uml2.uml.Port portB, boolean isAssembly) {
        boolean sameTypeAndKind;
        Port fcmPortA = (Port)UMLUtil.getStereotypeApplication((Element)portA, Port.class);
        Port fcmPortB = (Port)UMLUtil.getStereotypeApplication((Element)portB, Port.class);
        if (fcmPortA == null || fcmPortB == null) {
            return false;
        }
        boolean bl = sameTypeAndKind = fcmPortA.getType() == fcmPortB.getType() && ComparisonUtils.sameObject((EObject)fcmPortA.getKind(), (EObject)fcmPortB.getKind());
        if (isAssembly) {
            return sameTypeAndKind && portA.isConjugated() != portB.isConjugated();
        }
        return sameTypeAndKind && portA.isConjugated() == portB.isConjugated();
    }

    public static boolean isCompatible(org.eclipse.uml2.uml.Port portA, org.eclipse.uml2.uml.Port portB, boolean isAssembly) {
        if (PortUtils.matches(portA, portB, isAssembly)) {
            return true;
        }
        if (isAssembly) {
            Interface reqA = PortUtils.getRequired(portA);
            Interface reqB = PortUtils.getRequired(portB);
            Interface prodA = PortUtils.getProvided(portA);
            Interface prodB = PortUtils.getProvided(portB);
            return reqA == null && PortUtils.isSubInterface(prodA, reqB) || reqB == null && PortUtils.isSubInterface(prodB, reqA) || PortUtils.isSubInterface(prodA, reqB) && PortUtils.isSubInterface(prodB, reqA);
        }
        return PortUtils.getProvided(portA) == PortUtils.getProvided(portB) && PortUtils.getRequired(portB) == PortUtils.getRequired(portA);
    }

    public static boolean isSubInterface(Interface intfA, Interface intfB) {
        return intfA == intfB || intfA != null && intfA.getGeneralizations().contains((Object)intfB);
    }
}

