/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PThreadTypes;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ChangeEventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private PThreadTypes ptTypes;
    private Class superContext;
    private Package targetPack;

    public ChangeEventTransformation(SM2ClassesTransformationCore core) {
        Package _targetPacket;
        this.core = core;
        this.superContext = core.superContext;
        this.targetPack = _targetPacket = core.getTargetPacket();
        this.ptTypes = core.ptTypes;
        this.cdefs = core.cdefs;
    }

    public void createChangeEvents() {
        boolean _isEmpty = this.core.changeEvents.isEmpty();
        if (_isEmpty) {
            return;
        }
        Type _pthread = this.ptTypes.getPthread();
        Property threads = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.THREADS_CHANGE_EVENT, _pthread);
        StereotypeUtil.apply((Element)threads, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)threads, Array.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        int _size = this.core.changeEvents.size();
        _builder.append((Object)_size, "");
        _builder.append("]");
        _stereotypeApplication.setDefinition(_builder.toString());
        Property threadStructs = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, this.core.concurrency.threadStructType);
        StereotypeUtil.apply((Element)threadStructs, Array.class);
        Array _stereotypeApplication_1 = (Array)UMLUtil.getStereotypeApplication((Element)threadStructs, Array.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("[");
        int _size_1 = this.core.changeEvents.size();
        _builder_1.append((Object)_size_1, "");
        _builder_1.append("]");
        _stereotypeApplication_1.setDefinition(_builder_1.toString());
        String WAIT_TIME = "10";
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("#ifdef WIN32");
        _builder_2.newLine();
        _builder_2.append("#include <windows.h>");
        _builder_2.newLine();
        _builder_2.append("#elif _POSIX_C_SOURCE >= 199309L");
        _builder_2.newLine();
        _builder_2.append("#include <time.h>   // for nanosleep");
        _builder_2.newLine();
        _builder_2.append("#else");
        _builder_2.newLine();
        _builder_2.append("#include <unistd.h> // for usleep");
        _builder_2.newLine();
        _builder_2.append("#endif");
        this.core.appendIncludeHeader(_builder_2.toString());
        Operation changeEventOp = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.CHANGE_EVENT_LISTEN_FUNCTION, null, null);
        changeEventOp.createOwnedParameter("id", this.core.intType);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("struct timeval tv;");
        _builder_3.newLine();
        _builder_3.append("struct timespec ts;");
        _builder_3.newLine();
        _builder_3.append("bool oldValue;");
        _builder_3.newLine();
        _builder_3.append("bool newValue;");
        _builder_3.newLine();
        _builder_3.append("bool isFirstTime = true;");
        _builder_3.newLine();
        _builder_3.append("bool periodic = ");
        _builder_3.append(WAIT_TIME, "");
        _builder_3.append("; //ms");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("while(true) {");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("switch(id) {");
        _builder_3.newLine();
        for (ChangeEvent ch : this.core.changeEvents) {
            _builder_3.append("\t\t");
            _builder_3.append("case ");
            String _eventID = TransformationUtil.eventID((Event)ch);
            _builder_3.append(_eventID, "\t\t");
            _builder_3.append(":");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("\t\t");
            _builder_3.append("\t");
            _builder_3.append("newValue = ");
            String _changeEventExpression = this.getChangeEventExpression(ch);
            _builder_3.append(_changeEventExpression, "\t\t\t");
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("\t\t");
            _builder_3.append("\t");
            _builder_3.append("break;");
            _builder_3.newLine();
        }
        _builder_3.append("\t");
        _builder_3.append("}");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("if (isFirstTime) {");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("oldValue = newValue;");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("isFirstTime = false;");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("} else {");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("#ifdef WIN32");
        _builder_3.newLine();
        _builder_3.append("\t\t\t");
        _builder_3.append("Sleep(periodic);");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("#elif _POSIX_C_SOURCE >= 199309L");
        _builder_3.newLine();
        _builder_3.append("\t\t    ");
        _builder_3.append("struct timespec ts;");
        _builder_3.newLine();
        _builder_3.append("\t\t    ");
        _builder_3.append("ts.tv_sec = periodic / 1000;");
        _builder_3.newLine();
        _builder_3.append("\t\t    ");
        _builder_3.append("ts.tv_nsec = (periodic % 1000) * 1000000;");
        _builder_3.newLine();
        _builder_3.append("\t\t    ");
        _builder_3.append("nanosleep(&ts, NULL);");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("#else");
        _builder_3.newLine();
        _builder_3.append("\t\t    ");
        _builder_3.append("usleep(periodic * 1000);");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("#endif");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("}");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("if (oldValue != newValue) {");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append("//the expression is changed, push an event to the queue");
        _builder_3.newLine();
        _builder_3.append("\t\t");
        _builder_3.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t");
        _builder_3.append(".push(statemachine::PRIORITY_2, NULL, id, statemachine::CHANGE_EVENT, 0);");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("\t");
        _builder_3.append("}");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("oldValue = newValue;");
        _builder_3.newLine();
        _builder_3.append("}");
        this.core.createOpaqueBehavior(this.superContext, changeEventOp, _builder_3.toString());
    }

    public String getChangeEventExpression(ChangeEvent e) {
        ValueSpecification _changeExpression_1;
        boolean _not;
        boolean _or = false;
        ValueSpecification _changeExpression = e.getChangeExpression();
        boolean _equals = Objects.equal((Object)_changeExpression, null);
        _or = _equals ? true : (_not = !((_changeExpression_1 = e.getChangeExpression()) instanceof OpaqueExpression));
        if (_or) {
            return "false";
        }
        ValueSpecification _changeExpression_2 = e.getChangeExpression();
        EList _bodies = ((OpaqueExpression)_changeExpression_2).getBodies();
        return (String)IterableExtensions.head((Iterable)_bodies);
    }
}

