/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.ChangeEventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.ConcurrencyGenerator;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.EventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.MonitoringTransformation;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PThreadTypes;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.PseudostateGenerator;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.transformation.vsl.ParseVSL;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SM2ClassesTransformationCore {
    @Extension
    protected CDefinitions cdefs;
    public int MAX_NUMBER_ORTHOGONAL_REGIONS = 1;
    private StateMachine sm;
    public Type boolType;
    public Class superContext;
    private List<Transition> transitions = new ArrayList<Transition>();
    private List<OpaqueBehavior> actions = new ArrayList<OpaqueBehavior>();
    public Region topRegion;
    public List<State> states = new ArrayList<State>();
    private List<Vertex> vertexes = new ArrayList<Vertex>();
    public LazyCopier copier;
    private String langID = "C++";
    private Type stateStruct;
    public boolean generateActionLog = false;
    private boolean createDoActivity = true;
    private boolean useThreadCpp11 = true;
    private Type threadCpp11;
    public Type voidType;
    private Enumeration stateIdEnum;
    public Type intType;
    public Type charType;
    private Enumeration eventIdEnum;
    public Type fptr;
    public PThreadTypes ptTypes;
    public Type sockAddrInType;
    public List<TimeEvent> timeEvents = new ArrayList<TimeEvent>();
    public List<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
    public List<CallEvent> callEvents = new ArrayList<CallEvent>();
    private List<SignalEvent> signalEvents = new ArrayList<SignalEvent>();
    private List<AnyReceiveEvent> anyEvents = new ArrayList<AnyReceiveEvent>();
    private List<Pseudostate> junctions = new ArrayList<Pseudostate>();
    public ConcurrencyGenerator concurrency;
    public EventTransformation eventTransform;
    public PseudostateGenerator pseudostateGenerator;
    public MonitoringTransformation monitoringTransformation;
    public static String ansiUri = "pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml";
    public static String smLibraryUri = "platform:/resource/org.eclipse.papyrus.designer.codegen.statemachine/models/SmLibrary.uml";
    public List<Behavior> doActivityList = new ArrayList<Behavior>();
    public Package smPack;
    private List<Region> regions = new ArrayList<Region>();
    public List<Transition> parallelTransitions = new ArrayList<Transition>();
    public Map<State, List<TimeEvent>> states2TimeEvents = new HashMap<State, List<TimeEvent>>();
    private Type threadStructType;
    public List<Region> orthogonalRegions = new ArrayList<Region>();
    private String paramName = "enter_mode";

    public SM2ClassesTransformationCore(LazyCopier copier, StateMachine sm, Class tmClass) {
        CDefinitions _cDefinitions;
        PThreadTypes _pThreadTypes;
        Type _socketType;
        Type _primitiveType_3;
        Type _primitiveType_2;
        Type _primitiveType_1;
        Type _primitiveType;
        this.copier = copier;
        this.superContext = tmClass;
        this.sm = sm;
        Package _targetPacket = this.getTargetPacket();
        Resource _eResource = _targetPacket.eResource();
        ResourceSet resourceSet = _eResource.getResourceSet();
        this.boolType = _primitiveType = this.getPrimitiveType("bool", resourceSet);
        this.voidType = _primitiveType_1 = this.getPrimitiveType("void", resourceSet);
        this.intType = _primitiveType_2 = this.getPrimitiveType("int", resourceSet);
        this.charType = _primitiveType_3 = this.getPrimitiveType("char", resourceSet);
        this.sockAddrInType = _socketType = this.getSocketType("sockaddr_in", resourceSet);
        this.ptTypes = _pThreadTypes = new PThreadTypes(this.superContext);
        this.cdefs = _cDefinitions = new CDefinitions(this.superContext);
    }

    public Package setSmPack(Package smPack) {
        this.smPack = smPack;
        return this.smPack;
    }

    public Type getThreadStructType() {
        return this.threadStructType;
    }

    public Type setThreadStructType(Type threadStructType) {
        this.threadStructType = threadStructType;
        return this.threadStructType;
    }

    public Type getSocketType(String name, ResourceSet resourceSet) {
        URI _createURI = URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/socket.uml");
        Package socketLibrary = PackageUtil.loadPackage((URI)_createURI, (ResourceSet)resourceSet);
        PackageableElement element = socketLibrary.getPackagedElement(name);
        if (element instanceof Type) {
            return (Type)element;
        }
        return null;
    }

    public Package getRoot() {
        return TransformationContext.current.copier.source;
    }

    public Type getPrimitiveType(String name, ResourceSet resourceSet) {
        URI _createURI = URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml");
        Package ansiCLibrary = PackageUtil.loadPackage((URI)_createURI, (ResourceSet)resourceSet);
        PackageableElement element = ansiCLibrary.getPackagedElement(name);
        if (element instanceof Type) {
            return (Type)element;
        }
        return null;
    }

    public Package getTargetPacket() {
        return this.copier.target;
    }

    public Package getExternalPackage(Package parentPack) {
        boolean _tripleEquals;
        Package _nestedPackage = parentPack.getNestedPackage("external");
        boolean bl = _tripleEquals = _nestedPackage == null;
        if (_tripleEquals) {
            Package createdPack = parentPack.createNestedPackage("external");
            StereotypeUtil.apply((Element)createdPack, NoCodeGen.class);
        }
        return parentPack.getNestedPackage("external");
    }

    public void transform() {
        boolean _greaterThan_1;
        boolean _not_1;
        boolean _not;
        boolean _greaterThan;
        MonitoringTransformation _monitoringTransformation;
        PseudostateGenerator _pseudostateGenerator;
        EventTransformation _eventTransformation;
        ConcurrencyGenerator _concurrencyGenerator;
        Region _head;
        Package targetPack = this.getTargetPacket();
        Resource _eResource = targetPack.eResource();
        ResourceSet resourceSet = _eResource.getResourceSet();
        URI _createURI = URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml");
        PackageUtil.loadPackage((URI)_createURI, (ResourceSet)resourceSet);
        URI _createURI_1 = URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml");
        Package profile = PackageUtil.loadPackage((URI)_createURI_1, (ResourceSet)resourceSet);
        if (profile instanceof Profile) {
            PackageUtil.applyProfile((Package)targetPack, (Profile)((Profile)profile), (boolean)true);
        }
        if (this.useThreadCpp11) {
            Type _createOwnedType;
            Package externalPackage = this.getExternalPackage(targetPack);
            this.threadCpp11 = _createOwnedType = externalPackage.createOwnedType("std::thread", UMLPackage.Literals.DATA_TYPE);
            StereotypeUtil.apply((Element)this.threadCpp11, External.class);
        }
        EList _regions = this.sm.getRegions();
        this.topRegion = _head = (Region)IterableExtensions.head((Iterable)_regions);
        this.concurrency = _concurrencyGenerator = new ConcurrencyGenerator(this);
        this.eventTransform = _eventTransformation = new EventTransformation(this);
        this.pseudostateGenerator = _pseudostateGenerator = new PseudostateGenerator(this);
        this.monitoringTransformation = _monitoringTransformation = new MonitoringTransformation(this);
        Map<Event, List<Transition>> eventMap = this.getAllEvents(this.topRegion);
        BiConsumer<Event, List<Transition>> _function = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e, List<Transition> k) {
                if (e instanceof TimeEvent) {
                    SM2ClassesTransformationCore.this.timeEvents.add((TimeEvent)e);
                } else if (e instanceof CallEvent) {
                    SM2ClassesTransformationCore.this.callEvents.add((CallEvent)e);
                } else if (e instanceof SignalEvent) {
                    SM2ClassesTransformationCore.this.signalEvents.add((SignalEvent)e);
                } else if (e instanceof ChangeEvent) {
                    SM2ClassesTransformationCore.this.changeEvents.add((ChangeEvent)e);
                } else if (e instanceof AnyReceiveEvent) {
                    SM2ClassesTransformationCore.this.anyEvents.add((AnyReceiveEvent)e);
                }
            }
        };
        eventMap.forEach(_function);
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.EVENT_ID, UMLPackage.Literals.ENUMERATION);
        this.eventIdEnum = (Enumeration)_createNestedClassifier;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _TIME_EVENT_LOWER_BOUND = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder.append(_TIME_EVENT_LOWER_BOUND, "");
        _builder.append(" (0)");
        this.appendIncludeHeader(_builder.toString());
        Consumer<TimeEvent> _function_1 = new Consumer<TimeEvent>(){

            @Override
            public void accept(TimeEvent it) {
                String _eventID = TransformationUtil.eventID((Event)it);
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(_eventID);
            }
        };
        this.timeEvents.forEach(_function_1);
        Consumer<ChangeEvent> _function_2 = new Consumer<ChangeEvent>(){

            @Override
            public void accept(ChangeEvent it) {
                String _eventID = TransformationUtil.eventID((Event)it);
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(_eventID);
            }
        };
        this.changeEvents.forEach(_function_2);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("#define ");
        String _CHANGE_EVENT_LOWER_BOUND = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_1.append(_CHANGE_EVENT_LOWER_BOUND, "");
        _builder_1.append(" (");
        int _size = this.timeEvents.size();
        _builder_1.append((Object)_size, "");
        _builder_1.append(")");
        this.appendIncludeHeader(_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("#define ");
        String _TE_INDEX = this.cdefs.TE_INDEX();
        _builder_2.append(_TE_INDEX, "");
        _builder_2.append("(id) (id - ");
        String _TIME_EVENT_LOWER_BOUND_1 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder_2.append(_TIME_EVENT_LOWER_BOUND_1, "");
        _builder_2.append(")");
        this.appendIncludeHeader(_builder_2.toString());
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("#define ");
        String _CHE_INDEX = this.cdefs.CHE_INDEX();
        _builder_3.append(_CHE_INDEX, "");
        _builder_3.append("(id) (id - ");
        String _CHANGE_EVENT_LOWER_BOUND_1 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_3.append(_CHANGE_EVENT_LOWER_BOUND_1, "");
        _builder_3.append(")");
        this.appendIncludeHeader(_builder_3.toString());
        this.monitoringTransformation.appendInclude();
        Consumer<SignalEvent> _function_3 = new Consumer<SignalEvent>(){

            @Override
            public void accept(SignalEvent it) {
                String _eventID = TransformationUtil.eventID((Event)it);
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(_eventID);
            }
        };
        this.signalEvents.forEach(_function_3);
        Consumer<CallEvent> _function_4 = new Consumer<CallEvent>(){

            @Override
            public void accept(CallEvent it) {
                String _eventID = TransformationUtil.eventID((Event)it);
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(_eventID);
            }
        };
        this.callEvents.forEach(_function_4);
        Consumer<AnyReceiveEvent> _function_5 = new Consumer<AnyReceiveEvent>(){

            @Override
            public void accept(AnyReceiveEvent it) {
                String _eventID = TransformationUtil.eventID((Event)it);
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(_eventID);
            }
        };
        this.anyEvents.forEach(_function_5);
        String _upperCase = SMCodeGeneratorConstants.COMPLETION_EVENT.toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_ID";
        this.eventIdEnum.createOwnedLiteral(_plus);
        this.getAllActionsTransitionsStates(this.topRegion);
        Functions.Function1<State, Boolean> _function_6 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return it.isOrthogonal();
            }
        };
        Iterable _filter = IterableExtensions.filter(this.states, (Functions.Function1)_function_6);
        Consumer<State> _function_7 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _greaterThan;
                EList _regions = it.getRegions();
                int _size = _regions.size();
                boolean bl = _greaterThan = _size > SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS;
                if (_greaterThan) {
                    int _size_1;
                    EList _regions_1 = it.getRegions();
                    SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS = _size_1 = _regions_1.size();
                }
            }
        };
        _filter.forEach(_function_7);
        Consumer<State> _function_8 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                final ArrayList triggers = new ArrayList();
                EList _outgoings = it.getOutgoings();
                Consumer<Transition> _function = new Consumer<Transition>(){

                    @Override
                    public void accept(Transition it) {
                        EList _triggers = it.getTriggers();
                        triggers.addAll(_triggers);
                    }
                };
                _outgoings.forEach((Consumer)_function);
                Functions.Function1<Trigger, Event> _function_1 = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List events = ListExtensions.map(triggers, (Functions.Function1)_function_1);
                Iterable _filter = Iterables.filter((Iterable)events, TimeEvent.class);
                List timeEvents = IterableExtensions.toList((Iterable)_filter);
                SM2ClassesTransformationCore.this.states2TimeEvents.put(it, timeEvents);
            }
        };
        this.states.forEach(_function_8);
        Iterable _filter_1 = Iterables.filter(this.vertexes, Pseudostate.class);
        Consumer<Pseudostate> _function_9 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
                if (_equals) {
                    SM2ClassesTransformationCore.this.junctions.add(it);
                }
            }
        };
        _filter_1.forEach(_function_9);
        Consumer<Pseudostate> _function_10 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                String _name = it.getName();
                SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_name, SM2ClassesTransformationCore.this.intType);
            }
        };
        this.junctions.forEach(_function_10);
        Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("StateIDEnum", UMLPackage.Literals.ENUMERATION);
        this.stateIdEnum = (Enumeration)_createNestedClassifier_1;
        this.monitoringTransformation.createMonitorAttributes();
        this.createStateStruct();
        Property stateArrayAttr = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, this.stateStruct);
        StereotypeUtil.apply((Element)stateArrayAttr, Array.class);
        Array _stereotypeApplication = (Array)UMLUtil.getStereotypeApplication((Element)stateArrayAttr, Array.class);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("[");
        int _size_1 = this.states.size();
        _builder_4.append((Object)_size_1, "");
        _builder_4.append("]");
        _stereotypeApplication.setDefinition(_builder_4.toString());
        this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, (Type)this.stateIdEnum);
        this.createRegionMethods();
        EList _ownedOperations = this.superContext.getOwnedOperations();
        Functions.Function1<Operation, Boolean> _function_11 = new Functions.Function1<Operation, Boolean>(){

            public Boolean apply(Operation it) {
                boolean _and = false;
                boolean _isApplied = StereotypeUtil.isApplied((Element)it, (String)"StandardProfile::Create");
                if (!_isApplied) {
                    _and = false;
                } else {
                    boolean _equals;
                    String _name = it.getName();
                    String _name_1 = SM2ClassesTransformationCore.this.superContext.getName();
                    _and = _equals = Objects.equal((Object)_name, (Object)_name_1);
                }
                return _and;
            }
        };
        Iterable sourceCtors = IterableExtensions.filter((Iterable)_ownedOperations, (Functions.Function1)_function_11);
        Functions.Function1<Operation, Operation> _function_12 = new Functions.Function1<Operation, Operation>(){

            public Operation apply(Operation it) {
                return it;
            }
        };
        Iterable targetCtors = IterableExtensions.map((Iterable)sourceCtors, (Functions.Function1)_function_12);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetCtors);
        if (_isEmpty) {
            String _name = this.superContext.getName();
            Operation ctor = this.superContext.createOwnedOperation(_name, null, null);
            StereotypeUtil.apply((Element)ctor, (String)"StandardProfile::Create");
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("startBehavior();");
            this.createOpaqueBehavior(this.superContext, ctor, _builder_5.toString());
        } else {
            Consumer<Operation> _function_13 = new Consumer<Operation>(){

                @Override
                public void accept(Operation it) {
                    boolean _notEquals;
                    EList _methods = it.getMethods();
                    Behavior _head = (Behavior)IterableExtensions.head((Iterable)_methods);
                    OpaqueBehavior opaque = (OpaqueBehavior)_head;
                    boolean bl = _notEquals = !Objects.equal((Object)opaque, null);
                    if (_notEquals) {
                        EList _bodies = opaque.getBodies();
                        String body = (String)_bodies.get(0);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append(body, "");
                        _builder.newLineIfNotEmpty();
                        _builder.append("startBehavior();");
                        SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, it, _builder.toString());
                    } else {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("startBehavior();");
                        SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, it, _builder_1.toString());
                    }
                }
            };
            targetCtors.forEach(_function_13);
        }
        this.monitoringTransformation.createConstructor();
        this.monitoringTransformation.createDestructor();
        Operation startBehavior = this.superContext.createOwnedOperation("startBehavior", null, null);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
        _builder_6.append(" = statemachine::IDLE;");
        _builder_6.newLineIfNotEmpty();
        for (State s : this.states) {
            Behavior _doActivity;
            boolean _isBehaviorExist_2;
            Behavior _exit;
            boolean _isBehaviorExist_1;
            Behavior _entry = s.getEntry();
            boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(_entry);
            if (_isBehaviorExist) {
                _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_6.append("[");
                String _name_1 = s.getName();
                String _upperCase_1 = _name_1.toUpperCase();
                _builder_6.append(_upperCase_1, "");
                _builder_6.append("_ID].");
                _builder_6.append(SMCodeGeneratorConstants.ENTRY_NAME, "");
                _builder_6.append(" = &");
                String _name_2 = this.superContext.getName();
                _builder_6.append(_name_2, "");
                _builder_6.append("::");
                String _name_3 = s.getName();
                String _plus_1 = String.valueOf(_name_3) + "_";
                String _plus_2 = String.valueOf(_plus_1) + SMCodeGeneratorConstants.ENTRY_NAME;
                _builder_6.append(_plus_2, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
            if (_isBehaviorExist_1 = TransformationUtil.isBehaviorExist(_exit = s.getExit())) {
                _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_6.append("[");
                String _name_4 = s.getName();
                String _upperCase_2 = _name_4.toUpperCase();
                _builder_6.append(_upperCase_2, "");
                _builder_6.append("_ID].");
                _builder_6.append(SMCodeGeneratorConstants.EXIT_NAME, "");
                _builder_6.append(" = &");
                String _name_5 = this.superContext.getName();
                _builder_6.append(_name_5, "");
                _builder_6.append("::");
                String _name_6 = s.getName();
                String _plus_3 = String.valueOf(_name_6) + "_";
                String _plus_4 = String.valueOf(_plus_3) + SMCodeGeneratorConstants.EXIT_NAME;
                _builder_6.append(_plus_4, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
            if (_isBehaviorExist_2 = TransformationUtil.isBehaviorExist(_doActivity = s.getDoActivity())) {
                _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_6.append("[");
                String _name_7 = s.getName();
                String _upperCase_3 = _name_7.toUpperCase();
                _builder_6.append(_upperCase_3, "");
                _builder_6.append("_ID].");
                _builder_6.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "");
                _builder_6.append(" = &");
                String _name_8 = this.superContext.getName();
                _builder_6.append(_name_8, "");
                _builder_6.append("::");
                String _name_9 = s.getName();
                String _plus_5 = String.valueOf(_name_9) + "_";
                String _plus_6 = String.valueOf(_plus_5) + SMCodeGeneratorConstants.DO_ACTIVITY_NAME;
                _builder_6.append(_plus_6, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
            _builder_6.append(SMCodeGeneratorConstants.DO_ACTIVITY_TABLE, "");
            _builder_6.append("[");
            String _name_10 = s.getName();
            String _upperCase_4 = _name_10.toUpperCase();
            _builder_6.append(_upperCase_4, "");
            _builder_6.append("_ID] =  ");
            _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder_6.append("[");
            String _name_11 = s.getName();
            String _upperCase_5 = _name_11.toUpperCase();
            _builder_6.append(_upperCase_5, "");
            _builder_6.append("_ID].");
            _builder_6.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "");
            _builder_6.append(";");
            _builder_6.newLineIfNotEmpty();
        }
        _builder_6.newLine();
        _builder_6.append("// initialize all threads, the threads wait until the associated flag is set");
        _builder_6.newLine();
        _builder_6.append("for(int i = 0; i < (int) ");
        _builder_6.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder_6.append("; i++) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("if (");
        _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder_6.append("[i].");
        _builder_6.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "\t");
        _builder_6.append(" != &");
        String _name_12 = this.superContext.getName();
        _builder_6.append(_name_12, "\t");
        _builder_6.append("::doActivity_dft) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
        _builder_6.append("[i].id = i;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
        _builder_6.append("[i].ptr = this;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
        _builder_6.append("[i].func_type = ");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
        _builder_6.append(";");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.MUTEXES, "\t\t");
        _builder_6.append("[i] = PTHREAD_MUTEX_INITIALIZER;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.CONDITIONS, "\t\t");
        _builder_6.append("[i] = PTHREAD_COND_INITIALIZER;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append(SMCodeGeneratorConstants.FORK_NAME, "\t\t");
        _builder_6.append("(&");
        _builder_6.append(SMCodeGeneratorConstants.THREADS, "\t\t");
        _builder_6.append("[i], NULL, &");
        String _name_13 = this.superContext.getName();
        _builder_6.append(_name_13, "\t\t");
        _builder_6.append("::");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t\t");
        _builder_6.append(", &");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
        _builder_6.append("[i]);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.newLine();
        int _size_2 = this.timeEvents.size();
        boolean bl = _greaterThan = _size_2 > 0;
        if (_greaterThan) {
            for (TimeEvent e : this.timeEvents) {
                TimeExpression _when = e.getWhen();
                ValueSpecification _expr = _when.getExpr();
                EList _bodies = ((OpaqueExpression)_expr).getBodies();
                String _get = (String)_bodies.get(0);
                long duration = ParseVSL.getMsDurationFromVSL((String)_get);
                _builder_6.newLineIfNotEmpty();
                _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "");
                _builder_6.append("[");
                String _TE_INDEX_1 = this.cdefs.TE_INDEX();
                _builder_6.append(_TE_INDEX_1, "");
                _builder_6.append("(");
                String _eventID = TransformationUtil.eventID((Event)e);
                _builder_6.append(_eventID, "");
                _builder_6.append(")].duration = ");
                _builder_6.append((Object)duration, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
            _builder_6.append("for(int i = ");
            String _TIME_EVENT_LOWER_BOUND_2 = this.cdefs.TIME_EVENT_LOWER_BOUND();
            _builder_6.append(_TIME_EVENT_LOWER_BOUND_2, "");
            _builder_6.append("; i < ");
            int _size_3 = this.timeEvents.size();
            _builder_6.append((Object)_size_3, "");
            _builder_6.append("; i++) {");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_2 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_2, "\t");
            _builder_6.append("(i)].id = i;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_3 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_3, "\t");
            _builder_6.append("(i)].ptr = this;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_4 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_4, "\t");
            _builder_6.append("(i)].func_type = ");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "\t");
            _builder_6.append(";");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.MUTEXES_TIME_EVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_5 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_5, "\t");
            _builder_6.append("(i)] = PTHREAD_MUTEX_INITIALIZER;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.CONDITIONS_TIME_EVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_6 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_6, "\t");
            _builder_6.append("(i)] = PTHREAD_COND_INITIALIZER;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.FORK_NAME, "\t");
            _builder_6.append("(&");
            _builder_6.append(SMCodeGeneratorConstants.THREADS_TIME_EVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_7 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_7, "\t");
            _builder_6.append("(i)], NULL, &");
            String _name_14 = this.superContext.getName();
            _builder_6.append(_name_14, "\t");
            _builder_6.append("::");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t");
            _builder_6.append(", &");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_8 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_8, "\t");
            _builder_6.append("(i)]);");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append("while(");
            _builder_6.append(SMCodeGeneratorConstants.FLAGS_TIME_EVENT, "\t");
            _builder_6.append("[");
            String _TE_INDEX_9 = this.cdefs.TE_INDEX();
            _builder_6.append(_TE_INDEX_9, "\t");
            _builder_6.append("(i)]) {}");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("}");
            _builder_6.newLine();
        }
        _builder_6.newLine();
        boolean _isEmpty_1 = this.orthogonalRegions.isEmpty();
        boolean bl2 = _not = !_isEmpty_1;
        if (_not) {
            for (Region r : this.orthogonalRegions) {
                _builder_6.append(SMCodeGeneratorConstants.REGION_TABLE, "");
                _builder_6.append("[");
                String _regionMacroId = this.getRegionMacroId(r);
                _builder_6.append(_regionMacroId, "");
                _builder_6.append("] = &");
                String _name_15 = this.superContext.getName();
                _builder_6.append(_name_15, "");
                _builder_6.append("::");
                String _regionMethodName = this.getRegionMethodName(r);
                _builder_6.append(_regionMethodName, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
                _builder_6.append(SMCodeGeneratorConstants.REGION_TABLE_EXIT, "");
                _builder_6.append("[");
                String _regionMacroId_1 = this.getRegionMacroId(r);
                _builder_6.append(_regionMacroId_1, "");
                _builder_6.append("] = &");
                String _name_16 = this.superContext.getName();
                _builder_6.append(_name_16, "");
                _builder_6.append("::");
                String _regionMethodExitName = this.getRegionMethodExitName(r);
                _builder_6.append(_regionMethodExitName, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
        }
        _builder_6.newLine();
        boolean _isEmpty_2 = this.parallelTransitions.isEmpty();
        boolean bl3 = _not_1 = !_isEmpty_2;
        if (_not_1) {
            for (Transition t : this.parallelTransitions) {
                _builder_6.append(SMCodeGeneratorConstants.PARALLEL_TRANSITION_TABLE, "");
                _builder_6.append("[");
                String _parallelTransitionId = this.concurrency.parallelTransitionId(t);
                _builder_6.append(_parallelTransitionId, "");
                _builder_6.append("] = &");
                String _name_17 = this.superContext.getName();
                _builder_6.append(_name_17, "");
                _builder_6.append("::");
                String _parallelTransitionMethodName = this.concurrency.parallelTransitionMethodName(t);
                _builder_6.append(_parallelTransitionMethodName, "");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
            }
        }
        _builder_6.newLine();
        _builder_6.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "");
        _builder_6.append(" = PTHREAD_MUTEX_INITIALIZER;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, "");
        _builder_6.append(" = PTHREAD_COND_INITIALIZER;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.newLine();
        _builder_6.append("dispatchStruct = ");
        _builder_6.append(SMCodeGeneratorConstants.STRUCT_FOR_THREAD, "");
        _builder_6.append("(this, 0, 0, ");
        _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_STATE_MACHINE_TYPE, "");
        _builder_6.append(", 0);");
        _builder_6.newLineIfNotEmpty();
        String _name_18 = this.superContext.getName();
        _builder_6.append(_name_18, "");
        _builder_6.append("_THREAD_CREATE(dispatchThread, dispatchStruct)");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("while(!dispatchFlag) {}");
        _builder_6.newLine();
        _builder_6.newLine();
        int _size_4 = this.changeEvents.size();
        boolean bl4 = _greaterThan_1 = _size_4 > 0;
        if (_greaterThan_1) {
            _builder_6.append("// threads for changeEvent");
            _builder_6.newLine();
            _builder_6.append("for(int i = ");
            String _CHANGE_EVENT_LOWER_BOUND_2 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_6.append(_CHANGE_EVENT_LOWER_BOUND_2, "");
            _builder_6.append("; i < ");
            String _CHANGE_EVENT_LOWER_BOUND_3 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_6.append(_CHANGE_EVENT_LOWER_BOUND_3, "");
            _builder_6.append(" + ");
            int _size_5 = this.changeEvents.size();
            _builder_6.append((Object)_size_5, "");
            _builder_6.append("; i++) {");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
            _builder_6.append("[");
            String _CHE_INDEX_1 = this.cdefs.CHE_INDEX();
            _builder_6.append(_CHE_INDEX_1, "\t");
            _builder_6.append("(i)].id = i;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
            _builder_6.append("[");
            String _CHE_INDEX_2 = this.cdefs.CHE_INDEX();
            _builder_6.append(_CHE_INDEX_2, "\t");
            _builder_6.append("(i)].ptr = this;");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
            _builder_6.append("[");
            String _CHE_INDEX_3 = this.cdefs.CHE_INDEX();
            _builder_6.append(_CHE_INDEX_3, "\t");
            _builder_6.append("(i)].func_type = ");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_CHANGEEVENT_TYPE, "\t");
            _builder_6.append(";");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("\t");
            _builder_6.append(SMCodeGeneratorConstants.FORK_NAME, "\t");
            _builder_6.append("(&");
            _builder_6.append(SMCodeGeneratorConstants.THREADS_CHANGE_EVENT, "\t");
            _builder_6.append("[");
            String _CHE_INDEX_4 = this.cdefs.CHE_INDEX();
            _builder_6.append(_CHE_INDEX_4, "\t");
            _builder_6.append("(i)], NULL, &");
            String _name_19 = this.superContext.getName();
            _builder_6.append(_name_19, "\t");
            _builder_6.append("::");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t");
            _builder_6.append(", &");
            _builder_6.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
            _builder_6.append("[");
            String _CHE_INDEX_5 = this.cdefs.CHE_INDEX();
            _builder_6.append(_CHE_INDEX_5, "\t");
            _builder_6.append("(i)]);");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("}");
            _builder_6.newLine();
        }
        _builder_6.newLine();
        _builder_6.append("//initialze root active state");
        _builder_6.newLine();
        _builder_6.append("//execute initial effect");
        _builder_6.newLine();
        String _regionMethodName_1 = this.getRegionMethodName(this.topRegion);
        _builder_6.append(_regionMethodName_1, "");
        _builder_6.append("(");
        String _initialMacroName = this.getInitialMacroName(this.topRegion);
        _builder_6.append(_initialMacroName, "");
        _builder_6.append(");");
        _builder_6.newLineIfNotEmpty();
        this.createOpaqueBehavior(this.superContext, startBehavior, _builder_6.toString());
        this.superContext.createOwnedAttribute("dispatchFlag", this.boolType);
        BiConsumer<Event, List<Transition>> _function_14 = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e, List<Transition> trans) {
                SM2ClassesTransformationCore.this.eventTransform.createEventMethod(e, trans);
            }
        };
        eventMap.forEach(_function_14);
        final ArrayList<Transition> autoTrans = new ArrayList<Transition>();
        Consumer<Transition> _function_15 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                Functions.Function1<Trigger, Event> _function;
                EList _triggers;
                List _map;
                int _size;
                boolean _equals;
                boolean _and = false;
                Vertex _source = it.getSource();
                _and = !(_source instanceof State) ? false : (_equals = (_size = (_map = ListExtensions.map((List)(_triggers = it.getTriggers()), (Functions.Function1)(_function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                }))).size()) == 0);
                if (_and) {
                    autoTrans.add(it);
                }
            }
        };
        this.transitions.forEach(_function_15);
        this.eventTransform.createEventMethod(SMCodeGeneratorConstants.COMPLETION_EVENT, autoTrans);
        Consumer<State> _function_16 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                Behavior _doActivity;
                boolean _isBehaviorExist_2;
                Behavior _exit;
                boolean _isBehaviorExist_1;
                String _name = it.getName();
                String _upperCase = _name.toUpperCase();
                String _plus = String.valueOf(_upperCase) + "_ID";
                SM2ClassesTransformationCore.this.stateIdEnum.createOwnedLiteral(_plus);
                Behavior _entry = it.getEntry();
                boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(_entry);
                if (_isBehaviorExist) {
                    String _name_1 = it.getName();
                    String _plus_1 = String.valueOf(_name_1) + "_";
                    String _plus_2 = String.valueOf(_plus_1) + SMCodeGeneratorConstants.ENTRY_NAME;
                    Operation entry = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_2, null, null);
                    Behavior _entry_1 = it.getEntry();
                    EList _bodies = ((OpaqueBehavior)_entry_1).getBodies();
                    String _head = (String)IterableExtensions.head((Iterable)_bodies);
                    OpaqueBehavior opaque = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, entry, _head);
                    EList _languages = opaque.getLanguages();
                    _languages.add((Object)SM2ClassesTransformationCore.this.langID);
                }
                if (_isBehaviorExist_1 = TransformationUtil.isBehaviorExist(_exit = it.getExit())) {
                    String _name_2 = it.getName();
                    String _plus_3 = String.valueOf(_name_2) + "_";
                    String _plus_4 = String.valueOf(_plus_3) + SMCodeGeneratorConstants.EXIT_NAME;
                    Operation exit = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_4, null, null);
                    Behavior _exit_1 = it.getExit();
                    EList _bodies_1 = ((OpaqueBehavior)_exit_1).getBodies();
                    String _head_1 = (String)IterableExtensions.head((Iterable)_bodies_1);
                    OpaqueBehavior opaque_1 = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, exit, _head_1);
                    EList _languages_1 = opaque_1.getLanguages();
                    _languages_1.add((Object)SM2ClassesTransformationCore.this.langID);
                }
                if (_isBehaviorExist_2 = TransformationUtil.isBehaviorExist(_doActivity = it.getDoActivity())) {
                    Behavior _doActivity_1 = it.getDoActivity();
                    SM2ClassesTransformationCore.this.doActivityList.add(_doActivity_1);
                    String _name_3 = it.getName();
                    String _plus_5 = String.valueOf(_name_3) + "_";
                    String _plus_6 = String.valueOf(_plus_5) + SMCodeGeneratorConstants.DO_ACTIVITY_NAME;
                    Operation doActivity = SM2ClassesTransformationCore.this.superContext.createOwnedOperation(_plus_6, null, null);
                    StringConcatenation _builder = new StringConcatenation();
                    String callCompletionEvent = _builder.toString();
                    boolean _isComposite = it.isComposite();
                    boolean _not = !_isComposite;
                    Behavior _doActivity_2 = it.getDoActivity();
                    EList _bodies_2 = ((OpaqueBehavior)_doActivity_2).getBodies();
                    String _head_2 = (String)IterableExtensions.head((Iterable)_bodies_2);
                    String _plus_7 = String.valueOf(_head_2) + "\n";
                    String _plus_8 = String.valueOf(_plus_7) + callCompletionEvent;
                    OpaqueBehavior opaque_2 = SM2ClassesTransformationCore.this.createOpaqueBehavior(SM2ClassesTransformationCore.this.superContext, doActivity, _plus_8);
                    EList _languages_2 = opaque_2.getLanguages();
                    _languages_2.add((Object)SM2ClassesTransformationCore.this.langID);
                }
            }
        };
        this.states.forEach(_function_16);
        this.stateIdEnum.createOwnedLiteral(SMCodeGeneratorConstants.STATE_MAX);
        this.concurrency.createThreadBasedParallelism();
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("#define CHECKPOINT if (");
        _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
        _builder_7.append(" == statemachine::EVENT_PROCESSING) {return;}");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("#define ");
        String _name_20 = this.superContext.getName();
        _builder_7.append(_name_20, "");
        _builder_7.append("_THREAD_CREATE(thThread, str) ");
        _builder_7.append(SMCodeGeneratorConstants.FORK_NAME, "");
        _builder_7.append("(&thThread, NULL, &");
        String _name_21 = this.superContext.getName();
        _builder_7.append(_name_21, "");
        _builder_7.append("::");
        _builder_7.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "");
        _builder_7.append(", &str);");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("#define ");
        String _name_22 = this.superContext.getName();
        String _upperCase_6 = _name_22.toUpperCase();
        _builder_7.append(_upperCase_6, "");
        _builder_7.append("_GET_CONTROL /*mutex synchronization to protect run-to-completion semantics*/ \\");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t");
        _builder_7.append("pthread_mutex_lock(&");
        _builder_7.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t");
        _builder_7.append("); \\");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t");
        _builder_7.append("while (");
        _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
        _builder_7.append(" != statemachine::IDLE) {\\");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t\t");
        _builder_7.append("pthread_cond_wait(&");
        _builder_7.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, "\t\t\t");
        _builder_7.append(", &");
        _builder_7.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t\t");
        _builder_7.append(");\\");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t");
        _builder_7.append("}");
        _builder_7.newLine();
        _builder_7.append("#define ");
        String _name_23 = this.superContext.getName();
        String _upperCase_7 = _name_23.toUpperCase();
        _builder_7.append(_upperCase_7, "");
        _builder_7.append("_RELEASE_CONTROL ");
        _builder_7.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
        _builder_7.append(" = statemachine::IDLE; pthread_cond_signal(&");
        _builder_7.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, "");
        _builder_7.append("); \\");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t\t\t");
        _builder_7.append("pthread_mutex_unlock(&");
        _builder_7.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t\t\t");
        _builder_7.append(");");
        this.appendIncludeHeader(_builder_7.toString());
        Type eventClass = this.smPack.getOwnedType("Event_t");
        Type eventQueueClass = this.smPack.getOwnedType("EventPriorityQueue");
        this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.EVENT_QUEUE, eventQueueClass);
        Property _createOwnedAttribute = this.superContext.createOwnedAttribute("currentEvent", eventClass);
        StereotypeUtil.apply((Element)_createOwnedAttribute, Ptr.class);
        Operation eventDispatch = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.EVENT_DISPATCH, null, null);
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("bool popDeferred = false;");
        _builder_8.newLine();
        _builder_8.append("while(true) {");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("//run-to-completion: need to have a mutex here");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("currentEvent = ");
        _builder_8.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
        _builder_8.append(".pop(popDeferred);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("dispatchFlag = true;");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("if (currentEvent != NULL) {");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("unsigned int eventID = currentEvent->eventID;");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        String _name_24 = this.superContext.getName();
        String _upperCase_8 = _name_24.toUpperCase();
        _builder_8.append(_upperCase_8, "\t\t");
        _builder_8.append("_GET_CONTROL");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t\t");
        _builder_8.append("switch(eventID) {");
        _builder_8.newLine();
        Set<Event> _keySet = eventMap.keySet();
        Functions.Function1<Event, Boolean> _function_17 = new Functions.Function1<Event, Boolean>(){

            public Boolean apply(Event it) {
                return !(it instanceof CallEvent);
            }
        };
        Iterable _filter_2 = IterableExtensions.filter(_keySet, (Functions.Function1)_function_17);
        for (Event e_1 : _filter_2) {
            _builder_8.append("\t\t\t");
            _builder_8.append("case ");
            String _eventID_1 = TransformationUtil.eventID(e_1);
            _builder_8.append(_eventID_1, "\t\t\t");
            _builder_8.append(": {");
            _builder_8.newLineIfNotEmpty();
            if (e_1 instanceof SignalEvent) {
                boolean _notEquals;
                Signal _signal = ((SignalEvent)e_1).getSignal();
                boolean bl5 = _notEquals = !Objects.equal((Object)_signal, null);
                if (_notEquals) {
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    Signal _signal_1 = ((SignalEvent)e_1).getSignal();
                    String _cppQualifiedName = CppGenUtils.cppQualifiedName((NamedElement)_signal_1);
                    _builder_8.append(_cppQualifiedName, "\t\t\t\t");
                    _builder_8.append(" sig_");
                    String _eventID_2 = TransformationUtil.eventID(e_1);
                    _builder_8.append(_eventID_2, "\t\t\t\t");
                    _builder_8.append(";");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    _builder_8.append("if (currentEvent != NULL) {");
                    _builder_8.newLine();
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    _builder_8.append("\t");
                    _builder_8.append("memcpy(&sig_");
                    String _eventID_3 = TransformationUtil.eventID(e_1);
                    _builder_8.append(_eventID_3, "\t\t\t\t\t");
                    _builder_8.append(", currentEvent->data, sizeof(");
                    Signal _signal_2 = ((SignalEvent)e_1).getSignal();
                    String _cppQualifiedName_1 = CppGenUtils.cppQualifiedName((NamedElement)_signal_2);
                    _builder_8.append(_cppQualifiedName_1, "\t\t\t\t\t");
                    _builder_8.append("));");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    _builder_8.append("\t");
                    _builder_8.append("process");
                    String _eventName = TransformationUtil.eventName(e_1);
                    _builder_8.append(_eventName, "\t\t\t\t\t");
                    _builder_8.append("(sig_");
                    String _eventID_4 = TransformationUtil.eventID(e_1);
                    _builder_8.append(_eventID_4, "\t\t\t\t\t");
                    _builder_8.append(");");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    _builder_8.append("}");
                    _builder_8.newLine();
                } else {
                    _builder_8.append("\t\t\t");
                    _builder_8.append("\t");
                    _builder_8.append("process");
                    String _eventName_1 = TransformationUtil.eventName(e_1);
                    _builder_8.append(_eventName_1, "\t\t\t\t");
                    _builder_8.append("();");
                    _builder_8.newLineIfNotEmpty();
                }
            } else {
                _builder_8.append("\t\t\t");
                _builder_8.append("\t");
                _builder_8.append("process");
                String _eventName_2 = TransformationUtil.eventName(e_1);
                _builder_8.append(_eventName_2, "\t\t\t\t");
                _builder_8.append("();");
                _builder_8.newLineIfNotEmpty();
            }
            _builder_8.append("\t\t\t");
            _builder_8.append("\t");
            _builder_8.append("break;");
            _builder_8.newLine();
            _builder_8.append("\t\t\t");
            _builder_8.append("}");
            _builder_8.newLine();
        }
        _builder_8.append("\t\t\t\t");
        _builder_8.append("case COMPLETIONEVENT_ID: {");
        _builder_8.newLine();
        _builder_8.append("\t\t\t\t\t");
        _builder_8.append("processCompletionEvent();");
        _builder_8.newLine();
        _builder_8.append("\t\t\t\t\t");
        _builder_8.append("break;");
        _builder_8.newLine();
        _builder_8.append("\t\t\t\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("if (");
        _builder_8.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
        _builder_8.append(" == statemachine::EVENT_DEFERRED) {");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t\t\t");
        _builder_8.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t");
        _builder_8.append(".saveDeferred(*currentEvent);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t\t");
        _builder_8.append("popDeferred = (");
        _builder_8.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
        _builder_8.append(" != statemachine::EVENT_DEFERRED);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t\t");
        _builder_8.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
        _builder_8.append(" = statemachine::IDLE;");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t\t");
        String _name_25 = this.superContext.getName();
        String _upperCase_9 = _name_25.toUpperCase();
        _builder_8.append(_upperCase_9, "\t\t");
        _builder_8.append("_RELEASE_CONTROL");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("}");
        _builder_8.newLine();
        _builder_8.append("\t");
        _builder_8.append("usleep(100);");
        _builder_8.newLine();
        _builder_8.append("}");
        this.createOpaqueBehavior(this.superContext, eventDispatch, _builder_8.toString());
        this.concurrency.createConcurrencyForTransitions();
        Type _pthread = this.ptTypes.getPthread();
        this.superContext.createOwnedAttribute("dispatchThread", _pthread);
        this.superContext.createOwnedAttribute("dispatchStruct", this.concurrency.threadStructType);
        Type _pthreadMutex = this.ptTypes.getPthreadMutex();
        this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, _pthreadMutex);
        Type _pthreadCond = this.ptTypes.getPthreadCond();
        this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, _pthreadCond);
        this.createChangeEvents();
    }

    public void appendIncludeHeader(String appended) {
        Include _stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        boolean _equals = Objects.equal((Object)_stereotypeApplication, null);
        if (_equals) {
            StereotypeUtil.apply((Element)this.superContext, Include.class);
        }
        Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        String header = _stereotypeApplication_1.getHeader();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(header, "");
        _builder.newLineIfNotEmpty();
        _builder.append(appended, "");
        header = _builder.toString();
        Include _stereotypeApplication_2 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        _stereotypeApplication_2.setHeader(header);
    }

    public void appendIncludeBody(String appended) {
        Include _stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        boolean _equals = Objects.equal((Object)_stereotypeApplication, null);
        if (_equals) {
            StereotypeUtil.apply((Element)this.superContext, Include.class);
        }
        Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        String body = _stereotypeApplication_1.getBody();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(body, "");
        _builder.newLineIfNotEmpty();
        _builder.append(appended, "");
        body = _builder.toString();
        Include _stereotypeApplication_2 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        _stereotypeApplication_2.setBody(body);
    }

    private void createChangeEvents() {
        ChangeEventTransformation _changeEventTransformation = new ChangeEventTransformation(this);
        _changeEventTransformation.createChangeEvents();
    }

    public String generateChangeState(State s) {
        Region _container = s.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
            _builder.append(" = ");
            String _name = s.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_ID;");
            return _builder.toString();
        }
        Region _container_1 = s.getContainer();
        State _state = _container_1.getState();
        EList _regions = _state.getRegions();
        Region _container_2 = s.getContainer();
        int rIndex = _regions.indexOf((Object)_container_2);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder_1.append("[");
        Region _container_3 = s.getContainer();
        State _state_1 = _container_3.getState();
        String _name_1 = _state_1.getName();
        String _upperCase_1 = _name_1.toUpperCase();
        _builder_1.append(_upperCase_1, "");
        _builder_1.append("_ID].");
        _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
        _builder_1.append("[");
        _builder_1.append((Object)rIndex, "");
        _builder_1.append("] = ");
        String _name_2 = s.getName();
        String _upperCase_2 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_2, "");
        _builder_1.append("_ID;");
        return _builder_1.toString();
    }

    public String generateExitingSubStates(State parent, boolean exitParent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            _builder_1.append("//exiting concurrent state ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1, "");
            _builder_1.newLineIfNotEmpty();
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                String _generateForkCall = this.concurrency.generateForkCall(r, false, "0");
                _builder_1.append(_generateForkCall, "");
                _builder_1.newLineIfNotEmpty();
            }
            EList _regions_1 = parent.getRegions();
            for (Region r_1 : _regions_1) {
                String _generateJoinCall = this.concurrency.generateJoinCall(r_1, false);
                _builder_1.append(_generateJoinCall, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                EList _regions_2 = parent.getRegions();
                Region _head = (Region)IterableExtensions.head((Iterable)_regions_2);
                String _regionMethodExitName = this.getRegionMethodExitName(_head);
                _builder_1.append(_regionMethodExitName, "");
                _builder_1.append("();");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            Behavior _doActivity = parent.getDoActivity();
            boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(_doActivity);
            if (_isBehaviorExist) {
                _builder_1.append("//signal to exit the doActivity of ");
                String _name_2 = parent.getName();
                _builder_1.append(_name_2, "");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
                _builder_1.append("(");
                String _name_3 = parent.getName();
                String _upperCase_1 = _name_3.toUpperCase();
                _builder_1.append(_upperCase_1, "");
                _builder_1.append("_ID, ");
                _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
                _builder_1.append(", false);");
                _builder_1.newLineIfNotEmpty();
            }
            String _generateDeactivateTimeEvent = this.generateDeactivateTimeEvent(parent);
            _builder_1.append(_generateDeactivateTimeEvent, "");
            _builder_1.newLineIfNotEmpty();
            Behavior _exit = parent.getExit();
            boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(_exit);
            if (_isBehaviorExist_1) {
                _builder_1.append("//exit action of ");
                String _name_4 = parent.getName();
                _builder_1.append(_name_4, "");
                _builder_1.newLineIfNotEmpty();
                String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.EXIT_NAME);
                _builder_1.append(_fptrCall, "");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    public String generateActivateTimeEvent(State s) {
        List<TimeEvent> _get = this.states2TimeEvents.get(s);
        boolean _equals = Objects.equal(_get, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
        for (TimeEvent te : _get_1) {
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder_1.append(_TE_INDEX, "");
            _builder_1.append("(");
            String _eventID = TransformationUtil.eventID((Event)te);
            _builder_1.append(_eventID, "");
            _builder_1.append("), ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    public String generateDeactivateTimeEvent(State s) {
        List<TimeEvent> _get = this.states2TimeEvents.get(s);
        boolean _equals = Objects.equal(_get, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
        for (TimeEvent te : _get_1) {
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder_1.append(_TE_INDEX, "");
            _builder_1.append("(");
            String _eventID = TransformationUtil.eventID((Event)te);
            _builder_1.append(_eventID, "");
            _builder_1.append("), ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "");
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateExitingSubStatesWithTransition(State parent, boolean exitParent, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                EList _subvertices = r.getSubvertices();
                Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        boolean _isComposite;
                        boolean _and = false;
                        boolean _not = !(it instanceof FinalState);
                        _and = !_not ? false : (_isComposite = it.isComposite());
                        return _and;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                boolean _hasElements = false;
                for (State s : _filter_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_1 = parent.getName();
                    String _upperCase_1 = _name_1.toUpperCase();
                    _builder_1.append(_upperCase_1, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[");
                    EList _regions_1 = parent.getRegions();
                    int _indexOf = _regions_1.indexOf((Object)r);
                    _builder_1.append((Object)_indexOf, "");
                    _builder_1.append("] == &");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_2 = s.getName();
                    String _upperCase_2 = _name_2.toUpperCase();
                    _builder_1.append(_upperCase_2, "");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates = this.generateExitingSubStates(s, true);
                    _builder_1.append(_generateExitingSubStates, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_3 = parent.getName();
                String _upperCase_3 = _name_3.toUpperCase();
                _builder_1.append(_upperCase_3, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[");
                EList _regions_2 = parent.getRegions();
                int _indexOf_1 = _regions_2.indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1, "");
                _builder_1.append("] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                EList _subvertices_1 = r.getSubvertices();
                Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
                Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_1);
                boolean _hasElements_1 = false;
                for (State sub : _filter_3) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                    _builder_1.append("[");
                    String _name_4 = parent.getName();
                    String _upperCase_4 = _name_4.toUpperCase();
                    _builder_1.append(_upperCase_4, "\t");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
                    _builder_1.append("[");
                    EList _regions_3 = parent.getRegions();
                    int _indexOf_2 = _regions_3.indexOf((Object)r);
                    _builder_1.append((Object)_indexOf_2, "\t");
                    _builder_1.append("] == &");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                    _builder_1.append("[");
                    String _name_5 = sub.getName();
                    String _upperCase_5 = _name_5.toUpperCase();
                    _builder_1.append(_upperCase_5, "\t");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
                    _builder_1.append("(");
                    String _name_6 = sub.getName();
                    String _upperCase_6 = _name_6.toUpperCase();
                    _builder_1.append(_upperCase_6, "\t\t");
                    _builder_1.append("_ID, ");
                    _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _name_7 = parent.getName();
                String _upperCase_7 = _name_7.toUpperCase();
                String _plus = String.valueOf(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE) + "[" + _upperCase_7;
                String _plus_1 = String.valueOf(_plus) + "_ID].";
                String _plus_2 = String.valueOf(_plus_1) + SMCodeGeneratorConstants.ACTIVE_SUB_STATES;
                String _plus_3 = String.valueOf(_plus_2) + "[";
                EList _regions_4 = parent.getRegions();
                int _indexOf_3 = _regions_4.indexOf((Object)r);
                String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_indexOf_3);
                String _plus_5 = String.valueOf(_plus_4) + "]";
                String _fptrCall = this.getFptrCall(_plus_5, true, SMCodeGeneratorConstants.EXIT_NAME);
                _builder_1.append(_fptrCall, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_8 = parent.getName();
                String _upperCase_8 = _name_8.toUpperCase();
                _builder_1.append(_upperCase_8, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[");
                EList _regions_5 = parent.getRegions();
                int _indexOf_4 = _regions_5.indexOf((Object)r);
                _builder_1.append((Object)_indexOf_4, "");
                _builder_1.append("] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                EList _regions_6 = parent.getRegions();
                Region _head = (Region)IterableExtensions.head((Iterable)_regions_6);
                EList _subvertices_2 = _head.getSubvertices();
                Iterable _filter_4 = Iterables.filter((Iterable)_subvertices_2, State.class);
                Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        boolean _isComposite;
                        boolean _and = false;
                        boolean _not = !(it instanceof FinalState);
                        _and = !_not ? false : (_isComposite = it.isComposite());
                        return _and;
                    }
                };
                Iterable _filter_5 = IterableExtensions.filter((Iterable)_filter_4, (Functions.Function1)_function_2);
                boolean _hasElements_2 = false;
                for (State s_1 : _filter_5) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_9 = parent.getName();
                    String _upperCase_9 = _name_9.toUpperCase();
                    _builder_1.append(_upperCase_9, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[0] == &");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_10 = s_1.getName();
                    String _upperCase_10 = _name_10.toUpperCase();
                    _builder_1.append(_upperCase_10, "");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates_1 = this.generateExitingSubStates(s_1, true);
                    _builder_1.append(_generateExitingSubStates_1, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_11 = parent.getName();
                String _upperCase_11 = _name_11.toUpperCase();
                _builder_1.append(_upperCase_11, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[0] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                EList _regions_7 = parent.getRegions();
                Region _head_1 = (Region)IterableExtensions.head((Iterable)_regions_7);
                EList _subvertices_3 = _head_1.getSubvertices();
                Iterable _filter_6 = Iterables.filter((Iterable)_subvertices_3, State.class);
                Functions.Function1<State, Boolean> _function_3 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_7 = IterableExtensions.filter((Iterable)_filter_6, (Functions.Function1)_function_3);
                boolean _hasElements_3 = false;
                for (State sub_1 : _filter_7) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                    _builder_1.append("[");
                    String _name_12 = parent.getName();
                    String _upperCase_12 = _name_12.toUpperCase();
                    _builder_1.append(_upperCase_12, "\t");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
                    _builder_1.append("[0] == &");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                    _builder_1.append("[");
                    String _name_13 = sub_1.getName();
                    String _upperCase_13 = _name_13.toUpperCase();
                    _builder_1.append(_upperCase_13, "\t");
                    _builder_1.append("_ID]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
                    _builder_1.append("(");
                    String _name_14 = sub_1.getName();
                    String _upperCase_14 = _name_14.toUpperCase();
                    _builder_1.append(_upperCase_14, "\t\t");
                    _builder_1.append("_ID, ");
                    _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _name_15 = parent.getName();
                String _upperCase_15 = _name_15.toUpperCase();
                String _plus_6 = String.valueOf(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE) + "[" + _upperCase_15;
                String _plus_7 = String.valueOf(_plus_6) + "_ID].";
                String _plus_8 = String.valueOf(_plus_7) + SMCodeGeneratorConstants.ACTIVE_SUB_STATES;
                String _plus_9 = String.valueOf(_plus_8) + "[0]";
                String _fptrCall_1 = this.getFptrCall(_plus_9, true, SMCodeGeneratorConstants.EXIT_NAME);
                _builder_1.append(_fptrCall_1, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_16 = parent.getName();
                String _upperCase_16 = _name_16.toUpperCase();
                _builder_1.append(_upperCase_16, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[0] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _name_17 = parent.getName();
            String _upperCase_17 = _name_17.toUpperCase();
            _builder_1.append(_upperCase_17, "");
            _builder_1.append("_ID, ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall_2 = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.EXIT_NAME);
            _builder_1.append(_fptrCall_2, "");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        String _transitionEffect = TransformationUtil.getTransitionEffect(t);
        _builder_1.append(_transitionEffect, "");
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, boolean enterParent) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState, "");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_1.append(_fptrCall, "");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _name_2 = parent.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder_1.append(_upperCase_1, "");
            _builder_1.append("_ID, ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates = this.generateEnteringSubStates(_findInitialState_1, true);
                _builder_1.append(_generateEnteringSubStates, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                boolean _notEquals_1;
                EList _regions_1 = parent.getRegions();
                Region _head = (Region)IterableExtensions.head((Iterable)_regions_1);
                State _findInitialState_2 = TransformationUtil.findInitialState(_head);
                boolean bl = _notEquals_1 = !Objects.equal((Object)_findInitialState_2, null);
                if (_notEquals_1) {
                    EList _regions_2 = parent.getRegions();
                    Region _head_1 = (Region)IterableExtensions.head((Iterable)_regions_2);
                    String _initialEffect_1 = TransformationUtil.getInitialEffect(_head_1);
                    _builder_1.append(_initialEffect_1, "");
                    _builder_1.newLineIfNotEmpty();
                    EList _regions_3 = parent.getRegions();
                    Region _head_2 = (Region)IterableExtensions.head((Iterable)_regions_3);
                    State _findInitialState_3 = TransformationUtil.findInitialState(_head_2);
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(_findInitialState_3, true);
                    _builder_1.append(_generateEnteringSubStates_1, "");
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, State child, boolean enterParent, boolean gotoSubstate) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState, "");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_1.append(_fptrCall, "");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _name_2 = parent.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder_1.append(_upperCase_1, "");
            _builder_1.append("_ID, ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoSubstate) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(_findInitialState_1, true);
                _builder_1.append(_generateEnteringSubStates_1, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                _builder_1.append("//");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_3 = parent.getName();
                String _upperCase_2 = _name_3.toUpperCase();
                _builder_1.append(_upperCase_2, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[0] = &");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_4 = child.getName();
                String _upperCase_3 = _name_4.toUpperCase();
                _builder_1.append(_upperCase_3, "");
                _builder_1.append("_ID];");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_2 = this.generateEnteringSubStates(child, true);
                _builder_1.append(_generateEnteringSubStates_2, "");
                _builder_1.newLineIfNotEmpty();
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState, "");
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall, "");
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name_1 = parent.getName();
        _builder_1.append(_name_1, "");
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
        _builder_1.append("(");
        String _name_2 = parent.getName();
        String _upperCase_1 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_1, "");
        _builder_1.append("_ID, ");
        _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(r);
                boolean _contains = _transitiveSubStates.contains(child);
                if (_contains) {
                    EList _subvertices = r.getSubvertices();
                    Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                    State nextParent = (State)IterableExtensions.head((Iterable)_filter_1);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(_findInitialState_1, true);
                _builder_1.append(_generateEnteringSubStates_1, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Region _container_1 = child.getContainer();
                State _state = _container_1.getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, false, false);
                    _builder_1.append(_generateEnteringSubStates_2, "");
                    _builder_1.newLineIfNotEmpty();
                } else {
                    EList _regions_1 = parent.getRegions();
                    Region _head = (Region)IterableExtensions.head((Iterable)_regions_1);
                    EList _subvertices_1 = _head.getSubvertices();
                    Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_1);
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)_filter_3);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1, "");
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child, boolean enterParent, boolean gotoChild) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState, "");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_1.append(_fptrCall, "");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("//start activity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _name_2 = parent.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder_1.append(_upperCase_1, "");
            _builder_1.append("_ID, ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoChild) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(r);
                boolean _contains = _transitiveSubStates.contains(child);
                if (_contains) {
                    EList _subvertices = r.getSubvertices();
                    Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                    State nextParent = (State)IterableExtensions.head((Iterable)_filter_1);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(_findInitialState_1, true);
                _builder_1.append(_generateEnteringSubStates_1, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Region _container_1 = child.getContainer();
                State _state = _container_1.getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    if (gotoChild) {
                        String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, enterParent, false);
                        _builder_1.append(_generateEnteringSubStates_2, "");
                        _builder_1.newLineIfNotEmpty();
                    }
                } else {
                    EList _regions_1 = parent.getRegions();
                    Region _head = (Region)IterableExtensions.head((Iterable)_regions_1);
                    EList _subvertices_1 = _head.getSubvertices();
                    Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_1);
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)_filter_3);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1, "");
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    public String hasSubstatesAcceptingEvent(State parent, final List<State> states) {
        boolean _greaterThan;
        Functions.Function1<State, Boolean> _function;
        List<State> transitives = TransformationUtil.transitiveSubStates(parent);
        Iterable intersects = IterableExtensions.filter(transitives, (Functions.Function1)(_function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return states.contains(it);
            }
        }));
        int _size = IterableExtensions.size((Iterable)intersects);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return "!isProcessed && ";
        }
        StringConcatenation _builder = new StringConcatenation();
        return _builder.toString();
    }

    @Deprecated
    public String generateEntryWithPseudo(State cp, Pseudostate p, List<Vertex> enters) {
        String _generateEnteringSpecial;
        String _generatePseudo;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)cp, (Object)p);
        _xifexpression = _equals ? (ret = (_generatePseudo = this.pseudostateGenerator.generatePseudo(p))) : (ret = (_generateEnteringSpecial = this.generateEnteringSpecial(cp, p)));
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private List<State> transitiveSubStates(Region r) {
        return TransformationUtil.transitiveSubStates(r);
    }

    private List<State> transitiveSubStates(State s) {
        return TransformationUtil.transitiveSubStates(s);
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState, "");
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall, "");
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name_1 = parent.getName();
        _builder_1.append(_name_1, "");
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
        _builder_1.append("(");
        String _name_2 = parent.getName();
        String _upperCase_1 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_1, "");
        _builder_1.append("_ID, ");
        _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                List<State> _transitiveSubStates = this.transitiveSubStates(r);
                boolean _contains = _transitiveSubStates.contains(child);
                if (_contains) {
                    EList _subvertices = r.getSubvertices();
                    Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List _transitiveSubStates = SM2ClassesTransformationCore.this.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                    State nextParent = (State)IterableExtensions.head((Iterable)_filter_1);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_3 = parent.getName();
                    String _upperCase_2 = _name_3.toUpperCase();
                    _builder_1.append(_upperCase_2, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[");
                    EList _regions_1 = parent.getRegions();
                    int _indexOf = _regions_1.indexOf((Object)r);
                    _builder_1.append((Object)_indexOf, "");
                    _builder_1.append("] = ");
                    String _name_4 = nextParent.getName();
                    String _upperCase_3 = _name_4.toUpperCase();
                    _builder_1.append(_upperCase_3, "");
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_5 = parent.getName();
                String _upperCase_4 = _name_5.toUpperCase();
                _builder_1.append(_upperCase_4, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[");
                EList _regions_2 = parent.getRegions();
                int _indexOf_1 = _regions_2.indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1, "");
                _builder_1.append("] = ");
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _name_6 = _findInitialState_1.getName();
                String _upperCase_5 = _name_6.toUpperCase();
                _builder_1.append(_upperCase_5, "");
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_2 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates = this.generateEnteringSubStates(_findInitialState_2, true);
                _builder_1.append(_generateEnteringSubStates, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Region _container_1 = child.getContainer();
                State _state = _container_1.getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1, "");
                    _builder_1.newLineIfNotEmpty();
                } else {
                    EList _regions_3 = parent.getRegions();
                    Region _head = (Region)IterableExtensions.head((Iterable)_regions_3);
                    EList _subvertices_1 = _head.getSubvertices();
                    Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List _transitiveSubStates = SM2ClassesTransformationCore.this.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_1);
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)_filter_3);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_7 = parent.getName();
                    String _upperCase_6 = _name_7.toUpperCase();
                    _builder_1.append(_upperCase_6, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[0] = ");
                    String _name_8 = nextParent_1.getName();
                    String _upperCase_7 = _name_8.toUpperCase();
                    _builder_1.append(_upperCase_7, "");
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1, "");
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState, "");
        _builder_1.newLineIfNotEmpty();
        String _transitionEffect = TransformationUtil.getTransitionEffect(t);
        _builder_1.append(_transitionEffect, "");
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall, "");
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name_1 = parent.getName();
        _builder_1.append(_name_1, "");
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
        _builder_1.append("(");
        String _name_2 = parent.getName();
        String _upperCase_1 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_1, "");
        _builder_1.append("_ID, ");
        _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _notEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                List<State> _transitiveSubStates = this.transitiveSubStates(r);
                boolean _contains = _transitiveSubStates.contains(child);
                if (_contains) {
                    EList _subvertices = r.getSubvertices();
                    Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List _transitiveSubStates = SM2ClassesTransformationCore.this.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                    State nextParent = (State)IterableExtensions.head((Iterable)_filter_1);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_3 = parent.getName();
                    String _upperCase_2 = _name_3.toUpperCase();
                    _builder_1.append(_upperCase_2, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[");
                    EList _regions_1 = parent.getRegions();
                    int _indexOf = _regions_1.indexOf((Object)r);
                    _builder_1.append((Object)_indexOf, "");
                    _builder_1.append("] = ");
                    String _name_4 = nextParent.getName();
                    String _upperCase_3 = _name_4.toUpperCase();
                    _builder_1.append(_upperCase_3, "");
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial, "");
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState(r);
                boolean bl = _notEquals = !Objects.equal((Object)_findInitialState, null);
                if (!_notEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect(r);
                _builder_1.append(_initialEffect, "");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_1.append("[");
                String _name_5 = parent.getName();
                String _upperCase_4 = _name_5.toUpperCase();
                _builder_1.append(_upperCase_4, "");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_1.append("[");
                EList _regions_2 = parent.getRegions();
                int _indexOf_1 = _regions_2.indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1, "");
                _builder_1.append("] = ");
                State _findInitialState_1 = TransformationUtil.findInitialState(r);
                String _name_6 = _findInitialState_1.getName();
                String _upperCase_5 = _name_6.toUpperCase();
                _builder_1.append(_upperCase_5, "");
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                State _findInitialState_2 = TransformationUtil.findInitialState(r);
                String _generateEnteringSubStates = this.generateEnteringSubStates(_findInitialState_2, true);
                _builder_1.append(_generateEnteringSubStates, "");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Region _container_1 = child.getContainer();
                State _state = _container_1.getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1, "");
                    _builder_1.newLineIfNotEmpty();
                } else {
                    EList _regions_3 = parent.getRegions();
                    Region _head = (Region)IterableExtensions.head((Iterable)_regions_3);
                    EList _subvertices_1 = _head.getSubvertices();
                    Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            List _transitiveSubStates = SM2ClassesTransformationCore.this.transitiveSubStates(it);
                            return _transitiveSubStates.contains(child);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_1);
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)_filter_3);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_1.append("[");
                    String _name_7 = parent.getName();
                    String _upperCase_6 = _name_7.toUpperCase();
                    _builder_1.append(_upperCase_6, "");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_1.append("[0] = ");
                    String _name_8 = nextParent_1.getName();
                    String _upperCase_7 = _name_8.toUpperCase();
                    _builder_1.append(_upperCase_7, "");
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1, "");
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    public String generateCompletionCall(State state) {
        StringConcatenation _builder = new StringConcatenation();
        String callCompletionEvent = _builder.toString();
        Region _container = state.getContainer();
        State composite = _container.getState();
        boolean _equals = Objects.equal((Object)composite, null);
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            callCompletionEvent = _builder_1.toString();
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("if (");
            EList _regions = composite.getRegions();
            boolean _hasElements = false;
            for (Region r : _regions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" && ", "");
                }
                _builder_2.append("(");
                _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_2.append("[");
                String _name = composite.getName();
                String _upperCase = _name.toUpperCase();
                _builder_2.append(_upperCase, "");
                _builder_2.append("_ID].");
                _builder_2.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_2.append("[");
                EList _regions_1 = composite.getRegions();
                int _indexOf = _regions_1.indexOf((Object)r);
                _builder_2.append((Object)_indexOf, "");
                _builder_2.append("] == ");
                _builder_2.append(SMCodeGeneratorConstants.STATE_MAX, "");
                _builder_2.append(")");
            }
            _builder_2.append(") {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            _builder_2.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
            _builder_2.append(".push(statemachine::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
            String _name_1 = composite.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder_2.append(_upperCase_1, "\t");
            _builder_2.append("_ID);");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}");
            callCompletionEvent = _builder_2.toString();
        }
        return callCompletionEvent;
    }

    public TransitionGraph calculateTransitionGraphs(final State s, final Transition t) {
        TransitionGraph ret = new TransitionGraph();
        Vertex _target = t.getTarget();
        ret.P.add((Pseudostate)_target);
        ret.T.add(t);
        ret.S.add(s);
        Vertex _target_1 = t.getTarget();
        Pseudostate target = (Pseudostate)_target_1;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            EList _incomings = target.getIncomings();
            Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    Vertex _source = it.getSource();
                    Region _container = _source.getContainer();
                    State _state = _container.getState();
                    Region _container_1 = s.getContainer();
                    State _state_1 = _container_1.getState();
                    return Objects.equal((Object)_state, (Object)_state_1);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_incomings, (Functions.Function1)_function);
            List ins = IterableExtensions.toList((Iterable)_filter);
            Functions.Function1<Transition, Vertex> _function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            };
            List _map = ListExtensions.map((List)ins, (Functions.Function1)_function_1);
            Iterable _filter_1 = Iterables.filter((Iterable)_map, State.class);
            Iterables.addAll(ret.S, (Iterable)_filter_1);
            ret.T.addAll(ins);
        }
        Vertex _target_2 = t.getTarget();
        List<Transition> nexts = this.findTrans(_target_2);
        ret.T.addAll(nexts);
        Functions.Function1<Transition, Vertex> _function_2 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return t.getTarget();
            }
        };
        List _map_1 = ListExtensions.map(nexts, (Functions.Function1)_function_2);
        Iterable _filter_2 = Iterables.filter((Iterable)_map_1, Pseudostate.class);
        Functions.Function1<Pseudostate, Boolean> _function_3 = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                boolean _or = false;
                PseudostateKind _kind = it.getKind();
                boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.DEEP_HISTORY_LITERAL);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _equals_1;
                    PseudostateKind _kind_1 = it.getKind();
                    _or = _equals_1 = Objects.equal((Object)_kind_1, (Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
                }
                return _or;
            }
        };
        Iterable H = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)_function_3);
        Iterables.addAll(ret.P, (Iterable)H);
        Functions.Function1<Transition, Vertex> _function_4 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getSource();
            }
        };
        List _map_2 = ListExtensions.map(nexts, (Functions.Function1)_function_4);
        Iterable _filter_3 = Iterables.filter((Iterable)_map_2, Pseudostate.class);
        Iterables.addAll(ret.P, (Iterable)_filter_3);
        Functions.Function1<Transition, Vertex> _function_5 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getTarget();
            }
        };
        List _map_3 = ListExtensions.map(nexts, (Functions.Function1)_function_5);
        Iterable _filter_4 = Iterables.filter((Iterable)_map_3, State.class);
        Iterables.addAll(ret.L, (Iterable)_filter_4);
        return ret;
    }

    public List<Transition> findTrans(Vertex v) {
        UniqueEList ret = new UniqueEList();
        EList _outgoings = v.getOutgoings();
        ret.addAll((Collection)_outgoings);
        EList _outgoings_1 = v.getOutgoings();
        for (Transition out : _outgoings_1) {
            boolean _not;
            Vertex _target = out.getTarget();
            boolean bl = _not = !(_target instanceof State);
            if (!_not) continue;
            Vertex _target_1 = out.getTarget();
            List<Transition> _findTrans = this.findTrans(_target_1);
            ret.addAll(_findTrans);
        }
        return ret;
    }

    public List<State> getRootStates(List<State> states) {
        ArrayList<State> ret = new ArrayList<State>();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                Region _container = it.getContainer();
                return Objects.equal((Object)_container, (Object)SM2ClassesTransformationCore.this.topRegion);
            }
        };
        Iterable _filter = IterableExtensions.filter(states, (Functions.Function1)_function);
        Iterables.addAll(ret, (Iterable)_filter);
        return ret;
    }

    public State getRootState(State state) {
        State ret = state;
        while (!Objects.equal((Object)ret.getContainer().getState(), null)) {
            State _state;
            Region _container = ret.getContainer();
            ret = _state = _container.getState();
        }
        return ret;
    }

    public int getRegionNumber(State child) {
        Region _container = child.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            return 0;
        }
        Region _container_1 = child.getContainer();
        State _state = _container_1.getState();
        EList _regions = _state.getRegions();
        Region _container_2 = child.getContainer();
        return _regions.indexOf((Object)_container_2);
    }

    @Deprecated
    public String generateHierarchy(List<State> hie, List<State> ins, int mode, List<Transition> ts) {
        boolean _equals;
        String ret = "";
        ArrayList<State> tmpHie = new ArrayList<State>();
        tmpHie.addAll(hie);
        int _size = tmpHie.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            if (mode == 0) {
                StringConcatenation _builder = new StringConcatenation();
                boolean _hasElements = false;
                for (final State s : ins) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)" else ", "");
                    }
                    _builder.append("if (!isProcessed && ");
                    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder.append("[");
                    State _head = (State)IterableExtensions.head(tmpHie);
                    String _name = _head.getName();
                    String _upperCase = _name.toUpperCase();
                    _builder.append(_upperCase, "");
                    _builder.append("_ID].");
                    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder.append("[");
                    int _regionNumber = this.getRegionNumber(s);
                    _builder.append((Object)_regionNumber, "");
                    _builder.append("] == ");
                    String _name_1 = s.getName();
                    String _upperCase_1 = _name_1.toUpperCase();
                    _builder.append(_upperCase_1, "");
                    _builder.append("_ID) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)s);
                        }
                    };
                    Iterable _filter = IterableExtensions.filter(ts, (Functions.Function1)_function);
                    Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_filter);
                    String _generateTransitionCode = this.eventTransform.generateTransitionCode(s, _head_1);
                    _builder.append(_generateTransitionCode, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                }
                ret = _builder.toString();
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("if (isProcessed) {");
                _builder_1.newLine();
                boolean _hasElements_1 = false;
                for (final State s_1 : ins) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                    _builder_1.append("[");
                    State _head_2 = (State)IterableExtensions.head(tmpHie);
                    String _name_2 = _head_2.getName();
                    String _upperCase_2 = _name_2.toUpperCase();
                    _builder_1.append(_upperCase_2, "\t");
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
                    _builder_1.append("[");
                    int _regionNumber_1 = this.getRegionNumber(s_1);
                    _builder_1.append((Object)_regionNumber_1, "\t");
                    _builder_1.append("] == ");
                    String _name_3 = s_1.getName();
                    String _upperCase_3 = _name_3.toUpperCase();
                    _builder_1.append(_upperCase_3, "\t");
                    _builder_1.append("_ID) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)s_1);
                        }
                    };
                    Iterable _filter_1 = IterableExtensions.filter(ts, (Functions.Function1)_function_1);
                    Transition _head_3 = (Transition)IterableExtensions.head((Iterable)_filter_1);
                    String _generateTransitionCode_1 = this.eventTransform.generateTransitionCode(s_1, _head_3);
                    _builder_1.append(_generateTransitionCode_1, "\t\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("}");
                _builder_1.newLine();
                ret = _builder_1.toString();
            }
        } else {
            boolean _greaterThan;
            int _size_1 = tmpHie.size();
            boolean bl2 = _greaterThan = _size_1 > 1;
            if (_greaterThan) {
                State head = (State)IterableExtensions.head(tmpHie);
                tmpHie.remove(head);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("if (!isProcessed && ");
                _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_2.append("[");
                String _name_4 = head.getName();
                String _upperCase_4 = _name_4.toUpperCase();
                _builder_2.append(_upperCase_4, "");
                _builder_2.append("_ID].");
                _builder_2.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_2.append("[");
                State _head_4 = (State)IterableExtensions.head(tmpHie);
                int _regionNumber_2 = this.getRegionNumber(_head_4);
                _builder_2.append((Object)_regionNumber_2, "");
                _builder_2.append("] == ");
                State _head_5 = (State)IterableExtensions.head(tmpHie);
                String _name_5 = _head_5.getName();
                String _upperCase_5 = _name_5.toUpperCase();
                _builder_2.append(_upperCase_5, "");
                _builder_2.append("_ID) {");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                String _generateHierarchy = this.generateHierarchy(tmpHie, ins, mode, ts);
                _builder_2.append(_generateHierarchy, "\t");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("}");
                ret = _builder_2.toString();
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                boolean _hasElements_2 = false;
                for (final State s_2 : ins) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_3.appendImmediate((Object)" else ", "");
                    }
                    _builder_3.newLineIfNotEmpty();
                    Functions.Function1<Transition, Boolean> _function_2 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)s_2);
                        }
                    };
                    Iterable _filter_2 = IterableExtensions.filter(ts, (Functions.Function1)_function_2);
                    Transition _head_6 = (Transition)IterableExtensions.head((Iterable)_filter_2);
                    String _generateTransitionCode_2 = this.eventTransform.generateTransitionCode(s_2, _head_6);
                    _builder_3.append(_generateTransitionCode_2, "");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("\t\t\t\t");
                }
                ret = _builder_3.toString();
            }
        }
        return ret;
    }

    public List<State> getTransitiveParentStates(Vertex s) {
        ArrayList<State> ret = new ArrayList<State>();
        Region _container = s.getContainer();
        State parent = _container.getState();
        while (!Objects.equal((Object)parent, null)) {
            State _state;
            ret.add(parent);
            Region _container_1 = parent.getContainer();
            parent = _state = _container_1.getState();
        }
        return ret;
    }

    public List<State> getStateHierarchy(State s) {
        ArrayList<State> ret = new ArrayList<State>();
        Region _container = s.getContainer();
        State parent = _container.getState();
        while (!Objects.equal((Object)parent, null) && !Objects.equal((Object)parent.getContainer(), (Object)this.topRegion)) {
            State _state;
            ret.add(0, parent);
            Region _container_1 = parent.getContainer();
            parent = _state = _container_1.getState();
        }
        return ret;
    }

    public List<Map.Entry<List<State>, Integer>> calculateAcceptingStates(State parent, final List<State> acceptingStates) {
        List<State> transitiveSubstates = this.transitiveSubStates(parent);
        final ArrayList<State> retTmp = new ArrayList<State>();
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _contains = acceptingStates.contains(it);
                if (_contains) {
                    retTmp.add(it);
                }
            }
        };
        transitiveSubstates.forEach(_function);
        ArrayList<Map.Entry<List<State>, Integer>> ret = new ArrayList<Map.Entry<List<State>, Integer>>();
        final HashMap map = new HashMap();
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _not;
                int depth = SM2ClassesTransformationCore.this.calculateDepth(it);
                boolean _containsKey = map.containsKey(depth);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    ArrayList _arrayList = new ArrayList();
                    map.put(depth, _arrayList);
                }
                List _get = (List)map.get(depth);
                _get.add(it);
            }
        };
        retTmp.forEach(_function_1);
        Set _keySet = map.keySet();
        List _list = IterableExtensions.toList(_keySet);
        int maxDepth = this.findMax(_list);
        int i = 0;
        while (i <= maxDepth) {
            boolean _containsKey = map.containsKey(i);
            if (_containsKey) {
                boolean _equals;
                List _get = (List)map.get(i);
                int _size = _get.size();
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    ArrayList newList = new ArrayList();
                    List _get_1 = (List)map.get(i);
                    newList.addAll(_get_1);
                    HashMap mapEntry = new HashMap();
                    mapEntry.put(newList, 0);
                    Set _entrySet = mapEntry.entrySet();
                    ret.addAll(_entrySet);
                } else {
                    HashMap m = new HashMap();
                    List _get_2 = (List)map.get(i);
                    for (State s : _get_2) {
                        boolean _not;
                        Region _container = s.getContainer();
                        State _state = _container.getState();
                        boolean _containsKey_1 = m.containsKey(_state);
                        boolean bl2 = _not = !_containsKey_1;
                        if (_not) {
                            Region _container_1 = s.getContainer();
                            State _state_1 = _container_1.getState();
                            ArrayList _arrayList = new ArrayList();
                            m.put(_state_1, _arrayList);
                        }
                        Region _container_2 = s.getContainer();
                        State _state_2 = _container_2.getState();
                        List _get_3 = (List)m.get(_state_2);
                        _get_3.add(s);
                    }
                    Set _entrySet_1 = m.entrySet();
                    for (Map.Entry en : _entrySet_1) {
                        HashMap mapEntry_1 = new HashMap();
                        ArrayList newList_1 = new ArrayList();
                        List _value = (List)en.getValue();
                        newList_1.addAll(_value);
                        State _key = (State)en.getKey();
                        boolean _isOrthogonal = _key.isOrthogonal();
                        if (_isOrthogonal) {
                            mapEntry_1.put(newList_1, 1);
                            Set _entrySet_2 = mapEntry_1.entrySet();
                            ret.addAll(_entrySet_2);
                            continue;
                        }
                        mapEntry_1.put(newList_1, 0);
                        Set _entrySet_3 = mapEntry_1.entrySet();
                        ret.addAll(_entrySet_3);
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    private int findMax(List<Integer> l) {
        Integer ret = (Integer)IterableExtensions.head(l);
        for (Integer i : l) {
            boolean _greaterThan;
            boolean bl = _greaterThan = i.compareTo(ret) > 0;
            if (!_greaterThan) continue;
            ret = i;
        }
        return ret;
    }

    public int calculateDepth(State s) {
        Region _container = s.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            return 1;
        }
        Region _container_1 = s.getContainer();
        State _state = _container_1.getState();
        int _calculateDepth = this.calculateDepth(_state);
        return 1 + _calculateDepth;
    }

    public String generateDelegation(State s, List<Transition> transitions) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        boolean _checkTransitiveSubStatesAcceptEvent = this.checkTransitiveSubStatesAcceptEvent(s, transitions);
        if (_checkTransitiveSubStatesAcceptEvent && !(_isOrthogonal = s.isOrthogonal())) {
            _builder.newLine();
        }
        return _builder.toString();
    }

    public boolean checkSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        final ArrayList substates = new ArrayList();
        EList _regions = parent.getRegions();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                EList _subvertices = it.getSubvertices();
                Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                Iterables.addAll((Collection)substates, (Iterable)_filter);
            }
        };
        _regions.forEach((Consumer)_function);
        boolean ret = false;
        for (Transition t : transitions) {
            boolean _and = false;
            if (ret) {
                _and = false;
            } else {
                boolean _contains;
                Vertex _source = t.getSource();
                _and = _contains = substates.contains(_source);
            }
            if (!_and) continue;
            ret = true;
        }
        return ret;
    }

    public boolean checkTransitiveSubStatesAcceptEvent(State parent, List<Transition> transitions) {
        List<State> substates = TransformationUtil.transitiveSubStates(parent);
        boolean ret = false;
        for (Transition t : transitions) {
            boolean _and = false;
            if (ret) {
                _and = false;
            } else {
                boolean _contains;
                Vertex _source = t.getSource();
                _and = _contains = substates.contains(_source);
            }
            if (!_and) continue;
            ret = true;
        }
        return ret;
    }

    public Dependency createStateStruct() {
        Dependency _xblockexpression = null;
        this.superContext.createOwnedOperation("entry_dft", null, null);
        this.superContext.createOwnedOperation("exit_dft", null, null);
        this.superContext.createOwnedOperation("doActivity_dft", null, null);
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.STATE_STRUCT_NAME, UMLPackage.Literals.PRIMITIVE_TYPE);
        this.stateStruct = _createNestedClassifier;
        StereotypeUtil.apply((Element)this.stateStruct, Typedef.class);
        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)this.stateStruct, Typedef.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        _builder.append(SMCodeGeneratorConstants.STATE_STRUCT_NAME, "");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append(" is configured as the maximum number of orthogonal regions a composite states can have");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsigned int /*");
        _builder.append(SMCodeGeneratorConstants.STATE_ID_ENUM, "\t");
        _builder.append("*/ ");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
        _builder.append("[");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append("]; //for history states");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("unsigned int /*");
        _builder.append(SMCodeGeneratorConstants.STATE_ID_ENUM, "\t");
        _builder.append("*/ ");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name = this.superContext.getName();
        _builder.append(_name, "\t");
        _builder.append("::*entry)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name_1 = this.superContext.getName();
        _builder.append(_name_1, "\t");
        _builder.append("::*exit)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void (");
        String _name_2 = this.superContext.getName();
        _builder.append(_name_2, "\t");
        _builder.append("::*doActivity)();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.STATE_STRUCT_NAME, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("entry = &");
        String _name_3 = this.superContext.getName();
        _builder.append(_name_3, "\t\t");
        _builder.append("::entry_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("exit = &");
        String _name_4 = this.superContext.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("::exit_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("doActivity = &");
        String _name_5 = this.superContext.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("::doActivity_dft;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for(int i = 0; i < ");
        _builder.append((Object)this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t\t");
        _builder.append("; i++) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t\t\t");
        _builder.append("[i] = ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t\t\t");
        _builder.append("[i] = ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("} ");
        _stereotypeApplication.setDefinition(_builder.toString());
        _xblockexpression = this.stateStruct.createDependency((NamedElement)this.stateIdEnum);
        return _xblockexpression;
    }

    public String getFptrCall(String attr, boolean isPointer, String fptrName) {
        if (isPointer) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(this->*");
            _builder.append(attr, "");
            _builder.append("->");
            _builder.append(fptrName, "");
            _builder.append(")()");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(this->*");
        _builder_1.append(attr, "");
        _builder_1.append(".");
        _builder_1.append(fptrName, "");
        _builder_1.append(")()");
        return _builder_1.toString();
    }

    private Map<Event, List<Transition>> getAllEvents(Region region) {
        final LinkedHashMap<Event, List<Transition>> ret = new LinkedHashMap<Event, List<Transition>>();
        EList subVertices = region.getSubvertices();
        EList transitions = region.getTransitions();
        Consumer<Transition> _function = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                EList _triggers = it.getTriggers();
                for (Trigger trigger : _triggers) {
                    Event _event_3;
                    List _get;
                    boolean _contains;
                    boolean _not_1;
                    boolean _not;
                    boolean _notEquals;
                    Event _event = trigger.getEvent();
                    boolean bl = _notEquals = !Objects.equal((Object)_event, null);
                    if (!_notEquals) continue;
                    Event _event_1 = trigger.getEvent();
                    boolean _containsKey = ret.containsKey(_event_1);
                    boolean bl2 = _not = !_containsKey;
                    if (_not) {
                        Event _event_2 = trigger.getEvent();
                        ArrayList _arrayList = new ArrayList();
                        ret.put(_event_2, _arrayList);
                    }
                    boolean bl3 = _not_1 = !(_contains = (_get = (List)ret.get(_event_3 = trigger.getEvent())).contains(it));
                    if (!_not_1) continue;
                    Event _event_4 = trigger.getEvent();
                    List _get_1 = (List)ret.get(_event_4);
                    _get_1.add(it);
                }
            }
        };
        transitions.forEach((Consumer)_function);
        Iterable _filter = Iterables.filter((Iterable)subVertices, State.class);
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                EList _regions = it.getRegions();
                for (Region subRe : _regions) {
                    Map m = SM2ClassesTransformationCore.this.getAllEvents(subRe);
                    Set _entrySet = m.entrySet();
                    for (Map.Entry e : _entrySet) {
                        boolean _not;
                        Event _key = (Event)e.getKey();
                        boolean _containsKey = ret.containsKey(_key);
                        boolean bl = _not = !_containsKey;
                        if (_not) {
                            Event _key_1 = (Event)e.getKey();
                            List _value = (List)e.getValue();
                            ret.put(_key_1, _value);
                            continue;
                        }
                        Event _key_2 = (Event)e.getKey();
                        List _get = (List)ret.get(_key_2);
                        List _value_1 = (List)e.getValue();
                        _get.addAll(_value_1);
                    }
                }
            }
        };
        _filter.forEach(_function_1);
        return ret;
    }

    private void getAllActionsTransitionsStates(Region region) {
        boolean _not;
        boolean _contains = this.regions.contains(region);
        boolean bl = _not = !_contains;
        if (_not) {
            this.regions.add(region);
        }
        EList _transitions = region.getTransitions();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Vertex _target;
                boolean _notEquals_1;
                boolean _notEquals;
                boolean _and = false;
                Vertex _source = it.getSource();
                boolean bl = _notEquals = !Objects.equal((Object)_source, null);
                _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_target = it.getTarget()), null));
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_transitions, (Functions.Function1)_function);
        Iterables.addAll(this.transitions, (Iterable)_filter);
        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                boolean _contains = SM2ClassesTransformationCore.this.parallelTransitions.contains(it);
                return !_contains;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(this.transitions, (Functions.Function1)_function_1);
        Consumer<Transition> _function_2 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                Vertex _target;
                Vertex _source = it.getSource();
                if (_source instanceof Pseudostate) {
                    Behavior _effect;
                    boolean _notEquals;
                    boolean _and = false;
                    Vertex _source_1 = it.getSource();
                    PseudostateKind _kind = ((Pseudostate)_source_1).getKind();
                    boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.FORK_LITERAL);
                    _and = !_equals ? false : (_notEquals = !Objects.equal((Object)(_effect = it.getEffect()), null));
                    if (_and) {
                        SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                    }
                }
                if ((_target = it.getTarget()) instanceof Pseudostate) {
                    Behavior _effect_1;
                    boolean _notEquals_1;
                    boolean _and_1 = false;
                    Vertex _target_1 = it.getTarget();
                    PseudostateKind _kind_1 = ((Pseudostate)_target_1).getKind();
                    boolean _equals_1 = Objects.equal((Object)_kind_1, (Object)PseudostateKind.JOIN_LITERAL);
                    _and_1 = !_equals_1 ? false : (_notEquals_1 = !Objects.equal((Object)(_effect_1 = it.getEffect()), null));
                    if (_and_1) {
                        SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                    }
                }
            }
        };
        _filter_1.forEach(_function_2);
        EList _subvertices = region.getSubvertices();
        for (Vertex s : _subvertices) {
            Behavior _doActivity;
            boolean _notEquals_2;
            boolean _notEquals_1;
            boolean _notEquals;
            this.vertexes.add(s);
            if (!(s instanceof State)) continue;
            if (!(s instanceof FinalState)) {
                this.states.add((State)s);
            }
            boolean _and = false;
            Behavior _entry = ((State)s).getEntry();
            boolean bl2 = _notEquals = !Objects.equal((Object)_entry, null);
            if (!_notEquals) {
                _and = false;
            } else {
                Behavior _entry_1 = ((State)s).getEntry();
                _and = _entry_1 instanceof OpaqueBehavior;
            }
            if (_and) {
                Behavior _entry_2 = ((State)s).getEntry();
                this.actions.add((OpaqueBehavior)_entry_2);
            }
            boolean _and_1 = false;
            Behavior _exit = ((State)s).getExit();
            boolean bl3 = _notEquals_1 = !Objects.equal((Object)_exit, null);
            if (!_notEquals_1) {
                _and_1 = false;
            } else {
                Behavior _exit_1 = ((State)s).getExit();
                _and_1 = _exit_1 instanceof OpaqueBehavior;
            }
            if (_and_1) {
                Behavior _exit_2 = ((State)s).getExit();
                this.actions.add((OpaqueBehavior)_exit_2);
            }
            boolean _and_2 = false;
            boolean _and_3 = false;
            _and_3 = !this.createDoActivity ? false : (_notEquals_2 = !Objects.equal((Object)(_doActivity = ((State)s).getDoActivity()), null));
            if (!_and_3) {
                _and_2 = false;
            } else {
                Behavior _doActivity_1 = ((State)s).getDoActivity();
                _and_2 = _doActivity_1 instanceof OpaqueBehavior;
            }
            if (_and_2) {
                Behavior _doActivity_2 = ((State)s).getDoActivity();
                this.actions.add((OpaqueBehavior)_doActivity_2);
            }
            EList _regions = ((State)s).getRegions();
            Consumer<Region> _function_3 = new Consumer<Region>(){

                @Override
                public void accept(Region it) {
                    SM2ClassesTransformationCore.this.getAllActionsTransitionsStates(it);
                }
            };
            _regions.forEach((Consumer)_function_3);
        }
    }

    private void createRegionMethods() {
        boolean _not;
        Region _get;
        StringConcatenation _builder_1;
        StringConcatenation _builder = new StringConcatenation();
        String macros = _builder.toString();
        int i = 0;
        while (i < this.regions.size()) {
            boolean _notEquals;
            _builder_1 = new StringConcatenation();
            _builder_1.append(macros, "");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("#define ");
            _get = this.regions.get(i);
            String _regionMacroName = this.getRegionMacroName(_get);
            _builder_1.append(_regionMacroName, "");
            _builder_1.append(" (");
            _builder_1.append((Object)i, "");
            _builder_1.append(")");
            macros = _builder_1.toString();
            Region _get_1 = this.regions.get(i);
            this.createRegionMethod(_get_1);
            Region _get_2 = this.regions.get(i);
            this.createRegionMethodExit(_get_2);
            boolean _and = false;
            Region _get_3 = this.regions.get(i);
            State _state = _get_3.getState();
            boolean bl = _notEquals = !Objects.equal((Object)_state, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isOrthogonal;
                Region _get_4 = this.regions.get(i);
                State _state_1 = _get_4.getState();
                _and = _isOrthogonal = _state_1.isOrthogonal();
            }
            if (_and) {
                Region _get_5 = this.regions.get(i);
                this.orthogonalRegions.add(_get_5);
            }
            ++i;
        }
        i = 0;
        while (i < this.orthogonalRegions.size()) {
            _builder_1 = new StringConcatenation();
            _builder_1.append("#define ");
            _get = this.orthogonalRegions.get(i);
            String _regionMacroId = this.getRegionMacroId(_get);
            _builder_1.append(_regionMacroId, "");
            _builder_1.append(" (");
            _builder_1.append((Object)i, "");
            _builder_1.append(")");
            this.appendIncludeHeader(_builder_1.toString());
            ++i;
        }
        boolean _isApplied = StereotypeUtil.isApplied((Element)this.superContext, Include.class);
        boolean bl = _not = !_isApplied;
        if (_not) {
            StereotypeUtil.apply((Element)this.superContext, Include.class);
        }
        Include _stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        String header = _stereotypeApplication.getHeader();
        Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        StringConcatenation _builder_12 = new StringConcatenation();
        _builder_12.append(header, "");
        _builder_12.newLineIfNotEmpty();
        _builder_12.append(macros, "");
        _stereotypeApplication_1.setHeader(_builder_12.toString());
    }

    public String getRegionMacroId(Region r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("REGION_ID_");
        State _state = r.getState();
        String _name = _state.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_");
        String _name_1 = r.getName();
        String _upperCase_1 = _name_1.toUpperCase();
        _builder.append(_upperCase_1, "");
        return _builder.toString();
    }

    public String getRegionMethodName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            StateMachine _stateMachine = r.getStateMachine();
            String _name = _stateMachine.getName();
            _builder.append(_name, "");
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1, "");
            _builder.append("_Enter");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        State _state = r.getState();
        String _name_2 = _state.getName();
        _builder_1.append(_name_2, "");
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3, "");
        _builder_1.append("_Enter");
        return _builder_1.toString();
    }

    public String getRegionMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            StateMachine _stateMachine = r.getStateMachine();
            String _name = _stateMachine.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_");
            String _name_1 = r.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        State _state = r.getState();
        String _name_2 = _state.getName();
        String _upperCase_2 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_2, "");
        _builder_1.append("_");
        String _name_3 = r.getName();
        String _upperCase_3 = _name_3.toUpperCase();
        _builder_1.append(_upperCase_3, "");
        return _builder_1.toString();
    }

    public String getVertexMacroName(Vertex v) {
        Region _container = v.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            StateMachine _stateMachine = this.topRegion.getStateMachine();
            String _name = _stateMachine.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_");
            Region _container_1 = v.getContainer();
            String _name_1 = _container_1.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "");
            _builder.append("_");
            String _name_2 = v.getName();
            String _upperCase_2 = _name_2.toUpperCase();
            _builder.append(_upperCase_2, "");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        Region _container_2 = v.getContainer();
        State _state = _container_2.getState();
        String _name_3 = _state.getName();
        String _upperCase_3 = _name_3.toUpperCase();
        _builder_1.append(_upperCase_3, "");
        _builder_1.append("_");
        Region _container_3 = v.getContainer();
        String _name_4 = _container_3.getName();
        String _upperCase_4 = _name_4.toUpperCase();
        _builder_1.append(_upperCase_4, "");
        _builder_1.append("_");
        String _name_5 = v.getName();
        String _upperCase_5 = _name_5.toUpperCase();
        _builder_1.append(_upperCase_5, "");
        return _builder_1.toString();
    }

    public String getInitialMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            StateMachine _stateMachine = r.getStateMachine();
            String _name = _stateMachine.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_");
            String _name_1 = r.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "");
            _builder.append("_DEFAULT");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        State _state = r.getState();
        String _name_2 = _state.getName();
        String _upperCase_2 = _name_2.toUpperCase();
        _builder_1.append(_upperCase_2, "");
        _builder_1.append("_");
        String _name_3 = r.getName();
        String _upperCase_3 = _name_3.toUpperCase();
        _builder_1.append(_upperCase_3, "");
        _builder_1.append("_DEFAULT");
        return _builder_1.toString();
    }

    private ArrayList<Vertex> getSubVertexes(State state) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        EList _regions = state.getRegions();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                EList _subvertices = it.getSubvertices();
                ret.addAll(_subvertices);
            }
        };
        _regions.forEach((Consumer)_function);
        return ret;
    }

    private void createRegionMethod(Region r) {
        boolean _notEquals_1;
        boolean _notEquals;
        ArrayList<Vertex> endVertexs = new ArrayList<Vertex>();
        HashMap state2TransSubVertices = new HashMap();
        EList _subvertices = r.getSubvertices();
        for (final Vertex v : _subvertices) {
            boolean _greaterThan;
            Functions.Function1<Transition, Vertex> _function_1;
            Functions.Function1<Transition, Boolean> _function;
            EList _incomings = v.getIncomings();
            Iterable incomings = IterableExtensions.filter((Iterable)_incomings, (Functions.Function1)(_function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    Region _container_1;
                    boolean _notEquals;
                    boolean _or = false;
                    Region _container = it.getContainer();
                    boolean bl = _notEquals = !Objects.equal((Object)_container, (Object)(_container_1 = v.getContainer()));
                    if (_notEquals) {
                        _or = true;
                    } else {
                        boolean _and = false;
                        Vertex _source = it.getSource();
                        if (!(_source instanceof State)) {
                            _and = false;
                        } else {
                            boolean _contains;
                            Vertex _source_1 = it.getSource();
                            ArrayList _subVertexes = SM2ClassesTransformationCore.this.getSubVertexes((State)_source_1);
                            Vertex _target = it.getTarget();
                            _and = _contains = _subVertexes.contains(_target);
                        }
                        _or = _and;
                    }
                    return _or;
                }
            }));
            Iterable sources = IterableExtensions.map((Iterable)incomings, (Functions.Function1)(_function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            }));
            int _size = IterableExtensions.size((Iterable)sources);
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                boolean _not;
                boolean _contains = endVertexs.contains(v);
                boolean bl2 = _not = !_contains;
                if (_not) {
                    endVertexs.add(v);
                }
            }
            if (!(v instanceof State)) continue;
            final ArrayList subvertices = new ArrayList();
            EList _regions = ((State)v).getRegions();
            Consumer<Region> _function_2 = new Consumer<Region>(){

                @Override
                public void accept(Region it) {
                    List<Vertex> _allSubVertexes = SM2ClassesTransformationCore.this.allSubVertexes(it);
                    subvertices.addAll(_allSubVertexes);
                }
            };
            _regions.forEach((Consumer)_function_2);
            for (Vertex subV : subvertices) {
                boolean _not_1;
                boolean _greaterThan_1;
                Functions.Function1<Vertex, Boolean> _function_4;
                Functions.Function1<Transition, Vertex> _function_3;
                EList _incomings_1 = subV.getIncomings();
                List sourcesOfIncomings = ListExtensions.map((List)_incomings_1, (Functions.Function1)(_function_3 = new Functions.Function1<Transition, Vertex>(){

                    public Vertex apply(Transition it) {
                        return it.getSource();
                    }
                }));
                Iterable sourcesOutSideOfR = IterableExtensions.filter((Iterable)sourcesOfIncomings, (Functions.Function1)(_function_4 = new Functions.Function1<Vertex, Boolean>(){

                    public Boolean apply(Vertex it) {
                        boolean _contains = subvertices.contains(it);
                        return !_contains;
                    }
                }));
                int _size_1 = IterableExtensions.size((Iterable)sourcesOutSideOfR);
                boolean bl3 = _greaterThan_1 = _size_1 > 0;
                if (!_greaterThan_1) continue;
                boolean _containsKey = state2TransSubVertices.containsKey(v);
                boolean bl4 = _not_1 = !_containsKey;
                if (_not_1) {
                    ArrayList _arrayList = new ArrayList();
                    state2TransSubVertices.put((State)v, _arrayList);
                }
                List _get = (List)state2TransSubVertices.get(v);
                _get.add(subV);
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        String switchBody = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String body = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        String macros = _builder_2.toString();
        Pseudostate _firstPseudoState = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        boolean bl = _notEquals = !Objects.equal((Object)_firstPseudoState, null);
        if (_notEquals) {
            boolean _isComposite;
            boolean _hasTriggerlessTransition;
            Pseudostate initialP = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
            EList _outgoings = initialP.getOutgoings();
            Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings);
            Vertex _target = _head.getTarget();
            State initialState = (State)_target;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder_3.append("[");
            String _name = initialState.getName();
            String _upperCase = _name.toUpperCase();
            _builder_3.append(_upperCase, "");
            _builder_3.append("_ID]");
            String pAttr = _builder_3.toString();
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(macros, "");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("#define ");
            String _initialMacroName = this.getInitialMacroName(r);
            _builder_4.append(_initialMacroName, "");
            _builder_4.append(" (0)");
            macros = _builder_4.toString();
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append(body, "");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("case ");
            String _initialMacroName_1 = this.getInitialMacroName(r);
            _builder_5.append(_initialMacroName_1, "");
            _builder_5.append(":");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            EList _outgoings_1 = initialP.getOutgoings();
            Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
            String _transitionEffect = TransformationUtil.getTransitionEffect(_head_1);
            _builder_5.append(_transitionEffect, "\t");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            String _generateChangeState = this.generateChangeState(initialState);
            _builder_5.append(_generateChangeState, "\t");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.newLine();
            Behavior _entry = initialState.getEntry();
            boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(_entry);
            if (_isBehaviorExist) {
                _builder_5.append("\t");
                String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
                _builder_5.append(_fptrCall, "\t");
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
                _builder_5.append("\t");
                _builder_5.append("//starting the counters for time events");
                _builder_5.newLine();
            }
            _builder_5.append("\t");
            String _generateActivateTimeEvent = this.generateActivateTimeEvent(initialState);
            _builder_5.append(_generateActivateTimeEvent, "\t");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.newLine();
            boolean _or = false;
            Behavior _doActivity = initialState.getDoActivity();
            boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(_doActivity);
            _or = _isBehaviorExist_1 ? true : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(initialState));
            if (_or) {
                _builder_5.append("\t");
                _builder_5.append("//start activity of ");
                String _name_1 = initialState.getName();
                _builder_5.append(_name_1, "\t");
                _builder_5.append(" by calling setFlag");
                _builder_5.newLineIfNotEmpty();
                _builder_5.append("\t");
                _builder_5.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
                _builder_5.append("(");
                String _name_2 = initialState.getName();
                String _upperCase_1 = _name_2.toUpperCase();
                _builder_5.append(_upperCase_1, "\t");
                _builder_5.append("_ID, ");
                _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
                _builder_5.append(", true);");
                _builder_5.newLineIfNotEmpty();
            }
            if (_isComposite = initialState.isComposite()) {
                boolean _isOrthogonal = initialState.isOrthogonal();
                if (_isOrthogonal) {
                    _builder_5.append("\t");
                    _builder_5.append("//TODO: fork region funtions");
                    _builder_5.newLine();
                    EList _regions = initialState.getRegions();
                    for (Region subRegion : _regions) {
                        _builder_5.append("\t");
                        _builder_5.append("//");
                        String _regionMethodName = this.getRegionMethodName(subRegion);
                        _builder_5.append(_regionMethodName, "\t");
                        _builder_5.append("(");
                        String _initialMacroName_2 = this.getInitialMacroName(subRegion);
                        _builder_5.append(_initialMacroName_2, "\t");
                        _builder_5.append(");");
                        _builder_5.newLineIfNotEmpty();
                        _builder_5.append("\t");
                        String _initialMacroName_3 = this.getInitialMacroName(subRegion);
                        String _generateForkCall = this.concurrency.generateForkCall(subRegion, true, _initialMacroName_3);
                        _builder_5.append(_generateForkCall, "\t");
                        _builder_5.newLineIfNotEmpty();
                    }
                    _builder_5.append("\t");
                    _builder_5.append("//TODO: join region functions");
                    _builder_5.newLine();
                    EList _regions_1 = initialState.getRegions();
                    for (Region subRegion_1 : _regions_1) {
                        _builder_5.append("\t");
                        _builder_5.append("//");
                        String _regionMethodName_1 = this.getRegionMethodName(subRegion_1);
                        _builder_5.append(_regionMethodName_1, "\t");
                        _builder_5.append("(");
                        String _initialMacroName_4 = this.getInitialMacroName(subRegion_1);
                        _builder_5.append(_initialMacroName_4, "\t");
                        _builder_5.append(");");
                        _builder_5.newLineIfNotEmpty();
                        _builder_5.append("\t");
                        String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, true);
                        _builder_5.append(_generateJoinCall, "\t");
                        _builder_5.newLineIfNotEmpty();
                    }
                } else {
                    _builder_5.append("\t");
                    EList _regions_2 = initialState.getRegions();
                    Region _head_2 = (Region)IterableExtensions.head((Iterable)_regions_2);
                    String _regionMethodName_2 = this.getRegionMethodName(_head_2);
                    _builder_5.append(_regionMethodName_2, "\t");
                    _builder_5.append("(");
                    EList _regions_3 = initialState.getRegions();
                    Region _head_3 = (Region)IterableExtensions.head((Iterable)_regions_3);
                    String _initialMacroName_5 = this.getInitialMacroName(_head_3);
                    _builder_5.append(_initialMacroName_5, "\t");
                    _builder_5.append(");");
                    _builder_5.newLineIfNotEmpty();
                }
            }
            _builder_5.append("\t");
            _builder_5.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("break;");
            body = _builder_5.toString();
        }
        int i = 0;
        while (i < endVertexs.size()) {
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append(macros, "");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append("#define ");
            Vertex _get = (Vertex)endVertexs.get(i);
            String _vertexMacroName = this.getVertexMacroName(_get);
            _builder_6.append(_vertexMacroName, "");
            _builder_6.append(" (");
            _builder_6.append((Object)(i + 1), "");
            _builder_6.append(")");
            macros = _builder_6.toString();
            ++i;
        }
        Include _stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        boolean _equals = Objects.equal((Object)_stereotypeApplication, null);
        if (_equals) {
            StereotypeUtil.apply((Element)this.superContext, Include.class);
        }
        Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        String header = _stereotypeApplication_1.getHeader();
        Include _stereotypeApplication_2 = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append(header, "");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append(macros, "");
        _stereotypeApplication_2.setHeader(_builder_6.toString());
        String _regionMethodName_3 = this.getRegionMethodName(r);
        Operation regionMethod = this.superContext.createOwnedOperation(_regionMethodName_3, null, null);
        regionMethod.createOwnedParameter(this.paramName, this.charType);
        for (Vertex v_1 : endVertexs) {
            if (v_1 instanceof State) {
                boolean _isComposite_1;
                boolean _hasTriggerlessTransition_1;
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_7.append("[");
                String _name_3 = ((State)v_1).getName();
                String _upperCase_2 = _name_3.toUpperCase();
                _builder_7.append(_upperCase_2, "");
                _builder_7.append("_ID]");
                String pAttr_1 = _builder_7.toString();
                StringConcatenation _builder_8 = new StringConcatenation();
                _builder_8.append(body, "");
                _builder_8.newLineIfNotEmpty();
                _builder_8.append("case ");
                String _vertexMacroName = this.getVertexMacroName(v_1);
                _builder_8.append(_vertexMacroName, "");
                _builder_8.append(":");
                _builder_8.newLineIfNotEmpty();
                _builder_8.append("\t");
                String _generateChangeState_1 = this.generateChangeState((State)v_1);
                _builder_8.append(_generateChangeState_1, "\t");
                _builder_8.newLineIfNotEmpty();
                Behavior _entry_1 = ((State)v_1).getEntry();
                boolean _isBehaviorExist_2 = TransformationUtil.isBehaviorExist(_entry_1);
                if (_isBehaviorExist_2) {
                    _builder_8.append("\t");
                    String _fptrCall_1 = this.getFptrCall(pAttr_1, false, SMCodeGeneratorConstants.ENTRY_NAME);
                    _builder_8.append(_fptrCall_1, "\t");
                    _builder_8.append(";");
                    _builder_8.newLineIfNotEmpty();
                }
                _builder_8.append("\t");
                _builder_8.append("//starting the counters for time events");
                _builder_8.newLine();
                _builder_8.append("\t");
                String _generateActivateTimeEvent_1 = this.generateActivateTimeEvent((State)v_1);
                _builder_8.append(_generateActivateTimeEvent_1, "\t");
                _builder_8.newLineIfNotEmpty();
                boolean _or_1 = false;
                Behavior _doActivity_1 = ((State)v_1).getDoActivity();
                boolean _isBehaviorExist_3 = TransformationUtil.isBehaviorExist(_doActivity_1);
                _or_1 = _isBehaviorExist_3 ? true : (_hasTriggerlessTransition_1 = TransformationUtil.hasTriggerlessTransition((State)v_1));
                if (_or_1) {
                    _builder_8.append("\t");
                    _builder_8.append("//start activity of ");
                    String _name_4 = ((State)v_1).getName();
                    _builder_8.append(_name_4, "\t");
                    _builder_8.append(" by calling setFlag");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t");
                    _builder_8.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
                    _builder_8.append("(");
                    String _name_5 = ((State)v_1).getName();
                    String _upperCase_3 = _name_5.toUpperCase();
                    _builder_8.append(_upperCase_3, "\t");
                    _builder_8.append("_ID, ");
                    _builder_8.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
                    _builder_8.append(", true);");
                    _builder_8.newLineIfNotEmpty();
                }
                if (_isComposite_1 = ((State)v_1).isComposite()) {
                    boolean _isOrthogonal_1 = ((State)v_1).isOrthogonal();
                    if (_isOrthogonal_1) {
                        _builder_8.append("\t");
                        _builder_8.append("//TODO: fork region funtions");
                        _builder_8.newLine();
                        EList _regions_4 = ((State)v_1).getRegions();
                        for (Region subRegion_2 : _regions_4) {
                            _builder_8.append("\t");
                            _builder_8.append("//");
                            String _regionMethodName_4 = this.getRegionMethodName(subRegion_2);
                            _builder_8.append(_regionMethodName_4, "\t");
                            _builder_8.append("(");
                            String _initialMacroName_6 = this.getInitialMacroName(subRegion_2);
                            _builder_8.append(_initialMacroName_6, "\t");
                            _builder_8.append(");");
                            _builder_8.newLineIfNotEmpty();
                            _builder_8.append("\t");
                            String _initialMacroName_7 = this.getInitialMacroName(subRegion_2);
                            String _generateForkCall_1 = this.concurrency.generateForkCall(subRegion_2, true, _initialMacroName_7);
                            _builder_8.append(_generateForkCall_1, "\t");
                            _builder_8.newLineIfNotEmpty();
                        }
                        _builder_8.append("\t");
                        _builder_8.append("//TODO: join region functions");
                        _builder_8.newLine();
                        EList _regions_5 = ((State)v_1).getRegions();
                        for (Region subRegion_3 : _regions_5) {
                            _builder_8.append("\t");
                            _builder_8.append("//");
                            String _regionMethodName_5 = this.getRegionMethodName(subRegion_3);
                            _builder_8.append(_regionMethodName_5, "\t");
                            _builder_8.append("(");
                            String _initialMacroName_8 = this.getInitialMacroName(subRegion_3);
                            _builder_8.append(_initialMacroName_8, "\t");
                            _builder_8.append(");");
                            _builder_8.newLineIfNotEmpty();
                            _builder_8.append("\t");
                            String _generateJoinCall_1 = this.concurrency.generateJoinCall(subRegion_3, true);
                            _builder_8.append(_generateJoinCall_1, "\t");
                            _builder_8.newLineIfNotEmpty();
                        }
                    } else {
                        _builder_8.append("\t");
                        EList _regions_6 = ((State)v_1).getRegions();
                        Region _head_4 = (Region)IterableExtensions.head((Iterable)_regions_6);
                        String _regionMethodName_6 = this.getRegionMethodName(_head_4);
                        _builder_8.append(_regionMethodName_6, "\t");
                        _builder_8.append("(");
                        EList _regions_7 = ((State)v_1).getRegions();
                        Region _head_5 = (Region)IterableExtensions.head((Iterable)_regions_7);
                        String _initialMacroName_9 = this.getInitialMacroName(_head_5);
                        _builder_8.append(_initialMacroName_9, "\t");
                        _builder_8.append(");");
                        _builder_8.newLineIfNotEmpty();
                    }
                }
                _builder_8.append("\t");
                _builder_8.append("//TODO: set systemState to EVENT_CONSUMED");
                _builder_8.newLine();
                _builder_8.append("\t");
                _builder_8.append("break;");
                body = _builder_8.toString();
                continue;
            }
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append(body, "");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("case ");
            String _vertexMacroName_1 = this.getVertexMacroName(v_1);
            _builder_9.append(_vertexMacroName_1, "");
            _builder_9.append(": ");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            String _generatePseudo = this.pseudostateGenerator.generatePseudo((Pseudostate)v_1);
            _builder_9.append(_generatePseudo, "\t");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("\t");
            _builder_9.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_9.newLine();
            _builder_9.append("\t");
            _builder_9.append("break;");
            body = _builder_9.toString();
        }
        boolean bl5 = _notEquals_1 = !Objects.equal((Object)r, (Object)this.topRegion);
        if (_notEquals_1) {
            Set _entrySet = state2TransSubVertices.entrySet();
            for (Map.Entry e : _entrySet) {
                State state = (State)e.getKey();
                List _value = (List)e.getValue();
                for (Vertex transitiveSubVertex : _value) {
                    StringConcatenation _builder_10 = new StringConcatenation();
                    _builder_10.append(body, "");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("case ");
                    String _vertexMacroName_2 = this.getVertexMacroName(transitiveSubVertex);
                    _builder_10.append(_vertexMacroName_2, "");
                    _builder_10.append(":");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("\t");
                    String _generateEnteringOnSubVertex = this.generateEnteringOnSubVertex(state, transitiveSubVertex);
                    _builder_10.append(_generateEnteringOnSubVertex, "\t");
                    _builder_10.newLineIfNotEmpty();
                    _builder_10.append("\t");
                    _builder_10.append("break;");
                    body = _builder_10.toString();
                }
            }
        }
        StringConcatenation _builder_10 = new StringConcatenation();
        _builder_10.append("switch(");
        _builder_10.append(this.paramName, "");
        _builder_10.append(") {");
        _builder_10.newLineIfNotEmpty();
        _builder_10.append("\t");
        _builder_10.append(body, "\t");
        _builder_10.newLineIfNotEmpty();
        _builder_10.append("}");
        switchBody = _builder_10.toString();
        this.createOpaqueBehavior(this.superContext, regionMethod, switchBody);
    }

    public String generateEnteringOnSubVertex(State parent, final Vertex subVertex) {
        boolean _notEquals;
        boolean _hasTriggerlessTransition;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name = parent.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append(_upperCase, "");
        _builder.append("_ID]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState, "");
        _builder_1.newLineIfNotEmpty();
        Behavior _entry = parent.getEntry();
        boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(_entry);
        if (_isBehaviorExist) {
            String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_1.append(_fptrCall, "");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("//starting the counters for time events");
        _builder_1.newLine();
        String _generateActivateTimeEvent = this.generateActivateTimeEvent(parent);
        _builder_1.append(_generateActivateTimeEvent, "");
        _builder_1.newLineIfNotEmpty();
        boolean _or = false;
        Behavior _doActivity = parent.getDoActivity();
        boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(_doActivity);
        _or = _isBehaviorExist_1 ? true : (_hasTriggerlessTransition = TransformationUtil.hasTriggerlessTransition(parent));
        if (_or) {
            _builder_1.append("//start activity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_1.append("(");
            String _name_2 = parent.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder_1.append(_upperCase_1, "");
            _builder_1.append("_ID, ");
            _builder_1.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        boolean _and = false;
        boolean _isComposite = parent.isComposite();
        _and = !_isComposite ? false : (_notEquals = !Objects.equal((Object)parent, (Object)subVertex));
        if (_and) {
            boolean _isOrthogonal = parent.isOrthogonal();
            if (_isOrthogonal) {
                ArrayList<Region> toJoinList = new ArrayList<Region>();
                _builder_1.newLineIfNotEmpty();
                EList _regions = parent.getRegions();
                for (Region r : _regions) {
                    boolean _notEquals_4;
                    boolean _notEquals_3;
                    boolean _notEquals_1;
                    boolean bl = _notEquals_1 = !Objects.equal((Object)subVertex, null);
                    if (_notEquals_1) {
                        boolean _notEquals_2;
                        Region _container = subVertex.getContainer();
                        boolean _equals = Objects.equal((Object)_container, (Object)r);
                        if (_equals) {
                            boolean b = toJoinList.add(r);
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append("//");
                            String _regionMethodName = this.getRegionMethodName(r);
                            _builder_1.append(_regionMethodName, "");
                            _builder_1.append("(");
                            String _vertexMacroName = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName, "");
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                            String _vertexMacroName_1 = this.getVertexMacroName(subVertex);
                            String _generateForkCall = this.concurrency.generateForkCall(r, true, _vertexMacroName_1);
                            _builder_1.append(_generateForkCall, "");
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        List<Vertex> _allSubVertexes = this.allSubVertexes(r);
                        boolean _contains = _allSubVertexes.contains(subVertex);
                        if (_contains) {
                            boolean b_1 = toJoinList.add(r);
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append("//");
                            String _regionMethodName_1 = this.getRegionMethodName(r);
                            _builder_1.append(_regionMethodName_1, "");
                            _builder_1.append("(");
                            String _vertexMacroName_2 = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName_2, "");
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                            String _vertexMacroName_3 = this.getVertexMacroName(subVertex);
                            String _generateForkCall_1 = this.concurrency.generateForkCall(r, true, _vertexMacroName_3);
                            _builder_1.append(_generateForkCall_1, "");
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        State _findInitialState = TransformationUtil.findInitialState(r);
                        boolean bl2 = _notEquals_2 = !Objects.equal((Object)_findInitialState, null);
                        if (!_notEquals_2) continue;
                        boolean b_2 = toJoinList.add(r);
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("//");
                        String _regionMethodName_2 = this.getRegionMethodName(r);
                        _builder_1.append(_regionMethodName_2, "");
                        _builder_1.append("(");
                        String _initialMacroName = this.getInitialMacroName(r);
                        _builder_1.append(_initialMacroName, "");
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                        String _initialMacroName_1 = this.getInitialMacroName(r);
                        String _generateForkCall_2 = this.concurrency.generateForkCall(r, true, _initialMacroName_1);
                        _builder_1.append(_generateForkCall_2, "");
                        _builder_1.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _and_1 = false;
                    boolean bl3 = _notEquals_3 = !Objects.equal((Object)subVertex, null);
                    if (!_notEquals_3) {
                        _and_1 = false;
                    } else {
                        boolean _equals_1;
                        Region _container_1 = subVertex.getContainer();
                        _and_1 = _equals_1 = Objects.equal((Object)_container_1, null);
                    }
                    if (_and_1) {
                        EObject _eContainer = subVertex.eContainer();
                        boolean _equals_2 = Objects.equal((Object)_eContainer, (Object)parent);
                        if (_equals_2) {
                            boolean b_3 = toJoinList.add(r);
                            _builder_1.newLineIfNotEmpty();
                            String _vertexMacroName_4 = this.getVertexMacroName(subVertex);
                            String _generateForkCall_3 = this.concurrency.generateForkCall(r, true, _vertexMacroName_4);
                            _builder_1.append(_generateForkCall_3, "");
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        boolean b_4 = toJoinList.add(r);
                        _builder_1.newLineIfNotEmpty();
                        String _vertexMacroName_5 = this.getVertexMacroName(subVertex);
                        String _generateForkCall_4 = this.concurrency.generateForkCall(r, true, _vertexMacroName_5);
                        _builder_1.append(_generateForkCall_4, "");
                        _builder_1.newLineIfNotEmpty();
                        continue;
                    }
                    State _findInitialState_1 = TransformationUtil.findInitialState(r);
                    boolean bl4 = _notEquals_4 = !Objects.equal((Object)_findInitialState_1, null);
                    if (!_notEquals_4) continue;
                    boolean b_5 = toJoinList.add(r);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("//");
                    String _regionMethodName_3 = this.getRegionMethodName(r);
                    _builder_1.append(_regionMethodName_3, "");
                    _builder_1.append("(");
                    String _initialMacroName_2 = this.getInitialMacroName(r);
                    _builder_1.append(_initialMacroName_2, "");
                    _builder_1.append(");");
                    _builder_1.newLineIfNotEmpty();
                    String _initialMacroName_3 = this.getInitialMacroName(r);
                    String _generateForkCall_5 = this.concurrency.generateForkCall(r, true, _initialMacroName_3);
                    _builder_1.append(_generateForkCall_5, "");
                    _builder_1.newLineIfNotEmpty();
                }
                for (Region r_1 : toJoinList) {
                    String _generateJoinCall = this.concurrency.generateJoinCall(r_1, true);
                    _builder_1.append(_generateJoinCall, "");
                    _builder_1.newLineIfNotEmpty();
                }
            } else {
                boolean _isComposite_1 = parent.isComposite();
                if (_isComposite_1) {
                    boolean _notEquals_5;
                    boolean bl = _notEquals_5 = !Objects.equal((Object)subVertex, null);
                    if (_notEquals_5) {
                        boolean _and_2 = false;
                        Region _container_2 = subVertex.getContainer();
                        boolean _equals_3 = Objects.equal((Object)_container_2, null);
                        if (!_equals_3) {
                            _and_2 = false;
                        } else {
                            EObject _eContainer_1 = subVertex.eContainer();
                            _and_2 = _eContainer_1 instanceof State;
                        }
                        if (_and_2) {
                            EList _regions_1 = parent.getRegions();
                            Region _head = (Region)IterableExtensions.head((Iterable)_regions_1);
                            String _regionMethodName_4 = this.getRegionMethodName(_head);
                            _builder_1.append(_regionMethodName_4, "");
                            _builder_1.append("(");
                            String _vertexMacroName_6 = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName_6, "");
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                        } else {
                            Region _container_3 = subVertex.getContainer();
                            State _state = _container_3.getState();
                            boolean _equals_4 = Objects.equal((Object)_state, (Object)parent);
                            if (_equals_4) {
                                EList _regions_2 = parent.getRegions();
                                Region _head_1 = (Region)IterableExtensions.head((Iterable)_regions_2);
                                String _regionMethodName_5 = this.getRegionMethodName(_head_1);
                                _builder_1.append(_regionMethodName_5, "");
                                _builder_1.append("(");
                                String _vertexMacroName_7 = this.getVertexMacroName(subVertex);
                                _builder_1.append(_vertexMacroName_7, "");
                                _builder_1.append(");");
                                _builder_1.newLineIfNotEmpty();
                            } else {
                                EList _regions_3 = parent.getRegions();
                                Functions.Function1<Region, Boolean> _function = new Functions.Function1<Region, Boolean>(){

                                    public Boolean apply(Region it) {
                                        List<Vertex> _allSubVertexes = SM2ClassesTransformationCore.this.allSubVertexes(it);
                                        return _allSubVertexes.contains(subVertex);
                                    }
                                };
                                Iterable _filter = IterableExtensions.filter((Iterable)_regions_3, (Functions.Function1)_function);
                                Region containingRegion = (Region)IterableExtensions.head((Iterable)_filter);
                                _builder_1.newLineIfNotEmpty();
                                String _regionMethodName_6 = this.getRegionMethodName(containingRegion);
                                _builder_1.append(_regionMethodName_6, "");
                                _builder_1.append("(");
                                String _vertexMacroName_8 = this.getVertexMacroName(subVertex);
                                _builder_1.append(_vertexMacroName_8, "");
                                _builder_1.append(");");
                                _builder_1.newLineIfNotEmpty();
                            }
                        }
                    } else {
                        EList _regions_4 = parent.getRegions();
                        Region _head_2 = (Region)IterableExtensions.head((Iterable)_regions_4);
                        String _regionMethodName_7 = this.getRegionMethodName(_head_2);
                        _builder_1.append(_regionMethodName_7, "");
                        _builder_1.append("(");
                        EList _regions_5 = parent.getRegions();
                        Region _head_3 = (Region)IterableExtensions.head((Iterable)_regions_5);
                        String _initialMacroName_4 = this.getInitialMacroName(_head_3);
                        _builder_1.append(_initialMacroName_4, "");
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                    }
                }
            }
        } else {
            boolean _equals_5;
            boolean _and_3 = false;
            boolean _isComposite_2 = parent.isComposite();
            _and_3 = !_isComposite_2 ? false : (_equals_5 = Objects.equal((Object)parent, (Object)subVertex));
            if (_and_3) {
                boolean _isOrthogonal_1 = parent.isOrthogonal();
                if (_isOrthogonal_1) {
                    ArrayList<Region> toJoinList_1 = new ArrayList<Region>();
                    _builder_1.newLineIfNotEmpty();
                    EList _regions_6 = parent.getRegions();
                    for (Region r_2 : _regions_6) {
                        boolean _notEquals_6;
                        State _findInitialState_2 = TransformationUtil.findInitialState(r_2);
                        boolean bl = _notEquals_6 = !Objects.equal((Object)_findInitialState_2, null);
                        if (!_notEquals_6) continue;
                        boolean b_6 = toJoinList_1.add(r_2);
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("//");
                        String _regionMethodName_8 = this.getRegionMethodName(r_2);
                        _builder_1.append(_regionMethodName_8, "");
                        _builder_1.append("(");
                        String _initialMacroName_5 = this.getInitialMacroName(r_2);
                        _builder_1.append(_initialMacroName_5, "");
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                        String _initialMacroName_6 = this.getInitialMacroName(r_2);
                        String _generateForkCall_6 = this.concurrency.generateForkCall(r_2, true, _initialMacroName_6);
                        _builder_1.append(_generateForkCall_6, "");
                        _builder_1.newLineIfNotEmpty();
                    }
                    for (Region r_3 : toJoinList_1) {
                        String _generateJoinCall_1 = this.concurrency.generateJoinCall(r_3, true);
                        _builder_1.append(_generateJoinCall_1, "");
                        _builder_1.newLineIfNotEmpty();
                    }
                } else {
                    boolean _notEquals_7;
                    EList _regions_7 = parent.getRegions();
                    Region _head_4 = (Region)IterableExtensions.head((Iterable)_regions_7);
                    State _findInitialState_3 = TransformationUtil.findInitialState(_head_4);
                    boolean bl = _notEquals_7 = !Objects.equal((Object)_findInitialState_3, null);
                    if (_notEquals_7) {
                        EList _regions_8 = parent.getRegions();
                        Region _head_5 = (Region)IterableExtensions.head((Iterable)_regions_8);
                        String _regionMethodName_9 = this.getRegionMethodName(_head_5);
                        _builder_1.append(_regionMethodName_9, "");
                        _builder_1.append("(");
                        EList _regions_9 = parent.getRegions();
                        Region _head_6 = (Region)IterableExtensions.head((Iterable)_regions_9);
                        String _initialMacroName_7 = this.getInitialMacroName(_head_6);
                        _builder_1.append(_initialMacroName_7, "");
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                    }
                }
                _builder_1.append("\t\t");
            }
        }
        return _builder_1.toString();
    }

    private void createRegionMethodExit(Region r) {
        State _state_1;
        boolean _isComposite;
        boolean _not;
        boolean _or = false;
        State _state = r.getState();
        boolean _equals = Objects.equal((Object)_state, null);
        _or = _equals ? true : (_not = !(_isComposite = (_state_1 = r.getState()).isComposite()));
        if (_or) {
            return;
        }
        State parent = r.getState();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//exiting region ");
        String _name = r.getName();
        _builder.append(_name, "");
        _builder.newLineIfNotEmpty();
        State _state_2 = r.getState();
        EList _regions = _state_2.getRegions();
        int regionIndex = _regions.indexOf((Object)r);
        _builder.newLineIfNotEmpty();
        EList _subvertices = r.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _and = false;
                boolean _not = !(it instanceof FinalState);
                _and = !_not ? false : (_isComposite = it.isComposite());
                return _and;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (State s : _filter_1) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder.append("[");
            String _name_1 = parent.getName();
            String _upperCase = _name_1.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
            _builder.append("[");
            _builder.append((Object)regionIndex, "");
            _builder.append("] == ");
            String _name_2 = s.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder.append(_upperCase_1, "");
            _builder.append("_ID) {");
            _builder.newLineIfNotEmpty();
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                EList _regions_1 = s.getRegions();
                for (Region subRegion : _regions_1) {
                    _builder.append("\t");
                    String _generateForkCall = this.concurrency.generateForkCall(subRegion, false, "0");
                    _builder.append(_generateForkCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
                EList _regions_2 = s.getRegions();
                for (Region subRegion_1 : _regions_2) {
                    _builder.append("\t");
                    String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, false);
                    _builder.append(_generateJoinCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append("\t");
                EList _regions_3 = s.getRegions();
                Region _head = (Region)IterableExtensions.head((Iterable)_regions_3);
                String _regionMethodExitName = this.getRegionMethodExitName(_head);
                _builder.append(_regionMethodExitName, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        String _name_3 = parent.getName();
        String _upperCase_2 = _name_3.toUpperCase();
        _builder.append(_upperCase_2, "");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
        _builder.append("[");
        _builder.append((Object)regionIndex, "");
        _builder.append("] != ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//signal to exit the doActivity of sub-state of ");
        String _name_4 = parent.getName();
        _builder.append(_name_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
        _builder.append("(");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        String _name_5 = parent.getName();
        String _upperCase_3 = _name_5.toUpperCase();
        _builder.append(_upperCase_3, "\t");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[0], ");
        _builder.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
        _builder.append(", false);");
        _builder.newLineIfNotEmpty();
        EList _subvertices_1 = r.getSubvertices();
        Iterable _filter_2 = Iterables.filter((Iterable)_subvertices_1, State.class);
        boolean _hasElements_1 = false;
        for (State sub : _filter_2) {
            boolean _notEquals;
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            List<TimeEvent> _get = this.states2TimeEvents.get(sub);
            boolean bl = _notEquals = !Objects.equal(_get, null);
            if (!_notEquals) continue;
            _builder.append("\t");
            _builder.append("if (");
            String _name_6 = sub.getName();
            String _upperCase_4 = _name_6.toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == ");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder.append("[");
            String _name_7 = parent.getName();
            String _upperCase_5 = _name_7.toUpperCase();
            _builder.append(_upperCase_5, "\t");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("]) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _generateDeactivateTimeEvent = this.generateDeactivateTimeEvent(sub);
            _builder.append(_generateDeactivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("//exit action of sub-state of ");
        String _name_8 = parent.getName();
        _builder.append(_name_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        String _name_9 = parent.getName();
        String _upperCase_6 = _name_9.toUpperCase();
        _builder.append(_upperCase_6, "\t");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[0]].");
        _builder.append(SMCodeGeneratorConstants.EXIT_NAME, "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _isSavehistory = TransformationUtil.isSavehistory(this.topRegion, r);
        if (_isSavehistory) {
            _builder.append("\t");
            _builder.append("//save history region ");
            String _name_10 = r.getName();
            _builder.append(_name_10, "\t");
            _builder.append(" of state ");
            String _name_11 = parent.getName();
            _builder.append(_name_11, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder.append("[");
            String _name_12 = parent.getName();
            String _upperCase_7 = _name_12.toUpperCase();
            _builder.append(_upperCase_7, "\t");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("] = ");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder.append("[");
            String _name_13 = parent.getName();
            String _upperCase_8 = _name_13.toUpperCase();
            _builder.append(_upperCase_8, "\t");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("//set active sub-state of ");
        String _name_14 = parent.getName();
        _builder.append(_name_14, "\t");
        _builder.append(" to ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
        _builder.append(" meaning NULL");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        String _name_15 = parent.getName();
        String _upperCase_9 = _name_15.toUpperCase();
        _builder.append(_upperCase_9, "\t");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("] = ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String body = _builder.toString();
        String _regionMethodExitName_1 = this.getRegionMethodExitName(r);
        Operation exitOp = this.superContext.createOwnedOperation(_regionMethodExitName_1, null, null);
        this.createOpaqueBehavior(this.superContext, exitOp, body);
    }

    private String getRegionMethodExitName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            StateMachine _stateMachine = r.getStateMachine();
            String _name = _stateMachine.getName();
            _builder.append(_name, "");
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1, "");
            _builder.append("_Exit");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        State _state = r.getState();
        String _name_2 = _state.getName();
        _builder_1.append(_name_2, "");
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3, "");
        _builder_1.append("_Exit");
        return _builder_1.toString();
    }

    public List<Vertex> allSubVertexes(Region r) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        EList _subvertices = r.getSubvertices();
        ret.addAll((Collection<Vertex>)_subvertices);
        EList _subvertices_1 = r.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices_1, State.class);
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                EList _regions = it.getRegions();
                Consumer<Region> _function = new Consumer<Region>(){

                    @Override
                    public void accept(Region it) {
                        List<Vertex> _allSubVertexes = SM2ClassesTransformationCore.this.allSubVertexes(it);
                        ret.addAll(_allSubVertexes);
                    }
                };
                _regions.forEach((Consumer)_function);
            }
        };
        _filter.forEach(_function);
        return ret;
    }

    private List<Vertex> allSubVertexes(State s) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        EList _regions = s.getRegions();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                List<Vertex> _allSubVertexes = SM2ClassesTransformationCore.this.allSubVertexes(it);
                ret.addAll(_allSubVertexes);
            }
        };
        _regions.forEach((Consumer)_function);
        return ret;
    }

    private OpaqueBehavior createOpaqueBehavior(Class container, Operation op) {
        EList _methods = op.getMethods();
        Iterable _filter = Iterables.filter((Iterable)_methods, OpaqueBehavior.class);
        OpaqueBehavior opaque = (OpaqueBehavior)IterableExtensions.head((Iterable)_filter);
        boolean _equals = Objects.equal((Object)opaque, null);
        if (_equals) {
            String _name = op.getName();
            Behavior _createClassifierBehavior = container.createClassifierBehavior(_name, UMLPackage.Literals.OPAQUE_BEHAVIOR);
            opaque = (OpaqueBehavior)_createClassifierBehavior;
            EList _methods_1 = op.getMethods();
            _methods_1.add((Object)opaque);
            EList _languages = opaque.getLanguages();
            _languages.add((Object)this.langID);
        }
        return opaque;
    }

    public OpaqueBehavior createOpaqueBehavior(Class container, Operation op, String body) {
        boolean _greaterThan;
        OpaqueBehavior opaque = this.createOpaqueBehavior(container, op);
        EList _bodies = opaque.getBodies();
        int _size = _bodies.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            EList _bodies_1 = opaque.getBodies();
            _bodies_1.set(0, (Object)body);
        } else {
            EList _languages = opaque.getLanguages();
            _languages.add((Object)this.langID);
            EList _bodies_2 = opaque.getBodies();
            _bodies_2.add((Object)body);
        }
        return opaque;
    }

    public Operation createDerivedOperation(Class clz, Operation source) {
        Operation _xblockexpression = null;
        String name = source.getName();
        Operation derivedOp = clz.createOwnedOperation(name, null, null);
        OperationUtils.syncOperation((Operation)source, (Operation)derivedOp);
        derivedOp.setName(name);
        StereotypeUtil.apply((Element)derivedOp, DerivedElement.class);
        DerivedElement _stereotypeApplication = (DerivedElement)UMLUtil.getStereotypeApplication((Element)derivedOp, DerivedElement.class);
        _stereotypeApplication.setSource((Element)source);
        this.setVirtual(derivedOp);
        _xblockexpression = derivedOp;
        return _xblockexpression;
    }

    public void copyParameters(Operation source, Operation target, boolean isCopyReturn) {
        String name = target.getName();
        OperationUtils.syncOperation((Operation)source, (Operation)target);
        if (!isCopyReturn) {
            EList _ownedParameters = target.getOwnedParameters();
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                }
            };
            Iterable ret = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
            EList _ownedParameters_1 = target.getOwnedParameters();
            CollectionExtensions.removeAll((Collection)_ownedParameters_1, (Iterable)ret);
        }
        EList _stereotypeApplications = target.getStereotypeApplications();
        for (EObject stt : _stereotypeApplications) {
            java.lang.Class<?> _class = stt.getClass();
            StereotypeUtil.applyApp((Element)target, _class);
        }
        target.setName(name);
    }

    private Stereotype setVirtual(Operation op) {
        return StereotypeUtil.apply((Element)op, Virtual.class);
    }

    public String getGuard(Transition t) {
        Constraint _guard = t.getGuard();
        ValueSpecification _specification = _guard.getSpecification();
        EList _bodies = ((OpaqueExpression)_specification).getBodies();
        return (String)IterableExtensions.head((Iterable)_bodies);
    }
}

