/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.designer.components.FCM.Assembly;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;

public abstract class AbstractCompToOO
implements IOOTrafo {
    protected LazyCopier copier;
    protected String progLang;
    public static final String NL = "\n";

    public void init(LazyCopier copier, Class bootloader) {
        PrefixConstants.init((PrefixConstants.CIFvariant)PrefixConstants.CIFvariant.UML);
        this.copier = copier;
    }

    public abstract String nameRef(Property var1);

    public abstract void applyRef(Element var1);

    public abstract String getRef(Property var1);

    public void addPortOperations(Class implementation) {
        boolean _not;
        boolean _isAbstract = implementation.isAbstract();
        boolean bl = _not = !_isAbstract;
        if (_not) {
            this.addGetPortOperation(implementation);
        }
        this.addConnectPortOperation(implementation);
    }

    public void addGetPortOperation(Class implementation) {
        EList _allPorts2 = PortUtils.getAllPorts2((EncapsulatedClassifier)implementation);
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)_allPorts2);
        for (PortInfo portInfo : _flattenExtendedPorts) {
            boolean _equals;
            boolean _isEmpty;
            boolean _not;
            List providedIntfs = portInfo.getProvideds();
            boolean _and = false;
            _and = providedIntfs == null ? false : (_not = !(_isEmpty = providedIntfs.isEmpty()));
            if (!_and) continue;
            int _size = providedIntfs.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Interface _get = (Interface)providedIntfs.get(0);
                String _name = portInfo.getName();
                this.addGetPortOperation(implementation, portInfo, _get, _name);
                continue;
            }
            for (Interface providedIntf : providedIntfs) {
                String _name_1 = portInfo.getName();
                String _name_2 = providedIntf.getName();
                String _plus = String.valueOf(_name_1) + _name_2;
                this.addGetPortOperation(implementation, portInfo, providedIntf, _plus);
            }
        }
    }

    public Object addGetPortOperation(Class implementation, PortInfo portInfo, Interface providedIntf, String portName) {
        Parameter _xblockexpression = null;
        String opName = String.valueOf(PrefixConstants.getP_Prefix) + portName;
        Operation op = implementation.getOwnedOperation(opName, null, null);
        Object _xifexpression = null;
        if (op != null) {
            boolean _notEquals;
            Parameter _xifexpression_1 = null;
            Type _type = op.getType();
            boolean bl = _notEquals = !Objects.equal((Object)_type, (Object)providedIntf);
            if (_notEquals) {
                _xifexpression_1 = op.createOwnedParameter("ret", (Type)providedIntf);
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _not;
            Operation _createOwnedOperation;
            boolean _xblockexpression_1 = false;
            op = _createOwnedOperation = implementation.createOwnedOperation(opName, null, null, (Type)providedIntf);
            EList _ownedParameters = op.getOwnedParameters();
            Parameter retParam = (Parameter)_ownedParameters.get(0);
            retParam.setName("ret");
            this.applyRef((Element)retParam);
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _methods = op.getMethods();
            _methods.add((Object)behavior);
            Port _modelPort = portInfo.getModelPort();
            List ces = ConnectorUtil.getDelegations((Class)implementation, (Port)_modelPort);
            String body = null;
            boolean _isEmpty = ces.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                body = "return ";
                int i = 0;
                while (i < ces.size() && body.equals("return ")) {
                    ConnectorEnd _get = (ConnectorEnd)ces.get(i);
                    Property part = _get.getPartWithPort();
                    ConnectorEnd _get_1 = (ConnectorEnd)ces.get(i);
                    ConnectableElement role = _get_1.getRole();
                    if (role instanceof Port) {
                        Port rolePort = (Port)role;
                        EList _provideds = rolePort.getProvideds();
                        boolean _contains = _provideds.contains((Object)providedIntf);
                        if (_contains) {
                            boolean _greaterThan;
                            EList _provideds_1 = rolePort.getProvideds();
                            int _size = _provideds_1.size();
                            boolean bl2 = _greaterThan = _size > 1;
                            if (_greaterThan) {
                                String _body = body;
                                StringConcatenation _builder = new StringConcatenation();
                                String _nameRef = this.nameRef(part);
                                _builder.append(_nameRef, "");
                                _builder.append(PrefixConstants.getP_Prefix, "");
                                String _name = ((Port)role).getName();
                                _builder.append(_name, "");
                                String _name_1 = providedIntf.getName();
                                _builder.append(_name_1, "");
                                _builder.append("();");
                                body = String.valueOf(_body) + _builder;
                            } else {
                                String _body_1 = body;
                                StringConcatenation _builder_1 = new StringConcatenation();
                                String _nameRef_1 = this.nameRef(part);
                                _builder_1.append(_nameRef_1, "");
                                _builder_1.append(PrefixConstants.getP_Prefix, "");
                                String _name_2 = ((Port)role).getName();
                                _builder_1.append(_name_2, "");
                                _builder_1.append("();");
                                body = String.valueOf(_body_1) + _builder_1;
                            }
                        }
                    } else if (role instanceof Property) {
                        InterfaceRealization _interfaceRealization;
                        boolean _tripleNotEquals;
                        Type roleType = ((Property)role).getType();
                        boolean _and = false;
                        _and = !(roleType instanceof BehavioredClassifier) ? false : (_tripleNotEquals = (_interfaceRealization = ((BehavioredClassifier)roleType).getInterfaceRealization(null, providedIntf)) != null);
                        if (_and) {
                            String _body_2 = body;
                            String _name_3 = ((Property)role).getName();
                            body = String.valueOf(_body_2) + _name_3;
                        }
                    }
                    ++i;
                }
            } else {
                boolean implementsIntf;
                InterfaceRealization _interfaceRealization = implementation.getInterfaceRealization(null, providedIntf);
                boolean bl3 = implementsIntf = _interfaceRealization != null;
                if (!implementsIntf) {
                    boolean _tripleNotEquals;
                    Interface providedIntfInCopy = (Interface)this.copier.getCopy((Element)providedIntf);
                    InterfaceRealization _interfaceRealization_1 = implementation.getInterfaceRealization(null, providedIntfInCopy);
                    implementsIntf = _tripleNotEquals = _interfaceRealization_1 != null;
                }
                if (implementsIntf) {
                    body = "return this;";
                } else {
                    String _name = providedIntf.getName();
                    String _name_1 = implementation.getName();
                    String _format = String.format("Interface <%s> provided by port <%s> of class <%s> is not implemented by the component itself nor does the port delegate to a part", _name, portName, _name_1);
                    throw new RuntimeException(_format);
                }
            }
            EList _languages = behavior.getLanguages();
            _languages.add((Object)this.progLang);
            EList _bodies = behavior.getBodies();
            _xblockexpression_1 = _bodies.add((Object)body);
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void addConnectPortOperation(Class implementation) {
        EList _allPorts2 = PortUtils.getAllPorts2((EncapsulatedClassifier)implementation);
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)_allPorts2);
        for (PortInfo portInfo : _flattenExtendedPorts) {
            boolean _equals;
            boolean _isEmpty;
            boolean _not;
            List requiredIntfs = portInfo.getRequireds();
            boolean _and = false;
            _and = requiredIntfs == null ? false : (_not = !(_isEmpty = requiredIntfs.isEmpty()));
            if (!_and) continue;
            int _size = requiredIntfs.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Interface _get = (Interface)requiredIntfs.get(0);
                String _name = portInfo.getName();
                this.addConnectPortOperation(implementation, portInfo, _get, _name);
                continue;
            }
            for (Interface requiredIntf : requiredIntfs) {
                String _name_1 = portInfo.getName();
                String _name_2 = requiredIntf.getName();
                String _plus = String.valueOf(_name_1) + _name_2;
                this.addConnectPortOperation(implementation, portInfo, requiredIntf, _plus);
            }
        }
    }

    public Boolean addConnectPortOperation(Class implementation, PortInfo portInfo, Interface requiredIntf, String portName) {
        boolean _tripleNotEquals;
        Boolean _xblockexpression = null;
        String opName = String.valueOf(PrefixConstants.connectQ_Prefix) + portName;
        Boolean _xifexpression = null;
        Operation _ownedOperation = implementation.getOwnedOperation(opName, null, null);
        boolean bl = _tripleNotEquals = _ownedOperation != null;
        if (_tripleNotEquals) {
            _xifexpression = null;
        } else {
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _greaterThan_1;
            boolean _not;
            int _upper_1;
            boolean _equals;
            boolean _greaterThan;
            boolean _xblockexpression_1 = false;
            Operation op = implementation.createOwnedOperation(opName, null, null);
            boolean _or = false;
            int _upper = portInfo.getUpper();
            boolean bl2 = _greaterThan = _upper > 1;
            _or = _greaterThan ? true : (_equals = (_upper_1 = portInfo.getUpper()) == -1);
            boolean multiPort = _or;
            if (multiPort) {
                NamedElement eLong = ElementUtils.getQualifiedElementFromRS((Element)this.copier.source, (String)"PrimitiveTypes::Integer");
                if (eLong != null) {
                    NamedElement _copy;
                    eLong = _copy = (NamedElement)this.copier.getCopy((Element)eLong);
                }
                if (eLong instanceof Type) {
                    op.createOwnedParameter("index", (Type)eLong);
                } else {
                    String _format = String.format("Can not find type %s. Thus, unable to create suitable connect operation in component to OO transformation", "PrimitiveTypes::Integer");
                    throw new RuntimeException(_format);
                }
            }
            Parameter refParam = op.createOwnedParameter("ref", (Type)requiredIntf);
            this.applyRef((Element)refParam);
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _methods = op.getMethods();
            _methods.add((Object)behavior);
            Port _modelPort = portInfo.getModelPort();
            List ces = ConnectorUtil.getDelegations((Class)implementation, (Port)_modelPort);
            String body = "";
            boolean _isEmpty = ces.isEmpty();
            boolean bl3 = _not = !_isEmpty;
            if (_not) {
                int i = 0;
                while (i < ces.size() && body.isEmpty()) {
                    ConnectorEnd _get = (ConnectorEnd)ces.get(i);
                    Property part = _get.getPartWithPort();
                    ConnectorEnd _get_1 = (ConnectorEnd)ces.get(i);
                    ConnectableElement role = _get_1.getRole();
                    if (role instanceof Port) {
                        EList _requireds = ((Port)role).getRequireds();
                        boolean _contains = _requireds.contains((Object)requiredIntf);
                        if (_contains) {
                            int _upper_3;
                            boolean _equals_1;
                            boolean _greaterThan_2;
                            boolean _greaterThan_12;
                            String _name;
                            body = _name = part.getName();
                            String _name_1 = ((Port)role).getName();
                            String targetOpName = String.valueOf(PrefixConstants.connectQ_Prefix) + _name_1;
                            EList _requireds_1 = ((Port)role).getRequireds();
                            int _size = _requireds_1.size();
                            boolean bl4 = _greaterThan_12 = _size > 1;
                            if (_greaterThan_12) {
                                String _targetOpName = targetOpName;
                                String _name_2 = requiredIntf.getName();
                                targetOpName = String.valueOf(_targetOpName) + _name_2;
                            }
                            StringConcatenation _builder = new StringConcatenation();
                            String _nameRef = this.nameRef(part);
                            _builder.append(_nameRef, "");
                            _builder.append(targetOpName, "");
                            body = _builder.toString();
                            boolean _or_1 = false;
                            int _upper_2 = portInfo.getUpper();
                            boolean bl5 = _greaterThan_2 = _upper_2 > 1;
                            _or_1 = _greaterThan_2 ? true : (_equals_1 = (_upper_3 = portInfo.getUpper()) == -1);
                            if (_or_1) {
                                String _body = body;
                                body = String.valueOf(_body) + "(index, ref);";
                            } else {
                                String _body_1 = body;
                                body = String.valueOf(_body_1) + "(ref);";
                            }
                        }
                    } else {
                        boolean _and = false;
                        Type _type = part.getType();
                        if (!(_type instanceof Classifier)) {
                            _and = false;
                        } else {
                            boolean _contains_1;
                            Type _type_1 = part.getType();
                            EList _allUsedInterfaces = ((Classifier)_type_1).getAllUsedInterfaces();
                            _and = _contains_1 = _allUsedInterfaces.contains((Object)requiredIntf);
                        }
                        if (_and) {
                            String _body_2 = body;
                            StringConcatenation _builder_1 = new StringConcatenation();
                            String _name_3 = part.getName();
                            _builder_1.append(_name_3, "");
                            _builder_1.append(";");
                            body = String.valueOf(_body_2) + _builder_1;
                        }
                    }
                    ++i;
                }
            } else {
                String attributeName = String.valueOf(PrefixConstants.attributePrefix) + portName;
                Property attr = implementation.getOwnedAttribute(attributeName, null);
                boolean _or_1 = false;
                _or_1 = attr == null ? true : attr instanceof Port;
                if (_or_1) {
                    Property _createOwnedAttribute;
                    attr = _createOwnedAttribute = implementation.createOwnedAttribute(attributeName, (Type)requiredIntf);
                    Port _port = portInfo.getPort();
                    CopyUtils.copyMultElemModifiers((MultiplicityElement)_port, (MultiplicityElement)attr);
                    attr.setAggregation(AggregationKind.SHARED_LITERAL);
                }
                body = attributeName;
                if (multiPort) {
                    String _body = body;
                    body = String.valueOf(_body) + "[index]";
                }
                String _body_1 = body;
                body = String.valueOf(_body_1) + " = ref;";
            }
            EList _languages = behavior.getLanguages();
            _languages.add((Object)this.progLang);
            EList _bodies = behavior.getBodies();
            _bodies.add((Object)body);
            boolean _xifexpression_1 = false;
            boolean _and = false;
            int _length = PrefixConstants.getConnQ_Prefix.length();
            boolean bl6 = _greaterThan_1 = _length > 0;
            _and = !_greaterThan_1 ? false : (_not_1 = !(_isEmpty_1 = ces.isEmpty()));
            if (_and) {
                boolean _xblockexpression_2 = false;
                String getConnOpName = String.valueOf(PrefixConstants.getConnQ_Prefix) + portName;
                Operation getConnOp = implementation.getOwnedOperation(getConnOpName, null, null);
                if (getConnOp == null) {
                    Operation _createOwnedOperation;
                    getConnOp = _createOwnedOperation = implementation.createOwnedOperation(getConnOpName, null, null, (Type)requiredIntf);
                    EList _ownedParameters = op.getOwnedParameters();
                    Parameter retParam = (Parameter)_ownedParameters.get(0);
                    retParam.setName("ret");
                    this.applyRef((Element)retParam);
                }
                EClass _opaqueBehavior_1 = UMLPackage.eINSTANCE.getOpaqueBehavior();
                Behavior _createOwnedBehavior_1 = implementation.createOwnedBehavior(getConnOpName, _opaqueBehavior_1);
                OpaqueBehavior getConnBehavior = (OpaqueBehavior)_createOwnedBehavior_1;
                EList _methods_1 = getConnOp.getMethods();
                _methods_1.add((Object)getConnBehavior);
                String name = String.valueOf(PrefixConstants.attributePrefix) + portName;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                _builder.append(name, "");
                _builder.append(";");
                body = _builder.toString();
                EList _languages_1 = behavior.getLanguages();
                _languages_1.add((Object)this.progLang);
                EList _bodies_1 = behavior.getBodies();
                _xifexpression_1 = _xblockexpression_2 = _bodies_1.add((Object)body);
            }
            _xblockexpression_1 = _xifexpression_1;
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void addConnectionOperation(Class compositeImplementation) throws TransformationException {
        boolean _greaterThan;
        String createConnBody = "";
        HashMap<MultiplicityElement, Integer> indexMap = new HashMap<MultiplicityElement, Integer>();
        EList _ownedConnectors = compositeImplementation.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            boolean _notEquals;
            boolean _isAssembly = ConnectorUtil.isAssembly((Connector)connector);
            if (!_isAssembly) continue;
            EList _ends = connector.getEnds();
            int _size = _ends.size();
            boolean bl = _notEquals = _size != 2;
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Connector <");
                String _name = connector.getName();
                _builder.append(_name, "");
                _builder.append("> does not have two ends. This is currently not supported");
                throw new TransformationException(_builder.toString());
            }
            EList _ends_1 = connector.getEnds();
            ConnectorEnd end1 = (ConnectorEnd)_ends_1.get(0);
            EList _ends_2 = connector.getEnds();
            ConnectorEnd end2 = (ConnectorEnd)_ends_2.get(1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("// realization of connector <");
            String _name_1 = connector.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(">");
            String cmd = String.valueOf(_builder_1.toString()) + NL;
            boolean _and = false;
            ConnectableElement _role = end1.getRole();
            if (!(_role instanceof Port)) {
                _and = false;
            } else {
                boolean _isExtendedPort;
                ConnectableElement _role_1 = end1.getRole();
                _and = _isExtendedPort = PortUtils.isExtendedPort((Port)((Port)_role_1));
            }
            if (_and) {
                ConnectableElement _role_2 = end1.getRole();
                Port port = (Port)_role_2;
                EList subPorts = PortUtils.flattenExtendedPort((Port)port);
                for (PortInfo subPort : subPorts) {
                    String _cmd = cmd;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("  ");
                    _builder_2.append("// realization of connection for sub-port ");
                    Port _port = subPort.getPort();
                    String _name_2 = _port.getName();
                    _builder_2.append(_name_2, "  ");
                    String _plus = String.valueOf(_builder_2.toString()) + NL;
                    String _cmd_1 = cmd = String.valueOf(_cmd) + _plus;
                    Port _port_1 = subPort.getPort();
                    String _connectPorts = this.connectPorts(indexMap, connector, end1, end2, _port_1);
                    String _cmd_2 = cmd = String.valueOf(_cmd_1) + _connectPorts;
                    Port _port_2 = subPort.getPort();
                    String _connectPorts_1 = this.connectPorts(indexMap, connector, end2, end1, _port_2);
                    cmd = String.valueOf(_cmd_2) + _connectPorts_1;
                }
            } else {
                String _cmd = cmd;
                String _connectPorts = this.connectPorts(indexMap, connector, end1, end2, null);
                String _cmd_1 = cmd = String.valueOf(_cmd) + _connectPorts;
                String _connectPorts_1 = this.connectPorts(indexMap, connector, end2, end1, null);
                cmd = String.valueOf(_cmd_1) + _connectPorts_1;
            }
            String _createConnBody = createConnBody;
            createConnBody = String.valueOf(_createConnBody) + cmd + NL;
        }
        int _length = createConnBody.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            Operation operation = compositeImplementation.createOwnedOperation("createConnections", null, null);
            String _name_2 = operation.getName();
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(_name_2, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _languages = behavior.getLanguages();
            _languages.add((Object)this.progLang);
            EList _bodies = behavior.getBodies();
            _bodies.add((Object)createConnBody);
            behavior.setSpecification((BehavioralFeature)operation);
        }
    }

    public String connectPorts(Map<MultiplicityElement, Integer> indexMap, Connector connector, ConnectorEnd receptacleEnd, ConnectorEnd facetEnd, Port subPort) throws TransformationException {
        Association association = connector.getType();
        boolean _and = false;
        ConnectableElement _role = receptacleEnd.getRole();
        if (!(_role instanceof Port)) {
            _and = false;
        } else {
            ConnectableElement _role_1 = facetEnd.getRole();
            _and = _role_1 instanceof Port;
        }
        if (_and) {
            Interface _required;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            ConnectableElement _role_2 = facetEnd.getRole();
            Port facetPort = (Port)_role_2;
            ConnectableElement _role_3 = receptacleEnd.getRole();
            Port receptaclePort = (Port)_role_3;
            PortInfo facetPI = PortInfo.fromSubPort((Port)facetPort, (Port)subPort);
            PortInfo receptaclePI = PortInfo.fromSubPort((Port)receptaclePort, (Port)subPort);
            boolean _and_1 = false;
            Interface _provided = facetPI.getProvided();
            boolean bl = _tripleNotEquals = _provided != null;
            _and_1 = !_tripleNotEquals ? false : (_tripleNotEquals_1 = (_required = receptaclePI.getRequired()) != null);
            if (_and_1) {
                boolean _greaterThan;
                Property facetPart = facetEnd.getPartWithPort();
                Property receptaclePart = receptacleEnd.getPartWithPort();
                String subPortName = "";
                if (subPort != null) {
                    String _subPortName = subPortName;
                    String _name = subPort.getName();
                    String _plus = "_" + _name;
                    subPortName = String.valueOf(_subPortName) + _plus;
                }
                String indexName = AbstractCompToOO.getIndexName(indexMap, receptaclePort, receptacleEnd);
                String result = "";
                List _requireds = receptaclePI.getRequireds();
                int _size = _requireds.size();
                boolean bl2 = _greaterThan = _size > 1;
                if (_greaterThan) {
                    List _requireds_1 = receptaclePI.getRequireds();
                    for (Interface requiredInterface : _requireds_1) {
                        boolean _isEmpty;
                        boolean _not;
                        String _name_1 = receptaclePI.getName();
                        String _name_2 = requiredInterface.getName();
                        String receptaclePortName = String.valueOf(_name_1) + _name_2;
                        String facetPortName = "";
                        List _provideds = facetPI.getProvideds();
                        boolean _contains = _provideds.contains(requiredInterface);
                        if (_contains) {
                            boolean _greaterThan_1;
                            String _facetPortName = facetPortName;
                            String _name_3 = facetPI.getName();
                            facetPortName = String.valueOf(_facetPortName) + _name_3;
                            List _provideds_1 = facetPI.getProvideds();
                            int _size_1 = _provideds_1.size();
                            boolean bl3 = _greaterThan_1 = _size_1 > 1;
                            if (_greaterThan_1) {
                                String _facetPortName_1 = facetPortName;
                                String _name_4 = requiredInterface.getName();
                                facetPortName = String.valueOf(_facetPortName_1) + _name_4;
                            }
                        }
                        boolean bl4 = _not = !(_isEmpty = facetPortName.isEmpty());
                        if (!_not) continue;
                        StringConcatenation _builder = new StringConcatenation();
                        String _nameRef = this.nameRef(receptaclePart);
                        _builder.append(_nameRef, "");
                        _builder.append("connect_");
                        _builder.append(receptaclePortName, "");
                        _builder.append(subPortName, "");
                        String setter = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _nameRef_1 = this.nameRef(facetPart);
                        _builder_1.append(_nameRef_1, "");
                        _builder_1.append("get_");
                        _builder_1.append(facetPortName, "");
                        _builder_1.append(subPortName, "");
                        _builder_1.append("()");
                        String getter = _builder_1.toString();
                        String _result = result;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append(setter, "");
                        _builder_2.append("(");
                        _builder_2.append(indexName, "");
                        _builder_2.append(getter, "");
                        _builder_2.append(");");
                        String _plus_1 = String.valueOf(_builder_2.toString()) + NL;
                        result = String.valueOf(_result) + _plus_1;
                    }
                } else {
                    boolean _not;
                    boolean _greaterThan_1;
                    String facetPortName = "";
                    boolean _and_2 = false;
                    List _provideds = facetPI.getProvideds();
                    int _size_1 = _provideds.size();
                    boolean bl5 = _greaterThan_1 = _size_1 > 1;
                    if (!_greaterThan_1) {
                        _and_2 = false;
                    } else {
                        boolean _contains;
                        List _provideds_1 = facetPI.getProvideds();
                        Interface _required_1 = receptaclePI.getRequired();
                        _and_2 = _contains = _provideds_1.contains(_required_1);
                    }
                    if (_and_2) {
                        String _facetPortName = facetPortName;
                        String _name_1 = facetPI.getName();
                        Interface _required_2 = receptaclePI.getRequired();
                        String _name_2 = _required_2.getName();
                        String _plus_1 = String.valueOf(_name_1) + _name_2;
                        facetPortName = String.valueOf(_facetPortName) + _plus_1;
                    } else {
                        boolean _equals;
                        List _provideds_2 = facetPI.getProvideds();
                        int _size_2 = _provideds_2.size();
                        boolean bl6 = _equals = _size_2 == 1;
                        if (_equals) {
                            String _name_3;
                            facetPortName = _name_3 = facetPI.getName();
                        }
                    }
                    boolean _isEmpty = facetPortName.isEmpty();
                    boolean bl7 = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenation _builder = new StringConcatenation();
                        String _nameRef = this.nameRef(receptaclePart);
                        _builder.append(_nameRef, "");
                        _builder.append("connect_");
                        String _name_4 = receptaclePort.getName();
                        _builder.append(_name_4, "");
                        _builder.append(subPortName, "");
                        String setter = _builder.toString();
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _nameRef_1 = this.nameRef(facetPart);
                        _builder_1.append(_nameRef_1, "");
                        _builder_1.append("get_");
                        _builder_1.append(facetPortName, "");
                        _builder_1.append(subPortName, "");
                        _builder_1.append("()");
                        String getter = _builder_1.toString();
                        String _result = result;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append(setter, "");
                        _builder_2.append("(");
                        _builder_2.append(indexName, "");
                        _builder_2.append(getter, "");
                        _builder_2.append(");");
                        String _plus_2 = String.valueOf(_builder_2.toString()) + NL;
                        result = String.valueOf(_result) + _plus_2;
                    }
                }
                return result;
            }
        } else {
            ConnectableElement _role_4 = receptacleEnd.getRole();
            if (_role_4 instanceof Port) {
                boolean _tripleNotEquals_2;
                ConnectableElement _role_5 = receptacleEnd.getRole();
                Port receptaclePort_1 = (Port)_role_5;
                Interface _required_3 = PortUtils.getRequired((Port)receptaclePort_1);
                boolean bl = _tripleNotEquals_2 = _required_3 != null;
                if (_tripleNotEquals_2) {
                    boolean _greaterThan_2;
                    ConnectableElement _role_6 = facetEnd.getRole();
                    Property facetPart_1 = (Property)_role_6;
                    Property receptaclePart_1 = facetEnd.getPartWithPort();
                    String indexName_1 = AbstractCompToOO.getIndexName(indexMap, receptaclePort_1, receptacleEnd);
                    String result_1 = "";
                    EList _requireds_2 = receptaclePort_1.getRequireds();
                    int _size_3 = _requireds_2.size();
                    boolean bl8 = _greaterThan_2 = _size_3 > 1;
                    if (_greaterThan_2) {
                        EList _requireds_3 = receptaclePort_1.getRequireds();
                        for (Interface requiredInterface_1 : _requireds_3) {
                            String _name_5 = receptaclePort_1.getName();
                            String _name_6 = requiredInterface_1.getName();
                            String receptaclePortName = String.valueOf(_name_5) + _name_6;
                            StringConcatenation _builder_3 = new StringConcatenation();
                            String _nameRef_2 = this.nameRef(receptaclePart_1);
                            _builder_3.append(_nameRef_2, "");
                            _builder_3.append("connect_");
                            _builder_3.append(receptaclePortName, "");
                            String setter_1 = _builder_3.toString();
                            StringConcatenation _builder_4 = new StringConcatenation();
                            String _ref = this.getRef(facetPart_1);
                            _builder_4.append(_ref, "");
                            String getter_1 = _builder_4.toString();
                            String _result_1 = result_1;
                            StringConcatenation _builder_5 = new StringConcatenation();
                            _builder_5.append(setter_1, "");
                            _builder_5.append("(");
                            _builder_5.append(indexName_1, "");
                            _builder_5.append(getter_1, "");
                            _builder_5.append(");");
                            String _plus_3 = String.valueOf(_builder_5.toString()) + NL;
                            result_1 = String.valueOf(_result_1) + _plus_3;
                        }
                    } else {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        String _nameRef_2 = this.nameRef(receptaclePart_1);
                        _builder_3.append(_nameRef_2, "");
                        _builder_3.append("connect_");
                        String _name_5 = receptaclePort_1.getName();
                        _builder_3.append(_name_5, "");
                        String setter_1 = _builder_3.toString();
                        StringConcatenation _builder_4 = new StringConcatenation();
                        String _ref = this.getRef(facetPart_1);
                        _builder_4.append(_ref, "");
                        String getter_1 = _builder_4.toString();
                        String _result_1 = result_1;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append(setter_1, "");
                        _builder_5.append("(");
                        _builder_5.append(indexName_1, "");
                        _builder_5.append(getter_1, "");
                        _builder_5.append(");");
                        String _plus_3 = String.valueOf(_builder_5.toString()) + NL;
                        result_1 = String.valueOf(_result_1) + _plus_3;
                    }
                    return result_1;
                }
            } else {
                ConnectableElement _role_7 = facetEnd.getRole();
                if (_role_7 instanceof Port) {
                    boolean _tripleNotEquals_3;
                    ConnectableElement _role_8 = facetEnd.getRole();
                    Port facetPort_1 = (Port)_role_8;
                    Interface _provided_1 = PortUtils.getProvided((Port)facetPort_1);
                    boolean bl = _tripleNotEquals_3 = _provided_1 != null;
                    if (_tripleNotEquals_3) {
                        boolean _greaterThan_3;
                        Property facetPart_2 = facetEnd.getPartWithPort();
                        ConnectableElement _role_9 = facetEnd.getRole();
                        Property receptaclePart_2 = (Property)_role_9;
                        String result_2 = "";
                        EList _provideds_3 = facetPort_1.getProvideds();
                        int _size_4 = _provideds_3.size();
                        boolean bl9 = _greaterThan_3 = _size_4 > 1;
                        if (_greaterThan_3) {
                            EList _provideds_4 = facetPort_1.getProvideds();
                            for (Interface providedInterface : _provideds_4) {
                                String _name_6 = facetPort_1.getName();
                                String _name_7 = providedInterface.getName();
                                String facetPortName_1 = String.valueOf(_name_6) + _name_7;
                                String setter_2 = receptaclePart_2.getName();
                                StringConcatenation _builder_6 = new StringConcatenation();
                                String _nameRef_3 = this.nameRef(facetPart_2);
                                _builder_6.append(_nameRef_3, "");
                                _builder_6.append("get_");
                                _builder_6.append(facetPortName_1, "");
                                _builder_6.append("();");
                                String getter_2 = _builder_6.toString();
                                String _result_2 = result_2;
                                StringConcatenation _builder_7 = new StringConcatenation();
                                _builder_7.append(setter_2, "");
                                _builder_7.append(" = ");
                                _builder_7.append(getter_2, "");
                                _builder_7.append(";");
                                String _plus_4 = String.valueOf(_builder_7.toString()) + NL;
                                result_2 = String.valueOf(_result_2) + _plus_4;
                            }
                        } else {
                            String setter_2 = receptaclePart_2.getName();
                            StringConcatenation _builder_6 = new StringConcatenation();
                            String _nameRef_3 = this.nameRef(facetPart_2);
                            _builder_6.append(_nameRef_3, "");
                            _builder_6.append("get_");
                            String _name_6 = facetPort_1.getName();
                            _builder_6.append(_name_6, "");
                            _builder_6.append("();");
                            String getter_2 = _builder_6.toString();
                            String _result_2 = result_2;
                            StringConcatenation _builder_7 = new StringConcatenation();
                            _builder_7.append(setter_2, "");
                            _builder_7.append(" = ");
                            _builder_7.append(getter_2, "");
                            _builder_7.append(";");
                            String _plus_4 = String.valueOf(_builder_7.toString()) + NL;
                            result_2 = String.valueOf(_result_2) + _plus_4;
                        }
                        return result_2;
                    }
                } else if (association != null) {
                    boolean _isNavigable;
                    ConnectableElement _role_10 = facetEnd.getRole();
                    Property facetPart_3 = (Property)_role_10;
                    ConnectableElement _role_11 = receptacleEnd.getRole();
                    Property receptaclePart_3 = (Property)_role_11;
                    Type _type = facetPart_3.getType();
                    Property assocProp1 = association.getMemberEnd(null, _type);
                    boolean _and_3 = false;
                    _and_3 = assocProp1 == null ? false : (_isNavigable = assocProp1.isNavigable());
                    if (_and_3) {
                        boolean _notEquals;
                        StringConcatenation _builder_8 = new StringConcatenation();
                        String _name_7 = receptaclePart_3.getName();
                        _builder_8.append(_name_7, "");
                        _builder_8.append(".");
                        String _name_8 = assocProp1.getName();
                        _builder_8.append(_name_8, "");
                        String setter_3 = _builder_8.toString();
                        StringConcatenation _builder_9 = new StringConcatenation();
                        String _name_9 = facetPart_3.getName();
                        _builder_9.append(_name_9, "");
                        String getter_3 = _builder_9.toString();
                        int _upper = assocProp1.getUpper();
                        boolean bl = _notEquals = _upper != 1;
                        if (_notEquals) {
                            Integer indexValue = indexMap.get(assocProp1);
                            if (indexValue == null) {
                                Integer _integer;
                                indexValue = _integer = new Integer(0);
                                indexMap.put((MultiplicityElement)assocProp1, indexValue);
                            }
                            String _setter = setter_3;
                            StringConcatenation _builder_10 = new StringConcatenation();
                            _builder_10.append("[");
                            Integer n = indexValue;
                            indexValue = n + 1;
                            Integer _plusPlus = n;
                            _builder_10.append((Object)_plusPlus, "");
                            _builder_10.append("]");
                            setter_3 = String.valueOf(_setter) + _builder_10;
                            indexMap.put((MultiplicityElement)assocProp1, indexValue);
                        }
                        StringConcatenation _builder_11 = new StringConcatenation();
                        _builder_11.append(setter_3, "");
                        _builder_11.append(" = ");
                        _builder_11.append(getter_3, "");
                        _builder_11.append(";");
                        return String.valueOf(_builder_11.toString()) + NL;
                    }
                } else {
                    String _name_10 = connector.getName();
                    String _plus_5 = "Connector <" + _name_10;
                    String _plus_6 = String.valueOf(_plus_5) + "> does not use ports, but it is not typed (only connectors between ports should not be typed)";
                    throw new TransformationException(_plus_6);
                }
            }
        }
        return "";
    }

    public static String getIndexName(Map<MultiplicityElement, Integer> indexMap, Port port, ConnectorEnd end) {
        int _upper_1;
        boolean _equals;
        boolean _greaterThan;
        boolean _or = false;
        int _upper = port.getUpper();
        boolean bl = _greaterThan = _upper > 1;
        _or = _greaterThan ? true : (_equals = (_upper_1 = port.getUpper()) == -1);
        if (_or) {
            Integer indexValue = indexMap.get(end);
            if (indexValue == null) {
                indexValue = 0;
                indexMap.put((MultiplicityElement)end, indexValue);
            }
            String index = indexValue + ", ";
            indexValue = indexValue + 1;
            indexMap.put((MultiplicityElement)end, indexValue);
            return index;
        }
        return "";
    }

    public static boolean instantiateViaBootloader(Class implementation) {
        boolean _isApplied;
        boolean _or = false;
        boolean _isAbstract = implementation.isAbstract();
        _or = _isAbstract ? true : (_isApplied = StereotypeUtil.isApplied((Element)implementation, Assembly.class));
        return _or;
    }

    public static boolean instantiateViaBootloader(StructuralFeature part) {
        if (part != null) {
            Type _type = part.getType();
            if (_type instanceof Class) {
                Type _type_1 = part.getType();
                Class implementation = (Class)_type_1;
                return AbstractCompToOO.instantiateViaBootloader(implementation);
            }
            return false;
        }
        return false;
    }

    public boolean hasMultipleDelegationsInDepth(Port port) {
        Element owner = port.getOwner();
        if (owner instanceof Class) {
            ConnectorEnd ce;
            ConnectableElement role;
            boolean _equals;
            boolean _greaterThan;
            List ces = ConnectorUtil.getDelegations((Class)((Class)owner), (Port)port);
            int _size = ces.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                return true;
            }
            int _size_1 = ces.size();
            boolean bl2 = _equals = _size_1 == 1;
            if (_equals && (role = (ce = (ConnectorEnd)ces.get(0)).getRole()) instanceof Port) {
                return this.hasMultipleDelegationsInDepth((Port)role);
            }
        }
        return false;
    }

    public void getAllConnectedProviders(Port port, Interface requiredInterface, List<Property> connectedProviders, List<Connector> visitedConnectors) {
        Model _model = port.getModel();
        EList _allOwnedElements = _model.allOwnedElements();
        for (Element element : _allOwnedElements) {
            boolean _greaterThan_1;
            boolean _not_2;
            Type _type_1;
            Class otherEndClass;
            EList _implementedInterfaces;
            boolean _contains_4;
            ConnectableElement _role_5;
            Property otherEndPart;
            Type _type;
            boolean _equals;
            boolean _not;
            if (!(element instanceof Connector)) continue;
            Connector connector = (Connector)element;
            boolean _contains = visitedConnectors.contains(connector);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            visitedConnectors.add(connector);
            EList _ends = connector.getEnds();
            int _size = _ends.size();
            boolean bl2 = _equals = _size == 2;
            if (!_equals) continue;
            ConnectorEnd otherEnd = null;
            EList _ends_1 = connector.getEnds();
            ConnectorEnd _get = (ConnectorEnd)_ends_1.get(0);
            ConnectableElement _role = _get.getRole();
            boolean _equals_1 = Objects.equal((Object)_role, (Object)port);
            if (_equals_1) {
                ConnectorEnd _get_1;
                EList _ends_2 = connector.getEnds();
                otherEnd = _get_1 = (ConnectorEnd)_ends_2.get(1);
            } else {
                EList _ends_3 = connector.getEnds();
                ConnectorEnd _get_2 = (ConnectorEnd)_ends_3.get(1);
                ConnectableElement _role_1 = _get_2.getRole();
                boolean _equals_2 = Objects.equal((Object)_role_1, (Object)port);
                if (_equals_2) {
                    ConnectorEnd _get_3;
                    EList _ends_4 = connector.getEnds();
                    otherEnd = _get_3 = (ConnectorEnd)_ends_4.get(0);
                }
            }
            if (otherEnd == null) continue;
            ConnectableElement _role_2 = otherEnd.getRole();
            if (_role_2 instanceof Port) {
                ConnectableElement _role_3 = otherEnd.getRole();
                Port otherEndPort = (Port)_role_3;
                EList _provideds = otherEndPort.getProvideds();
                boolean _contains_1 = _provideds.contains((Object)requiredInterface);
                if (_contains_1) {
                    boolean _greaterThan;
                    Property _partWithPort_1;
                    boolean _contains_2;
                    boolean _not_1;
                    boolean _tripleNotEquals;
                    boolean _and = false;
                    Property _partWithPort = otherEnd.getPartWithPort();
                    boolean bl3 = _tripleNotEquals = _partWithPort != null;
                    _and = !_tripleNotEquals ? false : (_not_1 = !(_contains_2 = connectedProviders.contains(_partWithPort_1 = otherEnd.getPartWithPort())));
                    if (!_and) continue;
                    Property _partWithPort_2 = otherEnd.getPartWithPort();
                    int _upper = _partWithPort_2.getUpper();
                    boolean bl4 = _greaterThan = _upper > 0;
                    if (_greaterThan) {
                        int i = 0;
                        while (i < otherEnd.getPartWithPort().getUpper()) {
                            Property _partWithPort_3 = otherEnd.getPartWithPort();
                            connectedProviders.add(_partWithPort_3);
                            ++i;
                        }
                        continue;
                    }
                    Property _partWithPort_3 = otherEnd.getPartWithPort();
                    connectedProviders.add(_partWithPort_3);
                    continue;
                }
                EList _requireds = otherEndPort.getRequireds();
                boolean _contains_3 = _requireds.contains((Object)requiredInterface);
                if (!_contains_3) continue;
                this.getAllConnectedProviders(otherEndPort, requiredInterface, connectedProviders, visitedConnectors);
                continue;
            }
            ConnectableElement _role_4 = otherEnd.getRole();
            if (!(_role_4 instanceof Property) || !((_type = (otherEndPart = (Property)(_role_5 = otherEnd.getRole())).getType()) instanceof Class) || !(_contains_4 = (_implementedInterfaces = (otherEndClass = (Class)(_type_1 = otherEndPart.getType())).getImplementedInterfaces()).contains((Object)requiredInterface))) continue;
            boolean _contains_5 = connectedProviders.contains(otherEndPart);
            boolean bl5 = _not_2 = !_contains_5;
            if (!_not_2) continue;
            int _upper_1 = otherEndPart.getUpper();
            boolean bl6 = _greaterThan_1 = _upper_1 > 0;
            if (_greaterThan_1) {
                int i = 0;
                while (i < otherEndPart.getUpper()) {
                    connectedProviders.add(otherEndPart);
                    ++i;
                }
                continue;
            }
            connectedProviders.add(otherEndPart);
        }
    }
}

