/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.sync;

import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.Activator;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepPlanUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.ElementFilter;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DepPlanSync {
    public static void syncAllDepPlans(Element element) {
        for (Package depPlan : DepPlanUtils.getAllDepPlans((Element)element)) {
            DepPlanSync.syncDepPlan(depPlan);
        }
    }

    public static void syncDepPlan(Package depPlan) {
        DepPlanSync.removeUnusedSlots(depPlan);
        for (InstanceSpecification is : DepUtils.getTopLevelInstances((Package)depPlan)) {
            DepPlanSync.addCDP(depPlan, is, is.getName());
        }
    }

    private static void addCDP(Package depPlan, InstanceSpecification instance, String canonicalName) {
        Class implementation = DepUtils.getImplementation((InstanceSpecification)instance);
        if (!instance.getName().equals(canonicalName)) {
            instance.setName(canonicalName);
        }
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification subInstance = DepUtils.getInstance((Slot)slot);
            if (subInstance == null) continue;
            DepPlanSync.addCDP(depPlan, subInstance, String.valueOf(canonicalName) + "." + slot.getDefiningFeature().getName());
        }
        for (Property attribute : PartsUtil.getParts((Class)implementation)) {
            Type type = attribute.getType();
            if (!(type instanceof Class) || DepPlanSync.hasSlot(instance, attribute)) continue;
            try {
                InstanceSpecification partIS = DepCreation.createDepPlan((Package)depPlan, (Class)((Class)type), (String)(String.valueOf(instance.getName()) + "." + attribute.getName()), (boolean)true);
                DepPlanUtils.createSlot((Package)depPlan, (InstanceSpecification)instance, (InstanceSpecification)partIS, (Property)attribute);
            }
            catch (TransformationException e) {
                Activator.log.error((Throwable)e);
                throw new TransformationRTException(e.getMessage());
            }
        }
    }

    protected static InstanceSpecification findISforConn(Package cdp, final Connector conn) {
        ElementFilter filter = new ElementFilter(){

            public boolean acceptElement(Element element) {
                InstanceSpecification is;
                DerivedElement de;
                return element instanceof InstanceSpecification && (de = (DerivedElement)UMLUtil.getStereotypeApplication((Element)(is = (InstanceSpecification)element), DerivedElement.class)) != null && de.getSource() == conn;
            }
        };
        BasicEList iList = new BasicEList();
        DepUtils.getAllInstances((Package)cdp, (EList)iList, (ElementFilter)filter);
        if (iList.size() > 0) {
            return (InstanceSpecification)iList.get(0);
        }
        return null;
    }

    private static boolean hasSlot(InstanceSpecification instance, Property attribute) {
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != attribute) continue;
            return true;
        }
        return false;
    }

    public static void removeUnusedSlots(Package depPlan) {
        for (NamedElement member : depPlan.getMembers()) {
            if (!(member instanceof InstanceSpecification)) continue;
            InstanceSpecification instance = (InstanceSpecification)member;
            Iterator slotIt = instance.getSlots().iterator();
            while (slotIt.hasNext()) {
                Slot slot = (Slot)slotIt.next();
                if (slot.getDefiningFeature() != null) continue;
                for (ValueSpecification value : slot.getValues()) {
                    if (!(value instanceof InstanceValue)) continue;
                    InstanceSpecification is = ((InstanceValue)value).getInstance();
                    DepPlanUtils.delDepPlan((InstanceSpecification)is);
                }
                slot.destroy();
                slotIt.remove();
            }
        }
    }
}

