/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.Activator;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UpdateUtils {
    public static EList<Element> getDerivedElements(Package pkg, NamedElement source) {
        BasicEList list = new BasicEList();
        for (NamedElement member : pkg.getOwnedMembers()) {
            if (UpdateUtils.getSource((Element)member) == source) {
                list.add((Object)member);
            }
            if (!(member instanceof Package)) continue;
            EList<Element> subList = UpdateUtils.getDerivedElements((Package)member, source);
            list.addAll(subList);
        }
        return list;
    }

    public static Element getDerivedElement(EList<? extends Element> list, Element source) {
        for (Element element : list) {
            DerivedElement de;
            if (!StereotypeUtil.isApplied((Element)element, DerivedElement.class) || (de = (DerivedElement)UMLUtil.getStereotypeApplication((Element)element, DerivedElement.class)) == null || de.getSource() != source) continue;
            return element;
        }
        return null;
    }

    public static void setSource(Element derivedElement, Element source) {
        DerivedElement de = (DerivedElement)StereotypeUtil.applyApp((Element)derivedElement, DerivedElement.class);
        if (de != null) {
            de.setSource(source);
        } else {
            Activator.log.warn(Messages.UpdateUtils_CannotApplyTrafoStereotype);
        }
    }

    public static Element getSource(Element element) {
        DerivedElement de;
        if (StereotypeUtil.isApplied((Element)element, DerivedElement.class) && (de = (DerivedElement)UMLUtil.getStereotypeApplication((Element)element, DerivedElement.class)) != null) {
            return de.getSource();
        }
        return null;
    }
}

