/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.ProjectExplorerNodeWalkerWithIProgress;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.ReverseSelectedNodeVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.ReverseWithJDTParserVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dialog.DndReverseCodeDialog;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dialog.ReverseCodeDialog;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd.AbstractJobAndTransactionForDrop;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd.DiagramNodeCreator;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd.IJobAndTransactionForDrop;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.exception.StopExecutionException;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.utils.QualifiedNamesFromIJavaElementCollector;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class ReverseJobAndTransactionForDrop
extends AbstractJobAndTransactionForDrop
implements IJobAndTransactionForDrop {
    private static String DefaultGenerationModeleName = "generated";
    private UmlModel umlModel;
    private ServicesRegistry servicesRegistry;
    private ITreeSelection recordedSelection;
    private ReverseCodeDialog dialog;
    private IProgressMonitor progressMonitor;
    private View parentView;
    private GraphicalEditPart parentViewEditPart;
    private Point firstNodeLocation;

    @Override
    public void init(Request request, EditPart targetEditPart) throws StopExecutionException {
        GraphicalEditPart gtEditPart;
        System.err.println(String.valueOf(this.getClass().getName()) + ".init()");
        super.init(request, targetEditPart);
        List<EObject> sources = this.getSourceEObjects(request);
        if (!sources.isEmpty()) {
            throw new StopExecutionException();
        }
        try {
            this.servicesRegistry = ServiceUtilsForEditPart.getInstance().getServiceRegistry(targetEditPart);
            this.umlModel = (UmlModel)ServiceUtils.getInstance().getModelSet((Object)this.servicesRegistry).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        }
        catch (ServiceException e) {
            throw new StopExecutionException(e);
        }
        DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        this.parentViewEditPart = gtEditPart = (GraphicalEditPart)targetEditPart;
        this.parentView = this.getTargetView(targetEditPart);
        Point location = dropRequest.getLocation().getCopy();
        gtEditPart.getContentPane().translateToRelative((Translatable)location);
        gtEditPart.getContentPane().translateFromParent((Translatable)location);
        location.translate(gtEditPart.getContentPane().getClientArea().getLocation().getNegated());
        this.firstNodeLocation = location;
        this.recordedSelection = this.getCurrentSelection();
    }

    @Override
    public boolean canExecute() {
        System.err.println(String.valueOf(this.getClass().getName()) + ".canExecute()");
        return true;
    }

    @Override
    public void executePreJob() throws StopExecutionException {
        System.err.println(String.valueOf(this.getClass().getName()) + ".jobPreprocess()");
        String selectedProjectName = this.getSelectedProjectName();
        Resource umlResource = this.umlModel.getResource();
        String modelUID = this.getResourceUid(umlResource);
        Shell shell = this.getShell();
        this.dialog = new DndReverseCodeDialog(shell, modelUID, selectedProjectName, null);
        int res = this.dialog.open();
        if (res == 1) {
            throw new StopExecutionException("Job canceled by user.");
        }
    }

    @Override
    public void jobPreprocess(IProgressMonitor monitor) throws StopExecutionException {
        this.progressMonitor = monitor;
    }

    @Override
    public void jobRun(IProgressMonitor monitor) throws StopExecutionException {
        Package rootPackage;
        System.err.println(String.valueOf(this.getClass().getName()) + ".jobRun()");
        List<String> searchPaths = Arrays.asList(this.dialog.getSearchPath());
        try {
            rootPackage = (Package)this.umlModel.lookupRoot();
        }
        catch (NotFoundException e) {
            throw new StopExecutionException(e);
        }
        List<String> creationPaths = this.dialog.getCreationPaths();
        QualifiedNamesFromIJavaElementCollector collector = new QualifiedNamesFromIJavaElementCollector(false, true, false);
        List<String> qualifiedNamesInProjects = collector.getQualifiedNamesFromSelection((ISelection)this.getRecordedSelection());
        List<NamedElement> returnedReversedNamedElement = null;
        switch (this.dialog.getSelectedParserIndex()) {
            case 0: 
            case 1: {
                ReverseSelectedNodeVisitor visitor = new ReverseSelectedNodeVisitor(rootPackage, this.getPackageName(this.dialog), searchPaths, creationPaths, qualifiedNamesInProjects);
                ProjectExplorerNodeWalkerWithIProgress reverseWalker = new ProjectExplorerNodeWalkerWithIProgress(visitor);
                reverseWalker.visit(this.getRecordedSelection().toList(), monitor);
                returnedReversedNamedElement = visitor.getReversedNamedElement();
                break;
            }
            case 2: {
                System.err.println("Use JDT parser (todo)");
                ReverseWithJDTParserVisitor jdtParserVisitor = new ReverseWithJDTParserVisitor(rootPackage, this.getPackageName(this.dialog), searchPaths);
                ProjectExplorerNodeWalkerWithIProgress reverseWalker = new ProjectExplorerNodeWalkerWithIProgress(jdtParserVisitor);
                reverseWalker.visit(this.getRecordedSelection().toList(), monitor);
                returnedReversedNamedElement = jdtParserVisitor.getReversedNamedElement();
            }
        }
        if (returnedReversedNamedElement != null) {
            DiagramNodeCreator nodeCreator = new DiagramNodeCreator(this.parentView, this.parentViewEditPart, this.firstNodeLocation);
            nodeCreator.createNodesFor(this.progressMonitor, returnedReversedNamedElement);
        }
    }

    @Override
    public void jobPostProcess() throws StopExecutionException {
        System.err.println(String.valueOf(this.getClass().getName()) + ".jobPostProcess()");
    }

    protected ITreeSelection getCurrentSelection() throws StopExecutionException {
        ISelection selection = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        selection = page.getSelection();
        if (selection instanceof ITreeSelection) {
            return (ITreeSelection)selection;
        }
        throw new StopExecutionException("Can't find a ITreeSelection");
    }

    private ITreeSelection getRecordedSelection() {
        return this.recordedSelection;
    }

    protected String getSelectedProjectName() {
        TreeSelection treeSelection = (TreeSelection)this.getRecordedSelection();
        Object firstSelection = treeSelection.getFirstElement();
        if (!(firstSelection instanceof IJavaElement)) {
            return "";
        }
        IJavaElement selectionElement = (IJavaElement)treeSelection.getFirstElement();
        String name = selectionElement.getAncestor(2).getElementName();
        return name;
    }

    private String getResourceUid(Resource resource) {
        String modelUid = resource.getURI().toPlatformString(true);
        if (modelUid == null) {
            modelUid = resource.getURI().path();
        }
        return modelUid;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell();
    }

    protected String getPackageName(ReverseCodeDialog dialog) {
        String generationPackageName = dialog.getValue();
        if (generationPackageName == null || generationPackageName.length() == 0) {
            generationPackageName = DefaultGenerationModeleName;
        }
        return generationPackageName;
    }

    protected View getTargetView(EditPart targetEditPart) {
        return NotationHelper.findView((Object)targetEditPart);
    }
}

