/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.ClassifierNeedCreationException;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.ClassifierNotFoundException;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.ImportNotFoundException;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.NestedClassifierNeedCreationException;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.LocalContext;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ClassifierCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.CreationPackageCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ImportedTypeCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

public class TypeResolver {
    protected ClassifierCatalog classifierCatalog;
    protected ImportedTypeCatalog importedTypeCatalog;
    protected CreationPackageCatalog creationPackageCatalog;

    public TypeResolver(ClassifierCatalog classifierCatalog, ImportedTypeCatalog importedTypeCatalog, CreationPackageCatalog creationPackageCatalog) {
        this.classifierCatalog = classifierCatalog;
        this.importedTypeCatalog = importedTypeCatalog;
        this.creationPackageCatalog = creationPackageCatalog;
    }

    public Classifier lookupClassifier(String name, LocalContext context) throws ClassifierNotFoundException, ClassifierNeedCreationException, NestedClassifierNeedCreationException {
        Classifier result = this.lookupInImportsAndContext(name, context);
        return result;
    }

    private Classifier lookupInImportsAndContext(String name, LocalContext context) throws ClassifierNotFoundException, ClassifierNeedCreationException, NestedClassifierNeedCreationException {
        if (this.isSimpleName(name)) {
            return this.lookupClassifierFromSimpleName(name, context);
        }
        List<String> qualifiedName = UmlUtils.toQualifiedName(name);
        return this.lookupClassifierFromTypename(qualifiedName, context);
    }

    /*
     * Unable to fully structure code
     */
    private Classifier lookupClassifierFromSimpleName(String sname, LocalContext context) throws ClassifierNotFoundException, ClassifierNeedCreationException {
        try {
            qualifiedName = this.importedTypeCatalog.getImportQualifiedNameChecked(sname);
            result = this.classifierCatalog.getClassifier(qualifiedName);
            if (result != null) {
                return result;
            }
            throw new ClassifierNeedCreationException(qualifiedName);
        }
        catch (ImportNotFoundException qualifiedName) {
            ** for (parentPackageQName : this.importedTypeCatalog.getStarImports())
        }
lbl-1000:
        // 1 sources

        {
            fullQName = new ArrayList<String>(parentPackageQName);
            fullQName.add(sname);
            result = this.classifierCatalog.getClassifier(fullQName);
            if (result == null) continue;
            return result;
        }
lbl15:
        // 1 sources

        result = context.lookupClassifier(sname, UmlUtils.CLASSIFIER_TYPE);
        if (result != null) {
            return result;
        }
        result = this.classifierCatalog.getClassifier(sname);
        if (result != null) {
            return result;
        }
        throw new ClassifierNotFoundException(sname);
    }

    private Classifier lookupClassifierFromTypename(List<String> qualifiedName, LocalContext context) throws NestedClassifierNeedCreationException, ClassifierNotFoundException {
        Object result;
        Classifier typenameClassifier;
        String typeName = qualifiedName.get(0);
        try {
            typenameClassifier = this.lookupInImportsAndContext(typeName, context);
            List<String> searchedQualifiedName = qualifiedName.subList(1, qualifiedName.size());
            result = UmlUtils.lookupNestedClassifier(typenameClassifier, qualifiedName, UmlUtils.CLASSIFIER_TYPE);
        }
        catch (ClassifierNeedCreationException e) {
            throw new NestedClassifierNeedCreationException(e.getQualifiedName(), qualifiedName);
        }
        catch (ClassifierNotFoundException e) {
            Classifier result2 = this.classifierCatalog.getClassifier(qualifiedName);
            if (result2 != null) {
                return result2;
            }
            throw new ClassifierNotFoundException(qualifiedName);
        }
        if (result != null) {
            return result;
        }
        throw new NestedClassifierNeedCreationException(typenameClassifier, qualifiedName);
    }

    private boolean isSimpleName(String name) {
        return name.indexOf(46) == -1;
    }

    public Type getType(String typename, LocalContext context) {
        try {
            Classifier result = this.lookupClassifier(typename, context);
            return result;
        }
        catch (ClassifierNotFoundException e) {
            Object result;
            if (e.getRequestedSimpleName() != null) {
                List<String> qualifiedName = UmlUtils.toQualifiedName(e.getRequestedSimpleName());
                Package creationPackage = context.getCurrentPackage();
                EClass requestedType = this.creationPackageCatalog.guessBestType(qualifiedName);
                result = UmlUtils.getClassifier(creationPackage, qualifiedName, requestedType);
            } else {
                List<String> qualifiedName = e.getRequestedQualifiedName();
                Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, null);
                EClass requestedType = this.creationPackageCatalog.guessBestType(qualifiedName);
                result = UmlUtils.getClassifier(creationPackage, qualifiedName, requestedType);
            }
            return result;
        }
        catch (ClassifierNeedCreationException e) {
            List<String> qualifiedName = e.getQualifiedName();
            Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, null);
            EClass requestedType = this.creationPackageCatalog.guessBestType(qualifiedName);
            Object result = UmlUtils.getClassifier(creationPackage, qualifiedName, requestedType);
            return result;
        }
        catch (NestedClassifierNeedCreationException e) {
            Type result;
            EClass requestedType = this.creationPackageCatalog.guessBestType(e.getRequestedNestedClassifierRelativename());
            if (e.getParentClassifier() != null) {
                result = UmlUtils.getNestedClassifier(e.getParentClassifier(), e.getRequestedNestedClassifierRelativename(), requestedType);
            } else {
                List<String> parentQualifiedName = e.getParentQualifiedname();
                Package creationPackage = this.creationPackageCatalog.getCreationPackage(parentQualifiedName, null);
                EClass parentRequestedType = this.creationPackageCatalog.guessBestType(parentQualifiedName);
                Classifier parent = (Classifier)UmlUtils.getClassifier(creationPackage, parentQualifiedName, parentRequestedType);
                result = UmlUtils.getNestedClassifier(parent, e.getRequestedNestedClassifierRelativename(), requestedType);
            }
            return result;
        }
    }
}

