/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dnd.AbstractModuleDropHandler;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ease.ui.modules.ui.ModulesTools;

public class ModulesDropHandler
extends AbstractModuleDropHandler
implements IShellDropHandler {
    @Override
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        return element instanceof ModuleDefinition || element instanceof ModulesTools.ModuleEntry;
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        try {
            ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
            if (element instanceof ModuleDefinition) {
                Method loadModuleMethod = EnvironmentModule.class.getMethod("loadModule", String.class, Boolean.TYPE);
                String call = codeFactory.createFunctionCall(loadModuleMethod, new Object[]{((ModuleDefinition)element).getPath().toString(), false});
                scriptEngine.executeAsync((Object)call);
            } else if (element instanceof ModulesTools.ModuleEntry) {
                ModuleDefinition declaringModule = ((ModulesTools.ModuleEntry)element).getModuleDefinition();
                this.loadModule(scriptEngine, declaringModule.getPath().toString(), false);
                if (((ModulesTools.ModuleEntry)element).getEntry() instanceof Method) {
                    String call = codeFactory.createFunctionCall((Method)((ModulesTools.ModuleEntry)element).getEntry(), new Object[0]);
                    scriptEngine.executeAsync((Object)call);
                } else if (((ModulesTools.ModuleEntry)element).getEntry() instanceof Field) {
                    scriptEngine.executeAsync((Object)((Field)((ModulesTools.ModuleEntry)element).getEntry()).getName());
                }
            } else {
                scriptEngine.executeAsync(element);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"loadModule() method not found in Environment module", (Throwable)e);
        }
    }
}

