/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;

public class PropertyValueFactory {
    public Object newInstance(String pluginId, String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> classType = this.loadClass(pluginId, classname);
        return classType.newInstance();
    }

    public Class<?> loadClass(String declaringID, String className) throws ClassNotFoundException {
        Class factoryClass;
        try {
            factoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                Bundle bundle = Platform.getBundle((String)declaringID);
                factoryClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new ClassNotFoundException("Can't find class " + className + "in plugin " + declaringID, e1);
            }
            catch (NullPointerException e1) {
                throw new ClassNotFoundException("Can't find plugin " + declaringID, e1);
            }
        }
        return factoryClass;
    }

    public EObject newEClassInstance(String nsURI, String propertyName) throws ClassNotFoundException {
        EPackage modelPackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        if (modelPackage == null) {
            throw new ClassNotFoundException("Can't get EPAckage for model '" + nsURI + "'");
        }
        EClass classifier = (EClass)modelPackage.getEClassifier(propertyName);
        if (classifier == null) {
            throw new ClassNotFoundException("Can't get classifier '" + propertyName + "' in model '" + nsURI + "'");
        }
        return modelPackage.getEFactoryInstance().create(classifier);
    }

    public Object getEObjectPropertyValue(EObject eObject, String propertyName) {
        return eObject.eGet(eObject.eClass().getEStructuralFeature(propertyName));
    }

    public void setEObjectPropertyValue(EObject eObject, String propertyName, Object value) {
        eObject.eSet(eObject.eClass().getEStructuralFeature(propertyName), value);
    }
}

