/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.BadStateException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerState;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.ApplicationDependantElementImpl;

public abstract class LayerExpressionImpl
extends ApplicationDependantElementImpl
implements LayerExpression {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final boolean IS_LAYER_ENABLED_INTERNAL_EDEFAULT = false;
    protected static final boolean IS_LAYER_ENABLED_EDEFAULT = true;
    protected boolean isLayerEnabled = true;
    protected static final boolean IS_BRANCH_ENABLED_EDEFAULT = true;
    protected boolean isBranchEnabled = true;
    protected LayersStack owningLayersStack;
    protected static final LayerState STATE_EDEFAULT = LayerState.DETACHED;
    protected LayerState state = STATE_EDEFAULT;
    protected Adapter containerListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            block0 : switch (msg.getFeatureID(LayerExpression.class)) {
                case 3: {
                    switch (msg.getEventType()) {
                        case 1: {
                            LayerExpressionImpl.this.owningLayerChanged((LayerOperator)msg.getNewValue(), (LayerOperator)msg.getOldValue());
                            break block0;
                        }
                        case 2: {
                            LayerExpressionImpl.this.owningLayerChanged((LayerOperator)msg.getNewValue(), (LayerOperator)msg.getOldValue());
                            break block0;
                        }
                    }
                }
            }
        }
    };

    protected LayerExpressionImpl() {
        this.eAdapters().add((Object)this.containerListener);
    }

    protected void startBehaviors() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYER_EXPRESSION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public boolean isLayerEnabledInternal() {
        return this.isLayerEnabled();
    }

    @Override
    public boolean isLayerEnabled() {
        return this.isLayerEnabled;
    }

    @Override
    public void setIsLayerEnabled(boolean newIsLayerEnabled) {
        boolean oldIsLayerEnabled = this.isLayerEnabled;
        this.isLayerEnabled = newIsLayerEnabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldIsLayerEnabled, this.isLayerEnabled));
        }
        this.setIsBranchEnabled(this.isLayerEnabled);
    }

    @Override
    public boolean isBranchEnabled() {
        return this.isBranchEnabled;
    }

    @Override
    public void setIsBranchEnabled(boolean newIsBranchEnabled) {
        boolean oldIsBranchEnabled = this.isBranchEnabled;
        this.isBranchEnabled = newIsBranchEnabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldIsBranchEnabled, this.isBranchEnabled));
        }
    }

    @Override
    public LayersStack getOwningLayersStack() {
        if (this.owningLayersStack != null && this.owningLayersStack.eIsProxy()) {
            InternalEObject oldOwningLayersStack = (InternalEObject)this.owningLayersStack;
            this.owningLayersStack = (LayersStack)this.eResolveProxy(oldOwningLayersStack);
            if (this.owningLayersStack != oldOwningLayersStack && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldOwningLayersStack, (Object)this.owningLayersStack));
            }
        }
        return this.owningLayersStack;
    }

    public LayersStack basicGetOwningLayersStack() {
        return this.owningLayersStack;
    }

    @Override
    public void setOwningLayersStack(LayersStack newOwningLayersStack) {
        LayersStack oldOwningLayersStack = this.owningLayersStack;
        this.owningLayersStack = newOwningLayersStack;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldOwningLayersStack, (Object)this.owningLayersStack));
        }
    }

    @Override
    public LayerState getState() {
        return this.state;
    }

    @Override
    public void setState(LayerState newState) {
        LayerState oldState = this.state;
        LayerState layerState = this.state = newState == null ? STATE_EDEFAULT : newState;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldState, (Object)this.state));
        }
    }

    @Override
    public LayersStack getLayersStack() throws NotFoundException {
        LayersStack res = this.getOwningLayersStack();
        if (res != null) {
            return res;
        }
        throw new NotFoundException("LayersStack is not set in the Layer '" + this.getName() + "'");
    }

    @Override
    public void enterAttachedState() throws LayersException {
    }

    @Override
    public void attach() throws LayersException {
        if (this.getState() == LayerState.ATTACHED) {
            return;
        }
        if (this.getApplication() == null || this.getOwningLayersStack() == null || this.eContainer() == null) {
            throw new BadStateException("A required attribute is not set. The Layer can't be attached.[layerName=" + this.getName() + ", application=" + (this.getApplication() == null ? "null" : "ok") + ", owningLayersStack=" + (this.getOwningLayersStack() == null ? "null" : "ok") + ", container=" + (this.eContainer() == null ? "null" : "ok") + "]");
        }
        this.setState(LayerState.ATTACHED);
        this.enterAttachedState();
    }

    @Override
    public void detach() throws LayersException {
        this.exitAttachedState();
        this.setState(LayerState.DETACHED);
    }

    @Override
    public void exitAttachedState() {
    }

    public void startAfterReloading() {
        this.startBehaviors();
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(EList<View> view, Property property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, EList<Property> property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachToLayersStack(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
        this.startBehaviors();
    }

    public void initLayer(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> view, Property property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.isLayerEnabledInternal();
            }
            case 4: {
                return this.isLayerEnabled();
            }
            case 5: {
                return this.isBranchEnabled();
            }
            case 6: {
                if (resolve) {
                    return this.getOwningLayersStack();
                }
                return this.basicGetOwningLayersStack();
            }
            case 7: {
                return this.getState();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.setIsLayerEnabled((Boolean)newValue);
                return;
            }
            case 5: {
                this.setIsBranchEnabled((Boolean)newValue);
                return;
            }
            case 6: {
                this.setOwningLayersStack((LayersStack)newValue);
                return;
            }
            case 7: {
                this.setState((LayerState)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.setIsLayerEnabled(true);
                return;
            }
            case 5: {
                this.setIsBranchEnabled(true);
                return;
            }
            case 6: {
                this.setOwningLayersStack(null);
                return;
            }
            case 7: {
                this.setState(STATE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return this.isLayerEnabledInternal();
            }
            case 4: {
                return !this.isLayerEnabled;
            }
            case 5: {
                return !this.isBranchEnabled;
            }
            case 6: {
                return this.owningLayersStack != null;
            }
            case 7: {
                return this.state != STATE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                try {
                    return this.getComputePropertyValueCommand((View)arguments.get(0), (Property)arguments.get(1));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 1: {
                try {
                    return this.getViewsComputePropertyValueCommand((EList<View>)((EList)arguments.get(0)), (Property)arguments.get(1));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                try {
                    return this.getPropertiesComputePropertyValueCommand((View)arguments.get(0), (EList<Property>)((EList)arguments.get(1)));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 3: {
                this.attachToLayersStack((LayersStack)arguments.get(0));
                return null;
            }
            case 4: {
                try {
                    return this.getLayersStack();
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 5: {
                try {
                    this.enterAttachedState();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 6: {
                try {
                    this.attach();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 7: {
                try {
                    this.detach();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 8: {
                this.exitAttachedState();
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", description: ");
        result.append(this.description);
        result.append(", isLayerEnabled: ");
        result.append(this.isLayerEnabled);
        result.append(", isBranchEnabled: ");
        result.append(this.isBranchEnabled);
        result.append(", state: ");
        result.append((Object)this.state);
        result.append(')');
        return result.toString();
    }

    private void owningLayerChanged(LayerOperator newParent, LayerOperator oldParent) {
        if (newParent != null) {
            this.setOwningLayersStack(newParent.getOwningLayersStack());
            this.setIsBranchEnabled(newParent.isBranchEnabled());
        }
    }
}

