/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.view;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.provider.NotationItemProviderAdapterFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.provider.custom.CustomLayersItemProviderAdapterFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;

public class LayersTreeViewerFactory {
    static final String CONTEXT_MENU_ID = "org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.diagram.ui.contextmenu";

    public static TreeViewer createLayersTreeViewer(Composite parent, int style) {
        TreeViewer layersExplorerTree = new TreeViewer(parent, style);
        LayersTreeViewerFactory.initContentAndLabelProviders(layersExplorerTree);
        return layersExplorerTree;
    }

    protected static void initContentAndLabelProviders(TreeViewer layersExplorerTree) {
        AdapterFactory adapterFactory = LayersTreeViewerFactory.createLayersTreeViewerItemProvidersFactory();
        layersExplorerTree.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(adapterFactory));
        layersExplorerTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
    }

    public static AdapterFactory createLayersTreeViewerItemProvidersFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new CustomLayersItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new NotationItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    public static void initContextMenuFor(IWorkbenchPartSite site, StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        site.registerContextMenu(CONTEXT_MENU_ID, contextMenu, (ISelectionProvider)viewer);
    }
}

