/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import java.util.List;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Type;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.PropertyRegistryImpl;

public class CustomPropertyRegistryImpl
extends PropertyRegistryImpl {
    protected CustomPropertyRegistryImpl() {
        this.init();
    }

    protected void init() {
        TypeRegistry typeRegistry = LayersFactory.eINSTANCE.createTypeRegistry();
        this.setTypeRegistry(typeRegistry);
        String[] properties = new String[]{"css", "CSSType", "", "cssHide", "CSSHideType", ""};
        int i = 0;
        while (i < properties.length) {
            Property property = LayersFactory.eINSTANCE.createProperty();
            property.setName(properties[i]);
            Type propertyType = typeRegistry.getTypes().get(properties[i + 1]);
            property.setType(propertyType);
            String defaultValueStr = properties[i + 2];
            if (defaultValueStr != null && defaultValueStr.length() > 0) {
                TypeInstance defaultValue = propertyType.createInstance();
                defaultValue.setValueFromString(defaultValueStr);
                property.setDefaultValue(defaultValue);
            }
            this.addProperty(property);
            i += 3;
        }
    }

    @Override
    public int getPropertiesCount() {
        return this.getProperties().size();
    }

    @Override
    public int getPropertyIndex(String propertyName) throws NotFoundException {
        if (propertyName == null) {
            throw new NotFoundException("Null not Allowed");
        }
        List<Property> props = this.getProperties();
        int i = 0;
        while (i < props.size()) {
            if (propertyName.equals(props.get(i).getName())) {
                return i;
            }
            ++i;
        }
        throw new NotFoundException("No property found with name '" + propertyName + "'");
    }

    @Override
    public Property getProperty(String propertyName) throws NotFoundException {
        int index = this.getPropertyIndex(propertyName);
        return this.getProperties().get(index);
    }

    @Override
    public void addProperty(Property property) {
        try {
            this.getProperty(property.getName());
            return;
        }
        catch (NotFoundException notFoundException) {
            property.setIndex(this.getProperties().size());
            this.getProperties().add(property);
            return;
        }
    }
}

