/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.StackedLayerOperatorImpl;

public class CustomStackedLayerOperatorImpl
extends StackedLayerOperatorImpl {
    protected CustomStackedLayerOperatorImpl() {
        LayerDescriptorSynchronizer adapter = new LayerDescriptorSynchronizer();
        this.eAdapters().add((Object)adapter);
    }

    @Override
    public void resetDescriptor() {
        if (this.getApplication() == null || this.getLayerOperatorDescriptorName() == null) {
            return;
        }
        try {
            LayerOperatorDescriptor descriptor = this.getApplication().getLayerOperatorDescriptorRegistry().getLayerOperatorDescriptor(this.getLayerOperatorDescriptorName());
            this.setLayerOperatorDescriptor(descriptor);
        }
        catch (NotFoundException e) {
            Activator.log.error(String.valueOf(this.getClass().getName()) + "- Can't get LayerOperatorDescriptor for descriptorName '" + this.getLayerOperatorDescriptorName() + "'.", (Throwable)e);
        }
    }

    @Override
    public void addLayer(LayerExpression layer) {
        this.getLayers().add(0, layer);
    }

    @Override
    public void setIsBranchEnabled(boolean newIsBranchEnabled) {
        super.setIsBranchEnabled(newIsBranchEnabled);
        boolean value = this.isBranchEnabled();
        for (LayerExpression layer : this.getLayers()) {
            layer.setIsBranchEnabled(value);
        }
    }

    @Override
    public void setOwningLayersStack(LayersStack newOwningLayersStack) {
        super.setOwningLayersStack(newOwningLayersStack);
        LayersStack value = this.getOwningLayersStack();
        for (LayerExpression layer : this.getLayers()) {
            layer.setOwningLayersStack(value);
        }
    }

    @Override
    public void attach() throws LayersException {
        super.attach();
        for (LayerExpression l : this.getLayers()) {
            l.attach();
        }
    }

    @Override
    public void detach() throws LayersException {
        super.detach();
        for (LayerExpression l : this.getLayers()) {
            l.detach();
        }
    }

    @Override
    public boolean isDescriptorSet() {
        return this.getLayerOperatorDescriptor() != null;
    }

    @Override
    public boolean isLayerEnabledInternal() {
        return this.isLayerEnabled && this.isDescriptorSet();
    }

    @Override
    @Deprecated
    public void attachToLayersStack(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
        for (LayerExpression l : this.getLayers()) {
            l.attachToLayersStack(owningLayersStack);
        }
        this.startBehaviors();
    }

    public class LayerDescriptorSynchronizer
    extends AdapterImpl {
        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(AbstractLayer.class)) {
                case 9: {
                    this.notifyDescriptorNameChanged(msg);
                    break;
                }
                case 0: {
                    this.notifyLayerApplicationFeatureChanged(msg);
                    break;
                }
            }
        }

        protected void notifyDescriptorNameChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 1: {
                    CustomStackedLayerOperatorImpl.this.resetDescriptor();
                    break;
                }
            }
        }

        protected void notifyLayerApplicationFeatureChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 1: {
                    CustomStackedLayerOperatorImpl.this.resetDescriptor();
                }
            }
        }
    }
}

