/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.loaders;

import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.Folder;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayerOperatorConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayerOperatorMultipleBinding;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayersConfigFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.OperatorBinding;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.PropertyId;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.TypeConfig;

public class LayersConfigModelUtils {
    public static Folder createFolder(Folder parent, String name) {
        Folder folder = LayersConfigFactory.eINSTANCE.createFolder();
        folder.setName(name);
        parent.getFolderElements().add(folder);
        return folder;
    }

    public static LayerOperatorConfig createLayerOperatorConfig(Folder parent, String ID, String classname) {
        LayerOperatorConfig config = LayersConfigFactory.eINSTANCE.createLayerOperatorConfig();
        config.setName(ID);
        config.setClassname(classname);
        parent.getFolderElements().add(config);
        return config;
    }

    public static OperatorConfig createPropertyOperatorConfig(Folder parent, String ID, String classname) {
        OperatorConfig config = LayersConfigFactory.eINSTANCE.createOperatorConfig();
        config.setName(ID);
        config.setClassname(classname);
        parent.getFolderElements().add(config);
        return config;
    }

    public static LayerOperatorMultipleBinding createLayerOperatorsMultipleBinding(Folder owner, LayerOperatorConfig layerOperator) {
        LayerOperatorMultipleBinding config = LayersConfigFactory.eINSTANCE.createLayerOperatorMultipleBinding();
        config.setLayerOperatorConfig(layerOperator);
        owner.getFolderElements().add(config);
        return config;
    }

    public static OperatorBinding createOperatorBinding(LayerOperatorMultipleBinding owner, PropertyId propertyId, OperatorConfig operatorConfig) {
        OperatorBinding binding = LayersConfigFactory.eINSTANCE.createOperatorBinding();
        binding.setPropertyId(propertyId);
        binding.setOperator(operatorConfig);
        binding.setOwner(owner);
        return binding;
    }

    public static PropertyId createPropertyId(Folder parent, String ID, TypeConfig type) {
        PropertyId propertyId = LayersConfigFactory.eINSTANCE.createPropertyId();
        propertyId.setName(ID);
        propertyId.setType(type);
        parent.getFolderElements().add(propertyId);
        return propertyId;
    }

    public static TypeConfig createTypeConfig(Folder parent, String ID) {
        TypeConfig config = LayersConfigFactory.eINSTANCE.createTypeConfig();
        config.setName(ID);
        parent.getFolderElements().add(config);
        return config;
    }
}

