/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.util;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ObservableListView<E>
extends ForwardingList<E> {
    protected List<E> delegate;
    protected EventBus eventBus = new EventBus(ObservableListView.class.getName());

    public ObservableListView() {
        this(new ArrayList());
    }

    public ObservableListView(List<E> delegate) {
        this.delegate = delegate;
    }

    protected List<E> delegate() {
        return this.delegate;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public boolean add(E element) {
        boolean isModified = this.delegate().add(element);
        if (isModified) {
            this.eventBus.post((Object)new ObservableListEvent(element));
        }
        return isModified;
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean isModified = this.delegate().addAll(collection);
        if (isModified) {
            this.eventBus.post((Object)new ObservableListEvent(collection));
        }
        return isModified;
    }

    public void add(int index, E element) {
        this.delegate().add(index, element);
        this.eventBus.post((Object)new ObservableListEvent(element));
    }

    public boolean addAll(int index, Collection<? extends E> elements) {
        boolean isModified = this.delegate().addAll(index, elements);
        if (isModified) {
            this.eventBus.post((Object)new ObservableListEvent(elements));
        }
        return isModified;
    }

    public E remove(int index) {
        Object removed = super.remove(index);
        this.getEventBus().post((Object)new ObservableListEvent(null, removed));
        return (E)removed;
    }

    public boolean remove(Object object) {
        boolean isRemoved = super.remove(object);
        if (isRemoved) {
            this.getEventBus().post((Object)new ObservableListEvent(null, object));
        }
        return isRemoved;
    }

    public boolean removeAll(Collection<?> collection) {
        ArrayList removedElements = Lists.newArrayList((Iterable)this.delegate());
        removedElements.retainAll(collection);
        boolean isRemoved = super.removeAll(collection);
        if (isRemoved) {
            this.getEventBus().post((Object)new ObservableListEvent(null, removedElements));
        }
        return isRemoved;
    }

    public boolean resetTo(Collection<? extends E> collection) {
        boolean isModified;
        ArrayList<E> elementsToRemove = new ArrayList<E>();
        ArrayList<E> elementsToAdd = new ArrayList<E>();
        Object attachedElements = this.delegate();
        for (Object o : collection) {
            if (attachedElements.contains(o)) continue;
            elementsToAdd.add(o);
        }
        Iterator<Object> iterator = attachedElements.iterator();
        while (iterator.hasNext()) {
            Object o;
            o = iterator.next();
            if (collection.contains(o)) continue;
            elementsToRemove.add(o);
        }
        this.delegate().clear();
        this.delegate().addAll(collection);
        boolean bl = isModified = !elementsToAdd.isEmpty() || !elementsToRemove.isEmpty();
        if (isModified) {
            this.getEventBus().post((Object)new ObservableListEvent(elementsToAdd, elementsToRemove));
        }
        return isModified;
    }

    public List<E> getUnnotifyingList() {
        return this.delegate();
    }

    public class ObservableListEvent {
        Collection<? extends E> addedElements = Collections.emptyList();
        Collection<? extends E> removedElements = Collections.emptyList();

        public ObservableListEvent() {
            this.addedElements = Collections.emptyList();
            this.removedElements = Collections.emptyList();
        }

        public ObservableListEvent(Collection<? extends E> addedElements) {
            this.addedElements = addedElements != null ? addedElements : Collections.emptyList();
            this.removedElements = Collections.emptyList();
        }

        public ObservableListEvent(Collection<? extends E> addedElements, Collection<? extends E> removedElements) {
            this.addedElements = addedElements != null ? addedElements : Collections.emptyList();
            this.removedElements = removedElements != null ? removedElements : Collections.emptyList();
        }

        public ObservableListEvent(E addedElement, E removedElement) {
            this.addedElements = addedElement != null ? Collections.singletonList(addedElement) : Collections.emptyList();
            this.removedElements = removedElement != null ? Collections.singletonList(removedElement) : Collections.emptyList();
        }

        public ObservableListEvent(E addedElement) {
            this.addedElements = addedElement != null ? Collections.singletonList(addedElement) : Collections.emptyList();
            this.removedElements = Collections.emptyList();
        }

        public Collection<? extends E> getAddedElements() {
            return this.addedElements;
        }

        public Collection<? extends E> getRemovedElements() {
            return this.removedElements;
        }
    }
}

