/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.blackboxes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryFactory;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.RpyShapeOperations;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIDiagramFrame;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectLink;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphElementsType;

public class Rpy2PapyrusNotationBlackboxes {
    public static final int M_TRANSFORM_SIZE = 6;
    public static final int M_TRANSFORM_X_RATIO_INDEX = 0;
    public static final int M_TRANSFORM_Y_RATIO_INDEX = 3;
    public static final int M_TRANSFORM_X_POSITION_INDEX = 4;
    public static final int M_TRANSFORM_Y_POSITION_INDEX = 5;
    public static final int M_POLYGON__RECTANGLE_NB_POINTS_INDEX = 0;
    public static final int M_POLYGON__RECTANGLE_TOP_LEFT_CORNER_X_INDEX = 1;
    public static final int M_POLYGON__RECTANGLE_TOP_LEFT_CORNER_Y_INDEX = 2;
    public static final int M_POLYGON__RECTANGLE_BOTTOM_LEFT_CORNER_X_INDEX = 3;
    public static final int M_POLYGON__RECTANGLE_BOTTOM_LEFT_CORNER_Y_INDEX = 4;
    public static final int M_POLYGON__RECTANGLE_BOTTOM_RIGHT_CORNER_X_INDEX = 5;
    public static final int M_POLYGON__RECTANGLE_BOTTOM_RIGHT_CORNER__Y_INDEX = 6;
    public static final int M_POLYGON__RECTANGLE_TOP_RIGHT_CORNER_X_INDEX = 7;
    public static final int M_POLYGON__RECTANGLE_TOP_RIGHT_CORNER_Y_INDEX = 8;
    public static final int X_INDEX = 0;
    public static final int Y_INDEX = 1;
    public static final int ERROR_CODE = Integer.MAX_VALUE;
    public static final String M_TRANSFORM = "m_transform";
    public static final String M_POLYGON = "m_polygon";
    public static final String M_pPARENT = "m_pParent";
    private static final int MAGIC_NUMBER_FOR_ABSOLUTE_BENDPOINTS = -643984;

    @Operation(kind=Operation.Kind.HELPER)
    public boolean contains(String aString, String aPotentialSubString) {
        if (aString == null || aPotentialSubString == null) {
            return false;
        }
        return aString.contains(aPotentialSubString);
    }

    @Operation(kind=Operation.Kind.QUERY)
    public void addAnchorsAndBendpoints(Object association, Connector result) {
        if (!this.isARpyLink(association)) {
            return;
        }
        List<String> rpySourceAnchorAsString = this.getM_SourcePort(association);
        List<String> rpyTargetAnchorAsString = this.getM_TargetPort(association);
        GraphElementsType sourceGraphicalObject = this.getM_pSource(association);
        GraphElementsType targetGraphicalObject = this.getM_pTarget(association);
        RpyShape sourceShape = RpyShapeOperations.createRpyShape((GraphElementsType)sourceGraphicalObject);
        RpyShape targetShape = RpyShapeOperations.createRpyShape((GraphElementsType)targetGraphicalObject);
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpySourceAnchor = RpyGeometryFactory.eINSTANCE.createPoint();
        rpySourceAnchor.setX(Double.valueOf(rpySourceAnchorAsString.get(0)));
        rpySourceAnchor.setY(Double.valueOf(rpySourceAnchorAsString.get(1)));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpySourceAnchorInAbsolute = sourceShape.getTransform().multiply(rpySourceAnchor);
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpyTargetAnchor = RpyGeometryFactory.eINSTANCE.createPoint();
        rpyTargetAnchor.setX(Double.valueOf(rpyTargetAnchorAsString.get(0)));
        rpyTargetAnchor.setY(Double.valueOf(rpyTargetAnchorAsString.get(1)));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpyTargetAnchorInAbsolute = targetShape.getTransform().multiply(rpyTargetAnchor);
        List<String> rpyBendpointsAsString = this.getM_arrow(association);
        ArrayList<org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point> rpyBendpointsInAbsolute = new ArrayList<org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point>();
        if (rpyBendpointsAsString.size() > 0) {
            int i = 1;
            while (i < Integer.valueOf(rpyBendpointsAsString.get(0)) * 2) {
                org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point newPoint = RpyGeometryFactory.eINSTANCE.createPoint();
                newPoint.setX(Double.valueOf(rpyBendpointsAsString.get(i)));
                newPoint.setY(Double.valueOf(rpyBendpointsAsString.get(i + 1)));
                rpyBendpointsInAbsolute.add(newPoint);
                i += 2;
            }
        }
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point sourceAnchorInRelative = RpyGeometryFactory.eINSTANCE.createPoint();
        sourceAnchorInRelative.setX(Double.valueOf(rpySourceAnchorInAbsolute.getX() - sourceShape.getAbsolutePosition().getX()));
        sourceAnchorInRelative.setY(Double.valueOf(rpySourceAnchorInAbsolute.getY() - sourceShape.getAbsolutePosition().getY()));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point targetAnchorInRelative = RpyGeometryFactory.eINSTANCE.createPoint();
        targetAnchorInRelative.setX(Double.valueOf(rpyTargetAnchorInAbsolute.getX() - targetShape.getAbsolutePosition().getX()));
        targetAnchorInRelative.setY(Double.valueOf(rpyTargetAnchorInAbsolute.getY() - targetShape.getAbsolutePosition().getY()));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point firstBendpoint = RpyGeometryFactory.eINSTANCE.createPoint();
        firstBendpoint.setX(rpySourceAnchorInAbsolute.getX());
        firstBendpoint.setY(rpySourceAnchorInAbsolute.getY());
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point lastBendpoint = RpyGeometryFactory.eINSTANCE.createPoint();
        lastBendpoint.setX(rpyTargetAnchorInAbsolute.getX());
        lastBendpoint.setY(rpyTargetAnchorInAbsolute.getY());
        ArrayList<RelativeBendpoint> gmfBendpoints = new ArrayList<RelativeBendpoint>();
        gmfBendpoints.add(new RelativeBendpoint(firstBendpoint.getIntX().intValue(), firstBendpoint.getIntY().intValue(), -643984, -643984));
        for (org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point current : rpyBendpointsInAbsolute) {
            gmfBendpoints.add(new RelativeBendpoint(current.getIntX().intValue(), current.getIntY().intValue(), -643984, -643984));
        }
        gmfBendpoints.add(new RelativeBendpoint(lastBendpoint.getIntX().intValue(), lastBendpoint.getIntY().intValue(), -643984, -643984));
        RelativeBendpoints bendpoints12 = NotationFactory.eINSTANCE.createRelativeBendpoints();
        bendpoints12.setPoints(gmfBendpoints);
        result.setBendpoints((Bendpoints)bendpoints12);
        IdentityAnchor sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        sourceAnchor.setId(this.getAnchorFromAbsolutePosition(sourceShape, sourceAnchorInRelative));
        IdentityAnchor targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        targetAnchor.setId(this.getAnchorFromAbsolutePosition(targetShape, targetAnchorInRelative));
        result.setSourceAnchor((Anchor)sourceAnchor);
        result.setTargetAnchor((Anchor)targetAnchor);
    }

    private boolean isARpyLink(Object anObject) {
        return this.getM_pSource(anObject) != null && this.getM_pTarget(anObject) != null && this.getM_SourcePort(anObject).size() == 2 && this.getM_TargetPort(anObject).size() == 2;
    }

    private List<String> getM_arrow(Object anObject) {
        if (anObject instanceof CGIObjectLink) {
            return ((CGIObjectLink)anObject).getM_arrow();
        }
        if (anObject instanceof CGIAnchor) {
            return ((CGIAnchor)anObject).getM_arrow();
        }
        if (anObject instanceof CGIAssociationEnd) {
            return ((CGIAssociationEnd)anObject).getM_arrow();
        }
        return Collections.emptyList();
    }

    private GraphElementsType getM_pSource(Object anObject) {
        if (anObject instanceof CGIObjectLink) {
            return (GraphElementsType)((CGIObjectLink)anObject).getM_pSource();
        }
        if (anObject instanceof CGIAnchor) {
            return (GraphElementsType)((CGIAnchor)anObject).getM_pSource();
        }
        if (anObject instanceof CGIAssociationEnd) {
            return (GraphElementsType)((CGIAssociationEnd)anObject).getM_pSource();
        }
        return null;
    }

    private GraphElementsType getM_pTarget(Object anObject) {
        if (anObject instanceof CGIObjectLink) {
            return (GraphElementsType)((CGIObjectLink)anObject).getM_pTarget();
        }
        if (anObject instanceof CGIAnchor) {
            return (GraphElementsType)((CGIAnchor)anObject).getM_pTarget();
        }
        if (anObject instanceof CGIAssociationEnd) {
            return (GraphElementsType)((CGIAssociationEnd)anObject).getM_pTarget();
        }
        return null;
    }

    private List<String> getM_SourcePort(Object anObject) {
        if (anObject instanceof CGIObjectLink) {
            return ((CGIObjectLink)anObject).getM_SourcePort();
        }
        if (anObject instanceof CGIAnchor) {
            return ((CGIAnchor)anObject).getM_SourcePort();
        }
        if (anObject instanceof CGIAssociationEnd) {
            return ((CGIAssociationEnd)anObject).getM_SourcePort();
        }
        return Collections.emptyList();
    }

    private List<String> getM_TargetPort(Object anObject) {
        if (anObject instanceof CGIObjectLink) {
            return ((CGIObjectLink)anObject).getM_TargetPort();
        }
        if (anObject instanceof CGIAnchor) {
            return ((CGIAnchor)anObject).getM_TargetPort();
        }
        if (anObject instanceof CGIAssociationEnd) {
            return ((CGIAssociationEnd)anObject).getM_TargetPort();
        }
        return Collections.emptyList();
    }

    @Operation(kind=Operation.Kind.QUERY)
    public void addAnchorsAndBendpoints_V2_FOR_LinkONLink(CGIAnchor association, Connector result) {
        EList rpySourceAnchorAsString = association.getM_SourcePort();
        EList rpyTargetAnchorAsString = association.getM_TargetPort();
        GraphElementsType sourceGraphicalObject = (GraphElementsType)association.getM_pSource();
        GraphElementsType targetGraphicalObject = (GraphElementsType)association.getM_pTarget();
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point newTargetAnchorInAbsolute = null;
        if (targetGraphicalObject instanceof CGIObjectLink) {
            CGIObjectLink link = (CGIObjectLink)targetGraphicalObject;
            Connector tmp = NotationFactory.eINSTANCE.createConnector();
            this.addAnchorsAndBendpoints(link, tmp);
            RelativeBendpoints bendpoints = (RelativeBendpoints)tmp.getBendpoints();
            double length = 0.0;
            ArrayList<LineSeg> linesSegs = new ArrayList<LineSeg>();
            ArrayList<Double> cumulatedLength = new ArrayList<Double>();
            int i = 1;
            while (i < bendpoints.getPoints().size()) {
                RelativeBendpoint pt1 = (RelativeBendpoint)bendpoints.getPoints().get(i - 1);
                RelativeBendpoint pt2 = (RelativeBendpoint)bendpoints.getPoints().get(i);
                linesSegs.add(new LineSeg(new Point(pt1.getSourceX(), pt1.getSourceY()), new Point(pt2.getSourceX(), pt2.getSourceY())));
                ++i;
            }
            for (LineSeg lineSeg : linesSegs) {
                cumulatedLength.add(length += lineSeg.length());
            }
            double percentage = Double.valueOf((String)rpyTargetAnchorAsString.get(0));
            double wantedLength = length * percentage / 100.0;
            int wantedLineSeg = -1;
            int iter = 0;
            while (wantedLineSeg == -1 && iter < cumulatedLength.size()) {
                if (!((Double)cumulatedLength.get(iter) > wantedLength)) continue;
                wantedLineSeg = iter;
            }
            double needToCrossOnThisLineSeg = -1.0;
            needToCrossOnThisLineSeg = iter == 0 ? wantedLength : wantedLength - (Double)cumulatedLength.get(wantedLineSeg - 1);
            LineSeg w = (LineSeg)linesSegs.get(iter);
            double percentage12 = 100.0 * needToCrossOnThisLineSeg / ((LineSeg)linesSegs.get(iter)).length();
            double xOffset = ((double)w.getTerminus().x - (double)w.getOrigin().x) * percentage12 / 100.0;
            double yOffset = ((double)w.getTerminus().y - (double)w.getOrigin().y) * percentage12 / 100.0;
            newTargetAnchorInAbsolute = RpyGeometryFactory.eINSTANCE.createPoint();
            newTargetAnchorInAbsolute.setX(Double.valueOf((double)w.getOrigin().x + xOffset));
            newTargetAnchorInAbsolute.setY(Double.valueOf((double)w.getOrigin().y + yOffset));
            Point ptResult = new Point();
            LineSeg.KeyPoint toto = LineSeg.KeyPoint.ORIGIN;
            w.pointOn((long)needToCrossOnThisLineSeg, toto, ptResult);
            int j = 0;
            ++j;
            Object var33_40 = null;
        }
        RpyShape sourceShape = RpyShapeOperations.createRpyShape((GraphElementsType)sourceGraphicalObject);
        RpyShape targetShape = RpyShapeOperations.createRpyShape((GraphElementsType)targetGraphicalObject);
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpySourceAnchor = RpyGeometryFactory.eINSTANCE.createPoint();
        rpySourceAnchor.setX(Double.valueOf((String)rpySourceAnchorAsString.get(0)));
        rpySourceAnchor.setY(Double.valueOf((String)rpySourceAnchorAsString.get(1)));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpySourceAnchorInAbsolute = sourceShape.getTransform().multiply(rpySourceAnchor);
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpyTargetAnchor = RpyGeometryFactory.eINSTANCE.createPoint();
        rpyTargetAnchor.setX(Double.valueOf((String)rpyTargetAnchorAsString.get(0)));
        rpyTargetAnchor.setY(Double.valueOf((String)rpyTargetAnchorAsString.get(1)));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point rpyTargetAnchorInAbsolute = newTargetAnchorInAbsolute == null ? targetShape.getTransform().multiply(rpyTargetAnchor) : newTargetAnchorInAbsolute;
        EList rpyBendpointsAsString = association.getM_arrow();
        ArrayList<org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point> rpyBendpointsInAbsolute = new ArrayList<org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point>();
        if (rpyBendpointsAsString.size() > 0) {
            int i = 1;
            while (i < Integer.valueOf((String)rpyBendpointsAsString.get(0)) * 2) {
                org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point newPoint = RpyGeometryFactory.eINSTANCE.createPoint();
                newPoint.setX(Double.valueOf((String)rpyBendpointsAsString.get(i)));
                newPoint.setY(Double.valueOf((String)rpyBendpointsAsString.get(i + 1)));
                rpyBendpointsInAbsolute.add(newPoint);
                i += 2;
            }
        }
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point sourceAnchorInRelative = RpyGeometryFactory.eINSTANCE.createPoint();
        sourceAnchorInRelative.setX(Double.valueOf(rpySourceAnchorInAbsolute.getX() - sourceShape.getAbsolutePosition().getX()));
        sourceAnchorInRelative.setY(Double.valueOf(rpySourceAnchorInAbsolute.getY() - sourceShape.getAbsolutePosition().getY()));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point targetAnchorInRelative = RpyGeometryFactory.eINSTANCE.createPoint();
        targetAnchorInRelative.setX(Double.valueOf(rpyTargetAnchorInAbsolute.getX() - targetShape.getAbsolutePosition().getX()));
        targetAnchorInRelative.setY(Double.valueOf(rpyTargetAnchorInAbsolute.getY() - targetShape.getAbsolutePosition().getY()));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point firstBendpoint = RpyGeometryFactory.eINSTANCE.createPoint();
        firstBendpoint.setX(rpySourceAnchorInAbsolute.getX());
        firstBendpoint.setY(rpySourceAnchorInAbsolute.getY());
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point lastBendpoint = RpyGeometryFactory.eINSTANCE.createPoint();
        lastBendpoint.setX(rpyTargetAnchorInAbsolute.getX());
        lastBendpoint.setY(rpyTargetAnchorInAbsolute.getY());
        ArrayList<RelativeBendpoint> gmfBendpoints = new ArrayList<RelativeBendpoint>();
        gmfBendpoints.add(new RelativeBendpoint(firstBendpoint.getIntX().intValue(), firstBendpoint.getIntY().intValue(), -643984, -643984));
        for (org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point current : rpyBendpointsInAbsolute) {
            gmfBendpoints.add(new RelativeBendpoint(current.getIntX().intValue(), current.getIntY().intValue(), -643984, -643984));
        }
        gmfBendpoints.add(new RelativeBendpoint(lastBendpoint.getIntX().intValue(), lastBendpoint.getIntY().intValue(), -643984, -643984));
        RelativeBendpoints bendpoints12 = NotationFactory.eINSTANCE.createRelativeBendpoints();
        bendpoints12.setPoints(gmfBendpoints);
        result.setBendpoints((Bendpoints)bendpoints12);
        IdentityAnchor sourceAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        sourceAnchor.setId(this.getAnchorFromAbsolutePosition(sourceShape, sourceAnchorInRelative));
        IdentityAnchor targetAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        targetAnchor.setId(this.getAnchorFromAbsolutePosition(targetShape, targetAnchorInRelative));
        result.setSourceAnchor((Anchor)sourceAnchor);
        result.setTargetAnchor((Anchor)targetAnchor);
    }

    protected String getAnchorFromAbsolutePosition(RpyShape shape, org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point point) {
        float newxRatio = 0.0f;
        float newyRatio = 0.0f;
        newxRatio = new Float(point.getX()).floatValue() / new Float(shape.getWidth().intValue()).floatValue();
        newyRatio = new Float(point.getY()).floatValue() / new Float(shape.getHeight().intValue()).floatValue();
        if (newxRatio > 1.0f) {
            newxRatio = 1.0f;
        }
        if (newyRatio > 1.0f) {
            newyRatio = 1.0f;
        }
        String id = "(" + newxRatio + "," + newyRatio + ")";
        return id;
    }

    @Deprecated
    protected String getAnchorFromAbsolutePosition(RpyShape shape, List<String> port) {
        double yPort;
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point point = RpyGeometryFactory.eINSTANCE.createPoint();
        point.setX(Double.valueOf(port.get(0)));
        point.setY(Double.valueOf(port.get(1)));
        org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point res = shape.getTransform().multiply(point);
        res.setX(Double.valueOf(res.getX() - shape.getAbsolutePosition().getX()));
        res.setY(Double.valueOf(res.getY() - shape.getAbsolutePosition().getY()));
        double[] topLeft = new double[]{shape.getParentRelativePosition().getX(), shape.getParentRelativePosition().getY()};
        double[] topRight = new double[]{shape.getParentRelativePosition().getX() + (double)shape.getWidth().intValue(), shape.getParentRelativePosition().getY()};
        double[] bottomLeft = new double[]{shape.getParentRelativePosition().getX(), shape.getParentRelativePosition().getY() + (double)shape.getHeight().intValue()};
        double xPort = Double.parseDouble(port.get(0));
        if (xPort < topLeft[0]) {
            xPort = topLeft[0];
        }
        if (xPort > topRight[0]) {
            xPort = topRight[0];
        }
        if ((yPort = Double.parseDouble(port.get(1))) < topLeft[1]) {
            yPort = topLeft[1];
        }
        if (yPort > bottomLeft[1]) {
            yPort = bottomLeft[1];
        }
        float newxRatio = new Float(xPort).floatValue() / new Float(shape.getWidth().intValue()).floatValue();
        float newyRatio = new Float(yPort).floatValue() / new Float(shape.getHeight().intValue()).floatValue();
        newxRatio = new Float(res.getX()).floatValue() / new Float(shape.getWidth().intValue()).floatValue();
        newyRatio = new Float(res.getY()).floatValue() / new Float(shape.getHeight().intValue()).floatValue();
        if (newxRatio > 1.0f) {
            newxRatio = 1.0f;
        }
        if (newyRatio > 1.0f) {
            newyRatio = 1.0f;
        }
        String id = "(" + newxRatio + "," + newyRatio + ")";
        return id;
    }

    @Operation(kind=Operation.Kind.HELPER)
    public String getAnchorId(List<String> polygon, List<String> transform, List<String> port) {
        int yPort;
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] topRight = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        int xPort = Integer.parseInt(port.get(0));
        if (xPort < topLeft[0]) {
            xPort = topLeft[0];
        }
        if (xPort > topRight[0]) {
            xPort = topRight[0];
        }
        if ((yPort = Integer.parseInt(port.get(1))) < topLeft[1]) {
            yPort = topLeft[1];
        }
        if (yPort > bottomLeft[1]) {
            yPort = bottomLeft[1];
        }
        float newxRatio = new Float(xPort).floatValue() / new Float(Rpy2PapyrusNotationBlackboxes.getRelativeWidth(topRight[0], topLeft[0])).floatValue();
        float newyRatio = new Float(yPort).floatValue() / new Float(Rpy2PapyrusNotationBlackboxes.getRelativeHeight(bottomLeft[1], topLeft[1])).floatValue();
        if (newxRatio > 1.0f) {
            newxRatio = 1.0f;
        }
        if (newyRatio > 1.0f) {
            newyRatio = 1.0f;
        }
        String id = "(" + newxRatio + "," + newyRatio + ")";
        return id;
    }

    public static int getRelativeHeight(int a, int b) {
        return a - b;
    }

    public static int getRelativeWidth(int a, int b) {
        return a - b;
    }

    @Deprecated
    @Operation(kind=Operation.Kind.HELPER)
    public int getStateHeight(List<String> polygon, List<String> transform) {
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] topRight = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        int[] bottomRight = new int[]{Integer.parseInt(polygon.get(5)), Integer.parseInt(polygon.get(6))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        float xRatio = Float.parseFloat(transform.get(0));
        float yRatio = Float.parseFloat(transform.get(3));
        return Math.round(yRatio * (float)(bottomLeft[1] - topLeft[1]));
    }

    @Deprecated
    @Operation(kind=Operation.Kind.HELPER)
    public int getStateWidth(List<String> polygon, List<String> transform) {
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] topRight = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        int[] bottomRight = new int[]{Integer.parseInt(polygon.get(5)), Integer.parseInt(polygon.get(6))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        float xRatio = Float.parseFloat(transform.get(0));
        float yRatio = Float.parseFloat(transform.get(3));
        return Math.round(xRatio * (float)(topRight[0] - topLeft[0]));
    }

    @Deprecated
    @Operation(kind=Operation.Kind.HELPER)
    public int getClassHeight(List<String> polygon, List<String> transform) {
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        int[] bottomRight = new int[]{Integer.parseInt(polygon.get(5)), Integer.parseInt(polygon.get(6))};
        int[] topRight = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        float xRatio = Float.parseFloat(transform.get(0));
        float yRatio = Float.parseFloat(transform.get(3));
        return Math.round(yRatio * (float)(bottomLeft[1] - topLeft[1]));
    }

    @Operation(kind=Operation.Kind.HELPER)
    public int getClassWidth(List<String> polygon, List<String> transform) {
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        int[] bottomRight = new int[]{Integer.parseInt(polygon.get(5)), Integer.parseInt(polygon.get(6))};
        int[] topRight = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        float xRatio = Float.parseFloat(transform.get(0));
        float yRatio = Float.parseFloat(transform.get(3));
        return Math.round(xRatio * (float)(topRight[0] - topLeft[0]));
    }

    @Deprecated
    public int getWidth(List<String> m_polygon, List<String> m_transform) {
        int[] topLeft = new int[]{Integer.parseInt(m_polygon.get(1)), Integer.parseInt(m_polygon.get(2))};
        int[] topRight = new int[]{Integer.parseInt(m_polygon.get(7)), Integer.parseInt(m_polygon.get(8))};
        float xRatio = Float.parseFloat(m_transform.get(0));
        return Math.round(xRatio * (float)(topRight[0] - topLeft[0]));
    }

    @Deprecated
    public int getHeight(List<String> polygon, List<String> transform) {
        int[] topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        int[] bottomLeft = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        float yRatio = Float.parseFloat(transform.get(3));
        return Math.round(yRatio * (float)(bottomLeft[1] - topLeft[1]));
    }

    @Operation(kind=Operation.Kind.HELPER)
    public float get_X_Ratio(GraphElementsType element) {
        float result = 1.0f;
        List<String> mTransform = this.getTransformList(element);
        if (mTransform != null && mTransform.size() == 6) {
            result = Float.parseFloat(mTransform.get(0));
            GraphElementsType parent = this.getParent(element);
            if (!(parent instanceof CGIDiagramFrame)) {
                result *= this.get_X_Ratio(parent);
            }
        }
        return result;
    }

    @Operation(kind=Operation.Kind.HELPER)
    public float get_Y_Ratio(GraphElementsType element) {
        float result = 1.0f;
        List<String> mTransform = this.getTransformList(element);
        if (mTransform != null && mTransform.size() == 6) {
            result = Float.parseFloat(mTransform.get(3));
            GraphElementsType parent = this.getParent(element);
            if (!(parent instanceof CGIDiagramFrame)) {
                result *= this.get_Y_Ratio(parent);
            }
        }
        return result;
    }

    private final GraphElementsType getParent(GraphElementsType element) {
        Object value;
        EStructuralFeature paretnFeature = element.eClass().getEStructuralFeature(M_pPARENT);
        if (paretnFeature != null && (value = element.eGet(paretnFeature)) instanceof GraphElementsType) {
            return (GraphElementsType)value;
        }
        return null;
    }

    protected final List<String> getTransformList(GraphElementsType element) {
        String tmp;
        int i;
        Object mTransformValue;
        ArrayList<String> returnedValues = new ArrayList<String>();
        EStructuralFeature mTransformFeature = element.eClass().getEStructuralFeature(M_TRANSFORM);
        if (mTransformFeature != null && (mTransformValue = element.eGet(mTransformFeature)) instanceof List) {
            returnedValues.addAll((List)mTransformValue);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        if (returnedValues.size() != 6) {
            i = 0;
            while (i < returnedValues.size()) {
                tmp = (String)returnedValues.get(i);
                if (!tmp.startsWith("e")) {
                    String tmp2;
                    if (!tmp.startsWith("e") && returnedValues.size() > i + 1 && (tmp2 = (String)returnedValues.get(i + 1)).startsWith("e")) {
                        tmp = String.valueOf(tmp) + tmp2;
                    }
                    toReturn.add(tmp);
                }
                ++i;
            }
            returnedValues = toReturn;
        }
        i = 0;
        while (i < returnedValues.size()) {
            tmp = (String)returnedValues.get(i);
            if (tmp.contains("e-")) {
                returnedValues.set(i, "0");
            }
            ++i;
        }
        return returnedValues;
    }

    protected final List<String> getPolygonList(GraphElementsType element) {
        Object mPolygonValue;
        Object mPolygonValue2;
        EStructuralFeature mPolygonFeature = element.eClass().getEStructuralFeature(M_POLYGON);
        if (mPolygonFeature != null && (mPolygonValue2 = element.eGet(mPolygonFeature)) instanceof List) {
            return (List)mPolygonValue2;
        }
        EStructuralFeature mPositionlygonFeature = element.eClass().getEStructuralFeature("m_position");
        if (mPolygonFeature != null && (mPolygonValue = element.eGet(mPolygonFeature)) instanceof List) {
            return (List)mPolygonValue;
        }
        return null;
    }

    @Operation(kind=Operation.Kind.HELPER)
    public int getRectangleWidth(GraphElementsType element) {
        RpyShape shape = RpyShapeOperations.createRpyShape((GraphElementsType)element);
        return shape.getWidth();
    }

    @Operation(kind=Operation.Kind.HELPER)
    public int getRectangleHeight(GraphElementsType element) {
        RpyShape shape = RpyShapeOperations.createRpyShape((GraphElementsType)element);
        return shape.getHeight();
    }

    @Operation(kind=Operation.Kind.HELPER)
    public int getX(GraphElementsType element) {
        RpyShape shape = RpyShapeOperations.createRpyShape((GraphElementsType)element);
        return shape.getParentRelativePosition().getIntX();
    }

    @Operation(kind=Operation.Kind.HELPER)
    public int getY(GraphElementsType element) {
        RpyShape shape = RpyShapeOperations.createRpyShape((GraphElementsType)element);
        return shape.getParentRelativePosition().getIntY();
    }

    protected final int stringToInteger(String aString) {
        int result = Integer.MAX_VALUE;
        result = aString.contains(".") ? Float.valueOf(Float.parseFloat(aString)).intValue() : Integer.parseInt(aString);
        return result;
    }
}

